/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.behaviors;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.animation.Animation;
import javafx.animation.PauseTransition;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;
import org.eclipse.gef4.fx.utils.CursorUtils;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.behaviors.HoverBehavior;
import org.eclipse.gef4.mvc.behaviors.IBehavior;
import org.eclipse.gef4.mvc.parts.IFeedbackPart;
import org.eclipse.gef4.mvc.parts.IHandlePart;
import org.eclipse.gef4.mvc.parts.IHandlePartFactory;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public class FXHoverBehavior
extends HoverBehavior<Node> {
    public static final int REMOVAL_DELAY_MILLIS = 500;
    public static final int CREATION_DELAY_MILLIS = 250;
    public static final double MOUSE_MOVE_THRESHOLD = 4.0;
    @Inject
    @Named(value="hover")
    private IHandlePartFactory<Node> handlePartFactory;
    private final Map<IVisualPart<Node, ? extends Node>, Effect> effects = new HashMap<IVisualPart<Node, ? extends Node>, Effect>();
    private boolean isFeedback;
    private boolean isHandles;
    private PauseTransition creationDelayTransition;
    private PauseTransition removalDelayTransition;
    private Point initialPointerLocation;
    private final EventHandler<MouseEvent> mouseMoveHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            FXHoverBehavior.this.onMouseMove(event);
        }
    };

    public static boolean isContained(List<? extends IVisualPart<Node, ? extends Node>> rootParts, IVisualPart<Node, ? extends Node> part) {
        if (part == null) {
            return false;
        }
        if (rootParts == null || rootParts.isEmpty()) {
            return false;
        }
        for (IVisualPart<Node, ? extends Node> iVisualPart : rootParts) {
            if (iVisualPart == part) {
                return true;
            }
            if (!FXHoverBehavior.isContained((List<? extends IVisualPart<Node, ? extends Node>>)iVisualPart.getChildrenUnmodifiable(), part)) continue;
            return true;
        }
        return false;
    }

    protected void addFeedback(List<? extends IVisualPart<Node, ? extends Node>> targets, List<? extends IFeedbackPart<Node, ? extends Node>> feedback) {
        this.isFeedback = true;
        if (this.getHost() instanceof IHandlePart) {
            for (IVisualPart<Node, ? extends Node> iVisualPart : targets) {
                Node visual = (Node)iVisualPart.getVisual();
                this.effects.put(iVisualPart, visual.getEffect());
                visual.setEffect(this.getHandleHoverFeedbackEffect(Collections.emptyMap()));
            }
        } else {
            super.addFeedback(targets, feedback);
        }
    }

    protected void doDeactivate() {
        super.doDeactivate();
        if (this.isInCreationDelay()) {
            this.stopCreationDelay();
        }
        if (this.isInRemovalDelay()) {
            this.stopRemovalDelay();
        }
        this.removeFeedback(Collections.singletonList(this.getHost()));
        this.removeHandles(Collections.singletonList(this.getHost()));
    }

    public Effect getHandleHoverFeedbackEffect(Map<Object, Object> contextMap) {
        DropShadow effect = new DropShadow();
        effect.setRadius(5.0);
        return effect;
    }

    protected IHandlePartFactory<Node> getHandlePartFactory() {
        return this.handlePartFactory;
    }

    protected boolean isHostOrHoverHandlePart(IVisualPart<Node, ? extends Node> part) {
        return this.getHost() == part || FXHoverBehavior.isContained(this.getHandleParts(), part);
    }

    protected boolean isInCreationDelay() {
        return this.creationDelayTransition != null && Animation.Status.RUNNING.equals((Object)this.creationDelayTransition.getStatus());
    }

    protected boolean isInRemovalDelay() {
        return this.removalDelayTransition != null && Animation.Status.RUNNING.equals((Object)this.removalDelayTransition.getStatus());
    }

    protected void onCreationDelay() {
        this.unregisterMouseHandler();
        this.initialPointerLocation = null;
        this.switchAdaptableScopes();
        List<IVisualPart> targets = Collections.singletonList(this.getHost());
        this.addHandles(targets, this.getHandlePartFactory().createHandleParts(targets, (IBehavior)this, Collections.emptyMap()));
        this.isHandles = this.getHandleParts() != null && !this.getHandleParts().isEmpty();
    }

    protected void onHover() {
        if (this.isInRemovalDelay()) {
            this.stopRemovalDelay();
        }
        if (!this.isFeedback) {
            this.switchAdaptableScopes();
            List<IVisualPart> targets = Collections.singletonList(this.getHost());
            this.addFeedback(targets, this.getFeedbackPartFactory().createFeedbackParts(targets, (IBehavior)this, Collections.emptyMap()));
        }
        if (!this.isHandles) {
            this.startHandleCreationDelay();
        }
    }

    protected void onHoverChange(IVisualPart<Node, ? extends Node> oldHovered, IVisualPart<Node, ? extends Node> newHovered) {
        boolean wasHovered = this.isHostOrHoverHandlePart(oldHovered);
        boolean isHovered = this.isHostOrHoverHandlePart(newHovered);
        if (!wasHovered && isHovered) {
            this.onHover();
        } else if (wasHovered && !isHovered) {
            this.onUnhover();
        }
    }

    protected void onMouseMove(MouseEvent event) {
        if (!this.isInCreationDelay()) {
            throw new IllegalStateException("Mouse handler is active, although the creation timer is not running.");
        }
        double dx = event.getScreenX() - this.initialPointerLocation.x;
        double dy = event.getScreenY() - this.initialPointerLocation.y;
        if (Math.abs(dx) > 4.0 || Math.abs(dy) > 4.0) {
            this.initialPointerLocation = CursorUtils.getPointerLocation();
            this.creationDelayTransition.playFromStart();
        }
    }

    protected void onRelease() {
        this.removeFeedback(Collections.singletonList(this.getHost()));
        this.isHandles = false;
        this.removeHandles(Collections.singletonList(this.getHost()));
    }

    protected void onRemovalDelay() {
        this.removeFeedback(Collections.singletonList(this.getHost()));
        this.isHandles = false;
        this.removeHandles(Collections.singletonList(this.getHost()));
    }

    protected void onUnhover() {
        if (!this.isHandles && this.isFeedback) {
            if (this.isInCreationDelay()) {
                this.stopCreationDelay();
            }
            this.removeFeedback(Collections.singletonList(this.getHost()));
        } else if (this.isHandles) {
            this.startHandleRemovalDelay();
        }
    }

    protected void registerMouseHandler() {
        this.initialPointerLocation = CursorUtils.getPointerLocation();
        Scene scene = ((Node)this.getHost().getVisual()).getScene();
        scene.addEventFilter(MouseEvent.MOUSE_MOVED, this.mouseMoveHandler);
        scene.addEventFilter(MouseEvent.MOUSE_DRAGGED, this.mouseMoveHandler);
    }

    protected void removeFeedback(List<? extends IVisualPart<Node, ? extends Node>> targets) {
        this.isFeedback = false;
        if (this.getHost() instanceof IHandlePart) {
            for (IVisualPart<Node, ? extends Node> iVisualPart : targets) {
                Node visual = (Node)iVisualPart.getVisual();
                visual.setEffect(this.effects.remove(iVisualPart));
            }
        } else {
            super.removeFeedback(targets);
        }
    }

    protected void removeHandles(List<? extends IVisualPart<Node, ? extends Node>> targets) {
        super.removeHandles(targets);
        this.isHandles = this.getHandleParts() != null && !this.getHandleParts().isEmpty();
    }

    protected void startHandleCreationDelay() {
        this.registerMouseHandler();
        this.creationDelayTransition = new PauseTransition(Duration.millis((double)250.0));
        this.creationDelayTransition.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                FXHoverBehavior.this.onCreationDelay();
            }
        });
        this.creationDelayTransition.play();
    }

    protected void startHandleRemovalDelay() {
        this.removalDelayTransition = new PauseTransition(Duration.millis((double)500.0));
        this.removalDelayTransition.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                FXHoverBehavior.this.onRemovalDelay();
            }
        });
        this.removalDelayTransition.play();
    }

    protected void stopCreationDelay() {
        this.creationDelayTransition.stop();
        this.unregisterMouseHandler();
    }

    protected void stopRemovalDelay() {
        this.removalDelayTransition.stop();
    }

    protected void unregisterMouseHandler() {
        Scene scene = ((Node)this.getHost().getVisual()).getScene();
        scene.removeEventFilter(MouseEvent.MOUSE_MOVED, this.mouseMoveHandler);
        scene.removeEventFilter(MouseEvent.MOUSE_DRAGGED, this.mouseMoveHandler);
        this.initialPointerLocation = null;
    }
}

