/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.common.adapt;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import org.eclipse.gef4.common.activate.IActivatable;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.common.adapt.IAdaptable;
import org.eclipse.gef4.common.beans.property.ReadOnlyMapWrapperEx;
import org.eclipse.gef4.common.dispose.IDisposable;

public class AdaptableSupport<A extends IAdaptable>
implements IDisposable {
    private ObservableMap<AdapterKey<?>, Object> adapters = FXCollections.observableHashMap();
    private ObservableMap<AdapterKey<?>, Object> adaptersUnmodifiable = FXCollections.unmodifiableObservableMap(this.adapters);
    private ReadOnlyMapWrapperEx<AdapterKey<?>, Object> adaptersUnmodifiableProperty = null;
    private A source;

    public AdaptableSupport(A source) {
        if (source == null) {
            throw new IllegalArgumentException("source may not be null.");
        }
        this.source = source;
        this.adaptersUnmodifiableProperty = new ReadOnlyMapWrapperEx(source, "adapters", this.adaptersUnmodifiable);
    }

    private void activateAdapters() {
        for (IActivatable adapter : this.getAdapters(IActivatable.class).values()) {
            adapter.activate();
        }
    }

    private void deactivateAdapters() {
        for (IActivatable adapter : this.getAdapters(IActivatable.class).values()) {
            adapter.deactivate();
        }
    }

    public <T> T getAdapter(AdapterKey<T> key) {
        if (this.adapters.isEmpty()) {
            return null;
        }
        Map<AdapterKey<T>, T> adaptersForTypeKey = this.getAdapters(key.getKey(), key.getRole());
        int adapterCount = new HashSet<T>(adaptersForTypeKey.values()).size();
        if (adapterCount == 1) {
            return adaptersForTypeKey.values().iterator().next();
        }
        return null;
    }

    public <T> T getAdapter(Class<T> key) {
        return this.getAdapter(TypeToken.of(key));
    }

    public <T> T getAdapter(TypeToken<T> key) {
        Map<AdapterKey<T>, T> adaptersForTypeKey = this.getAdapters(key, null);
        int adapterCount = new HashSet<T>(adaptersForTypeKey.values()).size();
        if (adapterCount == 1) {
            return adaptersForTypeKey.values().iterator().next();
        }
        if (adapterCount > 1) {
            return this.getAdapter(AdapterKey.get(key, "default"));
        }
        return null;
    }

    public ObservableMap<AdapterKey<?>, Object> getAdapters() {
        return this.adaptersUnmodifiable;
    }

    public <T> Map<AdapterKey<? extends T>, T> getAdapters(Class<? super T> key) {
        return this.getAdapters(TypeToken.of(key));
    }

    public <T> Map<AdapterKey<? extends T>, T> getAdapters(TypeToken<? super T> key) {
        if (this.adapters.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<AdapterKey, Object> typeSafeAdapters = new HashMap<AdapterKey, Object>();
        for (AdapterKey k : this.adapters.keySet()) {
            if (!key.isAssignableFrom(k.getKey())) continue;
            typeSafeAdapters.put(k, this.adapters.get((Object)k));
        }
        return typeSafeAdapters;
    }

    private <T> Map<AdapterKey<? extends T>, T> getAdapters(TypeToken<? super T> typeKey, String role) {
        if (typeKey == null) {
            throw new IllegalArgumentException("typeKey may not be null");
        }
        if (this.adapters.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<AdapterKey, Object> typeSafeAdapters = new HashMap<AdapterKey, Object>();
        for (AdapterKey k : this.adapters.keySet()) {
            if (role != null && !k.getRole().equals(role) || !typeKey.isAssignableFrom(k.getKey())) continue;
            typeSafeAdapters.put(k, this.adapters.get((Object)k));
        }
        return typeSafeAdapters;
    }

    private <T> boolean isRawType(TypeToken<? super T> typeKey) {
        return !(typeKey.getType() instanceof ParameterizedType);
    }

    public <T> void setAdapter(T adapter) {
        TypeToken actualType = TypeToken.of(adapter.getClass());
        if (!this.isRawType(actualType)) {
            throw new IllegalArgumentException("Adapter " + adapter + " has no raw type, thus needs to be registered with a type key reflecting its actual type");
        }
        this.setAdapter(actualType, adapter);
    }

    public <T> void setAdapter(T adapter, String role) {
        TypeToken actualType = TypeToken.of(adapter.getClass());
        if (!this.isRawType(actualType)) {
            Type[] typeArray = ((ParameterizedType)actualType.getType()).getActualTypeArguments();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type argument = typeArray[n2];
                if (argument instanceof TypeVariable) {
                    throw new IllegalArgumentException("Adapter " + adapter + " has no raw type, thus needs to be registered with a type key reflecting its actual type");
                }
                ++n2;
            }
        }
        this.setAdapter(actualType, adapter, role);
    }

    public <T> void setAdapter(TypeToken<T> adapterType, T adapter) {
        this.setAdapter(adapterType, adapter, "default");
    }

    public <T> void setAdapter(TypeToken<T> adapterType, T adapter, String role) {
        if (!adapterType.getRawType().isAssignableFrom(adapter.getClass()) || !adapter.getClass().isAssignableFrom(adapterType.getRawType())) {
            throw new IllegalArgumentException("The given adapter type " + adapterType.getType().getClass().getSimpleName() + " does not match the passed in adapter's type " + adapter.getClass().getSimpleName());
        }
        AdapterKey<T> key = AdapterKey.get(adapterType, role);
        if (this.adapters.containsKey(key)) {
            if (this.adapters.get(key) != adapter) {
                throw new IllegalArgumentException("A different adapter (" + adapter + ") is already registered with key " + key + " at adaptable " + this.source);
            }
            System.err.println("The adapter " + adapter + " was already registered with key " + key + " at adaptable " + this.source);
        }
        if (this.source instanceof IActivatable && ((IActivatable)this.source).isActive()) {
            this.deactivateAdapters();
        }
        this.adapters.put(key, adapter);
        if (adapter instanceof IAdaptable.Bound) {
            ((IAdaptable.Bound)adapter).setAdaptable(this.source);
        }
        if (this.source instanceof IActivatable && ((IActivatable)this.source).isActive()) {
            this.activateAdapters();
        }
    }

    public ReadOnlyMapProperty<AdapterKey<?>, Object> adaptersProperty() {
        return this.adaptersUnmodifiableProperty.getReadOnlyProperty();
    }

    public <T> void unsetAdapter(T adapter) {
        if (!this.adapters.containsValue(adapter)) {
            throw new IllegalArgumentException("Given adapter is not registered.");
        }
        if (this.source instanceof IActivatable && ((IActivatable)this.source).isActive()) {
            this.deactivateAdapters();
        }
        for (AdapterKey key : this.adapters.keySet()) {
            if (this.adapters.get((Object)key) != adapter) continue;
            this.adapters.remove((Object)key);
        }
        if (adapter instanceof IAdaptable.Bound) {
            ((IAdaptable.Bound)adapter).setAdaptable(null);
        }
        if (this.source instanceof IActivatable && ((IActivatable)this.source).isActive()) {
            this.activateAdapters();
        }
    }

    @Override
    public void dispose() {
        if (this.source instanceof IActivatable && ((IActivatable)this.source).isActive()) {
            throw new IllegalStateException("source needs to be deactivated before disposing this AdaptableSupport.");
        }
        HashMap oldAdapters = new HashMap((Map<AdapterKey<?>, Object>)this.adapters);
        for (AdapterKey key : oldAdapters.keySet()) {
            Object adapter = this.adapters.remove((Object)key);
            if (adapter != null && adapter instanceof IAdaptable.Bound) {
                ((IAdaptable.Bound)adapter).setAdaptable(null);
            }
            if (!(adapter instanceof IDisposable)) continue;
            ((IDisposable)adapter).dispose();
        }
        this.adapters.clear();
    }
}

