/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.shapes.model.commands;

import java.util.Iterator;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.shapes.model.Connection;
import org.eclipse.gef.examples.shapes.model.Shape;

public class ConnectionCreateCommand
extends Command {
    private Connection connection;
    private final int lineStyle;
    private final Shape source;
    private Shape target;

    public ConnectionCreateCommand(Shape source, int lineStyle) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel("connection creation");
        this.source = source;
        this.lineStyle = lineStyle;
    }

    public boolean canExecute() {
        if (this.source.equals(this.target)) {
            return false;
        }
        Iterator iter = this.source.getSourceConnections().iterator();
        while (iter.hasNext()) {
            Connection conn = (Connection)iter.next();
            if (!conn.getTarget().equals(this.target)) continue;
            return false;
        }
        return true;
    }

    public void execute() {
        this.connection = new Connection(this.source, this.target);
        this.connection.setLineStyle(this.lineStyle);
    }

    public void redo() {
        this.connection.reconnect();
    }

    public void setTarget(Shape target) {
        if (target == null) {
            throw new IllegalArgumentException();
        }
        this.target = target;
    }

    public void undo() {
        this.connection.disconnect();
    }
}

