/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.algorithms.internal;

import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentPoint;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentRectangle;
import org.eclipse.zest.layouts.dataStructures.InternalNode;

public class DynamicScreen {
    private TreeSet XCoords = new TreeSet(new XComparator());
    private TreeSet YCoords = new TreeSet(new YComparator());
    private DisplayIndependentRectangle screenBounds = null;
    double minX = 0.0;
    double minY = 0.0;
    double maxX = 0.0;
    double maxY = 0.0;

    public void cleanScreen() {
        this.minX = 0.0;
        this.minY = 0.0;
        this.maxX = 0.0;
        this.maxY = 0.0;
    }

    public DynamicScreen(int x, int y, int width, int height) {
        this.screenBounds = new DisplayIndependentRectangle(x, y, width, height);
    }

    public void removeNode(InternalNode node) {
        this.XCoords.remove(node);
        this.YCoords.remove(node);
    }

    public void addNode(InternalNode node) {
        this.XCoords.add(node);
        this.YCoords.add(node);
    }

    public DisplayIndependentPoint getScreenLocation(InternalNode node) {
        DisplayIndependentRectangle layoutBounds = this.calculateBounds();
        double x = layoutBounds.width == 0.0 ? 0.0 : (node.getInternalX() - layoutBounds.x) / layoutBounds.width;
        double y = layoutBounds.height == 0.0 ? 0.0 : (node.getInternalY() - layoutBounds.y) / layoutBounds.height;
        x = this.screenBounds.x + x * this.screenBounds.width;
        y = this.screenBounds.y + y * this.screenBounds.height;
        return new DisplayIndependentPoint(x, y);
    }

    public DisplayIndependentPoint getVirtualLocation(DisplayIndependentPoint point) {
        DisplayIndependentRectangle layoutBounds = this.calculateBounds();
        double x = point.x / this.screenBounds.width * layoutBounds.width + layoutBounds.x;
        double y = point.y / this.screenBounds.height * layoutBounds.height + layoutBounds.y;
        return new DisplayIndependentPoint(x, y);
    }

    private DisplayIndependentRectangle calculateBounds() {
        InternalNode n1 = (InternalNode)this.XCoords.first();
        InternalNode n2 = (InternalNode)this.XCoords.last();
        InternalNode n3 = (InternalNode)this.YCoords.first();
        InternalNode n4 = (InternalNode)this.YCoords.last();
        double x = n1.getInternalX();
        double width = n2.getInternalX();
        double y = n3.getInternalY();
        double height = n4.getInternalY();
        return new DisplayIndependentRectangle(x, y, width - x, height - y);
    }

    class XComparator
    implements Comparator {
        XComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            InternalNode n1 = (InternalNode)arg0;
            InternalNode n2 = (InternalNode)arg1;
            if (n1.getInternalX() > n2.getInternalX()) {
                return 1;
            }
            if (n1.getInternalX() < n2.getInternalX()) {
                return -1;
            }
            return n1.toString().compareTo(n2.toString());
        }
    }

    class YComparator
    implements Comparator {
        YComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            InternalNode n1 = (InternalNode)arg0;
            InternalNode n2 = (InternalNode)arg1;
            if (n1.getInternalY() > n2.getInternalY()) {
                return 1;
            }
            if (n1.getInternalY() < n2.getInternalY()) {
                return -1;
            }
            return n1.toString().compareTo(n2.toString());
        }
    }
}

