/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language.fontname;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Style implements Enumerator
{
    NORMAL(0, "NORMAL", "roman"),
    OBLIQUE(1, "OBLIQUE", "oblique"),
    ITALIC(2, "ITALIC", "italic");

    public static final int NORMAL_VALUE = 0;
    public static final int OBLIQUE_VALUE = 1;
    public static final int ITALIC_VALUE = 2;
    private static final Style[] VALUES_ARRAY;
    public static final List<Style> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Style[]{NORMAL, OBLIQUE, ITALIC};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Style get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Style result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Style getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Style result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Style get(int value) {
        switch (value) {
            case 0: {
                return NORMAL;
            }
            case 1: {
                return OBLIQUE;
            }
            case 2: {
                return ITALIC;
            }
        }
        return null;
    }

    private Style(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

