/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.geometry.planar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiFunction;
import org.eclipse.gef.geometry.euclidean.Angle;
import org.eclipse.gef.geometry.euclidean.Straight;
import org.eclipse.gef.geometry.euclidean.Vector;
import org.eclipse.gef.geometry.internal.utils.PointListUtils;
import org.eclipse.gef.geometry.internal.utils.PrecisionUtils;
import org.eclipse.gef.geometry.planar.AbstractGeometry;
import org.eclipse.gef.geometry.planar.AffineTransform;
import org.eclipse.gef.geometry.planar.Arc;
import org.eclipse.gef.geometry.planar.CubicCurve;
import org.eclipse.gef.geometry.planar.CurveUtils;
import org.eclipse.gef.geometry.planar.ICurve;
import org.eclipse.gef.geometry.planar.IRotatable;
import org.eclipse.gef.geometry.planar.IScalable;
import org.eclipse.gef.geometry.planar.ITranslatable;
import org.eclipse.gef.geometry.planar.Line;
import org.eclipse.gef.geometry.planar.Path;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.geometry.planar.PolyBezier;
import org.eclipse.gef.geometry.planar.QuadraticCurve;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.geometry.projective.Straight3D;
import org.eclipse.gef.geometry.projective.Vector3D;

public class BezierCurve
extends AbstractGeometry
implements ICurve,
ITranslatable<BezierCurve>,
IScalable<BezierCurve>,
IRotatable<BezierCurve> {
    private static final long serialVersionUID = 1L;
    private static final int CHUNK_SHIFT = -3;
    private static final boolean ORTHOGONAL = true;
    private static final boolean PARALLEL = false;
    private static final double UNRECOGNIZABLE_PRECISION_FRACTION = PrecisionUtils.calculateFraction(0) / 10.0;
    private static final BiFunction<Point, Point, Boolean> xminCriteria = (p, q) -> PrecisionUtils.smallerEqual(p.x, q.x);
    private static final BiFunction<Point, Point, Boolean> xmaxCriteria = (p, q) -> PrecisionUtils.greaterEqual(p.x, q.x);
    private static final BiFunction<Point, Point, Boolean> yminCriteria = (p, q) -> PrecisionUtils.smallerEqual(p.y, q.y);
    private static final BiFunction<Point, Point, Boolean> ymaxCriteria = (p, q) -> PrecisionUtils.greaterEqual(p.y, q.y);
    private final Vector3D[] points;

    private static IntervalPair[] clusterChunks(IntervalPair[] intervalPairs, int shift) {
        boolean couldMerge;
        ArrayList<IntervalPair> ips = new ArrayList<IntervalPair>();
        ips.addAll(Arrays.asList(intervalPairs));
        Collections.sort(ips, new Comparator<IntervalPair>(){

            @Override
            public int compare(IntervalPair i, IntervalPair j) {
                if (i.pi.a < j.pi.a) {
                    return -1;
                }
                if (i.pi.a > j.pi.a) {
                    return 1;
                }
                return 0;
            }
        });
        ArrayList<IntervalPair> clusters = new ArrayList<IntervalPair>();
        IntervalPair current = null;
        do {
            clusters.clear();
            couldMerge = false;
            for (IntervalPair i : ips) {
                if (current == null) {
                    current = i.getCopy();
                    continue;
                }
                if (BezierCurve.isNextTo(current, i, shift)) {
                    couldMerge = true;
                    current.expand(i);
                    continue;
                }
                BezierCurve.isNextTo(current, i, shift);
                clusters.add(current);
                current = i.getCopy();
            }
            if (current != null) {
                clusters.add(current);
                current = null;
            }
            ips.clear();
            ips.addAll(clusters);
        } while (couldMerge);
        return clusters.toArray(new IntervalPair[0]);
    }

    private static boolean containmentParameter(BezierCurve c, double[] interval, Point p) {
        Stack<Interval> parts = new Stack<Interval>();
        parts.push(new Interval(interval));
        while (!parts.empty()) {
            Interval i = (Interval)parts.pop();
            if (i.converges(1)) {
                interval[0] = i.a;
                interval[1] = i.b;
                break;
            }
            double iMid = i.getMid();
            Interval left = new Interval(i.a, iMid);
            Interval right = new Interval(iMid, i.b);
            BezierCurve clipped = c.getClipped(left.a, left.b);
            Rectangle bounds = clipped.getControlBounds();
            if (bounds.contains(p)) {
                parts.push(left);
            }
            if (!(bounds = (clipped = c.getClipped(right.a, right.b)).getControlBounds()).contains(p)) continue;
            parts.push(right);
        }
        return PrecisionUtils.equal(interval[0], interval[1], 1);
    }

    private static double distanceToBaseLine(BezierCurve c) {
        Straight3D baseLine = Straight3D.through(c.points[0], c.points[c.points.length - 1]);
        if (baseLine == null) {
            return 0.0;
        }
        double maxDistance = 0.0;
        int i = 1;
        while (i < c.points.length - 1) {
            maxDistance = Math.max(maxDistance, Math.abs(baseLine.getSignedDistanceCW(c.points[i])));
            ++i;
        }
        return maxDistance;
    }

    private static IntervalPair extractOverlap(IntervalPair[] intersectionCandidates, IntervalPair[] endPoints) {
        IntervalPair[] chunks;
        IntervalPair[] fineChunks = new IntervalPair[intersectionCandidates.length + endPoints.length];
        int i = 0;
        while (i < intersectionCandidates.length) {
            fineChunks[i] = intersectionCandidates[i];
            ++i;
        }
        i = 0;
        while (i < endPoints.length) {
            fineChunks[intersectionCandidates.length + i] = endPoints[i];
            ++i;
        }
        if (fineChunks.length == 0) {
            return null;
        }
        BezierCurve.normalizeIntervalPairs(fineChunks);
        IntervalPair[] intervalPairArray = chunks = BezierCurve.clusterChunks(fineChunks, -4);
        int n = chunks.length;
        int n2 = 0;
        while (n2 < n) {
            IntervalPair overlap = intervalPairArray[n2];
            if (PrecisionUtils.smallerEqual(overlap.pi.a, 0.0) && PrecisionUtils.greaterEqual(overlap.pi.b, 1.0) || PrecisionUtils.smallerEqual(overlap.qi.a, 0.0) && PrecisionUtils.greaterEqual(overlap.qi.b, 1.0) || (PrecisionUtils.smallerEqual(overlap.pi.a, 0.0) || PrecisionUtils.greaterEqual(overlap.pi.b, 1.0)) && (PrecisionUtils.smallerEqual(overlap.qi.a, 0.0) || PrecisionUtils.greaterEqual(overlap.qi.b, 1.0))) {
                if (PrecisionUtils.smallerEqual(overlap.pi.a, 0.0, -4) && PrecisionUtils.smallerEqual(overlap.pi.b, 0.0, -4) || PrecisionUtils.greaterEqual(overlap.pi.a, 1.0, -4) && PrecisionUtils.greaterEqual(overlap.pi.b, 1.0, -4) || PrecisionUtils.smallerEqual(overlap.qi.a, 0.0, -4) && PrecisionUtils.smallerEqual(overlap.qi.b, 0.0, -4) || PrecisionUtils.greaterEqual(overlap.qi.a, 1.0, -4) && PrecisionUtils.greaterEqual(overlap.qi.b, 1.0, -4)) {
                    return null;
                }
                return BezierCurve.refineOverlap(overlap);
            }
            ++n2;
        }
        return null;
    }

    private static void findEndPointIntersections(IntervalPair ip, Set<IntervalPair> endPointIntervalPairs, Set<Point> intersections) {
        double CHUNK_SHIFT_EPSILON = PrecisionUtils.calculateFraction(-3);
        Point poi = ip.p.points[0].toPoint();
        double[] interval = new double[]{0.0, 1.0};
        if (BezierCurve.containmentParameter(ip.q, interval, poi)) {
            ip.pi.a = CHUNK_SHIFT_EPSILON;
            interval[0] = (interval[0] + interval[1]) / 2.0;
            interval[1] = interval[0] + CHUNK_SHIFT_EPSILON / 2.0;
            interval[0] = interval[0] - CHUNK_SHIFT_EPSILON / 2.0;
            endPointIntervalPairs.add(new IntervalPair(ip.p, new Interval(0.0, ip.pi.a), ip.q, new Interval(interval)));
            intersections.add(poi);
        }
        poi = ip.p.points[ip.p.points.length - 1].toPoint();
        interval[0] = 0.0;
        interval[1] = 1.0;
        if (BezierCurve.containmentParameter(ip.q, interval, poi)) {
            ip.pi.b = 1.0 - CHUNK_SHIFT_EPSILON;
            interval[0] = (interval[0] + interval[1]) / 2.0;
            interval[1] = interval[0] + CHUNK_SHIFT_EPSILON / 2.0;
            interval[0] = interval[0] - CHUNK_SHIFT_EPSILON / 2.0;
            endPointIntervalPairs.add(new IntervalPair(ip.p, new Interval(ip.pi.b, 1.0), ip.q, new Interval(interval)));
            intersections.add(poi);
        }
        poi = ip.q.points[0].toPoint();
        interval[0] = 0.0;
        interval[1] = 1.0;
        if (BezierCurve.containmentParameter(ip.p, interval, poi)) {
            ip.qi.a = CHUNK_SHIFT_EPSILON;
            interval[0] = (interval[0] + interval[1]) / 2.0;
            interval[1] = interval[0] + CHUNK_SHIFT_EPSILON / 2.0;
            interval[0] = interval[0] - CHUNK_SHIFT_EPSILON / 2.0;
            endPointIntervalPairs.add(new IntervalPair(ip.p, new Interval(interval), ip.q, new Interval(0.0, ip.qi.a)));
            intersections.add(poi);
        }
        poi = ip.q.points[ip.q.points.length - 1].toPoint();
        interval[0] = 0.0;
        interval[1] = 1.0;
        if (BezierCurve.containmentParameter(ip.p, interval, poi)) {
            ip.qi.b = 1.0 - CHUNK_SHIFT_EPSILON;
            interval[0] = (interval[0] + interval[1]) / 2.0;
            interval[1] = interval[0] + CHUNK_SHIFT_EPSILON / 2.0;
            interval[0] = interval[0] - CHUNK_SHIFT_EPSILON / 2.0;
            endPointIntervalPairs.add(new IntervalPair(ip.p, new Interval(interval), ip.q, new Interval(ip.qi.b, 1.0)));
            intersections.add(poi);
        }
    }

    private static void findIntersectionChunks(IntervalPair ip, Set<IntervalPair> intervalPairs, Set<Point> intersections) {
        if (ip.converges(-3)) {
            intervalPairs.add(ip.getCopy());
            return;
        }
        BezierCurve pClipped = ip.getPClipped();
        BezierCurve qClipped = ip.getQClipped();
        FatLine L1 = FatLine.from(qClipped, false);
        FatLine L2 = FatLine.from(qClipped, true);
        if (L1 == null || L2 == null) {
            Point poi = ip.q.getHC(ip.qi.getMid()).toPoint();
            double[] interval = new double[]{0.0, 1.0};
            if (poi != null && BezierCurve.containmentParameter(ip.p, interval, poi)) {
                intersections.add(poi);
            }
            return;
        }
        Interval interval = new Interval(pClipped.clipTo(L1));
        Interval intervalOrtho = new Interval(pClipped.clipTo(L2));
        double ratio = ip.pi.scaleTo(interval = Interval.min(interval, intervalOrtho));
        if (ratio < 0.0) {
            return;
        }
        if (ratio > 0.8) {
            if (ip.isPLonger()) {
                IntervalPair[] nip = ip.getPSplit();
                BezierCurve.findIntersectionChunks(nip[0], intervalPairs, intersections);
                BezierCurve.findIntersectionChunks(nip[1], intervalPairs, intersections);
            } else {
                IntervalPair[] nip = ip.getQSplit();
                BezierCurve.findIntersectionChunks(nip[0], intervalPairs, intersections);
                BezierCurve.findIntersectionChunks(nip[1], intervalPairs, intersections);
            }
            return;
        }
        BezierCurve.findIntersectionChunks(ip.getSwapped(), intervalPairs, intersections);
    }

    private static Point findSinglePreciseIntersection(IntervalPair ipIO) {
        Stack<IntervalPair> partStack = new Stack<IntervalPair>();
        partStack.push(ipIO);
        while (!partStack.isEmpty()) {
            Point q;
            Point p;
            IntervalPair ip = (IntervalPair)partStack.pop();
            BezierCurve pClipped = ip.getPClipped();
            BezierCurve qClipped = ip.getQClipped();
            if (!pClipped.getControlBounds().touches(qClipped.getControlBounds())) continue;
            if (ip.convergesP() && ip.q.contains(p = ip.p.getHC(ip.pi.a).toPoint())) {
                return p;
            }
            if (ip.convergesQ() && ip.p.contains(q = ip.q.getHC(ip.qi.a).toPoint())) {
                return q;
            }
            if (ip.converges()) {
                Point[] pointArray = ip.p.toPoints(ip.pi);
                int n = pointArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Point pp = pointArray[n2];
                    Point[] pointArray2 = ip.q.toPoints(ip.qi);
                    int n3 = pointArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Point qp = pointArray2[n4];
                        if (pp.equals(qp)) {
                            IntervalPair.copy(ipIO, ip);
                            return pp;
                        }
                        ++n4;
                    }
                    ++n2;
                }
                continue;
            }
            FatLine L1 = FatLine.from(qClipped, false);
            FatLine L2 = FatLine.from(qClipped, true);
            if (L1 == null || L2 == null) {
                Point poi = ip.q.getHC(ip.qi.getMid()).toPoint();
                if (!ip.p.contains(poi)) continue;
                IntervalPair.copy(ipIO, ip);
                return poi;
            }
            Interval interval = new Interval(pClipped.clipTo(L1));
            Interval intervalOrtho = new Interval(pClipped.clipTo(L2));
            double ratio = ip.pi.scaleTo(interval = Interval.min(interval, intervalOrtho));
            if (ratio < 0.0) continue;
            if (ratio > 0.8) {
                IntervalPair[] nip = ip.isPLonger() ? ip.getPSplit() : ip.getQSplit();
                partStack.push(nip[1]);
                partStack.push(nip[0]);
                continue;
            }
            partStack.push(ip.getSwapped());
        }
        return null;
    }

    private static double intersectXAxisParallel(Point p, Point q, double y) {
        double m = (q.y - p.y) / (q.x - p.x);
        return (y - p.y + m * p.x) / m;
    }

    private static boolean isNextTo(Interval i, Interval j, int shift) {
        return PrecisionUtils.smallerEqual(j.a, i.b, shift) && PrecisionUtils.greaterEqual(j.b, i.a, shift);
    }

    private static boolean isNextTo(IntervalPair a, IntervalPair b, int shift) {
        return BezierCurve.isNextTo(a.pi, b.pi, shift) && BezierCurve.isNextTo(a.qi, b.qi, shift);
    }

    private static PolyBezier mergeCurves(List<BezierCurve> curves) {
        if (curves.size() > 1) {
            int i = 1;
            while (i < curves.size()) {
                Point last = curves.get(i - 1).getP2();
                Point next = curves.get(i).getP1();
                if (!next.equals(last)) {
                    Point mid = new Rectangle(last, next).getCenter();
                    curves.get(i - 1).setP2(mid);
                    curves.get(i).setP1(mid);
                }
                ++i;
            }
        }
        return new PolyBezier(curves.toArray(new BezierCurve[0]));
    }

    private static void moveInterval(double[] interval, double x) {
        if (x < 0.0) {
            x = 0.0;
        } else if (x > 1.0) {
            x = 1.0;
        }
        if (interval[0] > x) {
            interval[0] = x;
        }
        if (interval[1] < x) {
            interval[1] = x;
        }
    }

    private static void normalizeIntervalPairs(IntervalPair[] intervalPairs) {
        if (intervalPairs.length == 0) {
            return;
        }
        BezierCurve pId = intervalPairs[0].p;
        BezierCurve qId = intervalPairs[0].q;
        IntervalPair[] intervalPairArray = intervalPairs;
        int n = intervalPairs.length;
        int n2 = 0;
        while (n2 < n) {
            IntervalPair ip = intervalPairArray[n2];
            if (ip.p != pId) {
                Interval qi = ip.pi;
                Interval pi = ip.qi;
                ip.p = pId;
                ip.q = qId;
                ip.pi = pi;
                ip.qi = qi;
            }
            ++n2;
        }
    }

    private static IntervalPair refineOverlap(IntervalPair overlap) {
        Interval piLo = BezierCurve.refineOverlapLo(overlap.p, overlap.pi.a, overlap.pi.getMid(), overlap.q);
        Interval piHi = BezierCurve.refineOverlapHi(overlap.p, overlap.pi.getMid(), overlap.pi.b, overlap.q);
        Interval qiLo = BezierCurve.refineOverlapLo(overlap.q, overlap.qi.a, overlap.qi.getMid(), overlap.p);
        Interval qiHi = BezierCurve.refineOverlapHi(overlap.q, overlap.qi.getMid(), overlap.qi.b, overlap.p);
        overlap.pi.a = piLo.b;
        overlap.pi.b = piHi.a;
        overlap.qi.a = qiLo.b;
        overlap.qi.b = qiHi.a;
        return overlap;
    }

    private static Interval refineOverlapHi(BezierCurve p, double mid, double b, BezierCurve q) {
        Interval i = new Interval(Math.max(mid, 0.0), Math.min(b, 1.0));
        int c = 0;
        while (c++ < 30 && !i.converges()) {
            double prevLo = i.a;
            i.a = i.getMid();
            Point pLo = p.get(i.a);
            if (q.contains(pLo)) continue;
            i.b = i.a;
            i.a = prevLo;
        }
        return i;
    }

    private static Interval refineOverlapLo(BezierCurve p, double a, double mid, BezierCurve q) {
        Interval i = new Interval(Math.max(a, 0.0), Math.min(mid, 1.0));
        int c = 0;
        while (c++ < 30 && !i.converges()) {
            double prevHi = i.b;
            i.b = i.getMid();
            Point pHi = p.get(i.b);
            if (q.contains(pHi)) continue;
            i.a = i.b;
            i.b = prevHi;
        }
        return i;
    }

    public BezierCurve(CubicCurve c) {
        this(c.getP1(), c.getCtrl1(), c.getCtrl2(), c.getP2());
    }

    public BezierCurve(double ... controlPoints) {
        this(PointListUtils.toPointsArray(controlPoints));
    }

    public BezierCurve(Point ... controlPoints) {
        this.points = new Vector3D[controlPoints.length];
        int i = 0;
        while (i < this.points.length) {
            this.points[i] = new Vector3D(controlPoints[i].x, controlPoints[i].y, 1.0);
            ++i;
        }
    }

    public BezierCurve(QuadraticCurve c) {
        this(c.getP1(), c.getCtrl(), c.getP2());
    }

    private BezierCurve(Vector3D ... controlPoints) {
        this.points = new Vector3D[controlPoints.length];
        int i = 0;
        while (i < this.points.length) {
            this.points[i] = controlPoints[i].getCopy();
            ++i;
        }
    }

    private double[] clipTo(FatLine L) {
        double[] interval = new double[]{1.0, 0.0};
        Vector3D[] differenceVectors = this.genDifferencePoints(L.line);
        Point[] differencePoints = new Point[differenceVectors.length];
        int i = 0;
        while (i < differenceVectors.length) {
            differencePoints[i] = differenceVectors[i].toPoint();
            ++i;
        }
        Point[] pointArray = differencePoints;
        int n = differencePoints.length;
        int n2 = 0;
        while (n2 < n) {
            Point p = pointArray[n2];
            if (Double.isNaN(p.y) || L.dmin <= p.y && p.y <= L.dmax) {
                BezierCurve.moveInterval(interval, p.x);
            }
            ++n2;
        }
        i = 1;
        while (i < differencePoints.length) {
            Line seg = new Line(differencePoints[0], differencePoints[i]);
            if (seg.getP1().y < L.dmin != seg.getP2().y < L.dmin) {
                double x = BezierCurve.intersectXAxisParallel(seg.getP1(), seg.getP2(), L.dmin);
                BezierCurve.moveInterval(interval, x);
            }
            if (seg.getP1().y < L.dmax != seg.getP2().y < L.dmax) {
                double x = BezierCurve.intersectXAxisParallel(seg.getP1(), seg.getP2(), L.dmax);
                BezierCurve.moveInterval(interval, x);
            }
            ++i;
        }
        i = 0;
        while (i < differencePoints.length - 1) {
            Line seg = new Line(differencePoints[i], differencePoints[differencePoints.length - 1]);
            if (seg.getP1().y < L.dmin != seg.getP2().y < L.dmin) {
                double x = BezierCurve.intersectXAxisParallel(seg.getP1(), seg.getP2(), L.dmin);
                BezierCurve.moveInterval(interval, x);
            }
            if (seg.getP1().y < L.dmax != seg.getP2().y < L.dmax) {
                double x = BezierCurve.intersectXAxisParallel(seg.getP1(), seg.getP2(), L.dmax);
                BezierCurve.moveInterval(interval, x);
            }
            ++i;
        }
        return interval;
    }

    public boolean contains(BezierCurve o) {
        return this.contains(o.getP1()) && this.contains(o.getP2()) && this.getOverlap(o) != null;
    }

    @Override
    public boolean contains(Point p) {
        if (p == null) {
            return false;
        }
        return BezierCurve.containmentParameter(this, new double[]{0.0, 1.0}, p);
    }

    public boolean equals(Object other) {
        Object[] tPoints;
        if (this == other) {
            return true;
        }
        if (!(other instanceof BezierCurve)) {
            return false;
        }
        BezierCurve o = (BezierCurve)other;
        BezierCurve t = this;
        while (o.points.length < t.points.length) {
            o = o.getElevated();
        }
        while (t.points.length < o.points.length) {
            t = t.getElevated();
        }
        Object[] oPoints = o.getPoints();
        return Arrays.equals(oPoints, tPoints = t.getPoints()) || Arrays.equals(oPoints, Point.getReverseCopy((Point[])tPoints));
    }

    private Point findExtreme(BiFunction<Point, Point, Boolean> criteria) {
        return this.findExtreme(criteria, Interval.getFull());
    }

    private Point findExtreme(BiFunction<Point, Point, Boolean> criteria, Interval iStart) {
        Stack<Interval> parts = new Stack<Interval>();
        parts.push(iStart);
        Point xtreme = this.getHC(iStart.a).toPoint();
        while (!parts.isEmpty()) {
            Interval i = (Interval)parts.pop();
            BezierCurve clipped = this.getClipped(i.a, i.b);
            Point sp = clipped.points[0].toPoint();
            xtreme = criteria.apply(sp, xtreme) != false ? sp : xtreme;
            Point ep = clipped.points[clipped.points.length - 1].toPoint();
            xtreme = criteria.apply(ep, xtreme) != false ? ep : xtreme;
            boolean everythingWorse = true;
            int j = 1;
            while (j < clipped.points.length - 1) {
                if (!criteria.apply(xtreme, clipped.points[j].toPoint()).booleanValue()) {
                    everythingWorse = false;
                    break;
                }
                ++j;
            }
            if (everythingWorse || i.converges()) continue;
            double im = i.getMid();
            parts.push(new Interval(im, i.b));
            parts.push(new Interval(i.a, im));
        }
        return xtreme;
    }

    private Vector3D[] genDifferencePoints(Straight3D line) {
        Vector3D[] D = new Vector3D[this.points.length];
        int i = 0;
        while (i < this.points.length) {
            double y = line.getSignedDistanceCW(this.points[i]);
            D[i] = new Vector3D((double)i / (double)(this.points.length - 1), y, 1.0);
            ++i;
        }
        return D;
    }

    public Point get(double t) {
        return this.getHC(t).toPoint();
    }

    @Override
    public Rectangle getBounds() {
        double xmin = this.findExtreme(BezierCurve.xminCriteria).x;
        double xmax = this.findExtreme(BezierCurve.xmaxCriteria).x;
        double ymin = this.findExtreme(BezierCurve.yminCriteria).y;
        double ymax = this.findExtreme(BezierCurve.ymaxCriteria).y;
        return new Rectangle(new Point(xmin, ymin), new Point(xmax, ymax));
    }

    public BezierCurve getClipped(double s, double e) {
        if (s == 1.0) {
            return new BezierCurve(this.points[this.points.length - 1]);
        }
        BezierCurve right = this.split(s)[1];
        double rightT2 = (e - s) / (1.0 - s);
        return right.split(rightT2)[0];
    }

    public Rectangle getControlBounds() {
        Point[] realPoints = this.getPoints();
        double xmin = realPoints[0].x;
        double xmax = realPoints[0].x;
        double ymin = realPoints[0].y;
        double ymax = realPoints[0].y;
        int i = 1;
        while (i < realPoints.length) {
            if (realPoints[i].x < xmin) {
                xmin = realPoints[i].x;
            } else if (realPoints[i].x > xmax) {
                xmax = realPoints[i].x;
            }
            if (realPoints[i].y < ymin) {
                ymin = realPoints[i].y;
            } else if (realPoints[i].y > ymax) {
                ymax = realPoints[i].y;
            }
            ++i;
        }
        return new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    @Override
    public BezierCurve getCopy() {
        return new BezierCurve(this.points);
    }

    public BezierCurve getDerivative() {
        Vector3D[] controlPoints = new Vector3D[this.points.length - 1];
        int i = 0;
        while (i < controlPoints.length) {
            controlPoints[i] = this.points[i + 1].getSubtracted(this.points[i]).getScaled(this.points.length - 1);
            controlPoints[i].z = 1.0;
            ++i;
        }
        return new BezierCurve(controlPoints);
    }

    public BezierCurve getElevated() {
        Point[] p = this.getPoints();
        Point[] q = new Point[p.length + 1];
        q[0] = p[0];
        q[p.length] = p[p.length - 1];
        int i = 1;
        while (i < p.length) {
            double c = (double)i / (double)p.length;
            q[i] = p[i - 1].getScaled(c).getTranslated(p[i].getScaled(1.0 - c));
            ++i;
        }
        return new BezierCurve(q);
    }

    private Vector3D getHC(double t) {
        if (t < 0.0 || t > 1.0) {
            throw new IllegalArgumentException("t out of range: " + t);
        }
        int n = this.points.length;
        if (n < 1) {
            return null;
        }
        double bn = 1.0;
        double tn = 1.0;
        double d = 1.0 - t;
        Vector3D pn = this.points[0].getScaled(bn * tn);
        int i = 1;
        while (i < n) {
            bn = bn * (double)(n - i) / (double)i;
            pn = pn.getScaled(d).getAdded(this.points[i].getScaled(bn * (tn *= t)));
            ++i;
        }
        return pn;
    }

    Set<IntervalPair> getIntersectionIntervalPairs(BezierCurve other, Set<Point> intersections) {
        HashSet<IntervalPair> intervalPairs = new HashSet<IntervalPair>();
        HashSet<IntervalPair> endPointIntervalPairs = new HashSet<IntervalPair>();
        IntervalPair ip = new IntervalPair(this, Interval.getFull(), other, Interval.getFull());
        BezierCurve.findEndPointIntersections(ip, endPointIntervalPairs, intersections);
        BezierCurve.findIntersectionChunks(ip, intervalPairs, intersections);
        BezierCurve.normalizeIntervalPairs(intervalPairs.toArray(new IntervalPair[0]));
        IntervalPair[] clusters = BezierCurve.clusterChunks(intervalPairs.toArray(new IntervalPair[0]), 0);
        IntervalPair overlapIntervalPair = BezierCurve.extractOverlap(clusters, endPointIntervalPairs.toArray(new IntervalPair[0]));
        BezierCurve overlap = overlapIntervalPair == null ? null : overlapIntervalPair.getPClipped();
        HashSet<IntervalPair> results = new HashSet<IntervalPair>();
        for (IntervalPair epip : endPointIntervalPairs) {
            if (overlapIntervalPair == null || !BezierCurve.isNextTo(overlapIntervalPair, epip, -3)) {
                results.add(epip);
                continue;
            }
            Iterator<Point> iterator = intersections.iterator();
            while (iterator.hasNext()) {
                if (!overlap.contains(iterator.next())) continue;
                iterator.remove();
            }
        }
        IntervalPair[] intervalPairArray = clusters;
        int n = clusters.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                IntervalPair cluster = intervalPairArray[n2];
                if (overlapIntervalPair == null || !BezierCurve.isNextTo(overlapIntervalPair, cluster, -3)) {
                    for (IntervalPair epip : endPointIntervalPairs) {
                        if (!BezierCurve.isNextTo(cluster, epip, -3)) {
                            continue;
                        }
                        break block9;
                    }
                    Point poi = BezierCurve.findSinglePreciseIntersection(cluster);
                    if (poi != null) {
                        intersections.add(poi);
                        if (cluster.converges()) {
                            results.add(cluster.getCopy());
                        }
                    }
                }
            }
            ++n2;
        }
        return results;
    }

    public Point[] getIntersections(BezierCurve other) {
        HashSet<Point> intersections = new HashSet<Point>();
        this.getIntersectionIntervalPairs(other, intersections);
        return intersections.toArray(new Point[0]);
    }

    @Override
    public final Point[] getIntersections(ICurve curve) {
        HashSet<Point> intersections = new HashSet<Point>();
        BezierCurve[] bezierCurveArray = curve.toBezier();
        int n = bezierCurveArray.length;
        int n2 = 0;
        while (n2 < n) {
            BezierCurve c = bezierCurveArray[n2];
            intersections.addAll(Arrays.asList(this.getIntersections(c)));
            ++n2;
        }
        return intersections.toArray(new Point[0]);
    }

    public PolyBezier getOffset(double distance) {
        return new LocalIntersectionOffsetRefiner().refine(new CuspAwareOffsetApproximator().approximateOffset(this, distance));
    }

    PolyBezier getOffsetRaw(double distance) {
        return BezierCurve.mergeCurves(new CuspAwareOffsetApproximator().approximateOffset(this, distance).getApproximatedOffsetCurve());
    }

    public BezierCurve getOverlap(BezierCurve other) {
        if (this.equals(other)) {
            return this.getCopy();
        }
        HashSet<Point> intersections = new HashSet<Point>();
        HashSet<IntervalPair> intervalPairs = new HashSet<IntervalPair>();
        HashSet<IntervalPair> endPointIntervalPairs = new HashSet<IntervalPair>();
        IntervalPair ip = new IntervalPair(this, Interval.getFull(), other, Interval.getFull());
        BezierCurve.findEndPointIntersections(ip, endPointIntervalPairs, intersections);
        BezierCurve.findIntersectionChunks(ip, intervalPairs, intersections);
        IntervalPair[] intervalPairs2 = intervalPairs.toArray(new IntervalPair[0]);
        BezierCurve.normalizeIntervalPairs(intervalPairs2);
        IntervalPair[] clusters = BezierCurve.clusterChunks(intervalPairs2, 0);
        IntervalPair overlap = BezierCurve.extractOverlap(clusters, endPointIntervalPairs.toArray(new IntervalPair[0]));
        return overlap == null ? null : overlap.getPClipped();
    }

    @Override
    public final ICurve[] getOverlaps(ICurve c) {
        return CurveUtils.getOverlaps(this, c);
    }

    @Override
    public Point getP1() {
        return this.points[0].toPoint();
    }

    @Override
    public Point getP2() {
        return this.points[this.points.length - 1].toPoint();
    }

    public double getParameterAt(Point p) {
        if (p == null) {
            throw new IllegalArgumentException("The passed-in Point may not be null: getParameterAt(" + p + "), this = " + this);
        }
        double[] interval = new double[]{0.0, 1.0};
        if (BezierCurve.containmentParameter(this, interval, p)) {
            return (interval[0] + interval[1]) / 2.0;
        }
        throw new IllegalArgumentException("The given Point does not lie on this BezierCurve: getParameterAt(" + p + "), this = " + this);
    }

    public Point getPoint(int i) {
        if (i < 0 || i >= this.points.length) {
            throw new IllegalArgumentException("You can only index this BezierCurve's points from 0 to " + (this.points.length - 1) + ": getPoint(" + i + "), this = " + this);
        }
        return this.points[i].toPoint();
    }

    public Point[] getPoints() {
        Point[] realPoints = new Point[this.points.length];
        int i = 0;
        while (i < this.points.length) {
            realPoints[i] = this.points[i].toPoint();
            ++i;
        }
        return realPoints;
    }

    private Vector3D[] getPointsCopy() {
        Vector3D[] copy = new Vector3D[this.points.length];
        int i = 0;
        while (i < this.points.length) {
            copy[i] = this.points[i].getCopy();
            ++i;
        }
        return copy;
    }

    @Override
    public Point getProjection(Point reference) {
        int numSamples = 100;
        double nearestParam = 0.0;
        Point nearest = this.get(nearestParam);
        double distance = reference.getDistance(nearest);
        int i = 1;
        while (i < numSamples) {
            double t = (double)i / ((double)numSamples - 1.0);
            Point candidate = this.get(t);
            double d = reference.getDistance(candidate);
            if (d < distance) {
                nearestParam = t;
                nearest = candidate;
                distance = d;
            }
            ++i;
        }
        Interval interval = new Interval(nearestParam / (double)(numSamples - 1) - 1.0 / (double)(numSamples - 1), nearestParam / (double)(numSamples - 1) + 1.0 / (double)(numSamples - 1));
        interval.a = Math.min(1.0, Math.max(0.0, interval.a));
        interval.b = Math.min(1.0, Math.max(0.0, interval.b));
        while (!interval.converges()) {
            Point sp = this.get(interval.a);
            Point ep = this.get(interval.b);
            double sDist = reference.getDistance(sp);
            double eDist = reference.getDistance(ep);
            if (sDist >= distance && eDist >= distance) {
                double range = interval.b - interval.a;
                interval.b = interval.a + 0.75 * range;
                interval.a += 0.25 * range;
                continue;
            }
            if (sDist < distance && sDist < eDist) {
                distance = sDist;
                nearest = sp;
                interval.b = (interval.a + interval.b) / 2.0;
                continue;
            }
            if (eDist < distance) {
                distance = eDist;
                nearest = ep;
                interval.a = (interval.a + interval.b) / 2.0;
                continue;
            }
            throw new IllegalStateException("condition should not be reachable");
        }
        return nearest;
    }

    @Override
    public BezierCurve getRotatedCCW(Angle angle) {
        return this.getCopy().rotateCCW(angle);
    }

    @Override
    public BezierCurve getRotatedCCW(Angle angle, double cx, double cy) {
        return this.getCopy().rotateCCW(angle, cx, cy);
    }

    @Override
    public BezierCurve getRotatedCCW(Angle angle, Point center) {
        return this.getCopy().rotateCCW(angle, center);
    }

    @Override
    public BezierCurve getRotatedCW(Angle angle) {
        return this.getCopy().rotateCW(angle);
    }

    @Override
    public BezierCurve getRotatedCW(Angle angle, double cx, double cy) {
        return this.getCopy().rotateCW(angle, cx, cy);
    }

    @Override
    public BezierCurve getRotatedCW(Angle angle, Point center) {
        return this.getCopy().rotateCW(angle, center);
    }

    @Override
    public BezierCurve getScaled(double factor) {
        return this.getCopy().scale(factor);
    }

    @Override
    public BezierCurve getScaled(double fx, double fy) {
        return this.getCopy().scale(fx, fy);
    }

    @Override
    public BezierCurve getScaled(double factor, double cx, double cy) {
        return this.getCopy().scale(factor, cx, cy);
    }

    @Override
    public BezierCurve getScaled(double fx, double fy, double cx, double cy) {
        return this.getCopy().scale(fx, fy, cx, cy);
    }

    @Override
    public BezierCurve getScaled(double fx, double fy, Point center) {
        return this.getCopy().scale(fx, fy, center);
    }

    @Override
    public BezierCurve getScaled(double factor, Point center) {
        return this.getCopy().scale(factor, center);
    }

    @Override
    public BezierCurve getTransformed(AffineTransform t) {
        return new BezierCurve(t.getTransformed(this.getPoints()));
    }

    @Override
    public BezierCurve getTranslated(double dx, double dy) {
        return this.getCopy().translate(dx, dy);
    }

    @Override
    public BezierCurve getTranslated(Point d) {
        return this.getCopy().translate(d.x, d.y);
    }

    @Override
    public double getX1() {
        return this.getP1().x;
    }

    @Override
    public double getX2() {
        return this.getP2().x;
    }

    @Override
    public double getY1() {
        return this.getP1().y;
    }

    @Override
    public double getY2() {
        return this.getP2().y;
    }

    @Override
    public boolean intersects(ICurve c) {
        return this.getIntersections(c).length > 0;
    }

    public boolean overlaps(BezierCurve other) {
        return this.getOverlap(other) != null;
    }

    @Override
    public final boolean overlaps(ICurve c) {
        BezierCurve[] bezierCurveArray = c.toBezier();
        int n = bezierCurveArray.length;
        int n2 = 0;
        while (n2 < n) {
            BezierCurve seg = bezierCurveArray[n2];
            if (this.overlaps(seg)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public BezierCurve rotateCCW(Angle angle) {
        Point centroid = Point.getCentroid(this.getPoints());
        return this.rotateCCW(angle, centroid.x, centroid.y);
    }

    public BezierCurve rotateCCW(Angle angle, double cx, double cy) {
        Point[] realPoints = this.getPoints();
        Point.rotateCCW(realPoints, angle, cx, cy);
        int i = 0;
        while (i < realPoints.length) {
            this.setPoint(i, realPoints[i]);
            ++i;
        }
        return this;
    }

    public BezierCurve rotateCCW(Angle angle, Point center) {
        int i = 0;
        while (i < this.points.length) {
            this.points[i] = new Vector3D(new Vector(this.points[i].toPoint().getTranslated(center.getNegated())).getRotatedCCW(angle).toPoint().getTranslated(center));
            ++i;
        }
        return this;
    }

    public BezierCurve rotateCW(Angle angle) {
        Point centroid = Point.getCentroid(this.getPoints());
        return this.rotateCW(angle, centroid.x, centroid.y);
    }

    public BezierCurve rotateCW(Angle angle, double cx, double cy) {
        Point[] realPoints = this.getPoints();
        Point.rotateCW(realPoints, angle, cx, cy);
        int i = 0;
        while (i < realPoints.length) {
            this.setPoint(i, realPoints[i]);
            ++i;
        }
        return this;
    }

    public BezierCurve rotateCW(Angle angle, Point center) {
        return this.rotateCW(angle, center.x, center.y);
    }

    @Override
    public BezierCurve scale(double factor) {
        return this.scale(factor, factor);
    }

    @Override
    public BezierCurve scale(double fx, double fy) {
        Point centroid = Point.getCentroid(this.getPoints());
        return this.scale(fx, fy, centroid.x, centroid.y);
    }

    @Override
    public BezierCurve scale(double factor, double cx, double cy) {
        return this.scale(factor, factor, cx, cy);
    }

    @Override
    public BezierCurve scale(double fx, double fy, double cx, double cy) {
        Point[] realPoints = this.getPoints();
        Point.scale(realPoints, fx, fy, cx, cy);
        int i = 0;
        while (i < realPoints.length) {
            this.setPoint(i, realPoints[i]);
            ++i;
        }
        return this;
    }

    @Override
    public BezierCurve scale(double fx, double fy, Point center) {
        return this.scale(fx, fy, center.x, center.y);
    }

    @Override
    public BezierCurve scale(double factor, Point center) {
        return this.scale(factor, factor, center.x, center.y);
    }

    public BezierCurve setP1(Point p1) {
        this.setPoint(0, p1);
        return this;
    }

    public BezierCurve setP2(Point p2) {
        this.setPoint(this.points.length - 1, p2);
        return this;
    }

    public BezierCurve setPoint(int i, Point p) {
        if (i < 0 || i >= this.points.length) {
            throw new IllegalArgumentException("setPoint(" + i + ", " + p + "): You can only index this BezierCurve's points from 0 to " + (this.points.length - 1) + ".");
        }
        this.points[i] = new Vector3D(p);
        return this;
    }

    public BezierCurve[] split(double t) {
        Vector3D[] leftPoints = new Vector3D[this.points.length];
        Vector3D[] rightPoints = new Vector3D[this.points.length];
        Vector3D[] ratioPoints = this.getPointsCopy();
        int i = 0;
        while (i < this.points.length) {
            leftPoints[i] = ratioPoints[0];
            rightPoints[this.points.length - 1 - i] = ratioPoints[this.points.length - 1 - i];
            int j = 0;
            while (j < this.points.length - i - 1) {
                ratioPoints[j] = ratioPoints[j].getRatio(ratioPoints[j + 1], t);
                ++j;
            }
            ++i;
        }
        return new BezierCurve[]{new BezierCurve(leftPoints), new BezierCurve(rightPoints)};
    }

    @Override
    public BezierCurve[] toBezier() {
        return new BezierCurve[]{this};
    }

    public CubicCurve toCubic() {
        if (this.points.length > 3) {
            return new CubicCurve(this.points[0].toPoint(), this.points[1].toPoint(), this.points[2].toPoint(), this.points[this.points.length - 1].toPoint());
        }
        return null;
    }

    public Line toLine() {
        if (this.points.length > 1) {
            return new Line(this.points[0].toPoint(), this.points[this.points.length - 1].toPoint());
        }
        return null;
    }

    public Line[] toLineStrip(double lineSimilarity) {
        return this.toLineStrip(lineSimilarity, Interval.getFull());
    }

    public Line[] toLineStrip(double lineSimilarity, Interval startInterval) {
        ArrayList<Line> lines = new ArrayList<Line>();
        Point startPoint = this.getHC(startInterval.a).toPoint();
        Stack<Interval> parts = new Stack<Interval>();
        parts.push(startInterval);
        while (!parts.isEmpty()) {
            Interval i = (Interval)parts.pop();
            BezierCurve part = this.getClipped(i.a, i.b);
            if (BezierCurve.distanceToBaseLine(part) < lineSimilarity) {
                Point endPoint = this.getHC(i.b).toPoint();
                lines.add(new Line(startPoint, endPoint));
                startPoint = endPoint;
                continue;
            }
            double im = i.getMid();
            parts.push(new Interval(im, i.b));
            parts.push(new Interval(i.a, im));
        }
        return lines.toArray(new Line[0]);
    }

    @Override
    public Path toPath() {
        Path path = new Path();
        Point startPoint = this.points[0].toPoint();
        path.moveTo(startPoint.x, startPoint.y);
        Line[] lineArray = this.toLineStrip(0.25);
        int n = lineArray.length;
        int n2 = 0;
        while (n2 < n) {
            Line seg = lineArray[n2];
            path.lineTo(seg.getX2(), seg.getY2());
            ++n2;
        }
        return path;
    }

    public Point[] toPoints(Interval startInterval) {
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(this.getHC(startInterval.a).toPoint());
        Stack<Interval> parts = new Stack<Interval>();
        parts.push(startInterval);
        while (!parts.isEmpty()) {
            Interval i = (Interval)parts.pop();
            BezierCurve part = this.getClipped(i.a, i.b);
            Point[] partPoints = part.getPoints();
            boolean allTogether = true;
            int j = 1;
            while (j < partPoints.length) {
                if (!partPoints[0].equals(partPoints[j])) {
                    allTogether = false;
                    break;
                }
                ++j;
            }
            if (allTogether) {
                points.add(partPoints[partPoints.length - 1]);
                continue;
            }
            double im = i.getMid();
            parts.push(new Interval(im, i.b));
            parts.push(new Interval(i.a, im));
        }
        return points.toArray(new Point[0]);
    }

    public QuadraticCurve toQuadratic() {
        if (this.points.length > 2) {
            return new QuadraticCurve(this.points[0].toPoint(), this.points[1].toPoint(), this.points[this.points.length - 1].toPoint());
        }
        return null;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("BezierCurve(");
        int i = 0;
        while (i < this.points.length) {
            Vector3D v = this.points[i];
            str.append(v);
            if (i < this.points.length - 1) {
                str.append(", ");
            }
            ++i;
        }
        str.append(")");
        return str.toString();
    }

    @Override
    public BezierCurve translate(double dx, double dy) {
        Point[] realPoints = this.getPoints();
        Point.translate(realPoints, dx, dy);
        int i = 0;
        while (i < realPoints.length) {
            this.setPoint(i, realPoints[i]);
            ++i;
        }
        return this;
    }

    @Override
    public BezierCurve translate(Point d) {
        return this.translate(d.x, d.y);
    }

    private static class CuspAwareOffsetApproximator {
        private ICurveSimplifier curveSimplifier;
        private IOffsetAlgorithm offsetAlgorithm;
        private ICuspSplitter cuspSplitter;

        public CuspAwareOffsetApproximator() {
            this(new LasserCurveSimplifier(), new TillerHansonOffsetAlgorithm(), new SamplingCuspSplitter());
        }

        public CuspAwareOffsetApproximator(ICurveSimplifier curveSimplifier, IOffsetAlgorithm offsetAlgorithm, ICuspSplitter cuspSplitter) {
            this.curveSimplifier = curveSimplifier;
            this.offsetAlgorithm = offsetAlgorithm;
            this.cuspSplitter = cuspSplitter;
        }

        public OffsetApproximation approximateOffset(BezierCurve curve, double distance) {
            ArrayList<BezierCurve> simpleCurve = new ArrayList<BezierCurve>();
            ArrayList<BezierCurve> approxOffsetCurve = new ArrayList<BezierCurve>();
            HashMap<Integer, Integer> approx2simple = new HashMap<Integer, Integer>();
            HashMap<Integer, Double> a2sParamStart = new HashMap<Integer, Double>();
            HashMap<Integer, Double> a2sParamEnd = new HashMap<Integer, Double>();
            List<PartialCurve> cuspsExtracted = this.cuspSplitter.splitAtCusps(curve);
            for (PartialCurve cc : cuspsExtracted) {
                Angle arcLengthAngle;
                Angle arcStartAngle;
                if (!(cc instanceof Cusp)) {
                    List<PartialCurve> simplified = this.curveSimplifier.simplify(cc.curve);
                    ArrayList<BezierCurve> simplifiedCurves = new ArrayList<BezierCurve>(simplified.size());
                    for (PartialCurve pc : simplified) {
                        simplifiedCurves.add(pc.curve.getClipped(pc.start, pc.end));
                    }
                    int simpleSize = simpleCurve.size();
                    simpleCurve.addAll(simplifiedCurves);
                    int j = 0;
                    while (j < simplifiedCurves.size()) {
                        BezierCurve simple = (BezierCurve)simplifiedCurves.get(j);
                        List<IOffsetAlgorithm.PartialOffset> parts = this.offsetAlgorithm.computeOffset(simple, distance);
                        for (IOffsetAlgorithm.PartialOffset part : parts) {
                            List<PartialCurve> splitApprox = this.curveSimplifier.simplify(part.offset);
                            int approxSize = approxOffsetCurve.size();
                            for (PartialCurve pc : splitApprox) {
                                approxOffsetCurve.add(pc.curve.getClipped(pc.start, pc.end));
                            }
                            int i = 0;
                            while (i < splitApprox.size()) {
                                approx2simple.put(approxSize + i, simpleSize + j);
                                PartialCurve pca = splitApprox.get(i);
                                double width = part.curveEnd - part.curveStart;
                                double c0 = part.curveStart + pca.start * width;
                                double c1 = part.curveStart + pca.end * width;
                                a2sParamStart.put(approxSize + i, c0);
                                a2sParamEnd.put(approxSize + i, c1);
                                ++i;
                            }
                        }
                        ++j;
                    }
                    continue;
                }
                Point center = curve.get(cc.start / 2.0 + cc.end / 2.0);
                Point startDirection = curve.getDerivative().get(cc.start);
                while (startDirection.equals(0.0, 0.0) && cc.start > 0.0) {
                    cc.start -= 1.0E-4;
                    if (cc.start < 0.0) {
                        cc.start = 0.0;
                    }
                    startDirection = curve.getDerivative().get(cc.start);
                }
                Point endDirection = curve.getDerivative().get(cc.end);
                while (endDirection.equals(0.0, 0.0) && cc.end < 1.0) {
                    cc.end += 1.0E-4;
                    if (cc.end > 1.0) {
                        cc.end = 1.0;
                    }
                    endDirection = curve.getDerivative().get(cc.end);
                }
                if (startDirection.equals(0.0, 0.0)) {
                    startDirection.setLocation(endDirection);
                }
                if (endDirection.equals(0.0, 0.0)) {
                    endDirection.setLocation(startDirection);
                }
                if (startDirection.equals(0.0, 0.0) || endDirection.equals(0.0, 0.0)) {
                    System.out.println("ERROR");
                    Point baselineDirection = new Vector(cc.curve.get(0.0), cc.curve.get(1.0)).toPoint();
                    startDirection.setLocation(baselineDirection);
                    endDirection.setLocation(baselineDirection);
                }
                Vector startNormal = new Vector(startDirection).getNormalized().getOrthogonalComplement();
                Vector endNormal = new Vector(endDirection).getNormalized().getOrthogonalComplement();
                Angle angleCCW = startNormal.getAngleCCW(endNormal);
                Angle angleCW = startNormal.getAngleCW(endNormal);
                if (angleCCW.rad() < angleCW.rad()) {
                    arcStartAngle = new Vector(1.0, 0.0).getAngleCCW(startNormal);
                    arcLengthAngle = angleCCW;
                } else {
                    arcStartAngle = new Vector(1.0, 0.0).getAngleCCW(endNormal);
                    arcLengthAngle = angleCW;
                }
                double absDistance = Math.abs(distance);
                PolyBezier arc = new Arc(center.x - absDistance, center.y - absDistance, 2.0 * absDistance, 2.0 * absDistance, arcStartAngle, arcLengthAngle).getRotatedCCW(Angle.fromDeg(distance < 0.0 ? 180 : 0));
                List<BezierCurve> arcBezier = Arrays.asList(arc.toBezier());
                Point lastOffsetPoint = curve.get(cc.start).getTranslated(startNormal.getMultiplied(distance).toPoint());
                if (lastOffsetPoint.getDistance(arcBezier.get(0).getP1()) > lastOffsetPoint.getDistance(arcBezier.get(arcBezier.size() - 1).getP2())) {
                    Collections.reverse(arcBezier);
                    int i = 0;
                    while (i < arcBezier.size()) {
                        BezierCurve c = arcBezier.get(i);
                        List<Point> pts = Arrays.asList(c.getPoints());
                        Collections.reverse(pts);
                        arcBezier.set(i, new BezierCurve(pts.toArray(new Point[0])));
                        ++i;
                    }
                }
                int approxSize = approxOffsetCurve.size();
                int simpleSize = simpleCurve.size();
                int i = 0;
                for (BezierCurve c : arcBezier) {
                    approxOffsetCurve.add(c);
                    approx2simple.put(approxSize + i, simpleSize - 1);
                    a2sParamStart.put(approxSize + i, 1.0);
                    a2sParamEnd.put(approxSize + i, 1.0);
                    ++i;
                }
            }
            return new OffsetApproximation(curve, distance, simpleCurve, approxOffsetCurve, approx2simple, a2sParamStart, a2sParamEnd);
        }

        private static class Cusp
        extends PartialCurve {
            public Cusp(BezierCurve c, double t0, double t1) {
                super(c, t0, t1);
            }
        }

        private static interface ICurveSimplifier {
            public List<PartialCurve> simplify(BezierCurve var1);
        }

        private static interface ICuspSplitter {
            public List<PartialCurve> splitAtCusps(BezierCurve var1);
        }

        private static interface IOffsetAlgorithm {
            public List<PartialOffset> computeOffset(BezierCurve var1, double var2);

            public static class PartialOffset {
                public BezierCurve offset;
                public double curveStart;
                public double curveEnd;

                public PartialOffset(BezierCurve offset, double t0, double t1) {
                    this.curveStart = t0;
                    this.curveEnd = t1;
                    this.offset = offset;
                }

                public PartialOffset(PartialCurve pc, BezierCurve offset) {
                    this(offset, pc.start, pc.end);
                }
            }
        }

        private static class LasserCurveSimplifier
        implements ICurveSimplifier {
            private static final int DEFAULT_MAX_DEPTH = 16;
            private int maxDepth;

            public LasserCurveSimplifier() {
                this(16);
            }

            public LasserCurveSimplifier(int maxDepth) {
                this.maxDepth = maxDepth;
            }

            private double computeAngleSum(BezierCurve curve) {
                double angleSum = 0.0;
                Point[] points = curve.getPoints();
                int i = 0;
                while (i < points.length - 2) {
                    Vector first = new Vector(points[i], points[i + 1]);
                    Vector second = new Vector(points[i + 1], points[i + 2]);
                    if (first.getLength() * second.getLength() > 0.0) {
                        Angle angle = first.getAngle(second);
                        angleSum += angle.rad();
                    }
                    ++i;
                }
                return angleSum;
            }

            private List<PartialCurve> computeLasserWithParams(PartialCurve partialCurve, int currentDepth) {
                BezierCurve curve = partialCurve.curve.getClipped(partialCurve.start, partialCurve.end);
                double angleSum = this.computeAngleSum(curve);
                ArrayList<PartialCurve> spline = new ArrayList<PartialCurve>();
                if (currentDepth < this.maxDepth && angleSum > Math.PI) {
                    PartialCurve[] split = partialCurve.split();
                    List<PartialCurve> left = this.computeLasserWithParams(split[0], currentDepth + 1);
                    List<PartialCurve> right = this.computeLasserWithParams(split[1], currentDepth + 1);
                    spline.addAll(left);
                    spline.addAll(right);
                } else {
                    spline.add(partialCurve);
                }
                return spline;
            }

            @Override
            public List<PartialCurve> simplify(BezierCurve curve) {
                return this.computeLasserWithParams(new PartialCurve(curve, 0.0, 1.0), 0);
            }
        }

        private static class PartialCurve {
            public BezierCurve curve;
            public double start;
            public double end;

            public PartialCurve(BezierCurve c, double t0, double t1) {
                this.curve = c;
                this.start = t0;
                this.end = t1;
            }

            public PartialCurve[] split() {
                double mid = this.start + 0.5 * (this.end - this.start);
                return new PartialCurve[]{new PartialCurve(this.curve, this.start, mid), new PartialCurve(this.curve, mid, this.end)};
            }
        }

        private static class SamplingCuspSplitter
        implements ICuspSplitter {
            private static final int DEFAULT_MAX_DEPTH = 4;
            private static final int DEFAULT_SAMPLE_COUNT = 128;
            private static final double DEFAULT_MIN_ANGLE_RAD = Angle.fromDeg(10.0).rad();
            private int sampleCount;
            private double minAngleRad;
            private int maxDepth;
            private BezierCurve curve;

            public SamplingCuspSplitter() {
                this(128, DEFAULT_MIN_ANGLE_RAD, 4);
            }

            public SamplingCuspSplitter(int sampleCount, double minAngle, int maxDepth) {
                if (sampleCount < 2) {
                    throw new IllegalArgumentException("sampleCount < 2");
                }
                this.sampleCount = sampleCount;
                this.minAngleRad = minAngle;
                this.maxDepth = maxDepth;
            }

            private List<Cusp> getCusps() {
                ArrayList<Cusp> cusps = new ArrayList<Cusp>();
                BezierCurve hodograph = this.curve.getDerivative();
                Point lastDirection = null;
                double lastT = 0.0;
                int i = 0;
                while (i < this.sampleCount) {
                    Angle angle;
                    double t = (double)i / (double)(this.sampleCount - 1);
                    Point direction = hodograph.get(t);
                    if (lastDirection != null && !direction.equals(0.0, 0.0) && (angle = new Vector(direction).getAngle(new Vector(lastDirection))).rad() > this.minAngleRad) {
                        cusps.add(this.refineCusp(lastT, t, 0));
                    }
                    if (!direction.equals(0.0, 0.0)) {
                        lastDirection = direction;
                        lastT = t;
                    }
                    ++i;
                }
                if (cusps.size() > 1) {
                    Cusp lastCusp = (Cusp)cusps.get(cusps.size() - 1);
                    int i2 = cusps.size() - 2;
                    while (i2 >= 0) {
                        Cusp c = (Cusp)cusps.get(i2);
                        if (this.curve.get(c.start).getDistance(this.curve.get(lastCusp.start)) < 1.0) {
                            if (lastCusp.start > c.start) {
                                lastCusp.start = c.start;
                            }
                            if (lastCusp.end < c.end) {
                                lastCusp.end = c.end;
                            }
                            cusps.remove(i2);
                        } else {
                            lastCusp = c;
                        }
                        --i2;
                    }
                }
                return cusps;
            }

            private Cusp refineCusp(double t0, double t1, int depth) {
                Point pb;
                Point pa = this.curve.get(t0);
                if (pa.getDistance(pb = this.curve.get(t1)) < 0.2) {
                    return new Cusp(this.curve, t0, t1);
                }
                BezierCurve hodograph = this.curve.getDerivative();
                Double maxRad = null;
                Point lastDirection = null;
                double lastT = 0.0;
                double maxA = t0;
                double maxB = t1;
                int i = 0;
                while (i < this.sampleCount) {
                    double t = t0 + (t1 - t0) * (double)i / (double)(this.sampleCount - 1);
                    Point direction = hodograph.get(t);
                    if (lastDirection != null && !direction.equals(0.0, 0.0)) {
                        Angle angle = new Vector(direction).getAngle(new Vector(lastDirection));
                        if (maxRad == null || angle.rad() > maxRad) {
                            maxRad = angle.rad();
                            maxA = lastT;
                            maxB = t;
                        }
                    }
                    if (!direction.equals(0.0, 0.0)) {
                        lastDirection = direction;
                        lastT = t;
                    }
                    ++i;
                }
                if (depth < this.maxDepth) {
                    return this.refineCusp(maxA, maxB, depth + 1);
                }
                return new Cusp(this.curve, maxA, maxB);
            }

            @Override
            public List<PartialCurve> splitAtCusps(BezierCurve curve) {
                this.curve = curve;
                List<Cusp> cusps = this.getCusps();
                ArrayList<PartialCurve> cc = new ArrayList<PartialCurve>();
                if (cusps.isEmpty()) {
                    cc.add(new PartialCurve(curve, 0.0, 1.0));
                    return cc;
                }
                cc.add(new PartialCurve(curve.split(cusps.get((int)0).start)[0], 0.0, 1.0));
                cc.add(cusps.get(0));
                int i = 1;
                while (i < cusps.size()) {
                    cc.add(new PartialCurve(curve.getClipped(cusps.get((int)(i - 1)).end, cusps.get((int)i).start), 0.0, 1.0));
                    cc.add(cusps.get(i));
                    ++i;
                }
                cc.add(new PartialCurve(curve.split(cusps.get((int)(cusps.size() - 1)).end)[1], 0.0, 1.0));
                return cc;
            }
        }

        public static class TillerHansonOffsetAlgorithm
        implements IOffsetAlgorithm {
            private static final double DEFAULT_ACCEPTABLE_ERROR = 0.1;
            private static final int DEFAULT_MAX_DEPTH = 32;
            private double acceptableError;
            private int maxDepth;
            private double distance;

            public TillerHansonOffsetAlgorithm() {
                this(0.1, 32);
            }

            public TillerHansonOffsetAlgorithm(double acceptableError, int maxDepth) {
                this.acceptableError = acceptableError;
                this.maxDepth = maxDepth;
            }

            private BezierCurve approximateOffset(BezierCurve curve) {
                Point[] curvePoints = curve.getPoints();
                ArrayList<ControlVertex> curveVertices = new ArrayList<ControlVertex>();
                curveVertices.add(new ControlVertex(curvePoints[0]));
                int i = 1;
                while (i < curvePoints.length) {
                    Point p = curvePoints[i];
                    ControlVertex lastVertex = (ControlVertex)curveVertices.get(curveVertices.size() - 1);
                    if (lastVertex.position.equals(p)) {
                        ++lastVertex.multiplicity;
                    } else {
                        curveVertices.add(new ControlVertex(p));
                    }
                    ++i;
                }
                if (curveVertices.size() < 2) {
                    return curve.getCopy();
                }
                ArrayList<ControlLeg> legs = new ArrayList<ControlLeg>();
                int i2 = 0;
                while (i2 < curveVertices.size() - 1) {
                    ControlVertex start = (ControlVertex)curveVertices.get(i2);
                    ControlVertex end = (ControlVertex)curveVertices.get(i2 + 1);
                    legs.add(new ControlLeg(start, end));
                    ++i2;
                }
                ArrayList<ControlLeg> offsetLegs = new ArrayList<ControlLeg>();
                for (ControlLeg leg : legs) {
                    Vector direction = new Vector(leg.start.position, leg.end.position);
                    if (direction.isNull()) {
                        throw new IllegalStateException("[ERROR] Leg direction cannot be computed because start and end position are the same.");
                    }
                    Point translation = direction.getOrthogonalComplement().getNormalized().getMultiplied(this.distance).toPoint();
                    ControlVertex offsetStart = new ControlVertex(leg.start.position.getTranslated(translation));
                    ControlVertex offsetEnd = new ControlVertex(leg.end.position.getTranslated(translation));
                    offsetLegs.add(new ControlLeg(offsetStart, offsetEnd));
                }
                ArrayList<ControlVertex> offsetVertices = new ArrayList<ControlVertex>();
                offsetVertices.add(((ControlLeg)offsetLegs.get((int)0)).start);
                int i3 = 1;
                while (i3 < offsetLegs.size()) {
                    ControlLeg previousLeg = (ControlLeg)offsetLegs.get(i3 - 1);
                    ControlLeg currentLeg = (ControlLeg)offsetLegs.get(i3);
                    Straight s1 = new Straight(previousLeg.start.position, previousLeg.end.position);
                    Straight s2 = new Straight(currentLeg.start.position, currentLeg.end.position);
                    Vector intersection = s1.getIntersection(s2);
                    if (intersection == null) {
                        Point p1 = previousLeg.end.position;
                        Point p2 = currentLeg.start.position;
                        Point mid = new Point(p1.x + p2.x, p1.y + p2.y).getScaled(0.5);
                        intersection = new Vector(mid);
                    }
                    offsetVertices.add(new ControlVertex(intersection.toPoint(), currentLeg.start.multiplicity));
                    ++i3;
                }
                offsetVertices.add(((ControlLeg)offsetLegs.get((int)(offsetLegs.size() - 1))).end);
                ArrayList<Point> offsetPoints = new ArrayList<Point>();
                for (ControlVertex vertex : offsetVertices) {
                    int i4 = 0;
                    while (i4 < vertex.multiplicity) {
                        offsetPoints.add(vertex.position.getCopy());
                        ++i4;
                    }
                }
                return new BezierCurve(offsetPoints.toArray(new Point[0]));
            }

            @Override
            public List<IOffsetAlgorithm.PartialOffset> computeOffset(BezierCurve curve, double distance) {
                this.distance = distance;
                return this.computeTillerHansonWithParams(new PartialCurve(curve, 0.0, 1.0), 0);
            }

            private double computeOffsetError(BezierCurve curve, BezierCurve hodograph, BezierCurve approx) {
                Double error = null;
                int N = curve.getPoints().length * 4;
                int i = 0;
                while (i < N) {
                    double t = (double)i / (double)(N - 1);
                    Point position = curve.get(t);
                    Point derivative = hodograph.get(t);
                    Vector tangent = new Vector(derivative);
                    if (tangent.getLength() > 0.0) {
                        Point direction = tangent.getNormalized().getOrthogonalComplement().getMultiplied(this.distance).toPoint();
                        Point offset = position.getTranslated(direction);
                        double delta = approx.get(t).getDistance(offset);
                        if (error == null || delta > error) {
                            error = delta;
                        }
                    }
                    ++i;
                }
                return error == null ? -1.0 : error;
            }

            private List<IOffsetAlgorithm.PartialOffset> computeTillerHansonWithParams(PartialCurve partialCurve, int currentDepth) {
                BezierCurve curve = partialCurve.curve.getClipped(partialCurve.start, partialCurve.end);
                BezierCurve approx = this.approximateOffset(curve);
                double error = this.computeOffsetError(curve, curve.getDerivative(), approx);
                ArrayList<IOffsetAlgorithm.PartialOffset> sapprox = new ArrayList<IOffsetAlgorithm.PartialOffset>();
                if (currentDepth < this.maxDepth && error >= this.acceptableError) {
                    PartialCurve[] s = partialCurve.split();
                    List<IOffsetAlgorithm.PartialOffset> l = this.computeTillerHansonWithParams(s[0], currentDepth + 1);
                    List<IOffsetAlgorithm.PartialOffset> r = this.computeTillerHansonWithParams(s[1], currentDepth + 1);
                    sapprox.addAll(l);
                    sapprox.addAll(r);
                } else if (error >= 0.0) {
                    sapprox.add(new IOffsetAlgorithm.PartialOffset(partialCurve, approx));
                }
                return sapprox;
            }

            private static class ControlLeg {
                public ControlVertex start;
                public ControlVertex end;

                public ControlLeg(ControlVertex start, ControlVertex end) {
                    this.start = new ControlVertex(start.position, start.multiplicity);
                    this.end = new ControlVertex(end.position, end.multiplicity);
                }
            }

            private static class ControlVertex {
                public Point position;
                public int multiplicity;

                public ControlVertex(Point pos) {
                    this.position = pos.getCopy();
                    this.multiplicity = 1;
                }

                public ControlVertex(Point pos, int mult) {
                    this.position = pos.getCopy();
                    this.multiplicity = mult;
                }
            }
        }
    }

    private static class FatLine {
        public Straight3D line = null;
        public double dmin = 0.0;
        public double dmax = 0.0;

        public static FatLine from(BezierCurve c, boolean ortho) {
            FatLine L = new FatLine();
            L.dmax = 0.0;
            L.dmin = 0.0;
            L.line = Straight3D.through(c.points[0], c.points[c.points.length - 1]);
            if (L.line == null) {
                return null;
            }
            if (ortho) {
                L.line = L.line.getOrtho();
            }
            if (L.line == null) {
                return null;
            }
            int i = 0;
            while (i < c.points.length) {
                double d = L.line.getSignedDistanceCW(c.points[i]);
                if (d < L.dmin) {
                    L.dmin = d;
                } else if (d > L.dmax) {
                    L.dmax = d;
                }
                ++i;
            }
            return L;
        }

        private FatLine() {
        }
    }

    static final class Interval {
        public double a;
        public double b;

        public static Interval getEmpty() {
            return new Interval(1.0, 0.0);
        }

        public static Interval getFull() {
            return new Interval(0.0, 1.0);
        }

        public static Interval min(Interval i, Interval j) {
            return i.b - i.a > j.b - j.a ? j : i;
        }

        public Interval(double ... ds) {
            if (ds.length <= 1) {
                throw new IllegalArgumentException("not enough values to create interval");
            }
            this.a = ds[0];
            this.b = ds[1];
        }

        public boolean converges() {
            return this.converges(0);
        }

        public boolean converges(int shift) {
            return PrecisionUtils.equal(this.a, this.b, shift);
        }

        public void expand(Interval i) {
            if (i.a < this.a) {
                this.a = i.a;
            }
            if (i.b > this.b) {
                this.b = i.b;
            }
        }

        public Interval getCopy() {
            return new Interval(this.a, this.b);
        }

        public double getMid() {
            return (this.a + this.b) / 2.0;
        }

        public double scaleTo(Interval interval) {
            double na = this.a + interval.a * (this.b - this.a);
            double nb = this.a + interval.b * (this.b - this.a);
            double ratio = (nb - na) / (this.b - this.a);
            this.a = na;
            this.b = nb;
            if (this.a < 0.0) {
                this.a = 0.0;
            }
            if (this.a > 1.0) {
                this.a = 1.0;
                this.b = 1.0;
            }
            if (this.b < 0.0) {
                this.a = 0.0;
                this.b = 0.0;
            }
            if (this.b > 1.0) {
                this.b = 1.0;
            }
            return ratio;
        }
    }

    static final class IntervalPair {
        public BezierCurve p;
        public BezierCurve q;
        public Interval pi;
        public Interval qi;

        public static void copy(IntervalPair dst, IntervalPair src) {
            dst.p = src.p;
            dst.q = src.q;
            dst.pi = src.pi;
            dst.qi = src.qi;
        }

        private static boolean equals(Vector3D v1, Vector3D v2, int precisionShift) {
            return PrecisionUtils.equal(v1.x / v1.z, v2.x / v2.z, precisionShift) && PrecisionUtils.equal(v1.y / v1.z, v2.y / v2.z, precisionShift);
        }

        public IntervalPair(BezierCurve pp, Interval pt, BezierCurve pq, Interval pu) {
            this.p = pp;
            this.pi = pt;
            this.q = pq;
            this.qi = pu;
        }

        public boolean converges() {
            return this.converges(0);
        }

        public boolean converges(int shift) {
            return !(!this.pi.converges(shift) && !IntervalPair.equals(this.p.getHC(this.pi.a), this.p.getHC(this.pi.b), shift) || !this.qi.converges(shift) && !IntervalPair.equals(this.q.getHC(this.qi.a), this.q.getHC(this.qi.b), shift));
        }

        public boolean convergesP() {
            return IntervalPair.equals(this.p.getHC(this.pi.a), this.p.getHC(this.pi.b), 0);
        }

        public boolean convergesQ() {
            return IntervalPair.equals(this.q.getHC(this.qi.a), this.q.getHC(this.qi.b), 0);
        }

        public void expand(IntervalPair ip) {
            if (this.p == ip.p) {
                this.pi.expand(ip.pi);
                this.qi.expand(ip.qi);
            } else {
                this.pi.expand(ip.qi);
                this.qi.expand(ip.pi);
            }
        }

        public IntervalPair getCopy() {
            return new IntervalPair(this.p, this.pi.getCopy(), this.q, this.qi.getCopy());
        }

        public BezierCurve getPClipped() {
            return this.p.getClipped(Math.max(this.pi.a, 0.0), Math.min(this.pi.b, 1.0));
        }

        public IntervalPair[] getPSplit() {
            double pm = (this.pi.a + this.pi.b) / 2.0;
            return new IntervalPair[]{new IntervalPair(this.p, new Interval(this.pi.a, pm), this.q, this.qi.getCopy()), new IntervalPair(this.p, new Interval(Math.min(this.pi.b, pm + 10.0 * UNRECOGNIZABLE_PRECISION_FRACTION), this.pi.b), this.q, this.qi.getCopy())};
        }

        public BezierCurve getQClipped() {
            return this.q.getClipped(Math.max(this.qi.a, 0.0), Math.min(this.qi.b, 1.0));
        }

        public IntervalPair[] getQSplit() {
            double qm = (this.qi.a + this.qi.b) / 2.0;
            return new IntervalPair[]{new IntervalPair(this.q, new Interval(this.qi.a, qm), this.p, this.pi.getCopy()), new IntervalPair(this.q, new Interval(Math.min(this.qi.b, qm + 10.0 * UNRECOGNIZABLE_PRECISION_FRACTION), this.qi.b), this.p, this.pi.getCopy())};
        }

        public IntervalPair getSwapped() {
            return new IntervalPair(this.q, this.qi.getCopy(), this.p, this.pi.getCopy());
        }

        public boolean isPLonger() {
            return this.pi.b - this.pi.a > this.qi.b - this.qi.a;
        }
    }

    private static class LocalIntersectionOffsetRefiner {
        private static final double DEFAULT_END_PARAM_PERCENTAGE = 0.02;
        private static final double DEFAULT_CONTAINMENT_EPSILON = 0.02;
        private double endParamPercentage;
        private double containmentEpsilon;
        private ICurveIntersector curveIntersector;
        private IGlobalIntersectionDetector globalIntersectionDetector;

        public LocalIntersectionOffsetRefiner() {
            this(new LineSimilarityCurveIntersector(), new WindingGlobalIntersectionDetector(), 0.02, 0.02);
        }

        public LocalIntersectionOffsetRefiner(ICurveIntersector curveIntersector, IGlobalIntersectionDetector globalIntersectionDetector, double endParamPercentage, double containmentEpsilon) {
            this.curveIntersector = curveIntersector;
            this.globalIntersectionDetector = globalIntersectionDetector;
            this.endParamPercentage = endParamPercentage;
            this.containmentEpsilon = containmentEpsilon;
        }

        public PolyBezier refine(OffsetApproximation oa) {
            Object inter;
            List<BezierCurve> approxOffset = oa.getApproximatedOffsetCurve();
            ArrayList<Intersection> offsetIntersections = new ArrayList<Intersection>();
            int i = 0;
            while (i < approxOffset.size() - 1) {
                BezierCurve a = approxOffset.get(i);
                int j = i + 1;
                while (j < approxOffset.size()) {
                    BezierCurve b = approxOffset.get(j);
                    Point[] intersections = this.curveIntersector.getIntersections(a, b).toArray(new Point[0]);
                    if (intersections.length > 0) {
                        double minA = 1.0;
                        double maxB = 0.0;
                        int k = 0;
                        while (k < intersections.length) {
                            double ta = a.getParameterAt(a.getProjection(intersections[k]));
                            double tb = b.getParameterAt(b.getProjection(intersections[k]));
                            if (ta < minA) {
                                minA = ta;
                            }
                            if (tb > maxB) {
                                maxB = tb;
                            }
                            ++k;
                        }
                        if (!(j == i + 1 && intersections.length == 1 && minA > 1.0 - this.endParamPercentage && maxB < this.endParamPercentage || this.globalIntersectionDetector.isGlobalIntersection(oa, i, j))) {
                            offsetIntersections.add(new Intersection(i, minA, j, maxB));
                        }
                    }
                    ++j;
                }
                ++i;
            }
            ArrayList<Intersection> toRemove = new ArrayList<Intersection>();
            if (offsetIntersections.size() > 1) {
                int i2 = 0;
                while (i2 < offsetIntersections.size()) {
                    Object snd;
                    Intersection fst = (Intersection)offsetIntersections.get(i2);
                    boolean nesting = false;
                    ArrayList<Integer> nested = new ArrayList<Integer>();
                    int j = i2 + 1;
                    while (j < offsetIntersections.size()) {
                        boolean hi;
                        snd = (Intersection)offsetIntersections.get(j);
                        boolean lo = fst.ai < ((Intersection)snd).ai || fst.ai == ((Intersection)snd).ai && fst.ap <= ((Intersection)snd).ap;
                        boolean bl = hi = fst.bi > ((Intersection)snd).bi || fst.bi == ((Intersection)snd).bi && fst.bp <= ((Intersection)snd).bp;
                        if (lo && hi) {
                            nesting = true;
                            nested.add(j);
                        }
                        ++j;
                    }
                    if (nesting) {
                        Collections.reverse(nested);
                        snd = nested.iterator();
                        while (snd.hasNext()) {
                            j = (Integer)snd.next();
                            offsetIntersections.remove(j);
                        }
                    }
                    toRemove.add(fst);
                    ++i2;
                }
            } else if (offsetIntersections.size() == 1) {
                toRemove.add((Intersection)offsetIntersections.get(0));
            }
            ArrayList<Integer> indicesToRemove = new ArrayList<Integer>();
            int i3 = toRemove.size() - 1;
            while (i3 >= 0) {
                inter = (Intersection)toRemove.get(i3);
                BezierCurve a = approxOffset.get(((Intersection)inter).ai);
                BezierCurve b = approxOffset.get(((Intersection)inter).bi);
                BezierCurve[] asplit = a.split(((Intersection)inter).ap);
                BezierCurve[] bananaSplit = b.split(((Intersection)inter).bp);
                approxOffset.set(((Intersection)inter).ai, asplit[0]);
                approxOffset.set(((Intersection)inter).bi, bananaSplit[1]);
                int k = ((Intersection)inter).bi - 1;
                while (k > ((Intersection)inter).ai) {
                    if (!indicesToRemove.contains(k)) {
                        indicesToRemove.add(k);
                    }
                    --k;
                }
                --i3;
            }
            Collections.sort(indicesToRemove, new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return o1 == o2 ? 0 : (o1 < o1 ? -1 : 1);
                }
            });
            inter = indicesToRemove.iterator();
            while (inter.hasNext()) {
                int k = (Integer)inter.next();
                approxOffset.remove(k);
            }
            ArrayList<Integer> fullyContainedOffsetIndices = new ArrayList<Integer>();
            BezierCurve input = oa.getInputCurve();
            double dMin = Math.abs(oa.getOffsetDistance()) - this.containmentEpsilon;
            int i4 = approxOffset.size() - 1;
            while (i4 >= 0) {
                BezierCurve oi = approxOffset.get(i4);
                boolean fullyContained = true;
                Point[] pointArray = oi.getBounds().getPoints();
                int n = pointArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Point p = pointArray[n2];
                    double dp = input.getProjection(p).getDistance(p);
                    if (dp > dMin) {
                        fullyContained = false;
                    }
                    ++n2;
                }
                if (fullyContained) {
                    fullyContainedOffsetIndices.add(i4);
                }
                --i4;
            }
            if (fullyContainedOffsetIndices.size() > 0) {
                ArrayList<Integer> startRemove = new ArrayList<Integer>();
                int i5 = 0;
                while (i5 < approxOffset.size() && fullyContainedOffsetIndices.contains(i5)) {
                    startRemove.add(i5);
                    ++i5;
                }
                Collections.reverse(startRemove);
                ArrayList<Integer> endRemove = new ArrayList<Integer>();
                int i6 = approxOffset.size() - 1;
                while (i6 >= 0 && fullyContainedOffsetIndices.contains(i6)) {
                    endRemove.add(i6);
                    --i6;
                }
                if (startRemove.size() > 0 && endRemove.size() > 0 && (Integer)startRemove.get(0) >= (Integer)endRemove.get(endRemove.size() - 1)) {
                    approxOffset.clear();
                } else {
                    Iterator iterator = endRemove.iterator();
                    while (iterator.hasNext()) {
                        i6 = (Integer)iterator.next();
                        approxOffset.remove(i6);
                    }
                    iterator = startRemove.iterator();
                    while (iterator.hasNext()) {
                        i6 = (Integer)iterator.next();
                        approxOffset.remove(i6);
                    }
                }
            }
            return BezierCurve.mergeCurves(approxOffset);
        }

        private static interface ICurveIntersector {
            public List<Point> getIntersections(BezierCurve var1, BezierCurve var2);
        }

        private static interface IGlobalIntersectionDetector {
            public boolean isGlobalIntersection(OffsetApproximation var1, int var2, int var3);
        }

        private static class Intersection {
            public int ai;
            public double ap;
            public int bi;
            public double bp;

            public Intersection(int ai, double ap, int bi, double bp) {
                this.ai = ai;
                this.ap = ap;
                this.bi = bi;
                this.bp = bp;
            }

            public String toString() {
                return String.valueOf(this.ai) + "," + this.ap + " : " + this.bi + "," + this.bp;
            }
        }

        private static class LineSimilarityCurveIntersector
        implements ICurveIntersector {
            private static final double DEFAULT_LINE_SIMILARITY_THRESHOLD = 0.2;
            private static final int DEFAULT_MAX_DEPTH = 32;
            private double lineSimilarityThreshold;
            private int maxDepth;

            private static double getLineSimilarity(BezierCurve cp) {
                double max = 0.0;
                Line baseline = cp.toLine();
                int N = cp.getPoints().length;
                int i = 0;
                while (i < N) {
                    Point p = cp.get((double)i / (double)(N - 1));
                    double distance = p.getDistance(baseline.getProjection(p));
                    if (distance > max) {
                        max = distance;
                    }
                    ++i;
                }
                return max;
            }

            public LineSimilarityCurveIntersector() {
                this(0.2, 32);
            }

            public LineSimilarityCurveIntersector(double lineSimilarityThreshold, int maxDepth) {
                this.lineSimilarityThreshold = lineSimilarityThreshold;
                this.maxDepth = maxDepth;
            }

            @Override
            public List<Point> getIntersections(BezierCurve cp, BezierCurve cq) {
                return this.getIntersections(cp, cq, 0);
            }

            private List<Point> getIntersections(BezierCurve cp, BezierCurve cq, int currentDepth) {
                double lineSimilarityQ;
                if (!cp.getControlBounds().touches(cq.getControlBounds())) {
                    return Collections.emptyList();
                }
                double lineSimilarityP = LineSimilarityCurveIntersector.getLineSimilarity(cp);
                if (lineSimilarityP < this.lineSimilarityThreshold && (lineSimilarityQ = LineSimilarityCurveIntersector.getLineSimilarity(cq)) < this.lineSimilarityThreshold) {
                    Point baselineIntersection = cp.toLine().getIntersection(cq.toLine());
                    if (baselineIntersection == null) {
                        return Collections.emptyList();
                    }
                    if (baselineIntersection != null) {
                        Point p = cp.getProjection(baselineIntersection);
                        Point q = cq.getProjection(baselineIntersection);
                        Point approxIntersection = new Rectangle(p, q).getCenter();
                        ArrayList<Point> intersections = new ArrayList<Point>();
                        intersections.add(approxIntersection);
                        return intersections;
                    }
                }
                ArrayList<Point> intersections = new ArrayList<Point>();
                if (currentDepth < this.maxDepth) {
                    BezierCurve[] pSplit = cp.split(0.5);
                    BezierCurve[] qSplit = cq.split(0.5);
                    intersections.addAll(this.getIntersections(pSplit[0], qSplit[0], currentDepth + 1));
                    intersections.addAll(this.getIntersections(pSplit[0], qSplit[1], currentDepth + 1));
                    intersections.addAll(this.getIntersections(pSplit[1], qSplit[0], currentDepth + 1));
                    intersections.addAll(this.getIntersections(pSplit[1], qSplit[1], currentDepth + 1));
                }
                return intersections;
            }
        }

        private static class WindingGlobalIntersectionDetector
        implements IGlobalIntersectionDetector {
            private static final double DEFAULT_SAMPLE_DISTANCE = 2.0;
            private static final int DEFAULT_SAMPLE_COUNT = 36;
            private int sampleCount;
            private double sampleDistance;

            public WindingGlobalIntersectionDetector() {
                this(36, 2.0);
            }

            public WindingGlobalIntersectionDetector(int sampleCount, double sampleDistance) {
                this.sampleCount = sampleCount;
                this.sampleDistance = sampleDistance;
            }

            private double determineAngle(List<BezierCurve> inputCurves) {
                ArrayList<Point> samples = new ArrayList<Point>();
                for (BezierCurve c : inputCurves) {
                    samples.addAll(this.sample(c));
                }
                double signedAngleSum = 0.0;
                int s = 0;
                while (s < samples.size() - 3) {
                    Point p = (Point)samples.get(s);
                    Point q = (Point)samples.get(s + 1);
                    Point r = (Point)samples.get(s + 2);
                    Vector u = new Vector(p, q);
                    Vector v = new Vector(q, r);
                    if (u.getLength() * v.getLength() > 0.0) {
                        double cw;
                        double ccw = u.getAngleCCW(v).rad();
                        signedAngleSum = ccw < (cw = u.getAngleCW(v).rad()) ? (signedAngleSum += ccw) : (signedAngleSum -= cw);
                    }
                    ++s;
                }
                return signedAngleSum;
            }

            @Override
            public boolean isGlobalIntersection(OffsetApproximation oa, int fstApproxIndex, int sndApproxIndex) {
                Integer simpleI = oa.getInputIndex(fstApproxIndex);
                Integer simpleJ = oa.getInputIndex(sndApproxIndex);
                if (simpleI == null || simpleJ == null) {
                    throw new IllegalStateException("OffsetApproximator does not map all offset approximation segments to the simplified input curve segments.");
                }
                List<BezierCurve> simpleCurve = oa.getSimplifiedInputCurve();
                Double ips = oa.getInputStartParam(fstApproxIndex);
                Double jpe = oa.getInputEndParam(sndApproxIndex);
                ArrayList<BezierCurve> inputCurves = new ArrayList<BezierCurve>();
                if (simpleJ > simpleI) {
                    BezierCurve sl = simpleCurve.get(simpleI).split(ips)[1];
                    inputCurves.add(sl);
                    int n = simpleI + 1;
                    while (n < simpleJ) {
                        inputCurves.add(simpleCurve.get(n));
                        ++n;
                    }
                    BezierCurve sr = simpleCurve.get(simpleJ).split(jpe)[0];
                    inputCurves.add(sr);
                } else {
                    inputCurves.add(simpleCurve.get(simpleI).getClipped(ips, jpe));
                }
                return Math.abs(this.determineAngle(inputCurves)) >= Math.PI;
            }

            private List<Point> sample(BezierCurve curve) {
                ArrayList<Point> pts = new ArrayList<Point>();
                int i = -1;
                while (i < this.sampleCount) {
                    double t = (double)(i + 1) / (double)this.sampleCount;
                    if (pts.isEmpty()) {
                        pts.add(curve.get(t));
                    } else {
                        Point pt = curve.get(t);
                        if (((Point)pts.get(pts.size() - 1)).getDistance(pt) >= this.sampleDistance) {
                            pts.add(pt);
                        }
                    }
                    ++i;
                }
                return pts;
            }
        }
    }

    private static class OffsetApproximation {
        private List<BezierCurve> simpleCurve = new ArrayList<BezierCurve>();
        private List<BezierCurve> approxOffsetCurve = new ArrayList<BezierCurve>();
        private Map<Integer, Integer> approx2simple = new HashMap<Integer, Integer>();
        private Map<Integer, Double> a2sParamStart = new HashMap<Integer, Double>();
        private Map<Integer, Double> a2sParamEnd = new HashMap<Integer, Double>();
        private BezierCurve inputCurve;
        private double offsetDistance;

        public OffsetApproximation(BezierCurve inputCurve, double offsetDistance, List<BezierCurve> simpleCurve, List<BezierCurve> approxOffsetCurve, Map<Integer, Integer> approx2simple, Map<Integer, Double> a2sParamStart, Map<Integer, Double> a2sParamEnd) {
            this.inputCurve = inputCurve;
            this.offsetDistance = offsetDistance;
            this.simpleCurve = simpleCurve;
            this.approxOffsetCurve = approxOffsetCurve;
            this.approx2simple = approx2simple;
            this.a2sParamStart = a2sParamStart;
            this.a2sParamEnd = a2sParamEnd;
        }

        public List<BezierCurve> getApproximatedOffsetCurve() {
            return this.approxOffsetCurve;
        }

        public BezierCurve getInputCurve() {
            return this.inputCurve;
        }

        public double getInputEndParam(int i) {
            return this.a2sParamEnd.get(i);
        }

        public int getInputIndex(int i) {
            return this.approx2simple.get(i);
        }

        public double getInputStartParam(int i) {
            return this.a2sParamStart.get(i);
        }

        public double getOffsetDistance() {
            return this.offsetDistance;
        }

        public List<BezierCurve> getSimplifiedInputCurve() {
            return this.simpleCurve;
        }
    }
}

