/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui;

import javafx.scene.Group;
import javafx.scene.Node;
import org.eclipse.gef.dot.internal.ui.DotEdgeLabelPart;
import org.eclipse.gef.dot.internal.ui.DotProperties;
import org.eclipse.gef.graph.Edge;

public class DotHTMLEdgeLabelPart
extends DotEdgeLabelPart {
    protected Group doCreateVisual() {
        this.createText();
        return new Group();
    }

    @Override
    protected void doRefreshVisual(Group visual) {
        super.doRefreshVisual(visual);
        this.refreshHtmlLabelNode();
    }

    protected void refreshHtmlLabelNode() {
        Node fx = this.getHtmlLabelNode();
        if (fx != null && !((Group)this.getVisual()).getChildren().contains((Object)fx)) {
            ((Group)this.getVisual()).getChildren().clear();
            ((Group)this.getVisual()).getChildren().add((Object)fx);
        }
    }

    protected Node getHtmlLabelNode() {
        Edge edge = (Edge)this.getContent().getKey();
        String attributeName = (String)this.getContent().getValue();
        if ("element-label".equals(attributeName)) {
            return DotProperties.getHtmlLikeLabel(edge);
        }
        if ("element-external-label".equals(attributeName)) {
            return DotProperties.getHtmlLikeExternalLabel(edge);
        }
        if ("edge-source-label".equals(attributeName)) {
            return DotProperties.getHtmlLikeSourceLabel(edge);
        }
        if ("edge-target-label".equals(attributeName)) {
            return DotProperties.getHtmlLikeTargetLabel(edge);
        }
        return null;
    }
}

