/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.mvc.fx.handlers.ISnapToStrategy;
import org.eclipse.gef.mvc.fx.models.SnappingModel;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;

public class AddSnapToStrategyOperation
extends AbstractOperation
implements ITransactionalOperation {
    private List<ISnapToStrategy> initialSupportedStrategies;
    private ISnapToStrategy strategy;
    private SnappingModel model;

    public AddSnapToStrategyOperation(SnappingModel model, ISnapToStrategy strategy) {
        super("Add Snap-To Strategy");
        this.model = model;
        this.strategy = strategy;
        this.initialSupportedStrategies = new ArrayList<ISnapToStrategy>((Collection<ISnapToStrategy>)model.snapToStrategiesProperty());
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.model.snapToStrategiesProperty().contains((Object)this.strategy)) {
            this.model.snapToStrategiesProperty().add((Object)this.strategy);
        }
        return Status.OK_STATUS;
    }

    @Override
    public boolean isContentRelevant() {
        return false;
    }

    @Override
    public boolean isNoOp() {
        return this.initialSupportedStrategies.contains(this.strategy);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.model.snapToStrategiesProperty().contains((Object)this.strategy)) {
            this.model.snapToStrategiesProperty().remove((Object)this.strategy);
        }
        return Status.OK_STATUS;
    }
}

