/**
 * Copyright (c) 2020 itemis AG and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Zoey Prigge (itemis AG) - initial API & implementation (bug #561084)
 */
package org.eclipse.gef.dot.internal.ui.language.wizard;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.ui.XtextProjectHelper;
import org.eclipse.xtext.ui.util.ProjectFactory;
import org.eclipse.xtext.ui.wizard.template.AbstractProjectTemplate;
import org.eclipse.xtext.ui.wizard.template.IProjectGenerator;
import org.eclipse.xtext.ui.wizard.template.ProjectTemplate;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@ProjectTemplate(label = "Simple Directed Graph", icon = "project_template.png", description = "<p><b>Simple Directed Graph</b></p>\n<p>This wizard creates a GEF DOT project containing a sample directed graph. I.e. a graph whose edges are directed.</p>")
@SuppressWarnings("all")
public final class DirectedGraph extends AbstractProjectTemplate {
  @Override
  public void generateProjects(final IProjectGenerator generator) {
    ProjectFactory _projectFactory = new ProjectFactory();
    final Procedure1<ProjectFactory> _function = (ProjectFactory it) -> {
      it.setProjectName(this.getProjectInfo().getProjectName());
      it.setLocation(this.getProjectInfo().getLocationPath());
      List<String> _projectNatures = it.getProjectNatures();
      Iterables.<String>addAll(_projectNatures, Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(XtextProjectHelper.NATURE_ID)));
      List<String> _builderIds = it.getBuilderIds();
      Iterables.<String>addAll(_builderIds, Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(XtextProjectHelper.BUILDER_ID)));
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("example.dot");
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append("/*");
      _builder_1.newLine();
      _builder_1.append(" ");
      _builder_1.append("* This is an example of a directed graph");
      _builder_1.newLine();
      _builder_1.append(" ");
      _builder_1.append("* To get help creating further graphs use the add file wizard.");
      _builder_1.newLine();
      _builder_1.append(" ");
      _builder_1.append("*/");
      _builder_1.newLine();
      _builder_1.append("digraph sampleGraphName {");
      _builder_1.newLine();
      _builder_1.append("\t");
      _builder_1.append("1 [label=\"Hello World\"]");
      _builder_1.newLine();
      _builder_1.append("\t");
      _builder_1.append("1->2");
      _builder_1.newLine();
      _builder_1.append("}");
      _builder_1.newLine();
      this.addFile(it, _builder, _builder_1);
    };
    ProjectFactory _doubleArrow = ObjectExtensions.<ProjectFactory>operator_doubleArrow(_projectFactory, _function);
    generator.generate(_doubleArrow);
  }
}
