/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.conversion;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.paint.Color;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.language.color.DotColors;
import org.eclipse.gef.dot.internal.language.color.HSVColor;
import org.eclipse.gef.dot.internal.language.color.RGBColor;
import org.eclipse.gef.dot.internal.language.color.StringColor;
import org.eclipse.gef.dot.internal.language.colorlist.ColorList;
import org.eclipse.gef.dot.internal.language.colorlist.WC;
import org.eclipse.gef.dot.internal.language.dot.Attribute;
import org.eclipse.gef.dot.internal.ui.conversion.DotColorInfo;
import org.eclipse.gef.dot.internal.ui.language.DotActivator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtext.parser.IParser;

public class DotColorUtil {
    public String computeZestColor(String colorScheme, org.eclipse.gef.dot.internal.language.color.Color dotColor) {
        String javaFxColor = null;
        if (dotColor instanceof RGBColor) {
            RGBColor rgbColor = (RGBColor)dotColor;
            StringBuffer sb = new StringBuffer();
            sb.append("#");
            sb.append(rgbColor.getR());
            sb.append(rgbColor.getG());
            sb.append(rgbColor.getB());
            if (rgbColor.getA() != null) {
                sb.append(rgbColor.getA());
            }
            javaFxColor = sb.toString();
        } else if (dotColor instanceof HSVColor) {
            HSVColor hsvColor = (HSVColor)dotColor;
            javaFxColor = String.format("hsb(%s, %s%%, %s%%)", Double.parseDouble(hsvColor.getH()) * 360.0, Double.parseDouble(hsvColor.getS()) * 100.0, Double.parseDouble(hsvColor.getV()) * 100.0);
        } else if (dotColor instanceof StringColor) {
            StringColor stringColor = (StringColor)dotColor;
            String currentColorScheme = stringColor.getScheme();
            if (currentColorScheme == null) {
                currentColorScheme = colorScheme;
            }
            if (currentColorScheme == null || currentColorScheme.isEmpty()) {
                currentColorScheme = "x11";
            }
            String colorName = stringColor.getName();
            javaFxColor = DotColors.get((String)currentColorScheme, (String)colorName);
        }
        return javaFxColor;
    }

    public Color computeGraphBackgroundColor(String colorScheme, org.eclipse.gef.dot.internal.language.color.Color dotColor) {
        if (dotColor instanceof HSVColor) {
            HSVColor hsvColor = (HSVColor)dotColor;
            return Color.hsb((double)(Double.parseDouble(hsvColor.getH()) * 360.0), (double)Double.parseDouble(hsvColor.getS()), (double)Double.parseDouble(hsvColor.getV()));
        }
        String javaFxStringColor = this.computeZestColor(colorScheme, dotColor);
        if (javaFxStringColor != null) {
            return Color.web((String)javaFxStringColor);
        }
        return null;
    }

    public org.eclipse.gef.dot.internal.language.color.Color parseColorAttributeValue(String colorAttributeValue) {
        if (colorAttributeValue == null) {
            return null;
        }
        IParser parser = (IParser)DotActivator.getInstance().getInjector("org.eclipse.gef.dot.internal.language.DotColor").getInstance(IParser.class);
        EObject rootNode = parser.parse((Reader)new StringReader(colorAttributeValue)).getRootASTElement();
        if (rootNode instanceof org.eclipse.gef.dot.internal.language.color.Color) {
            return (org.eclipse.gef.dot.internal.language.color.Color)rootNode;
        }
        return null;
    }

    public List<org.eclipse.gef.dot.internal.language.color.Color> parseColorListAttributeValue(String colorListAttributeValue) {
        if (colorListAttributeValue == null) {
            return null;
        }
        IParser parser = (IParser)DotActivator.getInstance().getInjector("org.eclipse.gef.dot.internal.language.DotColorList").getInstance(IParser.class);
        EObject rootNode = parser.parse((Reader)new StringReader(colorListAttributeValue)).getRootASTElement();
        if (rootNode instanceof ColorList) {
            ColorList colorList = (ColorList)rootNode;
            ArrayList<org.eclipse.gef.dot.internal.language.color.Color> colors = new ArrayList<org.eclipse.gef.dot.internal.language.color.Color>();
            for (WC wc : colorList.getColorValues()) {
                org.eclipse.gef.dot.internal.language.color.Color color = wc.getColor();
                colors.add(color);
            }
            return colors;
        }
        return null;
    }

    public DotColorInfo getColorInfo(Attribute attribute) {
        org.eclipse.gef.dot.internal.language.color.Color dotColor = this.parseColorAttributeValue(attribute.getValue().toValue());
        DotColorInfo colorInfo = new DotColorInfo(attribute, dotColor);
        colorInfo.calculate();
        return colorInfo;
    }

    public List<DotColorInfo> getColorInfos(Attribute attribute) {
        ArrayList<DotColorInfo> colorInfos = new ArrayList<DotColorInfo>();
        List<org.eclipse.gef.dot.internal.language.color.Color> dotColors = this.parseColorListAttributeValue(attribute.getValue().toValue());
        for (org.eclipse.gef.dot.internal.language.color.Color dotColor : dotColors) {
            DotColorInfo colorInfo = new DotColorInfo(attribute, dotColor);
            colorInfo.calculate();
            colorInfos.add(colorInfo);
        }
        return colorInfos;
    }

    public org.eclipse.swt.graphics.Color hex2Rgb(String colorStr) {
        return new org.eclipse.swt.graphics.Color((Device)Display.getDefault(), Integer.valueOf(colorStr.substring(1, 3), 16).intValue(), Integer.valueOf(colorStr.substring(3, 5), 16).intValue(), Integer.valueOf(colorStr.substring(5, 7), 16).intValue());
    }
}

