/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.fx.nodes;

import java.util.List;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import org.eclipse.gef.fx.anchors.AnchorKey;
import org.eclipse.gef.fx.anchors.DynamicAnchor;
import org.eclipse.gef.fx.nodes.AbstractRouter;
import org.eclipse.gef.fx.nodes.Connection;
import org.eclipse.gef.fx.utils.NodeUtils;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.geometry.euclidean.Vector;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.Line;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.geometry.planar.Polygon;
import org.eclipse.gef.geometry.planar.Rectangle;

public class OrthogonalRouter
extends AbstractRouter {
    private static final double OFFSET = 15.0;

    private int findReferenceIndex(List<Point> points, int anchorIndex, IGeometry anchorageGeometry, int step) {
        int startIndex;
        int i = startIndex = anchorIndex + step;
        while (!(step < 0 ? i < 0 : i >= points.size())) {
            Point point = points.get(i);
            if (!anchorageGeometry.contains(point)) {
                return i;
            }
            i += step;
        }
        return startIndex;
    }

    @Override
    protected Point getAnchoredReferencePoint(List<Point> points, int index) {
        if (index < 0 || index >= points.size()) {
            throw new IndexOutOfBoundsException();
        }
        Connection connection = this.getConnection();
        IGeometry geometry = this.getAnchorageGeometry(index);
        int referenceIndex = this.findReferenceIndex(points, index, geometry, index < points.size() - 1 ? 1 : -1);
        IGeometry referenceGeometry = this.getAnchorageGeometry(referenceIndex);
        if (referenceGeometry != null && geometry != null) {
            double y2;
            double x2;
            Point endPointHint;
            int oppositeReferenceIndex = this.findReferenceIndex(points, index == 0 ? points.size() - 1 : 0, geometry, index < points.size() - 1 ? -1 : 1);
            if (this.getAnchorageGeometry(oppositeReferenceIndex) == null) {
                return points.get(oppositeReferenceIndex);
            }
            if (index == 0) {
                Point startPointHint = connection.getStartPointHint();
                if (startPointHint != null) {
                    return startPointHint;
                }
            } else if (index == points.size() - 1 && (endPointHint = connection.getEndPointHint()) != null) {
                return endPointHint;
            }
            Rectangle bounds = geometry.getBounds();
            Rectangle refBounds = referenceGeometry.getBounds();
            double x1 = Math.max(bounds.getX(), refBounds.getX());
            if (x1 <= (x2 = Math.min(bounds.getX() + bounds.getWidth(), refBounds.getX() + refBounds.getWidth()))) {
                return new Point(x1 + (x2 - x1) / 2.0, refBounds.getY() > bounds.getY() + bounds.getHeight() ? refBounds.getY() : refBounds.getY() + refBounds.getHeight());
            }
            double y1 = Math.max(bounds.getY(), refBounds.getY());
            if (y1 <= (y2 = Math.min(bounds.getY() + bounds.getHeight(), refBounds.getY() + refBounds.getHeight()))) {
                return new Point(refBounds.getX() > bounds.getX() + bounds.getWidth() ? refBounds.getX() : refBounds.getX() + refBounds.getWidth(), y1 + (y2 - y1) / 2.0);
            }
            return this.getNearestBoundsProjection(referenceGeometry, geometry.getBounds().getCenter());
        }
        return points.get(referenceIndex);
    }

    private Point getNearestBoundsProjection(IGeometry g, Point p) {
        Line[] outlineSegments = g.getBounds().getOutlineSegments();
        Point nearestProjection = null;
        double nearestDistance = 0.0;
        Line[] lineArray = outlineSegments;
        int n = outlineSegments.length;
        int n2 = 0;
        while (n2 < n) {
            Line l = lineArray[n2];
            Point projection = l.getProjection(p);
            double distance = p.getDistance(projection);
            if (nearestProjection == null || distance < nearestDistance) {
                nearestDistance = distance;
                nearestProjection = projection;
            }
            ++n2;
        }
        return nearestProjection;
    }

    private Polygon[] getTriangles(Connection connection, int i) {
        Node anchorage = connection.getAnchor(i).getAnchorage();
        Bounds boundsInScene = anchorage.localToScene(anchorage.getLayoutBounds());
        Rectangle rectangle = FX2Geometry.toRectangle((Bounds)boundsInScene);
        Polygon top = new Polygon(new Point[]{rectangle.getTopLeft(), rectangle.getTopRight(), rectangle.getCenter()});
        Polygon bottom = new Polygon(new Point[]{rectangle.getBottomLeft(), rectangle.getBottomRight(), rectangle.getCenter()});
        Polygon left = new Polygon(new Point[]{rectangle.getTopLeft(), rectangle.getBottomLeft(), rectangle.getCenter()});
        Polygon right = new Polygon(new Point[]{rectangle.getTopRight(), rectangle.getBottomRight(), rectangle.getCenter()});
        return new Polygon[]{top, right, bottom, left};
    }

    private boolean isBottom(Connection connection, int i, Point currentPoint) {
        Point2D pointInScene = connection.localToScene(currentPoint.x, currentPoint.y);
        Point point = FX2Geometry.toPoint((Point2D)pointInScene);
        Polygon[] triangles = this.getTriangles(connection, i);
        return triangles[2].contains(point);
    }

    private boolean isLeft(Connection connection, int i, Point currentPoint) {
        Point2D pointInScene = connection.localToScene(currentPoint.x, currentPoint.y);
        Point point = FX2Geometry.toPoint((Point2D)pointInScene);
        Polygon[] triangles = this.getTriangles(connection, i);
        return triangles[3].contains(point);
    }

    private boolean isRight(Connection connection, int i, Point currentPoint) {
        Point2D pointInScene = connection.localToScene(currentPoint.x, currentPoint.y);
        Point point = FX2Geometry.toPoint((Point2D)pointInScene);
        Polygon[] triangles = this.getTriangles(connection, i);
        return triangles[1].contains(point);
    }

    private boolean isSufficientlyHorizontal(Vector currentDirection) {
        return Math.abs(currentDirection.y) < 0.5 && Math.abs(currentDirection.x) > Math.abs(currentDirection.y);
    }

    private boolean isSufficientlyVertical(Vector currentDirection) {
        return Math.abs(currentDirection.y) > Math.abs(currentDirection.x) && Math.abs(currentDirection.x) < 0.5;
    }

    private boolean isTop(Connection connection, int i, Point currentPoint) {
        Point2D pointInScene = connection.localToScene(currentPoint.x, currentPoint.y);
        Point point = FX2Geometry.toPoint((Point2D)pointInScene);
        Polygon[] triangles = this.getTriangles(connection, i);
        return triangles[0].contains(point);
    }

    private boolean isTopOrBottom(Connection connection, int i, Point currentPoint) {
        Point2D pointInScene = connection.localToScene(currentPoint.x, currentPoint.y);
        Point point = FX2Geometry.toPoint((Point2D)pointInScene);
        Polygon[] triangles = this.getTriangles(connection, i);
        return triangles[0].contains(point) || triangles[2].contains(point);
    }

    @Override
    protected Vector route(AbstractRouter.ControlPointManipulator cpm, Vector inDirection, Vector outDirection) {
        if (Math.abs(outDirection.x) <= 0.05 && Math.abs(outDirection.y) <= 0.05) {
            return inDirection;
        }
        if (this.isSufficientlyHorizontal(outDirection) || this.isSufficientlyVertical(outDirection)) {
            return super.route(cpm, inDirection, outDirection);
        }
        return this.routeNonOrthogonalSegment(cpm.getConnection(), cpm, inDirection, outDirection, cpm.getIndex(), cpm.getPoint());
    }

    protected Vector routeNonOrthogonalSegment(Connection connection, AbstractRouter.ControlPointManipulator controlPointManipulator, Vector inDirection, Vector outDirection, int i, Point currentPoint) {
        controlPointManipulator.setRoutingData(i + 1, currentPoint, outDirection);
        Vector moveVertically = new Vector(0.0, outDirection.y);
        Vector moveHorizontally = new Vector(outDirection.x, 0.0);
        if (i == 0 && connection.isStartConnected() || i == connection.getPointsUnmodifiable().size() - 2 && connection.isEndConnected()) {
            if (i == 0 && i != connection.getPointsUnmodifiable().size() - 2) {
                outDirection = this.isTopOrBottom(connection, i, currentPoint) ? controlPointManipulator.addRoutingPoint(moveVertically) : controlPointManipulator.addRoutingPoint(moveHorizontally);
            } else if (i != 0 && i == connection.getPointsUnmodifiable().size() - 2) {
                outDirection = this.isTopOrBottom(connection, i + 1, currentPoint.getTranslated(outDirection.x, outDirection.y)) ? controlPointManipulator.addRoutingPoint(moveHorizontally) : controlPointManipulator.addRoutingPoint(moveVertically);
            } else {
                boolean currentIsTopOrBottom = this.isTopOrBottom(connection, i, currentPoint);
                boolean nextIsTopOrBottom = this.isTopOrBottom(connection, i + 1, currentPoint.getTranslated(outDirection.x, outDirection.y));
                if (currentIsTopOrBottom && nextIsTopOrBottom) {
                    controlPointManipulator.addRoutingPoints(i + 1, currentPoint, 0.0, outDirection.y / 2.0, outDirection.x, outDirection.y / 2.0);
                } else if (!currentIsTopOrBottom && !nextIsTopOrBottom) {
                    controlPointManipulator.addRoutingPoints(i + 1, currentPoint, outDirection.x / 2.0, 0.0, outDirection.x / 2.0, outDirection.y);
                } else {
                    outDirection = currentIsTopOrBottom ? controlPointManipulator.addRoutingPoint(moveVertically) : controlPointManipulator.addRoutingPoint(moveHorizontally);
                }
            }
        } else {
            outDirection = inDirection == null ? controlPointManipulator.addRoutingPoint(moveHorizontally) : (inDirection.isHorizontal() ? (inDirection.x < 0.0 && outDirection.x < 0.0 || inDirection.x > 0.0 && outDirection.x > 0.0 ? controlPointManipulator.addRoutingPoint(moveHorizontally) : controlPointManipulator.addRoutingPoint(moveVertically)) : (inDirection.y < 0.0 && outDirection.y < 0.0 || inDirection.y > 0.0 && outDirection.y > 0.0 ? controlPointManipulator.addRoutingPoint(moveVertically) : controlPointManipulator.addRoutingPoint(moveHorizontally)));
        }
        return outDirection;
    }

    protected Vector routeOrthogonalSegment(Connection connection, AbstractRouter.ControlPointManipulator controlPointManipulator, Vector currentDirection, int i, Point currentPoint) {
        if (i == 0 && connection.isStartConnected() && i != connection.getPointsUnmodifiable().size() - 2) {
            if (currentDirection.isVertical()) {
                boolean isLeft = this.isLeft(connection, i, currentPoint);
                boolean isRight = this.isRight(connection, i, currentPoint);
                boolean isBottom = this.isBottom(connection, i, currentPoint);
                boolean isTop = this.isTop(connection, i, currentPoint);
                if ((isLeft || isRight) && !isBottom && !isTop) {
                    double offset = isLeft ? -15.0 : 15.0;
                    controlPointManipulator.addRoutingPoints(i + 1, currentPoint, offset, 0.0, offset, currentDirection.y);
                    currentDirection = new Vector(-offset, 0.0);
                }
            } else if (currentDirection.isHorizontal()) {
                boolean isLeft = this.isLeft(connection, i, currentPoint);
                boolean isRight = this.isRight(connection, i, currentPoint);
                boolean isBottom = this.isBottom(connection, i, currentPoint);
                boolean isTop = this.isTop(connection, i, currentPoint);
                if ((isTop || isBottom) && !isLeft && !isRight) {
                    double offset = isTop ? -15.0 : 15.0;
                    controlPointManipulator.addRoutingPoints(i + 1, currentPoint, 0.0, offset, currentDirection.x, offset);
                    currentDirection = new Vector(0.0, -offset);
                }
            }
        } else if (i != 0 && i == connection.getPointsUnmodifiable().size() - 2 && connection.isEndConnected()) {
            if (currentDirection.isHorizontal()) {
                boolean isLeft = this.isLeft(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                boolean isRight = this.isRight(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                boolean isTop = this.isTop(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                boolean isBottom = this.isBottom(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                if ((isTop || isBottom) && !isLeft && !isRight) {
                    double offset = isTop ? -15.0 : 15.0;
                    controlPointManipulator.addRoutingPoints(i + 1, currentPoint, 0.0, offset, currentDirection.x, offset);
                    currentDirection = new Vector(0.0, -offset);
                }
            } else if (currentDirection.isVertical()) {
                boolean isLeft = this.isLeft(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                boolean isRight = this.isRight(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                boolean isTop = this.isTop(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                boolean isBottom = this.isBottom(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                if ((isLeft || isRight) && !isTop && !isBottom) {
                    double offset = isLeft ? -15.0 : 15.0;
                    controlPointManipulator.addRoutingPoints(i + 1, currentPoint, offset, 0.0, offset, currentDirection.y);
                    currentDirection = new Vector(-offset, 0.0);
                }
            }
        } else if (i == 0 && i == connection.getPointsUnmodifiable().size() - 2 && connection.isStartConnected() && connection.isEndConnected()) {
            if (currentDirection.isHorizontal()) {
                boolean isCurrentTop = this.isTop(connection, i, currentPoint);
                boolean isNextBottom = this.isBottom(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                boolean isCurrentBottom = this.isBottom(connection, i, currentPoint);
                boolean isNextTop = this.isTop(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                if (isCurrentTop && isNextBottom || isCurrentBottom && isNextTop) {
                    double offset = isCurrentTop ? -15.0 : 15.0;
                    controlPointManipulator.addRoutingPoints(i + 1, currentPoint, 0.0, offset, currentDirection.x / 2.0, offset, currentDirection.x / 2.0, currentDirection.y - offset, currentDirection.x, currentDirection.y - offset);
                    currentDirection = new Vector(0.0, offset);
                }
            } else if (currentDirection.isVertical()) {
                boolean isCurrentLeft = this.isLeft(connection, i, currentPoint);
                boolean isNextRight = this.isRight(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                boolean isCurrentRight = this.isRight(connection, i, currentPoint);
                boolean isNextLeft = this.isLeft(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                if (isCurrentLeft && isNextRight || isCurrentRight && isNextLeft) {
                    double offset = isCurrentLeft ? -15.0 : 15.0;
                    controlPointManipulator.addRoutingPoints(i + 1, currentPoint, offset, 0.0, offset, currentDirection.y / 2.0, currentDirection.x - offset, currentDirection.y / 2.0, currentDirection.x - offset, currentDirection.y);
                }
            }
        }
        return currentDirection;
    }

    @Override
    protected void updateComputationParameters(List<Point> points, int index, DynamicAnchor anchor, AnchorKey key) {
        super.updateComputationParameters(points, index, anchor, key);
        if (index == 0 || index == points.size() - 1) {
            Point neighborPoint = points.get(index == 0 ? index + 1 : index - 1);
            Point refPoint = NodeUtils.sceneToLocal((Node)this.getConnection(), NodeUtils.localToScene(key.getAnchored(), (Point)anchor.getComputationParameter(key, DynamicAnchor.AnchoredReferencePoint.class).get()));
            Point delta = neighborPoint.getDifference(refPoint);
            Orientation hint = null;
            if (Math.abs(delta.x) < 5.0 && Math.abs(delta.x) < Math.abs(delta.y)) {
                hint = Orientation.VERTICAL;
            } else if (Math.abs(delta.y) < 5.0 && Math.abs(delta.y) < Math.abs(delta.x)) {
                hint = Orientation.HORIZONTAL;
            }
            anchor.getComputationParameter(key, DynamicAnchor.PreferredOrientation.class).set(hint);
        }
    }
}

