/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.examples.logo;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import org.eclipse.gef.fx.nodes.InfiniteCanvas;
import org.eclipse.gef.mvc.fx.viewer.IViewer;
import org.eclipse.gef.mvc.fx.viewer.InfiniteCanvasViewer;

public class MvcLogoExampleViewersComposite {
    private static final double PALETTE_INDICATOR_WIDTH = 10.0;
    private final HBox composite;

    public MvcLogoExampleViewersComposite(IViewer contentViewer, IViewer paletteViewer) {
        Parent contentRootNode = contentViewer.getCanvas();
        final InfiniteCanvas paletteRootNode = ((InfiniteCanvasViewer)paletteViewer).getCanvas();
        AnchorPane viewersPane = new AnchorPane();
        viewersPane.getChildren().addAll((Object[])new Node[]{contentRootNode, paletteRootNode});
        Pane paletteIndicator = new Pane();
        paletteIndicator.setStyle("-fx-background-color: rgba(128,128,128,1);");
        paletteIndicator.setMaxSize(10.0, Double.MAX_VALUE);
        paletteIndicator.setMinSize(10.0, 0.0);
        this.composite = new HBox();
        this.composite.setStyle("-fx-background-color: transparent;");
        this.composite.getChildren().addAll((Object[])new Node[]{paletteIndicator, viewersPane});
        this.composite.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.composite.setMinSize(0.0, 0.0);
        this.composite.setFillHeight(true);
        this.composite.setSpacing(0.0);
        HBox.setHgrow((Node)viewersPane, (Priority)Priority.ALWAYS);
        viewersPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        AnchorPane.setBottomAnchor((Node)contentRootNode, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)contentRootNode, (Double)0.0);
        AnchorPane.setRightAnchor((Node)contentRootNode, (Double)0.0);
        AnchorPane.setTopAnchor((Node)contentRootNode, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)paletteRootNode, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)paletteRootNode, (Double)0.0);
        AnchorPane.setTopAnchor((Node)paletteRootNode, (Double)0.0);
        paletteRootNode.setZoomGrid(false);
        paletteRootNode.setShowGrid(false);
        paletteRootNode.setHorizontalScrollBarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        paletteRootNode.setStyle("-fx-background-insets: 0; -fx-padding: 0; -fx-background-color: rgba(128,128,128,0.75); -fx-border-color: rgba(128,128,128,1); -fx-border-width: 2;");
        paletteRootNode.setVisible(false);
        paletteIndicator.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                paletteRootNode.setVisible(true);
            }
        });
        paletteRootNode.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                paletteRootNode.setVisible(false);
            }
        });
        paletteRootNode.getContentGroup().layoutBoundsProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

            public void changed(ObservableValue<? extends Bounds> observable, Bounds oldValue, Bounds newValue) {
                double scrollBarWidth = paletteRootNode.getVerticalScrollBar().isVisible() ? paletteRootNode.getVerticalScrollBar().getLayoutBounds().getWidth() : 0.0;
                paletteRootNode.setPrefWidth(newValue.getWidth() + scrollBarWidth);
            }
        });
        paletteRootNode.getVerticalScrollBar().visibleProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                double contentWidth = paletteRootNode.getContentGroup().getLayoutBounds().getWidth();
                double scrollBarWidth = newValue != false ? paletteRootNode.getVerticalScrollBar().getLayoutBounds().getWidth() : 0.0;
                paletteRootNode.setPrefWidth(contentWidth + scrollBarWidth);
            }
        });
        paletteRootNode.addEventHandler(MouseEvent.MOUSE_PRESSED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getTarget() != paletteRootNode) {
                    paletteRootNode.setVisible(false);
                }
            }
        });
    }

    public Parent getComposite() {
        return this.composite;
    }
}

