/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.examples.logo.policies;

import javafx.geometry.Bounds;
import org.eclipse.gef.fx.nodes.InfiniteCanvas;
import org.eclipse.gef.mvc.fx.policies.ViewportPolicy;
import org.eclipse.gef.mvc.fx.viewer.InfiniteCanvasViewer;

public class ContentRestrictedChangeViewportPolicy
extends ViewportPolicy {
    protected void locallyExecuteOperation() {
        double tmp;
        double tx = this.getChangeViewportOperation().getNewHorizontalScrollOffset();
        double ty = this.getChangeViewportOperation().getNewVerticalScrollOffset();
        double dx = tx - this.getChangeViewportOperation().getInitialHorizontalScrollOffset();
        double dy = ty - this.getChangeViewportOperation().getInitialVerticalScrollOffset();
        InfiniteCanvasViewer viewer = (InfiniteCanvasViewer)this.getHost().getRoot().getViewer();
        InfiniteCanvas canvas = viewer.getCanvas();
        Bounds scrollableBounds = canvas.getScrollableBounds();
        double contentRestrictedMinTranslateX = -scrollableBounds.getMinX();
        double contentRestrictedMinTranslateY = -scrollableBounds.getMinY();
        double contentRestrictedMaxTranslateX = -(scrollableBounds.getMaxX() - canvas.getWidth());
        double contentRestrictedMaxTranslateY = -(scrollableBounds.getMaxY() - canvas.getHeight());
        if (contentRestrictedMinTranslateX > contentRestrictedMaxTranslateX) {
            tmp = contentRestrictedMinTranslateX;
            contentRestrictedMinTranslateX = contentRestrictedMaxTranslateX;
            contentRestrictedMaxTranslateX = tmp;
        }
        if (contentRestrictedMinTranslateY > contentRestrictedMaxTranslateY) {
            tmp = contentRestrictedMinTranslateY;
            contentRestrictedMinTranslateY = contentRestrictedMaxTranslateY;
            contentRestrictedMaxTranslateY = tmp;
        }
        if (!canvas.getHorizontalScrollBar().isVisible()) {
            tx = this.getChangeViewportOperation().getInitialHorizontalScrollOffset();
        } else if (tx < contentRestrictedMinTranslateX || tx > contentRestrictedMaxTranslateX) {
            tx = dx < 0.0 ? contentRestrictedMinTranslateX : contentRestrictedMaxTranslateX;
        }
        if (!canvas.getVerticalScrollBar().isVisible()) {
            ty = this.getChangeViewportOperation().getInitialVerticalScrollOffset();
        } else if (ty < contentRestrictedMinTranslateY || ty > contentRestrictedMaxTranslateY) {
            ty = dy < 0.0 ? contentRestrictedMinTranslateY : contentRestrictedMaxTranslateY;
        }
        this.getChangeViewportOperation().setNewHorizontalScrollOffset(tx);
        this.getChangeViewportOperation().setNewVerticalScrollOffset(ty);
        super.locallyExecuteOperation();
    }
}

