/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.quickfix;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlTag;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;

public class DotHtmlLabelQuickfixProvider
extends DefaultQuickfixProvider {
    @Fix(value="html_tag_is_not_properly_closed")
    public void fixInvalidTagName(Issue issue, IssueResolutionAcceptor acceptor) {
        String[] issueData = issue.getData();
        final String openingTagName = issueData[0];
        final String closingTagName = issueData[1];
        String label = "Change the opening tag to '" + closingTagName + "'.";
        String description = "Change the opening tag from '" + openingTagName + "' to '" + closingTagName + "'.";
        acceptor.accept(issue, label, description, null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                if (element instanceof HtmlTag) {
                    HtmlTag htmlTag = (HtmlTag)element;
                    htmlTag.setName(closingTagName);
                }
            }
        });
        label = "Change the closing tag to '" + openingTagName + "'.";
        description = "Change the closing tag from '" + closingTagName + "' to '" + openingTagName + "'.";
        acceptor.accept(issue, label, description, null, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                if (element instanceof HtmlTag) {
                    HtmlTag htmlTag = (HtmlTag)element;
                    htmlTag.setCloseName(openingTagName);
                }
            }
        });
    }
}

