/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.fx.anchors;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.scene.Node;
import org.eclipse.gef.fx.anchors.DynamicAnchor;
import org.eclipse.gef.fx.anchors.IComputationStrategy;
import org.eclipse.gef.fx.utils.NodeUtils;
import org.eclipse.gef.geometry.planar.ICurve;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.IShape;
import org.eclipse.gef.geometry.planar.Path;
import org.eclipse.gef.geometry.planar.Point;

public class ProjectionStrategy
implements IComputationStrategy {
    @Override
    public Point computePositionInScene(Node anchorage, Node anchored, Set<IComputationStrategy.Parameter<?>> parameters) {
        IGeometry anchorageReferenceGeometryInLocal = (IGeometry)IComputationStrategy.Parameter.get(parameters, DynamicAnchor.AnchorageReferenceGeometry.class).get();
        Point anchoredReferencePointInLocal = (Point)IComputationStrategy.Parameter.get(parameters, DynamicAnchor.AnchoredReferencePoint.class).get();
        IGeometry anchorageGeometryInScene = NodeUtils.localToScene(anchorage, anchorageReferenceGeometryInLocal);
        List<ICurve> anchorageOutlinesInScene = this.getOutlineSegments(anchorageGeometryInScene);
        Point anchoredReferencePointInScene = NodeUtils.localToScene(anchored, anchoredReferencePointInLocal);
        return this.computeProjectionInScene(anchorageOutlinesInScene, anchoredReferencePointInScene, parameters);
    }

    protected Point computeProjectionInScene(List<ICurve> anchorageOutlinesInScene, Point anchoredReferencePointInScene, Set<IComputationStrategy.Parameter<?>> parameters) {
        Point[] projections = new Point[anchorageOutlinesInScene.size()];
        int i = 0;
        while (i < anchorageOutlinesInScene.size()) {
            ICurve c = anchorageOutlinesInScene.get(i);
            projections[i] = c.getProjection(anchoredReferencePointInScene);
            ++i;
        }
        return Point.nearest((Point)anchoredReferencePointInScene, (Point[])projections);
    }

    protected List<ICurve> getOutlineSegments(IGeometry geometry) {
        if (geometry instanceof IShape) {
            return Collections.singletonList(((IShape)geometry).getOutline());
        }
        if (geometry instanceof ICurve) {
            return Collections.singletonList((ICurve)geometry);
        }
        if (geometry instanceof Path) {
            return ((Path)geometry).getOutlines();
        }
        throw new IllegalStateException("The transformed geometry is neither an ICurve nor an IShape.");
    }

    @Override
    public Set<Class<? extends IComputationStrategy.Parameter<?>>> getRequiredParameters() {
        HashSet parameters = new HashSet();
        parameters.add(DynamicAnchor.AnchorageReferenceGeometry.class);
        parameters.add(DynamicAnchor.AnchoredReferencePoint.class);
        return parameters;
    }
}

