/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.behaviors;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.property.ReadOnlyProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.scene.Node;
import org.eclipse.gef.common.collections.ObservableSetMultimap;
import org.eclipse.gef.common.collections.SetMultimapChangeListener;
import org.eclipse.gef.common.dispose.IDisposable;
import org.eclipse.gef.mvc.fx.behaviors.AbstractBehavior;
import org.eclipse.gef.mvc.fx.behaviors.ContentPartPool;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IContentPartFactory;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.parts.PartUtils;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class ContentBehavior
extends AbstractBehavior
implements IDisposable {
    private ListChangeListener<Object> contentObserver = new ListChangeListener<Object>(){

        public void onChanged(ListChangeListener.Change<? extends Object> change) {
            ContentBehavior.this.synchronizeContentPartChildren(ContentBehavior.this.getHost(), (List<? extends Object>)change.getList());
        }
    };
    private ListChangeListener<Object> contentChildrenObserver = new ListChangeListener<Object>(){

        public void onChanged(ListChangeListener.Change<? extends Object> change) {
            IContentPart parent = (IContentPart)((ReadOnlyProperty)change.getList()).getBean();
            ContentBehavior.this.synchronizeContentPartChildren(parent, (List<? extends Object>)change.getList());
        }
    };
    private SetMultimapChangeListener<Object, String> contentAnchoragesObserver = new SetMultimapChangeListener<Object, String>(){

        public void onChanged(SetMultimapChangeListener.Change<? extends Object, ? extends String> change) {
            IContentPart anchored = (IContentPart)((ReadOnlyProperty)change.getSetMultimap()).getBean();
            ContentBehavior.this.synchronizeContentPartAnchorages(anchored, (SetMultimap<? extends Object, ? extends String>)HashMultimap.create((Multimap)change.getSetMultimap()));
        }
    };
    private MapChangeListener<Object, IContentPart<? extends Node>> contentPartMapObserver = new MapChangeListener<Object, IContentPart<? extends Node>>(){

        public void onChanged(MapChangeListener.Change<? extends Object, ? extends IContentPart<? extends Node>> change) {
            IContentPart contentPart;
            if (change.wasRemoved()) {
                contentPart = (IContentPart)change.getValueRemoved();
                contentPart.contentChildrenUnmodifiableProperty().removeListener(ContentBehavior.this.contentChildrenObserver);
                contentPart.contentAnchoragesUnmodifiableProperty().removeListener(ContentBehavior.this.contentAnchoragesObserver);
            }
            if (change.wasAdded()) {
                contentPart = (IContentPart)change.getValueAdded();
                contentPart.contentChildrenUnmodifiableProperty().addListener(ContentBehavior.this.contentChildrenObserver);
                contentPart.contentAnchoragesUnmodifiableProperty().addListener(ContentBehavior.this.contentAnchoragesObserver);
            }
        }
    };

    private void addAll(IVisualPart<? extends Node> parent, List<? extends Object> contentChildren, List<IContentPart<? extends Node>> added, LinkedHashMap<IVisualPart<? extends Node>, HashMultimap<Integer, IContentPart<? extends Node>>> addsPerParent) {
        List<IContentPart> childContentParts = PartUtils.filterParts(parent.getChildrenUnmodifiable(), IContentPart.class);
        HashMap<Object, IContentPart> contentPartMap = new HashMap<Object, IContentPart>();
        for (IContentPart contentPart : childContentParts) {
            contentPartMap.put(contentPart.getContent(), contentPart);
        }
        int contentChildrenSize = contentChildren.size();
        int childContentPartsSize = childContentParts.size();
        HashMultimap childrenToAdd = HashMultimap.create();
        int i = 0;
        while (i < contentChildrenSize) {
            Object content = contentChildren.get(i);
            if (i >= childContentPartsSize || childContentParts.get(i).getContent() != content) {
                IContentPart<? extends Node> contentPart = this.findOrCreatePartFor(content);
                if (contentPartMap.containsKey(content)) {
                    parent.reorderChild(contentPart, i);
                } else {
                    if (contentPart.getViewer() != null) {
                        throw new IllegalStateException("Located a ContentPart which controls the same (or an equal) content element but is already bound to a viewer. A content element may only be controlled by a single ContentPart.");
                    }
                    contentPart.setParent(parent);
                    added.add(contentPart);
                    childrenToAdd.put((Object)i, contentPart);
                    this.addAll((IVisualPart<? extends Node>)contentPart, (List<? extends Object>)contentPart.getContentChildrenUnmodifiable(), added, addsPerParent);
                }
            }
            ++i;
        }
        if (!childrenToAdd.isEmpty()) {
            addsPerParent.put(parent, (HashMultimap<Integer, IContentPart<? extends Node>>)childrenToAdd);
        }
    }

    private void detachAll(IVisualPart<? extends Node> parent, Set<? extends Object> contentChildren, List<IContentPart<? extends Node>> toRemove, Map<IVisualPart<? extends Node>, List<IContentPart<? extends Node>>> removalsPerParent) {
        ArrayList<IContentPart> childrenToRemove = new ArrayList<IContentPart>();
        for (IContentPart contentPart : PartUtils.filterParts(parent.getChildrenUnmodifiable(), IContentPart.class)) {
            if (contentChildren.contains(contentPart.getContent())) continue;
            this.detachAll(contentPart, Collections.emptySet(), toRemove, removalsPerParent);
            childrenToRemove.add(contentPart);
            toRemove.add(contentPart);
            this.synchronizeContentPartAnchorages(contentPart, (SetMultimap<? extends Object, ? extends String>)HashMultimap.create());
        }
        if (!childrenToRemove.isEmpty()) {
            removalsPerParent.put(parent, childrenToRemove);
        }
    }

    public void dispose() {
        this.contentObserver = null;
        this.contentChildrenObserver = null;
        this.contentAnchoragesObserver = null;
    }

    protected void disposeIfObsolete(IContentPart<? extends Node> contentPart) {
        if (contentPart.getParent() == null && contentPart.getAnchoredsUnmodifiable().isEmpty()) {
            this.getContentPartPool().add(contentPart);
            contentPart.setContent(null);
        }
    }

    @Override
    protected void doActivate() {
        IVisualPart<? extends Node> host = this.getHost();
        if (host != host.getRoot()) {
            throw new IllegalArgumentException();
        }
        IViewer viewer = host.getRoot().getViewer();
        viewer.contentPartMapProperty().addListener(this.contentPartMapObserver);
        this.synchronizeContentPartChildren(this.getHost(), (List<? extends Object>)viewer.getContents());
        viewer.getContents().addListener(this.contentObserver);
    }

    @Override
    protected void doDeactivate() {
        IVisualPart<? extends Node> host = this.getHost();
        IViewer viewer = host.getRoot().getViewer();
        viewer.getContents().removeListener(this.contentObserver);
        this.synchronizeContentPartChildren(this.getHost(), Collections.emptyList());
        viewer.contentPartMapProperty().removeListener(this.contentPartMapObserver);
    }

    protected IContentPart<? extends Node> findOrCreatePartFor(Object content) {
        IContentPartFactory contentPartFactory;
        Map<Object, IContentPart<? extends Node>> contentPartMap = this.getHost().getRoot().getViewer().getContentPartMap();
        if (contentPartMap.containsKey(content)) {
            return contentPartMap.get(content);
        }
        IContentPart<? extends Node> contentPart = this.getContentPartPool().remove(content);
        if (contentPart == null && (contentPart = (contentPartFactory = this.getContentPartFactory()).createContentPart(content, Collections.emptyMap())) == null) {
            throw new IllegalStateException("IContentPartFactory '" + contentPartFactory.getClass().getSimpleName() + "' did not create part for " + content + ".");
        }
        contentPart.setContent(content);
        return contentPart;
    }

    protected IContentPartFactory getContentPartFactory() {
        return (IContentPartFactory)this.getHost().getRoot().getViewer().getAdapter(IContentPartFactory.class);
    }

    protected ContentPartPool getContentPartPool() {
        return (ContentPartPool)this.getHost().getRoot().getViewer().getAdapter(ContentPartPool.class);
    }

    public void synchronizeContentPartAnchorages(IVisualPart<? extends Node> anchored, SetMultimap<? extends Object, ? extends String> contentAnchorages) {
        if (contentAnchorages == null) {
            throw new IllegalArgumentException("contentAnchorages may not be null");
        }
        ObservableSetMultimap<IVisualPart<Node>, String> anchorages = anchored.getAnchoragesUnmodifiable();
        ArrayList<Map.Entry> toRemove = new ArrayList<Map.Entry>();
        Set entries = anchorages.entries();
        for (Map.Entry e : entries) {
            Object content;
            if (!(e.getKey() instanceof IContentPart) || contentAnchorages.containsEntry(content = ((IContentPart)e.getKey()).getContent(), e.getValue())) continue;
            toRemove.add(e);
        }
        for (Map.Entry contentPart : toRemove) {
            anchored.detachFromAnchorage((IVisualPart)contentPart.getKey(), (String)contentPart.getValue());
            this.disposeIfObsolete((IContentPart)contentPart.getKey());
        }
        ArrayList<Map.Entry> toAdd = new ArrayList<Map.Entry>();
        for (Map.Entry e : contentAnchorages.entries()) {
            IContentPart<? extends Node> anchorage = this.findOrCreatePartFor(e.getKey());
            if (anchorages.containsEntry(anchorage, e.getValue())) continue;
            toAdd.add(Maps.immutableEntry(anchorage, (Object)((String)e.getValue())));
        }
        for (Map.Entry e : toAdd) {
            anchored.attachToAnchorage((IVisualPart)e.getKey(), (String)e.getValue());
        }
    }

    public void synchronizeContentPartChildren(IVisualPart<? extends Node> parent, List<? extends Object> contentChildren) {
        if (contentChildren == null) {
            throw new IllegalArgumentException("contentChildren may not be null");
        }
        ArrayList<IContentPart<? extends Node>> toRemove = new ArrayList<IContentPart<? extends Node>>();
        LinkedHashMap<IVisualPart<? extends Node>, List<IContentPart<? extends Node>>> removalsPerParent = new LinkedHashMap<IVisualPart<? extends Node>, List<IContentPart<? extends Node>>>();
        this.detachAll(parent, Sets.newHashSet(contentChildren), toRemove, removalsPerParent);
        removalsPerParent.forEach((removeFrom, removeUs) -> removeFrom.removeChildren((List<? extends IVisualPart<? extends Node>>)removeUs));
        for (IContentPart iContentPart : toRemove) {
            this.disposeIfObsolete(iContentPart);
        }
        LinkedHashMap<IVisualPart<? extends Node>, HashMultimap<Integer, IContentPart<? extends Node>>> linkedHashMap = new LinkedHashMap<IVisualPart<? extends Node>, HashMultimap<Integer, IContentPart<? extends Node>>>();
        ArrayList added = Lists.newArrayList();
        this.addAll(parent, contentChildren, added, linkedHashMap);
        ArrayList<IVisualPart<? extends Node>> parents = new ArrayList<IVisualPart<? extends Node>>(linkedHashMap.keySet());
        int i = parents.size() - 1;
        while (i >= 0) {
            IVisualPart<? extends Node> parentContentPart = parents.get(i);
            HashMultimap<Integer, IContentPart<? extends Node>> childContentParts = linkedHashMap.get(parentContentPart);
            childContentParts.keySet().forEach(cp -> {
                ArrayList children = Lists.newArrayList((Iterable)childContentParts.get(cp));
                parentContentPart.addChildren(children, (int)cp);
                children.forEach(contentPart -> this.synchronizeContentPartAnchorages((IVisualPart<? extends Node>)contentPart, (SetMultimap<? extends Object, ? extends String>)contentPart.getContentAnchoragesUnmodifiable()));
            });
            --i;
        }
    }
}

