/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.fx.swt.canvas;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Stack;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.embed.swt.FXCanvas;
import javafx.embed.swt.SWTFXUtils;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventType;
import javafx.scene.Cursor;
import javafx.scene.ImageCursor;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.RotateEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.SwipeEvent;
import javafx.scene.input.ZoomEvent;
import javafx.stage.Window;
import org.eclipse.gef.common.reflect.ReflectionUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.GestureEvent;
import org.eclipse.swt.events.GestureListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class FXCanvasEx
extends FXCanvas {
    private static final boolean JAVA_8 = System.getProperty("java.version").startsWith("1.8.0");
    private static final boolean WIN32 = SWT.getPlatform().equals("win32");
    private ChangeListener<Cursor> cursorChangeListener = new ChangeListener<Cursor>(){

        public void changed(ObservableValue<? extends Cursor> observable, Cursor oldCursor, Cursor newCursor) {
            if (newCursor instanceof ImageCursor) {
                ImageData imageData = SWTFXUtils.fromFXImage((Image)((ImageCursor)newCursor).getImage(), null);
                double hotspotX = ((ImageCursor)newCursor).getHotspotX();
                double hotspotY = ((ImageCursor)newCursor).getHotspotY();
                org.eclipse.swt.graphics.Cursor swtCursor = new org.eclipse.swt.graphics.Cursor((Device)FXCanvasEx.this.getDisplay(), imageData, (int)hotspotX, (int)hotspotY);
                try {
                    Method currentCursorFrameAccessor = Cursor.class.getDeclaredMethod("getCurrentFrame", new Class[0]);
                    currentCursorFrameAccessor.setAccessible(true);
                    Object currentCursorFrame = currentCursorFrameAccessor.invoke((Object)newCursor, new Object[0]);
                    Method platformCursorProvider = currentCursorFrame.getClass().getMethod("setPlatforCursor", Class.class, Object.class);
                    platformCursorProvider.setAccessible(true);
                    platformCursorProvider.invoke(currentCursorFrame, org.eclipse.swt.graphics.Cursor.class, swtCursor);
                }
                catch (Exception e) {
                    System.err.println("Failed to set platform cursor on the current cursor frame.");
                    e.printStackTrace();
                }
            }
        }
    };
    private Listener mouseWheelListener = new Listener(){

        public void handleEvent(Event e) {
            if (!(FXCanvasEx.this.gestureActive || FXCanvasEx.this.panGestureInertiaActive && FXCanvasEx.this.lastGestureEvent != null && e.time == ((FXCanvasEx)FXCanvasEx.this).lastGestureEvent.time)) {
                if (e.type == 37) {
                    this.sendScrollEventToFX((EventType<ScrollEvent>)ScrollEvent.SCROLL, 0.0, e.count > 0 ? 1 : -1, e.x, e.y, e.stateMask);
                } else {
                    this.sendScrollEventToFX((EventType<ScrollEvent>)ScrollEvent.SCROLL, e.count > 0 ? 1 : -1, 0.0, e.x, e.y, e.stateMask);
                }
            }
        }

        private void sendScrollEventToFX(final EventType<ScrollEvent> eventType, final double scrollX, final double scrollY, final int x, final int y, final int stateMask) {
            final Point los = FXCanvasEx.this.toDisplay(x, y);
            FXCanvasEx.this.scheduleSceneRunnable(new ISceneRunnable(){

                @Override
                public void run(TKSceneListenerWrapper sceneListener) {
                    sceneListener.scrollEvent((EventType<ScrollEvent>)eventType, scrollX, scrollY, scrollX, scrollY, 40.0, 40.0, 0, 0, 0, 0, 0, x, y, los.x, los.y, (stateMask & 0x20000) != 0, (stateMask & 0x40000) != 0, (stateMask & 0x10000) != 0, (stateMask & 0x400000) != 0, false, false);
                }
            });
        }
    };
    private boolean gestureActive = false;
    private boolean panGestureInertiaActive = false;
    private GestureEvent lastGestureEvent;
    private GestureListener gestureListener = new GestureListener(){
        private Stack<Integer> nestedGestures = new Stack();
        private long inertiaTime = 0L;
        private double inertiaXScroll = 0.0;
        private double inertiaYScroll = 0.0;
        private double lastTotalZoom = 0.0;
        private double lastTotalAngle = 0.0;
        double totalScrollX = 0.0;
        double totalScrollY = 0.0;

        public void gesture(GestureEvent gestureEvent) {
            switch (gestureEvent.detail) {
                case 2: {
                    FXCanvasEx.this.gestureActive = true;
                    FXCanvasEx.this.panGestureInertiaActive = false;
                    break;
                }
                case 32: {
                    if (FXCanvasEx.this.gestureActive && !this.nestedGestures.contains(32)) {
                        this.sendZoomEventToFX((EventType<ZoomEvent>)ZoomEvent.ZOOM_STARTED, gestureEvent);
                        this.nestedGestures.push(32);
                    }
                    this.sendZoomEventToFX((EventType<ZoomEvent>)ZoomEvent.ZOOM, gestureEvent);
                    break;
                }
                case 64: {
                    if (FXCanvasEx.this.gestureActive && !this.nestedGestures.contains(64)) {
                        this.sendScrollEventToFX((EventType<ScrollEvent>)ScrollEvent.SCROLL_STARTED, gestureEvent.xDirection, gestureEvent.yDirection, gestureEvent.x, gestureEvent.y, gestureEvent.stateMask, false);
                        this.nestedGestures.push(64);
                    }
                    if (FXCanvasEx.this.panGestureInertiaActive && gestureEvent.time > ((FXCanvasEx)FXCanvasEx.this).lastGestureEvent.time + 250) {
                        FXCanvasEx.this.panGestureInertiaActive = false;
                    }
                    if (!FXCanvasEx.this.gestureActive && !FXCanvasEx.this.panGestureInertiaActive) break;
                    double xDirection = gestureEvent.xDirection;
                    double yDirection = gestureEvent.yDirection;
                    if (FXCanvasEx.this.panGestureInertiaActive && xDirection == 0.0 && yDirection == 0.0) {
                        double delta = Math.max(0.0, Math.min(1.0, (double)((long)gestureEvent.time - this.inertiaTime) / 1500.0));
                        xDirection = (1.0 - delta) * this.inertiaXScroll;
                        yDirection = (1.0 - delta) * this.inertiaYScroll;
                    }
                    this.sendScrollEventToFX((EventType<ScrollEvent>)ScrollEvent.SCROLL, xDirection, yDirection, gestureEvent.x, gestureEvent.y, gestureEvent.stateMask, FXCanvasEx.this.panGestureInertiaActive);
                    break;
                }
                case 8: {
                    if (FXCanvasEx.this.gestureActive && !this.nestedGestures.contains(8)) {
                        this.sendRotateEventToFX((EventType<RotateEvent>)RotateEvent.ROTATION_STARTED, gestureEvent);
                        this.nestedGestures.push(8);
                    }
                    this.sendRotateEventToFX((EventType<RotateEvent>)RotateEvent.ROTATE, gestureEvent);
                    break;
                }
                case 16: {
                    EventType type = null;
                    if (gestureEvent.yDirection > 0) {
                        type = SwipeEvent.SWIPE_DOWN;
                    } else if (gestureEvent.yDirection < 0) {
                        type = SwipeEvent.SWIPE_UP;
                    } else if (gestureEvent.xDirection > 0) {
                        type = SwipeEvent.SWIPE_RIGHT;
                    } else if (gestureEvent.xDirection < 0) {
                        type = SwipeEvent.SWIPE_LEFT;
                    }
                    this.sendSwipeEventToFX((EventType<SwipeEvent>)type, gestureEvent);
                    break;
                }
                case 4: {
                    while (!this.nestedGestures.isEmpty()) {
                        switch (this.nestedGestures.pop()) {
                            case 32: {
                                this.sendZoomEventToFX((EventType<ZoomEvent>)ZoomEvent.ZOOM_FINISHED, gestureEvent);
                                break;
                            }
                            case 64: {
                                this.sendScrollEventToFX((EventType<ScrollEvent>)ScrollEvent.SCROLL_FINISHED, gestureEvent.xDirection, gestureEvent.yDirection, gestureEvent.x, gestureEvent.y, gestureEvent.stateMask, false);
                                this.inertiaXScroll = ((FXCanvasEx)FXCanvasEx.this).lastGestureEvent.xDirection;
                                this.inertiaYScroll = ((FXCanvasEx)FXCanvasEx.this).lastGestureEvent.yDirection;
                                this.inertiaTime = gestureEvent.time;
                                FXCanvasEx.this.panGestureInertiaActive = true;
                                break;
                            }
                            case 8: {
                                this.sendRotateEventToFX((EventType<RotateEvent>)RotateEvent.ROTATION_FINISHED, gestureEvent);
                            }
                        }
                    }
                    FXCanvasEx.this.gestureActive = false;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported gesture event type: " + gestureEvent);
                }
            }
            FXCanvasEx.this.lastGestureEvent = gestureEvent;
        }

        private void sendRotateEventToFX(final EventType<RotateEvent> eventType, final GestureEvent gestureEvent) {
            final Point los = FXCanvasEx.this.toDisplay(gestureEvent.x, gestureEvent.y);
            final double[] totalAngle = new double[]{-gestureEvent.rotation};
            if (eventType == RotateEvent.ROTATION_STARTED) {
                this.lastTotalAngle = 0.0;
                totalAngle[0] = 0.0;
            } else if (eventType == RotateEvent.ROTATION_FINISHED) {
                totalAngle[0] = this.lastTotalAngle;
            }
            final double angle = eventType == RotateEvent.ROTATION_FINISHED ? 0.0 : totalAngle[0] - this.lastTotalAngle;
            this.lastTotalAngle = totalAngle[0];
            FXCanvasEx.this.scheduleSceneRunnable(new ISceneRunnable(){

                @Override
                public void run(TKSceneListenerWrapper sceneListener) {
                    sceneListener.rotateEvent((EventType<RotateEvent>)eventType, angle, totalAngle[0], gestureEvent.x, gestureEvent.y, los.x, los.y, (gestureEvent.stateMask & 0x20000) != 0, (gestureEvent.stateMask & 0x40000) != 0, (gestureEvent.stateMask & 0x10000) != 0, (gestureEvent.stateMask & 0x400000) != 0, false, !FXCanvasEx.this.gestureActive);
                }
            });
        }

        private void sendScrollEventToFX(final EventType<ScrollEvent> eventType, final double scrollX, final double scrollY, final int x, final int y, final int stateMask, final boolean inertia) {
            double multiplier;
            double d = multiplier = "cocoa".equals(SWT.getPlatform()) && SWT.getVersion() < 4600 ? -5.0 : 5.0;
            if (eventType == ScrollEvent.SCROLL_STARTED) {
                this.totalScrollX = 0.0;
                this.totalScrollY = 0.0;
            } else if (inertia) {
                this.totalScrollX = scrollX;
                this.totalScrollY = scrollY;
            } else {
                this.totalScrollX += scrollX;
                this.totalScrollY += scrollY;
            }
            final Point los = FXCanvasEx.this.toDisplay(x, y);
            FXCanvasEx.this.scheduleSceneRunnable(new ISceneRunnable(){

                @Override
                public void run(TKSceneListenerWrapper sceneListener) {
                    sceneListener.scrollEvent((EventType<ScrollEvent>)eventType, scrollX, scrollY, totalScrollX, totalScrollY, multiplier, multiplier, 0, 0, 0, 0, 0, x, y, los.x, los.y, (stateMask & 0x20000) != 0, (stateMask & 0x40000) != 0, (stateMask & 0x10000) != 0, (stateMask & 0x400000) != 0, false, inertia);
                }
            });
        }

        private void sendSwipeEventToFX(final EventType<SwipeEvent> eventType, final GestureEvent gestureEvent) {
            final Point los = FXCanvasEx.this.toDisplay(gestureEvent.x, gestureEvent.y);
            FXCanvasEx.this.scheduleSceneRunnable(new ISceneRunnable(){

                @Override
                public void run(TKSceneListenerWrapper sceneListener) {
                    sceneListener.swipeEvent((EventType<SwipeEvent>)eventType, 0, gestureEvent.x, gestureEvent.y, los.x, los.y, (gestureEvent.stateMask & 0x20000) != 0, (gestureEvent.stateMask & 0x40000) != 0, (gestureEvent.stateMask & 0x10000) != 0, (gestureEvent.stateMask & 0x400000) != 0, false);
                }
            });
        }

        private void sendZoomEventToFX(final EventType<ZoomEvent> eventType, final GestureEvent gestureEvent) {
            final Point los = FXCanvasEx.this.toDisplay(gestureEvent.x, gestureEvent.y);
            final double[] totalZoom = new double[]{gestureEvent.magnification};
            if (eventType == ZoomEvent.ZOOM_STARTED) {
                this.lastTotalZoom = 1.0;
                totalZoom[0] = 1.0;
            } else if (eventType == ZoomEvent.ZOOM_FINISHED) {
                totalZoom[0] = this.lastTotalZoom;
            }
            final double zoom = eventType == ZoomEvent.ZOOM_FINISHED ? 1.0 : totalZoom[0] / this.lastTotalZoom;
            this.lastTotalZoom = totalZoom[0];
            final boolean inertia = !FXCanvasEx.this.gestureActive;
            FXCanvasEx.this.scheduleSceneRunnable(new ISceneRunnable(){

                @Override
                public void run(TKSceneListenerWrapper sceneListener) {
                    sceneListener.zoomEvent((EventType<ZoomEvent>)eventType, zoom, totalZoom[0], gestureEvent.x, gestureEvent.y, los.x, los.y, (gestureEvent.stateMask & 0x20000) != 0, (gestureEvent.stateMask & 0x40000) != 0, (gestureEvent.stateMask & 0x10000) != 0, (gestureEvent.stateMask & 0x400000) != 0, false, inertia);
                }
            });
        }
    };
    private TraverseListener traverseListener = null;
    private DisposeListener disposeListener;
    private Listener keyListener = new Listener(){

        /*
         * Unable to fully structure code
         */
        public void handleEvent(Event e) {
            if (!FXCanvasEx.access$7(FXCanvasEx.this).isEmpty()) ** GOTO lbl20
            throw new IllegalStateException("Handler called but filter did not record any events.");
lbl-1000:
            // 1 sources

            {
                previousEvent = (Event)FXCanvasEx.access$7(FXCanvasEx.this).poll();
                previousEvent.doit = false;
                if (1 == previousEvent.type) {
                    FXCanvasEx.access$8(FXCanvasEx.this).add(previousEvent);
                    for (Listener l : new ArrayList<E>(FXCanvasEx.access$9(FXCanvasEx.this))) {
                        l.handleEvent(previousEvent);
                    }
                    FXCanvasEx.access$10(FXCanvasEx.this).keyPressed(new org.eclipse.swt.events.KeyEvent(previousEvent));
                    continue;
                }
                if (2 != previousEvent.type) continue;
                FXCanvasEx.access$11(FXCanvasEx.this).add(previousEvent);
                for (Listener l : new ArrayList<E>(FXCanvasEx.access$12(FXCanvasEx.this))) {
                    l.handleEvent(previousEvent);
                }
                FXCanvasEx.access$10(FXCanvasEx.this).keyReleased(new org.eclipse.swt.events.KeyEvent(previousEvent));
lbl20:
                // 4 sources

                ** while (!this.sameEvent((Event)((Event)FXCanvasEx.access$7((FXCanvasEx)FXCanvasEx.this).peek()), (Event)e))
            }
lbl21:
            // 1 sources

            FXCanvasEx.access$7(FXCanvasEx.this).poll();
            if (1 == e.type) {
                FXCanvasEx.access$8(FXCanvasEx.this).add(e);
                for (Listener l : new ArrayList<E>(FXCanvasEx.access$9(FXCanvasEx.this))) {
                    l.handleEvent(e);
                }
                FXCanvasEx.access$10(FXCanvasEx.this).keyPressed(new org.eclipse.swt.events.KeyEvent(e));
            } else if (2 == e.type) {
                FXCanvasEx.access$11(FXCanvasEx.this).add(e);
                for (Listener l : new ArrayList<E>(FXCanvasEx.access$12(FXCanvasEx.this))) {
                    l.handleEvent(e);
                }
                FXCanvasEx.access$10(FXCanvasEx.this).keyReleased(new org.eclipse.swt.events.KeyEvent(e));
            }
        }

        private boolean sameEvent(Event e, Event f) {
            return e.display == f.display && e.widget == f.widget && e.time == f.time && e.data == f.data && e.character == f.character && e.keyCode == f.keyCode && e.keyLocation == f.keyLocation && e.stateMask == f.stateMask && e.doit == f.doit;
        }
    };
    private KeyListener superKeyListener;
    private List<Listener> keyUpListeners = new ArrayList<Listener>();
    private List<Listener> keyDownListeners = new ArrayList<Listener>();
    private Queue<Event> unprocessedKeyDownEvents = new LinkedList<Event>();
    private Queue<Event> unprocessedKeyUpEvents = new LinkedList<Event>();
    private Queue<Event> allSwtKeyEvents = new LinkedList<Event>();
    private Listener displayKeyFilter = new Listener(){

        private Event copy(Event event) {
            Event copy = new Event();
            copy.display = event.display;
            copy.widget = event.widget;
            copy.time = event.time;
            copy.type = event.type;
            copy.doit = event.doit;
            copy.data = event.data;
            copy.character = event.character;
            copy.keyCode = event.keyCode;
            copy.keyLocation = event.keyLocation;
            copy.stateMask = event.stateMask;
            return copy;
        }

        public void handleEvent(Event event) {
            if (event.widget != FXCanvasEx.this) {
                return;
            }
            FXCanvasEx.this.allSwtKeyEvents.add(this.copy(event));
        }
    };

    public static FXCanvas getFXCanvas(Scene scene) {
        if (scene == null) {
            return null;
        }
        if (JAVA_8) {
            Window window = scene.getWindow();
            if (window != null) {
                return (FXCanvas)ReflectionUtils.getPrivateFieldValue((Object)ReflectionUtils.getPrivateFieldValue((Object)window, (String)"host"), (String)"this$0");
            }
            return null;
        }
        try {
            Method m = FXCanvas.class.getDeclaredMethod("getFXCanvas", Scene.class);
            return (FXCanvas)m.invoke(null, scene);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to call FXCanvas.getFXCanvas(Scene)", e);
        }
    }

    public FXCanvasEx(Composite parent, int style) {
        super(parent, style);
        Object filterTable = ReflectionUtils.getPrivateFieldValue((Object)this.getDisplay(), (String)"filterTable");
        int[] types = (int[])ReflectionUtils.getPrivateFieldValue((Object)filterTable, (String)"types");
        Listener[] listeners = (Listener[])ReflectionUtils.getPrivateFieldValue((Object)filterTable, (String)"listeners");
        ReflectionUtils.setPrivateFieldValue((Object)this.getDisplay(), (String)"filterTable", null);
        this.getDisplay().addFilter(1, this.displayKeyFilter);
        this.getDisplay().addFilter(2, this.displayKeyFilter);
        int i = 0;
        while (i < types.length && types[i] != 0) {
            this.getDisplay().addFilter(types[i], listeners[i]);
            ++i;
        }
        this.disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent de) {
                FXCanvasEx.this.setScene(null);
                FXCanvasEx.this.getDisplay().removeFilter(1, FXCanvasEx.this.displayKeyFilter);
                FXCanvasEx.this.getDisplay().removeFilter(2, FXCanvasEx.this.displayKeyFilter);
                FXCanvasEx.this.displayKeyFilter = null;
                FXCanvasEx.this.cursorChangeListener = null;
                FXCanvasEx.this.removeDisposeListener(FXCanvasEx.this.disposeListener);
                FXCanvasEx.this.disposeListener = null;
                FXCanvasEx.this.removeTraverseListener(FXCanvasEx.this.traverseListener);
                FXCanvasEx.this.traverseListener = null;
                FXCanvasEx.this.removeListener(1, FXCanvasEx.this.keyListener);
                FXCanvasEx.this.removeListener(2, FXCanvasEx.this.keyListener);
                FXCanvasEx.this.keyListener = null;
                FXCanvasEx.this.superKeyListener = null;
                if (JAVA_8) {
                    FXCanvasEx.this.removeListener(38, FXCanvasEx.this.mouseWheelListener);
                    FXCanvasEx.this.removeListener(37, FXCanvasEx.this.mouseWheelListener);
                    FXCanvasEx.this.removeGestureListener(FXCanvasEx.this.gestureListener);
                }
                FXCanvasEx.this.mouseWheelListener = null;
                FXCanvasEx.this.gestureListener = null;
            }
        };
        this.addDisposeListener(this.disposeListener);
        this.traverseListener = new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if ((e.detail == 16 || e.detail == 8) && (e.stateMask & 0x40000) != 0) {
                    e.doit = true;
                }
            }
        };
        this.addTraverseListener(this.traverseListener);
        this.addListener(2, this.keyListener);
        this.addListener(1, this.keyListener);
        if (JAVA_8) {
            this.addListener(38, this.mouseWheelListener);
            this.addListener(37, this.mouseWheelListener);
            this.addGestureListener(this.gestureListener);
        }
    }

    public void addKeyListener(KeyListener listener) {
        if (listener.getClass().getName().startsWith(String.valueOf(FXCanvas.class.getName()) + "$")) {
            this.superKeyListener = listener;
        } else {
            super.addKeyListener(listener);
        }
    }

    public void addListener(int eventType, Listener listener) {
        if (eventType == 2) {
            if (listener == this.keyListener) {
                super.addListener(eventType, listener);
            } else {
                this.keyUpListeners.add(listener);
            }
        } else if (eventType == 1) {
            if (listener == this.keyListener) {
                super.addListener(eventType, listener);
            } else {
                this.keyDownListeners.add(listener);
            }
        } else {
            super.addListener(eventType, listener);
        }
    }

    public void addMouseWheelListener(MouseWheelListener listener) {
        if (JAVA_8) {
            if (!listener.getClass().getName().startsWith(String.valueOf(FXCanvas.class.getName()) + "$")) {
                super.addMouseWheelListener(listener);
            }
        } else {
            super.addMouseWheelListener(listener);
        }
    }

    public Window getStage() {
        return (Window)ReflectionUtils.getPrivateFieldValue((Object)((Object)this), (String)"stage");
    }

    public void removeKeyListener(KeyListener listener) {
        if (listener.getClass().getName().startsWith(String.valueOf(FXCanvas.class.getName()) + "$")) {
            this.superKeyListener = null;
        } else {
            super.removeKeyListener(listener);
        }
    }

    public void removeListener(int eventType, Listener listener) {
        if (eventType == 2) {
            if (listener == this.keyListener) {
                super.removeListener(eventType, listener);
            } else {
                this.keyUpListeners.remove(listener);
            }
        } else if (eventType == 1) {
            if (listener == this.keyListener) {
                super.removeListener(eventType, listener);
            } else {
                this.keyDownListeners.remove(listener);
            }
        } else {
            super.removeListener(eventType, listener);
        }
    }

    public void removeMouseWheelListener(MouseWheelListener listener) {
        if (JAVA_8) {
            if (!listener.getClass().getName().startsWith(String.valueOf(FXCanvas.class.getName()) + "$")) {
                super.removeMouseWheelListener(listener);
            }
        } else {
            super.removeMouseWheelListener(listener);
        }
    }

    private void scheduleSceneRunnable(final ISceneRunnable sr) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                final Object scenePeer = ReflectionUtils.getPrivateFieldValue((Object)((Object)FXCanvasEx.this), (String)"scenePeer");
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        Object sceneListener = ReflectionUtils.getPrivateFieldValue((Object)scenePeer, (String)"sceneListener");
                        if (sceneListener == null) {
                            return null;
                        }
                        sr.run(new TKSceneListenerWrapper(sceneListener));
                        return null;
                    }
                }, (AccessControlContext)ReflectionUtils.getPrivateFieldValue((Object)scenePeer, (String)"accessCtrlCtx"));
            }
        });
    }

    public void setScene(Scene newScene) {
        Scene oldScene = this.getScene();
        if (oldScene != null) {
            EventDispatcher eventDispatcher = oldScene.getEventDispatcher();
            if (eventDispatcher instanceof EventDispatcherEx) {
                oldScene.setEventDispatcher(((EventDispatcherEx)eventDispatcher).dispose());
            }
            if (JAVA_8) {
                oldScene.cursorProperty().removeListener(this.cursorChangeListener);
            }
        }
        super.setScene(newScene);
        if (newScene != null) {
            newScene.setEventDispatcher((EventDispatcher)new EventDispatcherEx(newScene.getEventDispatcher()));
            if (JAVA_8) {
                newScene.cursorProperty().addListener(this.cursorChangeListener);
            }
        }
    }

    static /* synthetic */ List access$9(FXCanvasEx fXCanvasEx) {
        return fXCanvasEx.keyDownListeners;
    }

    static /* synthetic */ KeyListener access$10(FXCanvasEx fXCanvasEx) {
        return fXCanvasEx.superKeyListener;
    }

    static /* synthetic */ List access$12(FXCanvasEx fXCanvasEx) {
        return fXCanvasEx.keyUpListeners;
    }

    private final class EventDispatcherEx
    implements EventDispatcher {
        private static final int REDRAW_INTERVAL_MILLIS = 40;
        private EventDispatcher delegate;
        private long lastRedrawMillis = System.currentTimeMillis();
        private Event downEvent;

        protected EventDispatcherEx(EventDispatcher delegate) {
            this.delegate = delegate;
        }

        public javafx.event.Event dispatchEvent(javafx.event.Event event, EventDispatchChain tail) {
            if (JAVA_8 && event instanceof KeyEvent) {
                Event lastDownEvent = (Event)FXCanvasEx.this.unprocessedKeyDownEvents.peek();
                if (event.getEventType().equals(KeyEvent.KEY_PRESSED)) {
                    if (!lastDownEvent.doit) {
                        event.consume();
                    }
                    this.downEvent = (Event)FXCanvasEx.this.unprocessedKeyDownEvents.poll();
                } else if (event.getEventType().equals(KeyEvent.KEY_TYPED)) {
                    if (!this.downEvent.doit) {
                        event.consume();
                    }
                } else if (event.getEventType().equals(KeyEvent.KEY_RELEASED)) {
                    Event lastUpEvent = (Event)FXCanvasEx.this.unprocessedKeyUpEvents.poll();
                    if (!lastUpEvent.doit) {
                        event.consume();
                    }
                }
            }
            javafx.event.Event returnedEvent = this.delegate.dispatchEvent(event, tail);
            long millisNow = System.currentTimeMillis();
            if (millisNow - this.lastRedrawMillis > 40L) {
                FXCanvasEx.this.redraw();
                if (WIN32) {
                    FXCanvasEx.this.update();
                }
                this.lastRedrawMillis = millisNow;
            }
            return returnedEvent;
        }

        protected EventDispatcher dispose() {
            EventDispatcher d = this.delegate;
            this.delegate = null;
            return d;
        }
    }

    private static interface ISceneRunnable {
        public void run(TKSceneListenerWrapper var1);
    }

    private class TKSceneListenerWrapper {
        private Object tkSceneListener;

        private TKSceneListenerWrapper(Object tkSceneListener) {
            this.tkSceneListener = tkSceneListener;
        }

        public void rotateEvent(EventType<RotateEvent> eventType, double angle, double totalAngle, double x, double y, double screenX, double screenY, boolean _shiftDown, boolean _controlDown, boolean _altDown, boolean _metaDown, boolean _direct, boolean _inertia) {
            try {
                Method m = this.tkSceneListener.getClass().getDeclaredMethod("rotateEvent", EventType.class, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
                m.setAccessible(true);
                m.invoke(this.tkSceneListener, eventType, angle, totalAngle, x, y, screenX, screenY, _shiftDown, _controlDown, _altDown, _metaDown, _direct, _inertia);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getCause();
                if (targetException instanceof RuntimeException) {
                    throw (RuntimeException)targetException;
                }
                targetException.printStackTrace();
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
                e.printStackTrace();
            }
        }

        public void scrollEvent(EventType<ScrollEvent> eventType, double scrollX, double scrollY, double totalScrollX, double totalScrollY, double xMultiplier, double yMultiplier, int touchCount, int scrollTextX, int scrollTextY, int defaultTextX, int defaultTextY, double x, double y, double screenX, double screenY, boolean _shiftDown, boolean _controlDown, boolean _altDown, boolean _metaDown, boolean _direct, boolean _inertia) {
            try {
                Method m = this.tkSceneListener.getClass().getDeclaredMethod("scrollEvent", EventType.class, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
                m.setAccessible(true);
                m.invoke(this.tkSceneListener, eventType, scrollX, scrollY, totalScrollX, totalScrollY, xMultiplier, yMultiplier, touchCount, scrollTextX, scrollTextY, defaultTextX, defaultTextY, x, y, screenX, screenY, _shiftDown, _controlDown, _altDown, _metaDown, _direct, _inertia);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getCause();
                if (targetException instanceof RuntimeException) {
                    throw (RuntimeException)targetException;
                }
                targetException.printStackTrace();
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
                e.printStackTrace();
            }
        }

        public void swipeEvent(EventType<SwipeEvent> eventType, int touchCount, double x, double y, double screenX, double screenY, boolean _shiftDown, boolean _controlDown, boolean _altDown, boolean _metaDown, boolean _direct) {
            try {
                Method m = this.tkSceneListener.getClass().getDeclaredMethod("swipeEvent", EventType.class, Integer.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
                m.setAccessible(true);
                m.invoke(this.tkSceneListener, eventType, touchCount, x, y, screenX, screenY, _shiftDown, _controlDown, _altDown, _metaDown, _direct);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getCause();
                if (targetException instanceof RuntimeException) {
                    throw (RuntimeException)targetException;
                }
                targetException.printStackTrace();
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
                e.printStackTrace();
            }
        }

        public void zoomEvent(EventType<ZoomEvent> eventType, double zoomFactor, double totalZoomFactor, double x, double y, double screenX, double screenY, boolean _shiftDown, boolean _controlDown, boolean _altDown, boolean _metaDown, boolean _direct, boolean _inertia) {
            try {
                Method m = this.tkSceneListener.getClass().getDeclaredMethod("zoomEvent", EventType.class, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
                m.setAccessible(true);
                m.invoke(this.tkSceneListener, eventType, zoomFactor, totalZoomFactor, x, y, screenX, screenY, _shiftDown, _controlDown, _altDown, _metaDown, _direct, _inertia);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getCause();
                if (targetException instanceof RuntimeException) {
                    throw (RuntimeException)targetException;
                }
                targetException.printStackTrace();
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
                e.printStackTrace();
            }
        }
    }
}

