/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.parts;

import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.transform.Affine;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.eclipse.gef.fx.anchors.IAnchor;
import org.eclipse.gef.fx.anchors.StaticAnchor;
import org.eclipse.gef.fx.nodes.Connection;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.geometry.planar.AffineTransform;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IResizableContentPart;
import org.eclipse.gef.mvc.fx.parts.ITransformableContentPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.parts.PartUtils;
import org.eclipse.gef.mvc.fx.providers.IAnchorProvider;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public interface IBendableContentPart<V extends Node>
extends ITransformableContentPart<V>,
IResizableContentPart<V> {
    public static final String SOURCE_ROLE = "source";
    public static final String TARGET_ROLE = "target";
    public static final String CONTROL_ROLE_PREFIX = "bp_";

    default public Connection getBendableVisual() {
        return (Connection)this.getVisual();
    }

    public List<BendPoint> getContentBendPoints();

    @Override
    default public Dimension getContentSize() {
        return BendPoint.computeSize(this.getContentBendPoints());
    }

    @Override
    default public Affine getContentTransform() {
        return BendPoint.computeTranslation(this.getContentBendPoints());
    }

    default public String getRole(List<BendPoint> bendPoints, int index) {
        if (index == 0) {
            return SOURCE_ROLE;
        }
        if (index == bendPoints.size() - 1) {
            return TARGET_ROLE;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(CONTROL_ROLE_PREFIX);
        sb.append(index);
        return sb.toString();
    }

    default public List<BendPoint> getVisualBendPoints() {
        ArrayList<BendPoint> bendPoints = new ArrayList<BendPoint>();
        Connection connection = this.getBendableVisual();
        IViewer viewer = this.getRoot().getViewer();
        ObservableList anchors = connection.getAnchorsUnmodifiable();
        int i = 0;
        while (i < anchors.size()) {
            IAnchor anchor = (IAnchor)anchors.get(i);
            if (!connection.getRouter().wasInserted(anchor)) {
                if (connection.isConnected(i)) {
                    Point positionHint = connection.getPoint(i);
                    if (i == 0 && connection.getStartPointHint() != null) {
                        positionHint = connection.getStartPointHint();
                    }
                    if (i == anchors.size() - 1 && connection.getEndPointHint() != null) {
                        positionHint = connection.getEndPointHint();
                    }
                    Node anchorageNode = anchor.getAnchorage();
                    IVisualPart<? extends Node> part = PartUtils.retrieveVisualPart(viewer, anchorageNode);
                    Object anchorageContent = null;
                    if (part instanceof IContentPart) {
                        anchorageContent = ((IContentPart)part).getContent();
                    }
                    bendPoints.add(new BendPoint(anchorageContent, positionHint));
                } else {
                    bendPoints.add(new BendPoint(connection.getPoint(i)));
                }
            }
            ++i;
        }
        return bendPoints;
    }

    @Override
    default public Dimension getVisualSize() {
        return BendPoint.computeSize(this.getVisualBendPoints());
    }

    @Override
    default public Affine getVisualTransform() {
        return BendPoint.computeTranslation(this.getVisualBendPoints());
    }

    public void setContentBendPoints(List<BendPoint> var1);

    @Override
    default public void setContentSize(Dimension totalSize) {
        Affine visualTransform = this.getContentTransform();
        double currentX = visualTransform.getTx();
        double currentY = visualTransform.getTy();
        List<BendPoint> resizedBendPoints = BendPoint.resize(this.getContentBendPoints(), currentX, currentY, this.getContentSize(), totalSize);
        this.setContentBendPoints(resizedBendPoints);
    }

    @Override
    default public void setContentTransform(Affine totalTransform) {
        this.setContentBendPoints(BendPoint.transform(this.getContentBendPoints(), this.getContentTransform(), totalTransform));
    }

    default public void setVisualBendPoints(List<BendPoint> bendPoints) {
        if (bendPoints == null || bendPoints.size() < 2) {
            throw new IllegalArgumentException("Not enough bend points supplied!");
        }
        ArrayList<Object> newAnchors = new ArrayList<Object>();
        int i = 0;
        while (i < bendPoints.size()) {
            BendPoint bp = bendPoints.get(i);
            if (bp.isAttached()) {
                IAnchorProvider anchorProvider = (IAnchorProvider)this.getRoot().getViewer().getContentPartMap().get(bp.getContentAnchorage()).getAdapter(IAnchorProvider.class);
                if (anchorProvider == null) {
                    throw new IllegalStateException("Anchorage does not provide anchor!");
                }
                IAnchor anchor = anchorProvider.get(this, this.getRole(bendPoints, i));
                if (anchor == null) {
                    throw new IllegalStateException("AnchorProvider does not provide anchor!");
                }
                newAnchors.add(anchor);
                if (i == 0) {
                    this.getBendableVisual().setStartPointHint(bendPoints.get(0).getPosition());
                }
                if (i == bendPoints.size() - 1) {
                    this.getBendableVisual().setEndPointHint(bendPoints.get(bendPoints.size() - 1).getPosition());
                }
            } else {
                newAnchors.add(new StaticAnchor((Node)this.getBendableVisual(), bp.getPosition()));
            }
            ++i;
        }
        this.getBendableVisual().setAnchors(newAnchors);
    }

    @Override
    default public void setVisualSize(Dimension totalSize) {
        List<BendPoint> visualBendPoints = this.getVisualBendPoints();
        Affine visualTransform = BendPoint.computeTranslation(visualBendPoints);
        double currentX = visualTransform.getTx();
        double currentY = visualTransform.getTy();
        List<BendPoint> resizedBendPoints = BendPoint.resize(visualBendPoints, currentX, currentY, BendPoint.computeSize(visualBendPoints), totalSize);
        this.setVisualBendPoints(resizedBendPoints);
    }

    @Override
    default public void setVisualTransform(Affine totalTransform) {
        List<BendPoint> visualBendPoints = this.getVisualBendPoints();
        this.setVisualBendPoints(BendPoint.transform(visualBendPoints, BendPoint.computeTranslation(visualBendPoints), totalTransform));
    }

    public static class BendPoint {
        private Object contentAnchorage;
        private Point position;

        static Dimension computeSize(List<BendPoint> bendPoints) {
            Point min = null;
            Point max = null;
            for (BendPoint bp : bendPoints) {
                if (bp.isAttached()) continue;
                Point pos = bp.getPosition();
                if (min == null) {
                    min = pos.getCopy();
                    max = min.getCopy();
                    continue;
                }
                if (min.x > pos.x) {
                    min.x = pos.x;
                }
                if (min.y > pos.y) {
                    min.y = pos.y;
                }
                if (max.x < pos.x) {
                    max.x = pos.x;
                }
                if (!(max.y < pos.y)) continue;
                max.y = pos.y;
            }
            return min == null ? new Dimension() : new Dimension(max.x - min.x, max.y - min.y);
        }

        static Affine computeTranslation(List<BendPoint> bendPoints) {
            Point min = null;
            for (BendPoint bp : bendPoints) {
                if (bp.isAttached()) continue;
                Point pos = bp.getPosition();
                if (min == null) {
                    min = pos.getCopy();
                    continue;
                }
                if (min.x > pos.x) {
                    min.x = pos.x;
                }
                if (!(min.y > pos.y)) continue;
                min.y = pos.y;
            }
            return min == null ? new Affine() : new Affine((Transform)new Translate(min.x, min.y));
        }

        static List<BendPoint> resize(List<BendPoint> bendPoints, double currentX, double currentY, Dimension currentSize, Dimension finalSize) {
            ArrayList<Point> points = new ArrayList<Point>();
            for (BendPoint bp : bendPoints) {
                if (bp.isAttached()) continue;
                points.add(bp.getPosition());
            }
            if (points.size() < 2) {
                return bendPoints;
            }
            double dw = finalSize.width - currentSize.width;
            double dh = finalSize.height - currentSize.height;
            double[] relX = new double[points.size()];
            double[] relY = new double[relX.length];
            int i = 0;
            while (i < relX.length) {
                Point p = (Point)points.get(i);
                relX[i] = (p.x - currentX) / currentSize.width;
                relY[i] = (p.y - currentY) / currentSize.height;
                ++i;
            }
            int pointIndex = 0;
            for (BendPoint bp : bendPoints) {
                if (bp.isAttached()) continue;
                bp.getPosition().x += relX[pointIndex] * dw;
                bp.getPosition().y += relY[pointIndex] * dh;
                ++pointIndex;
            }
            return bendPoints;
        }

        static List<BendPoint> transform(List<BendPoint> bendPoints, Affine currentTransform, Affine totalTransform) {
            Affine inverse;
            try {
                inverse = currentTransform.createInverse();
            }
            catch (NonInvertibleTransformException e) {
                throw new RuntimeException(e);
            }
            Affine deltaTransform = new Affine(inverse.createConcatenation((Transform)totalTransform));
            if (deltaTransform.isIdentity()) {
                return bendPoints;
            }
            AffineTransform tx = FX2Geometry.toAffineTransform((Transform)deltaTransform);
            for (BendPoint bp : bendPoints) {
                if (bp.isAttached()) continue;
                bp.getPosition().transform(tx);
            }
            return bendPoints;
        }

        public BendPoint(Object contentAnchorage, Point position) {
            if (contentAnchorage == null) {
                throw new IllegalArgumentException("contentAnchorage may not be null.");
            }
            if (position == null) {
                throw new IllegalArgumentException("position may not be null");
            }
            this.contentAnchorage = contentAnchorage;
            this.position = position.getCopy();
        }

        public BendPoint(Point position) {
            if (position == null) {
                throw new IllegalArgumentException("position may not be null.");
            }
            this.position = position.getCopy();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BendPoint other = (BendPoint)obj;
            if (this.contentAnchorage == null ? other.contentAnchorage != null : !this.contentAnchorage.equals(other.contentAnchorage)) {
                return false;
            }
            return !(this.position == null ? other.position != null : !this.position.equals((Object)other.position));
        }

        public Object getContentAnchorage() {
            return this.contentAnchorage;
        }

        public Point getPosition() {
            return this.position;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.contentAnchorage == null ? 0 : this.contentAnchorage.hashCode());
            result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
            return result;
        }

        public boolean isAttached() {
            return this.contentAnchorage != null;
        }

        public String toString() {
            return "BendPoint [" + (this.contentAnchorage != null ? "contentAnchorage=" + this.contentAnchorage + ", " : "") + (this.position != null ? "position=" + this.position : "") + "]";
        }
    }
}

