/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.domain;

import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.collections.ObservableMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.common.activate.ActivatableSupport;
import org.eclipse.gef.common.activate.IActivatable;
import org.eclipse.gef.common.adapt.AdaptableSupport;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.common.adapt.IAdaptable;
import org.eclipse.gef.common.adapt.inject.InjectAdapters;
import org.eclipse.gef.mvc.fx.domain.IDomain;
import org.eclipse.gef.mvc.fx.gestures.IGesture;
import org.eclipse.gef.mvc.fx.operations.AbstractCompositeOperation;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.operations.ReverseUndoCompositeOperation;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class HistoricizingDomain
implements IDomain {
    private static final int DEFAULT_UNDO_LIMIT = 128;
    private static final Thread.UncaughtExceptionHandler UNCAUGHT_EXCEPTION_HANDLER = new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            e.printStackTrace();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    };
    private ActivatableSupport acs = new ActivatableSupport((IActivatable)this);
    private AdaptableSupport<HistoricizingDomain> ads = new AdaptableSupport((IAdaptable)this);
    private IOperationHistory operationHistory;
    private IUndoContext undoContext;
    private AbstractCompositeOperation transaction;
    private Set<IGesture> transactionContext = new HashSet<IGesture>();
    private IOperationHistoryListener transactionListener = new IOperationHistoryListener(){

        public void historyNotification(OperationHistoryEvent event) {
            if (event.getEventType() == 3 && !HistoricizingDomain.this.transactionContext.isEmpty() && HistoricizingDomain.this.transaction != null) {
                if (HistoricizingDomain.this.transaction.getOperations().isEmpty()) {
                    for (IGesture tool : new ArrayList(HistoricizingDomain.this.transactionContext)) {
                        HistoricizingDomain.this.closeExecutionTransaction(tool);
                    }
                } else {
                    throw new IllegalStateException("Cannot perform UNDO while a currently open execution transaction contains operations.");
                }
            }
        }
    };

    public HistoricizingDomain() {
        Thread.currentThread().setUncaughtExceptionHandler(UNCAUGHT_EXCEPTION_HANDLER);
    }

    public final void activate() {
        this.acs.activate(null, this::doActivate);
    }

    protected void activateAdapters() {
        new TreeMap(this.ads.getAdapters()).values().forEach(adapter -> {
            if (adapter instanceof IActivatable) {
                ((IActivatable)adapter).activate();
            }
        });
    }

    public final ReadOnlyBooleanProperty activeProperty() {
        return this.acs.activeProperty();
    }

    public ReadOnlyMapProperty<AdapterKey<?>, Object> adaptersProperty() {
        return this.ads.adaptersProperty();
    }

    protected void applyUndoContext(ITransactionalOperation operation) {
        operation.addContext(this.getUndoContext());
    }

    @Override
    public void closeExecutionTransaction(IGesture tool) {
        if (!this.transactionContext.contains(tool)) {
            return;
        }
        if (this.transactionContext.size() == 1 && this.transactionContext.contains(tool)) {
            if (this.transaction == null) {
                throw new IllegalStateException("No transaction is currently active, while the transaction context sill contained tool " + tool + ".");
            }
            List<ITransactionalOperation> operations = this.transaction.getOperations();
            if (!operations.isEmpty()) {
                StringBuffer label = new StringBuffer();
                int operationCount = operations.size();
                int i = 0;
                while (i < operationCount) {
                    label.append(operations.get(i).getLabel());
                    if (operations.size() - 1 > i) {
                        label.append(", ");
                    }
                    ++i;
                }
                this.transaction.setLabel(label.toString());
                this.applyUndoContext(this.transaction);
                this.getOperationHistory().add((IUndoableOperation)this.transaction);
            }
            this.transaction = null;
        }
        this.transactionContext.remove(tool);
    }

    protected AbstractCompositeOperation createExecutionTransaction() {
        ReverseUndoCompositeOperation transaction = new ReverseUndoCompositeOperation(Long.toString(System.currentTimeMillis()));
        return transaction;
    }

    public final void deactivate() {
        this.acs.deactivate(this::doDeactivate, null);
    }

    protected void deactivateAdapters() {
        new TreeMap(this.ads.getAdapters()).values().forEach(adapter -> {
            if (adapter instanceof IActivatable) {
                ((IActivatable)adapter).deactivate();
            }
        });
    }

    public void dispose() {
        this.operationHistory.removeOperationHistoryListener(this.transactionListener);
        this.transactionListener = null;
        this.transactionContext.clear();
        this.transactionContext = null;
        this.transaction = null;
        this.operationHistory.dispose(this.undoContext, true, true, true);
        this.operationHistory = null;
        this.undoContext = null;
        this.ads.dispose();
        this.ads = null;
        this.acs = null;
    }

    protected void doActivate() {
        this.activateAdapters();
    }

    protected void doDeactivate() {
        this.deactivateAdapters();
    }

    @Override
    public void execute(ITransactionalOperation operation, IProgressMonitor monitor) throws ExecutionException {
        if (operation instanceof AbstractCompositeOperation) {
            operation = ((AbstractCompositeOperation)operation).unwrap(true);
        }
        if (operation == null || operation.isNoOp()) {
            return;
        }
        if (!operation.canExecute()) {
            throw new IllegalArgumentException("Operation cannot be executed.");
        }
        if (this.transaction != null) {
            operation.execute(monitor, null);
            this.transaction.add(operation);
        } else {
            this.applyUndoContext(operation);
            this.getOperationHistory().execute((IUndoableOperation)operation, monitor, null);
        }
    }

    public <T> T getAdapter(AdapterKey<T> key) {
        return (T)this.ads.getAdapter(key);
    }

    public <T> T getAdapter(Class<T> classKey) {
        return (T)this.ads.getAdapter(classKey);
    }

    public <T> T getAdapter(TypeToken<T> key) {
        return (T)this.ads.getAdapter(key);
    }

    public <T> AdapterKey<T> getAdapterKey(T adapter) {
        return this.ads.getAdapterKey(adapter);
    }

    public ObservableMap<AdapterKey<?>, Object> getAdapters() {
        return this.ads.getAdapters();
    }

    public <T> Map<AdapterKey<? extends T>, T> getAdapters(Class<? super T> classKey) {
        return this.ads.getAdapters(classKey);
    }

    public <T> Map<AdapterKey<? extends T>, T> getAdapters(TypeToken<? super T> key) {
        return this.ads.getAdapters(key);
    }

    public IOperationHistory getOperationHistory() {
        return this.operationHistory;
    }

    @Override
    public Map<AdapterKey<? extends IGesture>, IGesture> getTools() {
        return this.ads.getAdapters(IGesture.class);
    }

    public IUndoContext getUndoContext() {
        return this.undoContext;
    }

    @Override
    public Map<AdapterKey<? extends IViewer>, IViewer> getViewers() {
        return this.ads.getAdapters(IViewer.class);
    }

    public final boolean isActive() {
        return this.acs.isActive();
    }

    protected boolean isExecutionTransactionOpen() {
        return this.transaction != null;
    }

    @Override
    public boolean isExecutionTransactionOpen(IGesture tool) {
        return this.transactionContext.contains(tool);
    }

    @Override
    public void openExecutionTransaction(IGesture tool) {
        if (this.transactionContext.contains(tool)) {
            return;
        }
        this.transactionContext.add(tool);
        if (this.transactionContext.size() == 1 && this.transactionContext.contains(tool)) {
            if (this.transaction != null) {
                throw new IllegalStateException("A transaction is already active, while this is the first tool within the transaction context.");
            }
            this.transaction = this.createExecutionTransaction();
        }
    }

    public <T> void setAdapter(T adapter) {
        this.ads.setAdapter(adapter);
    }

    public <T> void setAdapter(T adapter, String role) {
        this.ads.setAdapter(adapter, role);
    }

    public <T> void setAdapter(TypeToken<T> adapterType, T adapter) {
        this.ads.setAdapter(adapterType, adapter);
    }

    @InjectAdapters
    public <T> void setAdapter(TypeToken<T> adapterType, T adapter, String role) {
        this.ads.setAdapter(adapterType, adapter, role);
    }

    @Inject
    public void setOperationHistory(IOperationHistory operationHistory) {
        if (this.operationHistory != null && this.operationHistory != operationHistory) {
            this.operationHistory.removeOperationHistoryListener(this.transactionListener);
        }
        if (this.operationHistory != operationHistory) {
            this.operationHistory = operationHistory;
            if (this.operationHistory != null) {
                this.operationHistory.addOperationHistoryListener(this.transactionListener);
                if (this.undoContext != null) {
                    this.operationHistory.setLimit(this.undoContext, 128);
                }
            }
        }
    }

    @Inject
    public void setUndoContext(IUndoContext undoContext) {
        this.undoContext = undoContext;
        if (this.operationHistory != null && undoContext != null) {
            this.operationHistory.setLimit(undoContext, 128);
        }
    }

    public <T> void unsetAdapter(T adapter) {
        this.ads.unsetAdapter(adapter);
    }
}

