/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.scrollpane;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.LabeledContainer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.SchemeBorder;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.TitleBarBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;

public class InternalFrame
extends LabeledContainer {
    public InternalFrame() {
        super((Border)new InternalFrameBorder());
        this.setLayoutManager((LayoutManager)new StackLayout());
        this.setOpaque(true);
        this.setRequestFocusEnabled(true);
        this.addListeners();
    }

    public InternalFrame(String title) {
        this();
        this.setLabel(title);
    }

    protected void addListeners() {
        DragTracker tracker = new DragTracker();
        this.addMouseMotionListener((MouseMotionListener)tracker);
        this.addMouseListener(tracker);
    }

    private class DragTracker
    extends MouseMotionListener.Stub
    implements MouseListener {
        private boolean move;
        private Point startLocation;
        private Rectangle bounds;
        private int position = 0;

        private DragTracker() {
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }

        public void mouseDragged(MouseEvent me) {
            if (this.position == 0) {
                return;
            }
            int dx = 0;
            int dy = 0;
            int dw = 0;
            int dh = 0;
            Rectangle rect = this.bounds.getCopy();
            Dimension diff = me.getLocation().getDifference(this.startLocation);
            if ((this.position & 1) == 1) {
                dy = diff.height;
                if (this.move) {
                    dx = diff.width;
                } else {
                    dh = -diff.height;
                }
            }
            if ((this.position & 8) == 8) {
                dx = diff.width;
                dx = rect.x + dx > rect.x + rect.width - 100 ? rect.width - 100 : dx;
                dw = -diff.width;
            }
            if ((this.position & 0x10) == 16) {
                dw = diff.width;
            }
            if ((this.position & 4) == 4) {
                dh = diff.height;
            }
            rect.x += dx;
            rect.y += dy;
            rect.width += dw;
            rect.width = rect.width < 100 ? 100 : rect.width;
            rect.height += dh;
            rect.height = rect.height < 22 ? 22 : rect.height;
            InternalFrame.this.setBounds(rect);
            InternalFrame.this.revalidate();
        }

        public void mouseMoved(MouseEvent me) {
            Rectangle figBounds = InternalFrame.this.getBounds();
            Point mouseLocation = me.getLocation();
            if (!InternalFrame.this.getBounds().contains(mouseLocation)) {
                System.out.println("Error");
            }
            if (!figBounds.contains(mouseLocation)) {
                return;
            }
            this.position = InternalFrame.this.getClientArea().getCopy().shrink(4, 4).getPosition(mouseLocation);
            this.move = false;
            Cursor newCursor = null;
            switch (this.position) {
                case 0: {
                    break;
                }
                case 20: {
                    newCursor = Cursors.SIZESE;
                    break;
                }
                case 4: {
                    newCursor = Cursors.SIZES;
                    break;
                }
                case 16: {
                    newCursor = Cursors.SIZEE;
                    break;
                }
                case 17: {
                    newCursor = Cursors.SIZENE;
                    break;
                }
                case 9: {
                    newCursor = Cursors.SIZENW;
                    break;
                }
                case 12: {
                    newCursor = Cursors.SIZESW;
                    break;
                }
                case 1: {
                    if (mouseLocation.y > InternalFrame.this.getBounds().y + InternalFrame.this.getInsets().left) {
                        this.move = true;
                        break;
                    }
                    newCursor = Cursors.SIZEN;
                    break;
                }
                case 8: {
                    newCursor = Cursors.SIZEW;
                }
            }
            InternalFrame.this.setCursor(newCursor);
        }

        public void mousePressed(MouseEvent me) {
            InternalFrame.this.requestFocus();
            me.consume();
            this.startLocation = me.getLocation();
            this.bounds = InternalFrame.this.getBounds().getCopy();
        }

        public void mouseReleased(MouseEvent me) {
            InternalFrame.this.revalidate();
            this.startLocation = null;
            this.position = 0;
            this.move = false;
        }

        public void mouseExited(MouseEvent me) {
            InternalFrame.this.setCursor(null);
        }
    }

    static class InternalFrameBorder
    extends CompoundBorder {
        InternalFrameBorder() {
            TitleBarBorder titlebar = new TitleBarBorder();
            titlebar.setTextColor(ColorConstants.white);
            titlebar.setBackgroundColor(ColorConstants.darkGray);
            this.inner = new CompoundBorder((Border)new LineBorder(FigureUtilities.mixColors((Color)ColorConstants.buttonDarker, (Color)ColorConstants.button), 3), (Border)new SchemeBorder(SchemeBorder.SCHEMES.LOWERED));
            this.outer = new CompoundBorder((Border)new SchemeBorder(SchemeBorder.SCHEMES.RAISED), (Border)titlebar);
        }
    }
}

