/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.tree;

import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.examples.tree.TreeBranch;
import org.eclipse.draw2d.geometry.Transposer;

public abstract class AbstractBranchLayout
extends AbstractLayout {
    private Transposer transposer;
    final TreeBranch branch;
    int[] cachedContourLeft;
    int[] cachedContourRight;
    int depth = -1;
    public boolean horizontal = true;
    int[] preferredRowHeights;
    int rowHeight;

    protected AbstractBranchLayout(TreeBranch branch) {
        this.branch = branch;
    }

    abstract void calculateDepth();

    public int[] getContourLeft() {
        if (this.cachedContourLeft == null) {
            this.updateContours();
        }
        return this.cachedContourLeft;
    }

    public int[] getContourRight() {
        if (this.cachedContourRight == null) {
            this.updateContours();
        }
        return this.cachedContourRight;
    }

    public int getDepth() {
        if (!this.branch.isExpanded()) {
            return 1;
        }
        if (this.depth == -1) {
            this.calculateDepth();
        }
        return this.depth;
    }

    public int[] getPreferredRowHeights() {
        if (this.preferredRowHeights == null) {
            this.updateRowHeights();
        }
        return this.preferredRowHeights;
    }

    List<TreeBranch> getSubtrees() {
        return this.branch.getSubtrees();
    }

    Transposer getTransposer() {
        if (this.transposer == null) {
            this.transposer = this.branch.getRoot().getTransposer();
        }
        return this.transposer;
    }

    int getMajorSpacing() {
        return this.branch.getRoot().getMajorSpacing();
    }

    public void invalidate() {
        this.preferredRowHeights = null;
        this.cachedContourLeft = null;
        this.cachedContourRight = null;
        this.depth = -1;
        super.invalidate();
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    abstract void paintLines(Graphics var1);

    public void setHorizontal(boolean value) {
        this.horizontal = value;
    }

    void setRowHeights(int[] heights, int offset) {
        if (this.rowHeight != heights[offset]) {
            this.rowHeight = heights[offset];
            this.branch.revalidate();
        }
    }

    abstract void updateContours();

    abstract void updateRowHeights();
}

