/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.model;

import java.util.Arrays;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.model.LogicNumberCellEditorValidator;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class LED
extends LogicSubpart {
    static final long serialVersionUID = 1L;
    private static final Dimension DEFAULT_SIZE = new Dimension(92, 71);
    private static final Image LED_ICON = LED.createImage(LED.class, "icons/ledicon16.gif");
    private static int count;
    public static final String P_VALUE = "value";
    protected static IPropertyDescriptor[] newDescriptors;
    public static final String TERMINAL_1_IN = "A";
    public static final String TERMINAL_2_IN = "B";
    public static final String TERMINAL_3_IN = "C";
    public static final String TERMINAL_4_IN = "D";
    public static final String TERMINAL_1_OUT = "1";
    public static final String TERMINAL_2_OUT = "2";
    public static final String TERMINAL_3_OUT = "3";
    public static final String TERMINAL_4_OUT = "4";
    protected static final String[] IN_TERMINALS;
    protected boolean[] bits = new boolean[4];

    static {
        newDescriptors = null;
        IN_TERMINALS = new String[]{TERMINAL_1_IN, TERMINAL_2_IN, TERMINAL_3_IN, TERMINAL_4_IN};
        TextPropertyDescriptor pValueProp = new TextPropertyDescriptor((Object)P_VALUE, LogicMessages.PropertyDescriptor_LED_Value);
        pValueProp.setValidator((ICellEditorValidator)LogicNumberCellEditorValidator.instance());
        if (descriptors != null) {
            newDescriptors = Arrays.copyOf(descriptors, descriptors.length + 1);
            LED.newDescriptors[LED.descriptors.length] = pValueProp;
        } else {
            newDescriptors = new IPropertyDescriptor[]{pValueProp};
        }
    }

    public LED() {
        this.size.width = LED.DEFAULT_SIZE.width;
        this.size.height = LED.DEFAULT_SIZE.height;
        this.location.x = 20;
        this.location.y = 20;
    }

    @Override
    public Image getIconImage() {
        return LED_ICON;
    }

    @Override
    public String getNewID() {
        return Integer.toString(count++);
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return newDescriptors;
    }

    @Override
    public Object getPropertyValue(Object propName) {
        if (P_VALUE.equals(propName)) {
            return Integer.toString(this.getValue());
        }
        if ("size".equals(propName)) {
            return "(" + this.getSize().width + "," + this.getSize().height + ")";
        }
        return super.getPropertyValue(propName);
    }

    @Override
    public void resetPropertyValue(Object id) {
        if (P_VALUE.equals(id)) {
            this.setValue(0);
        }
        super.resetPropertyValue(id);
    }

    public int getValue() {
        if (!this.inputs.isEmpty()) {
            boolean[] inputs = new boolean[]{this.getInput(TERMINAL_1_IN), this.getInput(TERMINAL_2_IN), this.getInput(TERMINAL_3_IN), this.getInput(TERMINAL_4_IN)};
            return LED.getValue(inputs);
        }
        return LED.getValue(this.bits);
    }

    private static int getValue(boolean[] bits) {
        int val = 0;
        if (bits[0]) {
            ++val;
        }
        if (bits[1]) {
            val += 2;
        }
        if (bits[2]) {
            val += 4;
        }
        if (bits[3]) {
            val += 8;
        }
        return val;
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (P_VALUE.equals(id)) {
            this.setValue(Integer.parseInt((String)value));
        } else {
            super.setPropertyValue(id, value);
        }
    }

    @Override
    public void setSize(Dimension d) {
        super.setSize(DEFAULT_SIZE);
    }

    public void setValue(int v) {
        if (!this.inputs.isEmpty()) {
            return;
        }
        int val = v % 16;
        this.bits = new boolean[4];
        if (val >= 8) {
            this.bits[3] = true;
        }
        if (val % 8 > 3) {
            this.bits[2] = true;
        }
        if (val % 4 > 1) {
            this.bits[1] = true;
        }
        this.bits[0] = val % 2 == 1;
        this.firePropertyChange(P_VALUE, null, null);
        this.update();
    }

    public String toString() {
        return LogicMessages.LED_LabelText + " #" + this.getID() + " " + LogicMessages.PropertyDescriptor_LED_Value + "=" + this.getValue();
    }

    @Override
    public void update() {
        boolean[] outputBits = new boolean[4];
        if (!this.inputs.isEmpty()) {
            outputBits[0] = this.getInput(TERMINAL_1_IN);
            outputBits[1] = this.getInput(TERMINAL_2_IN);
            outputBits[2] = this.getInput(TERMINAL_3_IN);
            outputBits[3] = this.getInput(TERMINAL_4_IN);
        } else {
            outputBits = this.bits;
        }
        this.firePropertyChange(P_VALUE, null, null);
        this.setOutput(TERMINAL_1_OUT, outputBits[0]);
        this.setOutput(TERMINAL_2_OUT, outputBits[1]);
        this.setOutput(TERMINAL_3_OUT, outputBits[2]);
        this.setOutput(TERMINAL_4_OUT, outputBits[3]);
    }
}

