/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.edit;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.examples.logicdesigner.figures.AndGateFeedbackFigure;
import org.eclipse.gef.examples.logicdesigner.figures.CircuitFeedbackFigure;
import org.eclipse.gef.examples.logicdesigner.figures.GroundFeedbackFigure;
import org.eclipse.gef.examples.logicdesigner.figures.LEDFeedbackFigure;
import org.eclipse.gef.examples.logicdesigner.figures.LabelFeedbackFigure;
import org.eclipse.gef.examples.logicdesigner.figures.LiveOutputFeedbackFigure;
import org.eclipse.gef.examples.logicdesigner.figures.LogicColorConstants;
import org.eclipse.gef.examples.logicdesigner.figures.LogicFlowFeedbackFigure;
import org.eclipse.gef.examples.logicdesigner.figures.OrGateFeedbackFigure;
import org.eclipse.gef.examples.logicdesigner.figures.XOrGateFeedbackFigure;
import org.eclipse.gef.examples.logicdesigner.model.AndGate;
import org.eclipse.gef.examples.logicdesigner.model.Circuit;
import org.eclipse.gef.examples.logicdesigner.model.GroundOutput;
import org.eclipse.gef.examples.logicdesigner.model.LED;
import org.eclipse.gef.examples.logicdesigner.model.LiveOutput;
import org.eclipse.gef.examples.logicdesigner.model.LogicFlowContainer;
import org.eclipse.gef.examples.logicdesigner.model.LogicLabel;
import org.eclipse.gef.examples.logicdesigner.model.OrGate;
import org.eclipse.gef.examples.logicdesigner.model.XORGate;
import org.eclipse.gef.examples.logicdesigner.tools.LogicResizeTracker;
import org.eclipse.gef.tools.ResizeTracker;

public class LogicResizableEditPolicy
extends ResizableEditPolicy {
    protected IFigure createDragSourceFeedbackFigure() {
        IFigure figure = this.createFigure(this.getHost(), null);
        figure.setBounds(this.getInitialFeedbackBounds());
        figure.validate();
        this.addFeedback(figure);
        return figure;
    }

    protected IFigure createFigure(GraphicalEditPart part, IFigure parent) {
        IFigure child = LogicResizableEditPolicy.getCustomFeedbackFigure(part.getModel());
        if (parent != null) {
            parent.add(child);
        }
        Rectangle childBounds = part.getFigure().getBounds().getCopy();
        IFigure walker = part.getFigure().getParent();
        while (walker != ((GraphicalEditPart)part.getParent()).getFigure()) {
            walker.translateToParent((Translatable)childBounds);
            walker = walker.getParent();
        }
        child.setBounds(childBounds);
        part.getChildren().forEach(ep -> {
            IFigure iFigure2 = this.createFigure((GraphicalEditPart)ep, child);
        });
        return child;
    }

    private static IFigure getCustomFeedbackFigure(Object modelPart) {
        Object figure;
        if (modelPart instanceof Circuit) {
            figure = new CircuitFeedbackFigure();
        } else if (modelPart instanceof LogicFlowContainer) {
            figure = new LogicFlowFeedbackFigure();
        } else if (modelPart instanceof LogicLabel) {
            figure = new LabelFeedbackFigure();
        } else if (modelPart instanceof LED) {
            figure = new LEDFeedbackFigure();
        } else if (modelPart instanceof OrGate) {
            figure = new OrGateFeedbackFigure();
        } else if (modelPart instanceof XORGate) {
            figure = new XOrGateFeedbackFigure();
        } else if (modelPart instanceof GroundOutput) {
            figure = new GroundFeedbackFigure();
        } else if (modelPart instanceof LiveOutput) {
            figure = new LiveOutputFeedbackFigure();
        } else if (modelPart instanceof AndGate) {
            figure = new AndGateFeedbackFigure();
        } else {
            figure = new RectangleFigure();
            figure.setXOR(true);
            figure.setFill(true);
            figure.setBackgroundColor(LogicColorConstants.ghostFillColor);
            figure.setForegroundColor(ColorConstants.white);
        }
        return figure;
    }

    protected IFigure getFeedbackLayer() {
        return this.getLayer("Scaled Feedback Layer");
    }

    protected Rectangle getInitialFeedbackBounds() {
        return this.getHostFigure().getBounds();
    }

    protected ResizeTracker getResizeTracker(int direction) {
        return new LogicResizeTracker(this.getHost(), direction);
    }
}

