/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.model.commands;

import org.eclipse.gef.examples.text.model.ModelLocation;
import org.eclipse.gef.examples.text.model.TextRun;
import org.eclipse.gef.examples.text.model.commands.MiniEdit;

public class RemoveText
extends MiniEdit {
    int offset;
    char[] chars;
    private final TextRun run;

    public RemoveText(TextRun run, int begin, int end) {
        this.run = run;
        this.offset = begin;
        this.chars = run.getText().substring(this.offset, end).toCharArray();
    }

    @Override
    public void apply() {
        this.run.removeRange(this.offset, this.chars.length);
    }

    @Override
    public boolean canApply() {
        return this.chars != null && this.chars.length != 0;
    }

    @Override
    public ModelLocation getResultingLocation() {
        return new ModelLocation(this.run, this.offset);
    }

    @Override
    public void reapply() {
        this.apply();
    }

    @Override
    public void rollback() {
        this.run.insertText(new String(this.chars), this.offset);
    }
}

