/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.widgets;

import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MidpointLocator;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphContainer;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.ZestStyles;
import org.eclipse.zest.core.widgets.internal.LoopAnchor;
import org.eclipse.zest.core.widgets.internal.PolylineArcConnection;
import org.eclipse.zest.core.widgets.internal.RoundedChopboxAnchor;
import org.eclipse.zest.core.widgets.internal.ZestRootLayer;
import org.eclipse.zest.layouts.LayoutBendPoint;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.LayoutRelationship;
import org.eclipse.zest.layouts.constraints.LayoutConstraint;

public class GraphConnection
extends GraphItem {
    private Font font;
    private final GraphNode sourceNode;
    private final GraphNode destinationNode;
    private double weight;
    private Color color;
    private Color highlightColor;
    private Color foreground;
    private int lineWidth;
    private int lineStyle;
    private final Graph graphModel;
    private int connectionStyle;
    private int curveDepth;
    private boolean isDisposed = false;
    private Label connectionLabel = null;
    private PolylineConnection connectionFigure = null;
    private PolylineConnection cachedConnectionFigure = null;
    private Connection sourceContainerConnectionFigure = null;
    private Connection targetContainerConnectionFigure = null;
    private boolean visible;
    private IFigure tooltip;
    private boolean highlighted;
    private GraphLayoutConnection layoutConnection = null;
    private boolean hasCustomTooltip;

    public GraphConnection(Graph graphModel, int style, GraphNode source, GraphNode destination) {
        super((Widget)graphModel, style);
        this.connectionStyle |= graphModel.getConnectionStyle();
        this.connectionStyle |= style;
        this.sourceNode = source;
        this.destinationNode = destination;
        this.visible = true;
        this.color = ColorConstants.lightGray;
        this.foreground = ColorConstants.lightGray;
        this.highlightColor = graphModel.DARK_BLUE;
        this.lineWidth = 1;
        this.lineStyle = 1;
        this.setWeight(this.weight);
        this.graphModel = graphModel;
        this.curveDepth = 0;
        this.layoutConnection = new GraphLayoutConnection();
        this.font = Display.getDefault().getSystemFont();
        this.registerConnection(source, destination);
    }

    public void registerConnection(GraphNode source, GraphNode destination) {
        if (source.getSourceConnections().contains((Object)this)) {
            source.removeSourceConnection(this);
        }
        if (destination.getTargetConnections().contains((Object)this)) {
            destination.removeTargetConnection(this);
        }
        source.addSourceConnection(this);
        destination.addTargetConnection(this);
        if (source.getParent().getItemType() == 3 && destination.getParent().getItemType() == 3 && source.getParent() == destination.getParent()) {
            this.graphModel.addConnection(this, false);
        } else {
            this.graphModel.addConnection(this, true);
        }
        if (source.getParent().getItemType() == 3) {
            this.sourceContainerConnectionFigure = this.doCreateFigure();
            ((GraphContainer)source.getParent()).addConnectionFigure((PolylineConnection)this.sourceContainerConnectionFigure);
            this.setVisible(false);
        }
        if (destination.getParent().getItemType() == 3) {
            this.targetContainerConnectionFigure = this.doCreateFigure();
            ((GraphContainer)destination.getParent()).addConnectionFigure((PolylineConnection)this.targetContainerConnectionFigure);
            this.setVisible(false);
        }
        this.graphModel.getGraph().registerItem(this);
    }

    void removeFigure() {
        if (this.connectionFigure.getParent() != null) {
            if (this.connectionFigure.getParent() instanceof ZestRootLayer) {
                ((ZestRootLayer)this.connectionFigure.getParent()).removeConnection((IFigure)this.connectionFigure);
            } else {
                this.connectionFigure.getParent().remove((IFigure)this.connectionFigure);
            }
        }
        this.connectionFigure = null;
        if (this.sourceContainerConnectionFigure != null) {
            IFigure sourceContainerConnectionParent = this.sourceContainerConnectionFigure.getParent();
            if (sourceContainerConnectionParent != null) {
                sourceContainerConnectionParent.remove((IFigure)this.sourceContainerConnectionFigure);
            }
            this.sourceContainerConnectionFigure = null;
        }
        if (this.targetContainerConnectionFigure != null && this.targetContainerConnectionFigure.getParent() != null) {
            IFigure targetContainerConnectionParent = this.targetContainerConnectionFigure.getParent();
            if (targetContainerConnectionParent != null) {
                targetContainerConnectionParent.remove((IFigure)this.targetContainerConnectionFigure);
            }
            this.targetContainerConnectionFigure = null;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.isDisposed = true;
        this.getSource().removeSourceConnection(this);
        this.getDestination().removeTargetConnection(this);
        this.graphModel.removeConnection(this);
        if (this.sourceContainerConnectionFigure != null && this.sourceContainerConnectionFigure.getParent() != null) {
            this.sourceContainerConnectionFigure.getParent().remove((IFigure)this.sourceContainerConnectionFigure);
        }
        if (this.targetContainerConnectionFigure != null && this.targetContainerConnectionFigure.getParent() != null) {
            this.targetContainerConnectionFigure.getParent().remove((IFigure)this.targetContainerConnectionFigure);
        }
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public Connection getConnectionFigure() {
        if (this.connectionFigure == null) {
            this.connectionFigure = this.createFigure();
        }
        return this.connectionFigure;
    }

    public LayoutRelationship getLayoutRelationship() {
        return this.layoutConnection;
    }

    public Object getExternalConnection() {
        return this.getData();
    }

    public String toString() {
        String arrow = this.isBidirectionalInLayout() ? " <--> " : " --> ";
        String src = this.sourceNode != null ? this.sourceNode.getText() : "null";
        String dest = this.destinationNode != null ? this.destinationNode.getText() : "null";
        String weight = "  (weight=" + this.getWeightInLayout() + ")";
        return "GraphModelConnection: " + src + arrow + dest + weight;
    }

    public int getConnectionStyle() {
        return this.connectionStyle;
    }

    public void setConnectionStyle(int style) {
        this.connectionStyle = style;
        this.updateFigure((Connection)this.connectionFigure);
    }

    public double getWeightInLayout() {
        return this.weight;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font f) {
        this.font = f;
    }

    public void setWeight(double weight) {
        this.weight = weight < 0.0 ? -1.0 : (weight > 1.0 ? 1.0 : weight);
    }

    public Color getLineColor() {
        return this.color;
    }

    public void setHighlightColor(Color color) {
        this.highlightColor = color;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setLineColor(Color color) {
        this.foreground = color;
        this.changeLineColor(this.foreground);
    }

    public void changeLineColor(Color color) {
        this.color = color;
        this.updateFigure((Connection)this.connectionFigure);
    }

    public void setTooltip(IFigure tooltip) {
        this.hasCustomTooltip = true;
        this.tooltip = tooltip;
        this.updateFigure((Connection)this.connectionFigure);
    }

    public IFigure getTooltip() {
        return this.tooltip;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
        this.updateFigure((Connection)this.connectionFigure);
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(int lineStyle) {
        this.lineStyle = lineStyle;
        this.updateFigure((Connection)this.connectionFigure);
    }

    public GraphNode getSource() {
        return this.sourceNode;
    }

    public GraphNode getDestination() {
        return this.destinationNode;
    }

    @Override
    public void highlight() {
        if (this.highlighted) {
            return;
        }
        this.highlighted = true;
        this.updateFigure((Connection)this.connectionFigure);
        this.graphModel.highlightEdge(this);
    }

    @Override
    public void unhighlight() {
        if (!this.highlighted) {
            return;
        }
        this.highlighted = false;
        this.updateFigure((Connection)this.connectionFigure);
        this.graphModel.unhighlightEdge(this);
    }

    @Override
    public boolean isHighlighted() {
        return this.highlighted;
    }

    @Override
    public Graph getGraphModel() {
        return this.graphModel;
    }

    public void setCurveDepth(int depth) {
        if (this.curveDepth == 0 && depth != 0 || this.curveDepth != 0 && depth == 0) {
            this.cachedConnectionFigure = this.connectionFigure;
            this.graphModel.removeConnection(this);
            this.curveDepth = depth;
            this.connectionFigure = this.createFigure();
            this.registerConnection(this.sourceNode, this.destinationNode);
            this.updateFigure((Connection)this.connectionFigure);
        } else {
            this.curveDepth = depth;
            this.updateFigure((Connection)this.connectionFigure);
        }
    }

    @Override
    public int getItemType() {
        return 2;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.getSource().isVisible() && this.getDestination().isVisible() && visible) {
            this.getFigure().setVisible(visible);
            if (this.sourceContainerConnectionFigure != null) {
                this.sourceContainerConnectionFigure.setVisible(visible);
            }
            if (this.targetContainerConnectionFigure != null) {
                this.targetContainerConnectionFigure.setVisible(visible);
            }
            this.visible = visible;
        } else {
            this.getFigure().setVisible(false);
            if (this.sourceContainerConnectionFigure != null) {
                this.sourceContainerConnectionFigure.setVisible(false);
            }
            if (this.targetContainerConnectionFigure != null) {
                this.targetContainerConnectionFigure.setVisible(false);
            }
            this.visible = false;
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void setText(String string) {
        super.setText(string);
        if (this.connectionFigure != null) {
            this.updateFigure((Connection)this.connectionFigure);
        }
    }

    PolylineConnection getSourceContainerConnectionFigure() {
        return (PolylineConnection)this.sourceContainerConnectionFigure;
    }

    PolylineConnection getTargetContainerConnectionFigure() {
        return (PolylineConnection)this.targetContainerConnectionFigure;
    }

    private void updateFigure(Connection connection) {
        if (this.sourceContainerConnectionFigure != null) {
            this.doUpdateFigure(this.sourceContainerConnectionFigure);
        }
        if (this.targetContainerConnectionFigure != null) {
            this.doUpdateFigure(this.targetContainerConnectionFigure);
        }
        this.doUpdateFigure(connection);
    }

    /*
     * WARNING - void declaration
     */
    private void doUpdateFigure(Connection connection) {
        IFigure toolTip;
        if (connection == null || this.isDisposed()) {
            return;
        }
        Shape connectionShape = (Shape)connection;
        connectionShape.setLineStyle(this.getLineStyle());
        if (this.connectionLabel != null && (this.getText() != null || this.getImage() != null)) {
            if (this.getImage() != null) {
                this.connectionLabel.setIcon(this.getImage());
            }
            if (this.getText() != null) {
                this.connectionLabel.setText(this.getText());
            }
            this.connectionLabel.setFont(this.getFont());
        }
        if (this.highlighted) {
            connectionShape.setForegroundColor(this.getHighlightColor());
            connectionShape.setLineWidth(this.getLineWidth() * 2);
        } else {
            connectionShape.setForegroundColor(this.getLineColor());
            connectionShape.setLineWidth(this.getLineWidth());
        }
        Connection connection2 = connection;
        if (connection2 instanceof PolylineArcConnection) {
            void arcConnection;
            PolylineArcConnection polylineArcConnection = (PolylineArcConnection)connection2;
            PolylineArcConnection cfr_ignored_0 = (PolylineArcConnection)connection2;
            arcConnection.setDepth(this.curveDepth);
        }
        if ((this.connectionStyle & 2) > 0) {
            PolygonDecoration decoration = new PolygonDecoration();
            if (this.getLineWidth() < 3) {
                decoration.setScale(9.0, 3.0);
            } else {
                double logLineWith = (double)this.getLineWidth() / 2.0;
                decoration.setScale(7.0 * logLineWith, 3.0 * logLineWith);
            }
            ((PolylineConnection)connection).setTargetDecoration((RotatableDecoration)decoration);
        }
        if (this.getTooltip() == null && this.getText() != null && this.getText().length() > 0 && !this.hasCustomTooltip) {
            toolTip = new Label();
            ((Label)toolTip).setText(this.getText());
        } else {
            toolTip = this.getTooltip();
        }
        connection.setToolTip(toolTip);
    }

    protected PolylineConnection createFigure() {
        return this.doCreateFigure();
    }

    private PolylineConnection doCreateFigure() {
        PolylineConnection connectionFigure = this.cachedOrNewConnectionFigure();
        ChopboxAnchor sourceAnchor = null;
        ChopboxAnchor targetAnchor = null;
        this.connectionLabel = new Label();
        MidpointLocator labelLocator = null;
        if (this.getSource() == this.getDestination()) {
            sourceAnchor = new LoopAnchor(this.getSource().getFigure());
            targetAnchor = new LoopAnchor(this.getDestination().getFigure());
            labelLocator = new MidpointLocator((Connection)connectionFigure, 0){

                protected Point getReferencePoint() {
                    Point p = Point.SINGLETON;
                    p.x = this.getConnection().getPoints().getPoint((int)this.getIndex()).x;
                    p.y = (int)((double)this.getConnection().getPoints().getPoint((int)this.getIndex()).y - (double)GraphConnection.this.curveDepth * 1.5);
                    this.getConnection().translateToAbsolute((Translatable)p);
                    return p;
                }
            };
        } else {
            if (connectionFigure instanceof PolylineArcConnection && this.curveDepth != 0) {
                ((PolylineArcConnection)connectionFigure).setDepth(this.curveDepth);
            }
            sourceAnchor = new RoundedChopboxAnchor(this.getSource().getFigure(), 8);
            targetAnchor = new RoundedChopboxAnchor(this.getDestination().getFigure(), 8);
            labelLocator = new MidpointLocator((Connection)connectionFigure, 0);
        }
        connectionFigure.setSourceAnchor((ConnectionAnchor)sourceAnchor);
        connectionFigure.setTargetAnchor((ConnectionAnchor)targetAnchor);
        connectionFigure.add((IFigure)this.connectionLabel, (Object)labelLocator);
        this.doUpdateFigure((Connection)connectionFigure);
        return connectionFigure;
    }

    protected PolylineConnection cachedOrNewConnectionFigure() {
        return this.cachedConnectionFigure == null ? new PolylineArcConnection() : this.cachedConnectionFigure;
    }

    private boolean isBidirectionalInLayout() {
        return !ZestStyles.checkStyle(this.connectionStyle, 2);
    }

    @Override
    IFigure getFigure() {
        return this.getConnectionFigure();
    }

    class GraphLayoutConnection
    implements LayoutRelationship {
        Object layoutInformation = null;

        GraphLayoutConnection() {
        }

        public void clearBendPoints() {
            GraphConnection.this.connectionFigure.getPoints().removeAllPoints();
        }

        public LayoutEntity getDestinationInLayout() {
            return GraphConnection.this.getDestination().getLayoutEntity();
        }

        public Object getLayoutInformation() {
            return this.layoutInformation;
        }

        public LayoutEntity getSourceInLayout() {
            return GraphConnection.this.getSource().getLayoutEntity();
        }

        public void populateLayoutConstraint(LayoutConstraint constraint) {
            GraphConnection.this.graphModel.invokeConstraintAdapters((Object)GraphConnection.this, constraint);
        }

        public void setBendPoints(LayoutBendPoint[] bendPoints) {
            PointList points = new PointList();
            points.addPoint(GraphConnection.this.getSource().getLocation().x + GraphConnection.this.getSource().getSize().width / 2, GraphConnection.this.getSource().getLocation().y + GraphConnection.this.getSource().getSize().height / 2);
            LayoutBendPoint[] layoutBendPointArray = bendPoints;
            int n = bendPoints.length;
            int n2 = 0;
            while (n2 < n) {
                LayoutBendPoint p = layoutBendPointArray[n2];
                if (p.getIsControlPoint()) {
                    points.addPoint((Point)new PrecisionPoint(p.getX(), p.getY()));
                }
                ++n2;
            }
            points.addPoint(GraphConnection.this.getDestination().getLocation().x + GraphConnection.this.getDestination().getSize().width / 2, GraphConnection.this.getDestination().getLocation().y + GraphConnection.this.getDestination().getSize().height / 2);
            GraphConnection.this.connectionFigure.setPoints(points);
        }

        public void setLayoutInformation(Object layoutInformation) {
            this.layoutInformation = layoutInformation;
        }

        public Object getGraphData() {
            return GraphConnection.this;
        }

        public void setGraphData(Object o) {
        }
    }
}

