/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.edit;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.AccessibleAnchorProvider;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.edit.LEDEditPolicy;
import org.eclipse.gef.examples.logicdesigner.edit.LogicEditPart;
import org.eclipse.gef.examples.logicdesigner.figures.FigureFactory;
import org.eclipse.gef.examples.logicdesigner.figures.LEDFigure;
import org.eclipse.gef.examples.logicdesigner.model.LED;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Image;

public class LEDEditPart
extends LogicEditPart {
    private static Image LED_SEL_PRIM_BG;
    private static Image LED_SEL_SECD_BG;

    private static Image createImage(String name) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream stream = LEDFigure.class.getResourceAsStream(name);){
                return new Image(null, stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    protected AccessibleEditPart createAccessible() {
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

            public void getName(AccessibleEvent e) {
                e.result = LogicMessages.LogicPlugin_Tool_CreationTool_LED_Label;
            }

            public void getValue(AccessibleControlEvent e) {
                e.result = Integer.toString(LEDEditPart.this.getLEDModel().getValue());
            }
        };
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new LEDEditPolicy());
    }

    protected IFigure createFigure() {
        return FigureFactory.createNewLED();
    }

    public <T> T getAdapter(Class<T> key) {
        if (key == AccessibleAnchorProvider.class) {
            return key.cast(new AbstractGraphicalEditPart.DefaultAccessibleAnchorProvider(this){

                public List<Point> getSourceAnchorLocations() {
                    ArrayList<Point> list = new ArrayList<Point>();
                    List<ConnectionAnchor> sourceAnchors = LEDEditPart.this.getNodeFigure().getSourceConnectionAnchors();
                    sourceAnchors.forEach(anchor -> {
                        boolean bl = list.add(anchor.getReferencePoint().getTranslated(0, -3));
                    });
                    return list;
                }

                public List<Point> getTargetAnchorLocations() {
                    ArrayList<Point> list = new ArrayList<Point>();
                    List<ConnectionAnchor> targetAnchors = LEDEditPart.this.getNodeFigure().getTargetConnectionAnchors();
                    targetAnchors.forEach(anchor -> {
                        boolean bl = list.add(anchor.getReferencePoint().getTranslated(0, 3));
                    });
                    return list;
                }
            });
        }
        return (T)super.getAdapter(key);
    }

    protected Image getBackgroundImage(int state) {
        if (state == 2) {
            if (LED_SEL_PRIM_BG == null) {
                LED_SEL_PRIM_BG = LEDEditPart.createImage("icons/ledbgprim.gif");
            }
            return LED_SEL_PRIM_BG;
        }
        if (state == 1) {
            if (LED_SEL_SECD_BG == null) {
                LED_SEL_SECD_BG = LEDEditPart.createImage("icons/ledbgsel.gif");
            }
            return LED_SEL_SECD_BG;
        }
        return null;
    }

    public LEDFigure getLEDFigure() {
        return (LEDFigure)this.getFigure();
    }

    protected LED getLEDModel() {
        return (LED)this.getModel();
    }

    @Override
    public void propertyChange(PropertyChangeEvent change) {
        if (change.getPropertyName().equals("value")) {
            this.refreshVisuals();
        } else {
            super.propertyChange(change);
        }
    }

    @Override
    public void refreshVisuals() {
        this.getLEDFigure().setValue(this.getLEDModel().getValue());
        super.refreshVisuals();
    }

    public void setSelected(int i) {
        super.setSelected(i);
        this.refreshVisuals();
    }
}

