/*******************************************************************************
 * Copyright (c) 2000, 2022 IBM Corporation and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.gef.examples.logicdesigner.edit;

import java.util.List;

import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;

import org.eclipse.gef.examples.logicdesigner.model.LogicDiagram;
import org.eclipse.gef.examples.logicdesigner.model.LogicElement;

/**
 * Tree EditPart for the Container.
 */
public class LogicContainerTreeEditPart extends LogicTreeEditPart {

	/**
	 * Constructor, which initializes this using the model given as input.
	 */
	public LogicContainerTreeEditPart(Object model) {
		super(model);
	}

	/**
	 * Creates and installs pertinent EditPolicies.
	 */
	@Override
	protected void createEditPolicies() {
		super.createEditPolicies();
		installEditPolicy(EditPolicy.CONTAINER_ROLE, new LogicContainerEditPolicy());
		installEditPolicy(EditPolicy.TREE_CONTAINER_ROLE, new LogicTreeContainerEditPolicy());
		// If this editpart is the contents of the viewer, then it is not deletable!
		if (getParent() instanceof RootEditPart)
			installEditPolicy(EditPolicy.COMPONENT_ROLE, new RootComponentEditPolicy());
	}

	/**
	 * Returns the model of this as a LogicDiagram.
	 *
	 * @return Model of this.
	 */
	protected LogicDiagram getLogicDiagram() {
		return (LogicDiagram) getModel();
	}

	/**
	 * Returns the children of this from the model, as this is capable enough of
	 * holding EditParts.
	 *
	 * @return List of children.
	 */
	@Override
	protected List<LogicElement> getModelChildren() {
		return getLogicDiagram().getChildren();
	}

}
