/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.BidiProcessor;
import org.eclipse.draw2d.text.BlockBox;
import org.eclipse.draw2d.text.BlockFlowLayout;
import org.eclipse.draw2d.text.FlowBorder;
import org.eclipse.draw2d.text.FlowFigure;
import org.eclipse.draw2d.text.FlowFigureLayout;

public class BlockFlow
extends FlowFigure {
    private final BlockBox blockBox = this.createBlockBox();
    private int alignment = 0;
    private int orientation = 0;
    private boolean bidiValid;

    @Override
    protected void contributeBidi(BidiProcessor proc) {
        proc.addControlChar('\u2029');
    }

    BlockBox createBlockBox() {
        return new BlockBox(this);
    }

    @Override
    protected FlowFigureLayout createDefaultFlowLayout() {
        return new BlockFlowLayout(this);
    }

    protected BlockBox getBlockBox() {
        return this.blockBox;
    }

    int getBottomMargin() {
        int margin = 0;
        if (this.getBorder() instanceof FlowBorder) {
            FlowBorder border = (FlowBorder)this.getBorder();
            return border.getBottomMargin();
        }
        List<? extends IFigure> children = this.getChildren();
        int childIndex = children.size() - 1;
        if (childIndex >= 0 && children.get(childIndex) instanceof BlockFlow) {
            margin = Math.max(margin, ((BlockFlow)children.get(childIndex)).getBottomMargin());
        }
        return margin;
    }

    public int getHorizontalAligment() {
        if (this.alignment != 0) {
            return this.alignment;
        }
        IFigure parent = this.getParent();
        while (parent != null && !(parent instanceof BlockFlow)) {
            parent = parent.getParent();
        }
        if (parent != null) {
            return ((BlockFlow)parent).getHorizontalAligment();
        }
        return 1;
    }

    int getLeftMargin() {
        if (this.getBorder() instanceof FlowBorder) {
            return ((FlowBorder)this.getBorder()).getLeftMargin();
        }
        return 0;
    }

    public int getLocalOrientation() {
        return this.orientation;
    }

    public int getLocalHorizontalAlignment() {
        return this.alignment;
    }

    public int getOrientation() {
        if (this.orientation != 0) {
            return this.orientation;
        }
        IFigure parent = this.getParent();
        while (parent != null && !(parent instanceof BlockFlow)) {
            parent = parent.getParent();
        }
        if (parent != null) {
            return ((BlockFlow)parent).getOrientation();
        }
        return this.isMirrored() ? 0x4000000 : 0x2000000;
    }

    int getRightMargin() {
        if (this.getBorder() instanceof FlowBorder) {
            return ((FlowBorder)this.getBorder()).getRightMargin();
        }
        return 0;
    }

    int getTopMargin() {
        int margin = 0;
        if (this.getBorder() instanceof FlowBorder) {
            FlowBorder border = (FlowBorder)this.getBorder();
            return border.getTopMargin();
        }
        List<? extends IFigure> children = this.getChildren();
        if (!children.isEmpty() && children.get(0) instanceof BlockFlow) {
            margin = Math.max(margin, ((BlockFlow)children.get(0)).getTopMargin());
        }
        return margin;
    }

    @Override
    public void paintBorder(Graphics graphics) {
        if (this.getBorder() instanceof FlowBorder) {
            Rectangle where = this.getBlockBox().toRectangle();
            where.crop(new Insets(this.getTopMargin(), this.getLeftMargin(), this.getBottomMargin(), this.getRightMargin()));
            ((FlowBorder)this.getBorder()).paint(this, graphics, where, 147456);
        } else {
            super.paintBorder(graphics);
        }
        if (this.selectionStart != -1) {
            graphics.restoreState();
            graphics.setXORMode(true);
            graphics.setBackgroundColor(ColorConstants.white);
            graphics.fillRectangle(this.getBounds());
        }
    }

    @Override
    public void postValidate() {
        Rectangle newBounds = this.getBlockBox().toRectangle();
        newBounds.crop(new Insets(this.getTopMargin(), this.getLeftMargin(), this.getBottomMargin(), this.getRightMargin()));
        this.setBounds(newBounds);
    }

    @Override
    public void revalidate() {
        BlockFlowLayout layout = (BlockFlowLayout)this.getLayoutManager();
        layout.blockContentsChanged();
        super.revalidate();
    }

    @Override
    protected void revalidateBidi(IFigure origin) {
        if (this.bidiValid) {
            this.bidiValid = false;
            this.revalidate();
        }
    }

    public void setHorizontalAligment(int value) {
        if ((value &= 0xC7) == this.alignment) {
            return;
        }
        this.alignment = value;
        this.revalidate();
    }

    public void setOrientation(int orientation) {
        if (this.orientation == (orientation &= 0x6000000)) {
            return;
        }
        this.orientation = orientation;
        this.revalidateBidi(this);
    }

    @Override
    protected boolean useLocalCoordinates() {
        return true;
    }

    @Override
    public void validate() {
        if (!this.bidiValid) {
            BidiProcessor.INSTANCE.setOrientation(this.getOrientation());
            if (this.getOrientation() == 0x2000000 && this.isMirrored()) {
                BidiProcessor.INSTANCE.addControlChar('\u202a');
            }
            super.contributeBidi(BidiProcessor.INSTANCE);
            BidiProcessor.INSTANCE.process();
            this.bidiValid = true;
        }
        super.validate();
    }
}

