/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.geometry;

import java.io.Serializable;

public class Insets
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public int left;
    public int top;
    public int bottom;
    public int right;

    public Insets() {
    }

    public Insets(Insets i) {
        this(i.top, i.left, i.bottom, i.right);
    }

    public Insets(int i) {
        this(i, i, i, i);
    }

    public Insets(int top, int left, int bottom, int right) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
    }

    public Insets add(Insets insets) {
        this.top += insets.top;
        this.bottom += insets.bottom;
        this.left += insets.left;
        this.right += insets.right;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        Object object = o;
        if (object instanceof Insets) {
            void i;
            Insets insets = (Insets)object;
            Insets cfr_ignored_0 = (Insets)object;
            return i.top == this.top && i.bottom == this.bottom && i.left == this.left && i.right == this.right;
        }
        return false;
    }

    public Insets getAdded(Insets insets) {
        return new Insets(this).add(insets);
    }

    public int getHeight() {
        return this.top + this.bottom;
    }

    public Insets getTransposed() {
        return new Insets(this).transpose();
    }

    public Insets getNegated() {
        return new Insets(-this.top, -this.left, -this.bottom, -this.right);
    }

    public int getWidth() {
        return this.left + this.right;
    }

    public int hashCode() {
        return this.top * 7 + this.left * 2 + this.bottom * 31 + this.right * 37;
    }

    public boolean isEmpty() {
        return this.left == 0 && this.right == 0 && this.top == 0 && this.bottom == 0;
    }

    public String toString() {
        return "Insets(t=" + this.top + ", l=" + this.left + ", b=" + this.bottom + ", r=" + this.right + ")";
    }

    public Insets transpose() {
        int temp = this.top;
        this.top = this.left;
        this.left = temp;
        temp = this.right;
        this.right = this.bottom;
        this.bottom = temp;
        return this;
    }

    public static Insets min(Insets insets_1, Insets insets_2) {
        return new Insets(Math.min(insets_1.top, insets_2.top), Math.min(insets_1.left, insets_2.left), Math.min(insets_1.bottom, insets_2.bottom), Math.min(insets_1.right, insets_2.right));
    }
}

