/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.examples.text.SelectionRange;
import org.eclipse.gef.examples.text.edit.TextEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class SelectionModel {
    private final SelectionRange selectionRange;
    private final EditPart selectionContainer;
    private final List constantSelection;

    public SelectionModel(ISelection selection) {
        this(null, selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).toList() : null, null);
    }

    public SelectionModel(SelectionRange range, List selectedParts, EditPart container) {
        this.selectionRange = range;
        this.selectionContainer = container;
        this.constantSelection = selectedParts == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(selectedParts);
    }

    protected void applySelectedParts() {
        if (!this.constantSelection.isEmpty()) {
            Iterator itr = this.constantSelection.iterator();
            while (true) {
                EditPart part = (EditPart)itr.next();
                if (!itr.hasNext()) {
                    part.setSelected(2);
                    break;
                }
                part.setSelected(1);
            }
        }
    }

    protected void applySelectionRange() {
        SelectionRange range = this.getSelectionRange();
        if (range != null) {
            List currentSelection = range.getSelectedParts();
            int i = 0;
            while (i < currentSelection.size()) {
                TextEditPart textpart = (TextEditPart)currentSelection.get(i);
                textpart.setSelection(0, textpart.getLength());
                ++i;
            }
            if (range.begin.part == range.end.part) {
                range.begin.part.setSelection(range.begin.offset, range.end.offset);
            } else {
                range.begin.part.setSelection(range.begin.offset, range.begin.part.getLength());
                range.end.part.setSelection(0, range.end.offset);
            }
        }
    }

    public void deselect() {
        this.deselectSelectedParts();
        this.deselectSelectionRange();
    }

    protected void deselectSelectedParts() {
        Iterator itr = this.constantSelection.iterator();
        while (itr.hasNext()) {
            ((EditPart)itr.next()).setSelected(0);
        }
    }

    protected void deselectSelectionRange() {
        SelectionRange range = this.getSelectionRange();
        if (range != null) {
            List selection = range.getSelectedParts();
            int i = 0;
            while (i < selection.size()) {
                ((TextEditPart)selection.get(i)).setSelection(-1, -1);
                ++i;
            }
        }
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = obj == this;
        if (!result && obj instanceof SelectionModel) {
            SelectionModel other = (SelectionModel)obj;
            EditPart otherContainer = other.getSelectionContainer();
            SelectionRange otherRange = other.getSelectionRange();
            result = this.constantSelection.equals(other.getSelectedEditParts()) && (this.selectionContainer == otherContainer || this.selectionContainer != null && this.selectionContainer.equals(otherContainer)) && (this.selectionRange == otherRange || this.selectionRange != null && this.selectionRange.equals(otherRange));
        }
        return result;
    }

    public SelectionModel getAppendedSelection(EditPart newPart) {
        ArrayList<EditPart> list = new ArrayList<EditPart>(this.constantSelection);
        list.remove(newPart);
        list.add(newPart);
        return new SelectionModel(this.selectionRange, list, this.selectionContainer);
    }

    public SelectionModel getExcludedSelection(EditPart exclude) {
        ArrayList list = new ArrayList(this.constantSelection);
        list.remove(exclude);
        return new SelectionModel(this.selectionRange, list, this.selectionContainer);
    }

    public EditPart getFocusPart() {
        if (this.constantSelection.isEmpty()) {
            return null;
        }
        return (EditPart)this.constantSelection.get(this.constantSelection.size() - 1);
    }

    public List getSelectedEditParts() {
        return this.constantSelection;
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.constantSelection);
    }

    public EditPart getSelectionContainer() {
        return this.selectionContainer;
    }

    public SelectionRange getSelectionRange() {
        return this.selectionRange;
    }

    public void applySelection(SelectionModel old) {
        if (old == null) {
            this.applySelectedParts();
            this.applySelectionRange();
            return;
        }
        if (!old.getSelectedEditParts().isEmpty()) {
            HashSet editparts = new HashSet(this.constantSelection);
            for (EditPart part : old.getSelectedEditParts()) {
                if (editparts.contains(part)) continue;
                part.setSelected(0);
            }
        }
        this.applySelectedParts();
        old.deselectSelectionRange();
        this.applySelectionRange();
    }

    public boolean isTextSelected() {
        return this.selectionRange != null;
    }
}

