/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.zoom;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ScaledGraphics;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class ZoomContainer
extends Figure {
    private float zoom;

    public ZoomContainer() {
        this.setLayoutManager((LayoutManager)new StackLayout());
    }

    public Rectangle getClientArea(Rectangle rect) {
        super.getClientArea(rect);
        rect.width = (int)((float)rect.width / this.zoom);
        rect.height = (int)((float)rect.height / this.zoom);
        return rect;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension d = super.getPreferredSize(wHint, hHint);
        int w = this.getInsets().getWidth();
        int h = this.getInsets().getHeight();
        return d.getExpanded(-w, -h).scale((double)this.zoom).expand(w, h);
    }

    protected void paintClientArea(Graphics graphics) {
        if (this.getChildren().isEmpty()) {
            return;
        }
        boolean optimizeClip = this.getBorder() == null || this.getBorder().isOpaque();
        ScaledGraphics g = new ScaledGraphics(graphics);
        if (!optimizeClip) {
            g.clipRect(this.getBounds().getCropped(this.getInsets()));
        }
        g.translate(this.getBounds().x + this.getInsets().left, this.getBounds().y + this.getInsets().top);
        g.scale((double)this.zoom);
        g.pushState();
        this.paintChildren((Graphics)g);
        g.popState();
        g.dispose();
        graphics.restoreState();
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
        this.revalidate();
        this.repaint();
    }

    public void translateToParent(Translatable t) {
        t.performScale((double)this.zoom);
        super.translateToParent(t);
    }

    public void translateFromParent(Translatable t) {
        super.translateFromParent(t);
        t.performScale((double)(1.0f / this.zoom));
    }

    protected boolean useLocalCoordinates() {
        return true;
    }
}

