/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.shapes.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.EllipseAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.examples.shapes.model.Connection;
import org.eclipse.gef.examples.shapes.model.EllipticalShape;
import org.eclipse.gef.examples.shapes.model.ModelElement;
import org.eclipse.gef.examples.shapes.model.RectangularShape;
import org.eclipse.gef.examples.shapes.model.Shape;
import org.eclipse.gef.examples.shapes.model.commands.ConnectionCreateCommand;
import org.eclipse.gef.examples.shapes.model.commands.ConnectionReconnectCommand;
import org.eclipse.gef.examples.shapes.parts.ShapeComponentEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;

class ShapeEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener,
NodeEditPart {
    private ConnectionAnchor anchor;

    ShapeEditPart() {
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            ((ModelElement)this.getModel()).addPropertyChangeListener(this);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ShapeComponentEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new GraphicalNodeEditPolicy(){

            protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
                ConnectionCreateCommand cmd = (ConnectionCreateCommand)request.getStartCommand();
                cmd.setTarget((Shape)this.getHost().getModel());
                return cmd;
            }

            protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
                Shape source = (Shape)this.getHost().getModel();
                int style = (Integer)request.getNewObjectType();
                ConnectionCreateCommand cmd = new ConnectionCreateCommand(source, style);
                request.setStartCommand((Command)cmd);
                return cmd;
            }

            protected Command getReconnectSourceCommand(ReconnectRequest request) {
                Connection conn = (Connection)request.getConnectionEditPart().getModel();
                Shape newSource = (Shape)this.getHost().getModel();
                ConnectionReconnectCommand cmd = new ConnectionReconnectCommand(conn);
                cmd.setNewSource(newSource);
                return cmd;
            }

            protected Command getReconnectTargetCommand(ReconnectRequest request) {
                Connection conn = (Connection)request.getConnectionEditPart().getModel();
                Shape newTarget = (Shape)this.getHost().getModel();
                ConnectionReconnectCommand cmd = new ConnectionReconnectCommand(conn);
                cmd.setNewTarget(newTarget);
                return cmd;
            }
        });
    }

    protected IFigure createFigure() {
        IFigure f = this.createFigureForModel();
        f.setOpaque(true);
        f.setBackgroundColor(ColorConstants.green);
        return f;
    }

    private IFigure createFigureForModel() {
        if (this.getModel() instanceof EllipticalShape) {
            return new Ellipse();
        }
        if (this.getModel() instanceof RectangularShape) {
            return new RectangleFigure();
        }
        throw new IllegalArgumentException();
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((ModelElement)this.getModel()).removePropertyChangeListener(this);
        }
    }

    private Shape getCastedModel() {
        return (Shape)this.getModel();
    }

    protected ConnectionAnchor getConnectionAnchor() {
        if (this.anchor == null) {
            if (this.getModel() instanceof EllipticalShape) {
                this.anchor = new EllipseAnchor(this.getFigure());
            } else if (this.getModel() instanceof RectangularShape) {
                this.anchor = new ChopboxAnchor(this.getFigure());
            } else {
                throw new IllegalArgumentException("unexpected model");
            }
        }
        return this.anchor;
    }

    protected List getModelSourceConnections() {
        return this.getCastedModel().getSourceConnections();
    }

    protected List getModelTargetConnections() {
        return this.getCastedModel().getTargetConnections();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return this.getConnectionAnchor();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("Shape.Size".equals(prop) || "Shape.Location".equals(prop)) {
            this.refreshVisuals();
        } else if ("Shape.SourceConn".equals(prop)) {
            this.refreshSourceConnections();
        } else if ("Shape.TargetConn".equals(prop)) {
            this.refreshTargetConnections();
        }
    }

    protected void refreshVisuals() {
        Rectangle bounds = new Rectangle(this.getCastedModel().getLocation(), this.getCastedModel().getSize());
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)bounds);
    }
}

