/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editparts;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class GuideLayer
extends FreeformLayer {
    private Map constraints;

    public Object getConstraint(IFigure child) {
        return this.getConstraints().get(child);
    }

    public Map getConstraints() {
        if (this.constraints == null) {
            this.constraints = new HashMap();
        }
        return this.constraints;
    }

    public Rectangle getFreeformExtent() {
        int maxX = 5;
        int minX = 5;
        int maxY = 5;
        int minY = 5;
        for (IFigure child : this.getChildren()) {
            int position;
            Boolean isHorizontal = (Boolean)this.getConstraint(child);
            if (isHorizontal == null) continue;
            if (isHorizontal.booleanValue()) {
                position = child.getBounds().y;
                minY = Math.min(minY, position);
                maxY = Math.max(maxY, position);
                continue;
            }
            position = child.getBounds().x;
            minX = Math.min(minX, position);
            maxX = Math.max(maxX, position);
        }
        Rectangle r = new Rectangle(minX, minY, maxX - minX + 1, maxY - minY + 1);
        if (r.width > 1) {
            r.expand(5, 0);
        }
        if (r.height > 1) {
            r.expand(0, 5);
        }
        return r;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Rectangle extents = this.getFreeformExtent();
        return new Dimension(extents.right(), extents.bottom());
    }

    public void remove(IFigure child) {
        this.getConstraints().remove(child);
        super.remove(child);
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
        for (IFigure child : this.getChildren()) {
            Boolean isHorizontal = (Boolean)this.getConstraint(child);
            if (isHorizontal == null) continue;
            if (isHorizontal.booleanValue()) {
                Rectangle.SINGLETON.setLocation(this.getBounds().x, child.getBounds().y);
                Rectangle.SINGLETON.setSize(this.getBounds().width, 1);
            } else {
                Rectangle.SINGLETON.setLocation(child.getBounds().x, this.getBounds().y);
                Rectangle.SINGLETON.setSize(1, this.getBounds().height);
            }
            child.setBounds(Rectangle.SINGLETON);
        }
    }

    public void setConstraint(IFigure child, Object constraint) {
        this.getConstraints().put(child, constraint);
    }
}

