/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.examples.text.figures.ListItemBorder;
import org.eclipse.swt.graphics.Image;

public class TreeItemBorder
extends ListItemBorder {
    private static final int LEFT_SPACE = 5;
    private static final int RIGHT_SPACE = 5;
    private Insets imgInsets;
    private Image image;
    private Dimension imageSize;

    public TreeItemBorder(Image image) {
        this.setImage(image);
    }

    public Insets getInsets(IFigure figure) {
        return this.imgInsets;
    }

    public Image getImage() {
        return this.image;
    }

    public Dimension getPreferredSize(IFigure f) {
        return this.imageSize;
    }

    @Override
    public void paintBorder(IFigure figure, Graphics graphics, Insets insets) {
        if (this.image == null) {
            return;
        }
        Rectangle rect = TreeItemBorder.getPaintRectangle((IFigure)figure, (Insets)insets);
        graphics.translate(rect.x, rect.y);
        graphics.drawImage(this.getImage(), 5, 0);
        int y = this.imageSize.height / 2;
        int i = 0;
        while (i < 5) {
            graphics.drawPoint(i, y);
            i += 2;
        }
    }

    public void setImage(Image img) {
        this.image = img;
        this.imageSize = new Dimension(this.image);
        this.imgInsets = new Insets();
        this.imgInsets.left = this.imageSize.width + 5 + 5;
    }
}

