/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.flow.model.commands;

import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.flow.model.Activity;
import org.eclipse.gef.examples.flow.model.Transition;

public class ReconnectTargetCommand
extends Command {
    protected Activity source;
    protected Activity target;
    protected Transition transition;
    protected Activity oldTarget;

    public boolean canExecute() {
        if (this.transition.source.equals(this.target)) {
            return false;
        }
        List transitions = this.source.getOutgoingTransitions();
        int i = 0;
        while (i < transitions.size()) {
            Transition trans = (Transition)transitions.get(i);
            if (trans.target.equals(this.target) && !trans.target.equals(this.oldTarget)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void execute() {
        if (this.target != null) {
            this.oldTarget.removeInput(this.transition);
            this.transition.target = this.target;
            this.target.addInput(this.transition);
        }
    }

    public Activity getSource() {
        return this.source;
    }

    public Activity getTarget() {
        return this.target;
    }

    public Transition getTransition() {
        return this.transition;
    }

    public void setSource(Activity activity) {
        this.source = activity;
    }

    public void setTarget(Activity activity) {
        this.target = activity;
    }

    public void setTransition(Transition trans) {
        this.transition = trans;
        this.source = trans.source;
        this.oldTarget = trans.target;
    }

    public void undo() {
        this.target.removeInput(this.transition);
        this.transition.target = this.oldTarget;
        this.oldTarget.addInput(this.transition);
    }
}

