/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.actions;

import org.eclipse.gef.examples.text.TextEditor;
import org.eclipse.gef.examples.text.actions.StyleListener;
import org.eclipse.gef.examples.text.actions.StyleService;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;

public abstract class StyleComboContributionItem
extends ContributionItem {
    protected Combo combo;
    protected ToolItem toolItem;
    protected StyleService styleService;
    protected IPartService partService;
    protected StyleListener styleListener = new StyleListener(){

        @Override
        public void styleChanged(String styleID) {
            if (styleID == null || styleID.equals(StyleComboContributionItem.this.getProperty())) {
                StyleComboContributionItem.this.refresh();
            }
        }
    };
    protected IPartListener2 partListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part instanceof TextEditor) {
                StyleComboContributionItem.this.setStyleService((StyleService)part.getAdapter(StyleService.class));
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    };

    public StyleComboContributionItem(IPartService service) {
        this.partService = service;
        this.partService.addPartListener(this.partListener);
    }

    protected Control createControl(Composite parent) {
        this.combo = new Combo(parent, 4);
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                StyleComboContributionItem.this.handleWidgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                StyleComboContributionItem.this.handleWidgetSelected(e);
            }
        });
        this.combo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                StyleComboContributionItem.this.refresh();
            }
        });
        this.combo.setItems(this.getItems());
        this.toolItem.setWidth(this.combo.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.refresh();
        return this.combo;
    }

    public void dispose() {
        if (this.styleService != null) {
            this.styleService.removeStyleListener(this.styleListener);
        }
        this.partService.removePartListener(this.partListener);
    }

    public void fill(ToolBar parent, int index) {
        this.toolItem = new ToolItem(parent, 2, index);
        Control control = this.createControl((Composite)parent);
        this.toolItem.setControl(control);
    }

    protected int findIndexOf(String text) {
        int i = 0;
        while (i < this.getItems().length) {
            if (this.getItems()[i].equalsIgnoreCase(text)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected abstract String[] getItems();

    protected abstract String getProperty();

    protected abstract void handleWidgetSelected(SelectionEvent var1);

    protected void refresh() {
        if (this.combo == null) {
            return;
        }
        boolean enablement = true;
        if (this.styleService == null) {
            enablement = false;
        } else {
            int index;
            if (!this.styleService.getStyleState(this.getProperty()).equals(StyleService.STATE_EDITABLE)) {
                enablement = false;
            }
            Object style = this.styleService.getStyle(this.getProperty());
            String value = style.toString();
            if (StyleService.UNDEFINED.equals(style)) {
                value = "";
            }
            if ((index = this.findIndexOf(value)) >= 0) {
                this.combo.select(index);
            } else {
                this.combo.setText(value);
            }
        }
        this.combo.setEnabled(enablement);
    }

    protected void setStyleService(StyleService service) {
        if (this.styleService == service) {
            return;
        }
        if (this.styleService != null) {
            this.styleService.removeStyleListener(this.styleListener);
        }
        this.styleService = service;
        if (this.styleService != null) {
            this.styleService.addStyleListener(this.styleListener);
        }
        this.refresh();
    }
}

