/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.edit;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.examples.logicdesigner.edit.LogicEditPart;
import org.eclipse.gef.examples.logicdesigner.figures.FigureFactory;
import org.eclipse.gef.examples.logicdesigner.figures.NodeFigure;
import org.eclipse.gef.examples.logicdesigner.model.GroundOutput;
import org.eclipse.gef.examples.logicdesigner.model.LiveOutput;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;
import org.eclipse.gef.examples.logicdesigner.model.Wire;
import org.eclipse.gef.examples.logicdesigner.model.commands.ConnectionCommand;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;

public class LogicNodeEditPolicy
extends GraphicalNodeEditPolicy {
    protected Connection createDummyConnection(Request req) {
        PolylineConnection conn = FigureFactory.createNewWire(null);
        return conn;
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        ConnectionCommand command = (ConnectionCommand)request.getStartCommand();
        command.setTarget(this.getLogicSubpart());
        ConnectionAnchor ctor = this.getLogicEditPart().getTargetConnectionAnchor((Request)request);
        if (ctor == null) {
            return null;
        }
        command.setTargetTerminal(this.getLogicEditPart().mapConnectionAnchorToTerminal(ctor));
        return command;
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        ConnectionCommand command = new ConnectionCommand();
        command.setWire(new Wire());
        command.setSource(this.getLogicSubpart());
        ConnectionAnchor ctor = this.getLogicEditPart().getSourceConnectionAnchor((Request)request);
        command.setSourceTerminal(this.getLogicEditPart().mapConnectionAnchorToTerminal(ctor));
        request.setStartCommand((Command)command);
        return command;
    }

    protected IFigure getFeedbackLayer() {
        return this.getLayer("Scaled Feedback Layer");
    }

    protected LogicEditPart getLogicEditPart() {
        return (LogicEditPart)this.getHost();
    }

    protected LogicSubpart getLogicSubpart() {
        return (LogicSubpart)this.getHost().getModel();
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        if (this.getLogicSubpart() instanceof LiveOutput || this.getLogicSubpart() instanceof GroundOutput) {
            return null;
        }
        ConnectionCommand cmd = new ConnectionCommand();
        cmd.setWire((Wire)request.getConnectionEditPart().getModel());
        ConnectionAnchor ctor = this.getLogicEditPart().getTargetConnectionAnchor((Request)request);
        cmd.setTarget(this.getLogicSubpart());
        cmd.setTargetTerminal(this.getLogicEditPart().mapConnectionAnchorToTerminal(ctor));
        return cmd;
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        ConnectionCommand cmd = new ConnectionCommand();
        cmd.setWire((Wire)request.getConnectionEditPart().getModel());
        ConnectionAnchor ctor = this.getLogicEditPart().getSourceConnectionAnchor((Request)request);
        cmd.setSource(this.getLogicSubpart());
        cmd.setSourceTerminal(this.getLogicEditPart().mapConnectionAnchorToTerminal(ctor));
        return cmd;
    }

    protected NodeFigure getNodeFigure() {
        return (NodeFigure)((GraphicalEditPart)this.getHost()).getFigure();
    }
}

