/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajdoc;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.HierarchyWalker;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationship;
import org.aspectj.tools.ajdoc.StructureUtil;
import org.aspectj.util.TypeSafeEnum;

class HtmlDecorator {
    private static final String POINTCUT_DETAIL = "Pointcut Detail";
    private static final String ADVICE_DETAIL = "Advice Detail";
    private static final String DECLARE_DETAIL = "Declare Detail";
    private static final String ADVICE_SUMMARY = "Advice Summary";
    private static final String POINTCUT_SUMMARY = "Pointcut Summary";
    private static final String DECLARE_SUMMARY = "Declare Summary";
    private static final String ITD_METHOD_SUMMARY = "Inter-Type Method Summary";
    private static final String ITD_FIELD_SUMMARY = "Inter-Type Field Summary";
    private static final String ITD_CONSTRUCTOR_SUMMARY = "Inter-Type Constructor Summary";
    static List visibleFileList = new ArrayList();
    static Hashtable declIDTable = null;
    static File rootDir = null;
    static String docVisibilityModifier;

    HtmlDecorator() {
    }

    static void decorateHTMLFromInputFiles(AsmManager model, Hashtable table, File newRootDir, File[] inputFiles, String docModifier) throws IOException {
        rootDir = newRootDir;
        declIDTable = table;
        docVisibilityModifier = docModifier;
        for (int i = 0; i < inputFiles.length; ++i) {
            HtmlDecorator.decorateHTMLFromIPEs(HtmlDecorator.getProgramElements(model, inputFiles[i].getCanonicalPath()), rootDir.getCanonicalPath() + "/", docModifier, false);
        }
    }

    static void decorateHTMLFromIPEs(IProgramElement[] decls, String base, String docModifier, boolean exceededNestingLevel) throws IOException {
        if (decls != null) {
            for (int i = 0; i < decls.length; ++i) {
                IProgramElement decl = decls[i];
                HtmlDecorator.decorateHTMLFromIPE(decl, base, docModifier, exceededNestingLevel);
            }
        }
    }

    static void decorateHTMLFromIPE(IProgramElement decl, String base, String docModifier, boolean exceededNestingLevel) throws IOException {
        boolean nestedClass = false;
        if (decl.getKind().isType()) {
            boolean decorateFile = true;
            if (HtmlDecorator.isAboveVisibility(decl)) {
                visibleFileList.add(decl.toSignatureString());
                String packageName = decl.getPackageName();
                String filename = "";
                if (packageName != null) {
                    int index1 = base.lastIndexOf("/");
                    int index2 = base.lastIndexOf(".");
                    String currFileClass = "";
                    if (index1 > -1 && index2 > 0 && index1 < index2) {
                        currFileClass = base.substring(index1 + 1, index2);
                    }
                    if (currFileClass.equals(decl.getDeclaringType())) {
                        nestedClass = true;
                        packageName = packageName.replace('.', '/');
                        String newBase = "";
                        if (base.lastIndexOf("/") > 0) {
                            newBase = base.substring(0, base.lastIndexOf("/"));
                        }
                        String signature = HtmlDecorator.constructNestedTypeName(decl);
                        filename = newBase + "/" + packageName + "/" + currFileClass + signature + ".html";
                    } else {
                        packageName = packageName.replace('.', '/');
                        filename = base + packageName + "/" + decl.toSignatureString() + ".html";
                    }
                } else {
                    filename = base + decl.toSignatureString() + ".html";
                }
                if (!exceededNestingLevel) {
                    HtmlDecorator.decorateHTMLFile(new File(filename));
                } else {
                    System.out.println("Warning: can not generate documentation for nested inner class: " + decl.toSignatureString());
                }
            }
        }
    }

    private static String constructNestedTypeName(IProgramElement node) {
        if (node.getParent().getKind().isSourceFile()) {
            return node.getName();
        }
        String nodeName = "";
        if (node.getKind().isType()) {
            nodeName = nodeName + '.' + node.getName();
        }
        return HtmlDecorator.constructNestedTypeName(node.getParent()) + nodeName;
    }

    static void decorateHTMLFile(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        System.out.println("> Decorating " + file.getCanonicalPath() + "...");
        BufferedReader reader = new BufferedReader(new FileReader(file));
        StringBuffer fileContents = new StringBuffer();
        String line = reader.readLine();
        while (line != null) {
            fileContents.append(line + "\n");
            line = reader.readLine();
        }
        boolean isSecond = false;
        int index = 0;
        while (true) {
            int classEndIndex;
            int classEndIndex2;
            String fullname;
            IProgramElement decl;
            String contents = fileContents.toString();
            int start = contents.indexOf("__AJDECLID:", index);
            int end = contents.indexOf(":__", index);
            if (start == -1) {
                decl = null;
            } else {
                if (end == -1) {
                    throw new Error("Malformed DeclID.");
                }
                String tid = contents.substring(start + "__AJDECLID:".length(), end);
                decl = (IProgramElement)declIDTable.get(tid);
                index = start;
            }
            if (decl == null) break;
            fileContents.delete(start, end + ":__".length());
            if (decl.getKind().isType()) {
                isSecond = true;
                fullname = "";
                fullname = decl.getParent().getKind().equals(IProgramElement.Kind.ASPECT) || decl.getParent().getKind().equals(IProgramElement.Kind.CLASS) ? fullname + decl.getParent().toSignatureString().concat(".").concat(decl.toSignatureString()) : fullname + decl.toSignatureString();
                if (file.getName().indexOf(fullname + ".html") != -1) {
                    HtmlDecorator.addAspectDocumentation(decl, fileContents, index);
                }
            } else {
                HtmlDecorator.decorateMemberDocumentation(decl, fileContents, index);
            }
            if (!decl.getKind().equals(IProgramElement.Kind.ASPECT) || file.getName().indexOf(decl.toSignatureString()) == -1) continue;
            fullname = "";
            fullname = decl.getParent().getKind().equals(IProgramElement.Kind.ASPECT) || decl.getParent().getKind().equals(IProgramElement.Kind.CLASS) ? fullname + decl.getParent().toSignatureString().concat(".").concat(decl.toSignatureString()) : fullname + decl.toSignatureString();
            if (file.getName().indexOf(fullname + ".html") == -1) continue;
            boolean br = true;
            int classStartIndex = fileContents.toString().indexOf("<BR>\nClass ");
            if (classStartIndex == -1) {
                classStartIndex = fileContents.toString().indexOf("<H2>\nClass ");
                br = false;
            }
            if (classStartIndex == -1) {
                classStartIndex = fileContents.toString().indexOf("<h2 title=\"Class ");
                classEndIndex2 = fileContents.toString().indexOf("</h2>", classStartIndex);
                if (classEndIndex2 != -1) {
                    String classLine = fileContents.toString().substring(classStartIndex, classEndIndex2);
                    String aspectLine = classLine.replaceAll("Class ", "Aspect ");
                    fileContents.delete(classStartIndex, classEndIndex2);
                    fileContents.insert(classStartIndex, aspectLine);
                }
            } else if (classStartIndex != -1) {
                classEndIndex2 = fileContents.toString().indexOf("</H2>", classStartIndex);
                if (classStartIndex != -1 && classEndIndex2 != -1) {
                    String classLine = fileContents.toString().substring(classStartIndex, classEndIndex2);
                    String aspectLine = "";
                    aspectLine = br ? aspectLine + "<BR>\nAspect " + classLine.substring(11, classLine.length()) : aspectLine + "<H2>\nAspect " + classLine.substring(11, classLine.length());
                    fileContents.delete(classStartIndex, classEndIndex2);
                    fileContents.insert(classStartIndex, aspectLine);
                }
            }
            int secondClassStartIndex = fileContents.toString().indexOf("class <B>");
            if (secondClassStartIndex != -1) {
                String name = decl.toSignatureString();
                int classEndIndex3 = fileContents.toString().indexOf(name + "</B><DT>");
                if (secondClassStartIndex == -1 || classEndIndex3 == -1) continue;
                StringBuffer sb = new StringBuffer(fileContents.toString().substring(secondClassStartIndex, classEndIndex3));
                sb.replace(0, 5, "aspect");
                fileContents.delete(secondClassStartIndex, classEndIndex3);
                fileContents.insert(secondClassStartIndex, sb.toString());
                continue;
            }
            classStartIndex = fileContents.toString().indexOf("class <span class=\"typeNameLabel\">");
            if (classStartIndex == -1) {
                classStartIndex = fileContents.toString().indexOf("class <span class=\"strong\">");
            }
            if ((classEndIndex = fileContents.toString().indexOf("</span>", classStartIndex)) == -1) continue;
            String classLine = fileContents.toString().substring(classStartIndex, classEndIndex);
            String aspectLine = "aspect" + fileContents.substring(classStartIndex + 5, classEndIndex);
            fileContents.delete(classStartIndex, classEndIndex);
            fileContents.insert(classStartIndex, aspectLine);
        }
        file.delete();
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(fileContents.toString().getBytes());
        reader.close();
        fos.close();
    }

    static void addAspectDocumentation(IProgramElement node, StringBuffer fileBuffer, int index) {
        List advisedBy;
        List annotatedBy;
        List parentsDeclaredOn;
        List fieldsDeclaredOn;
        ArrayList<IProgramElement> pointcuts = new ArrayList<IProgramElement>();
        ArrayList<IProgramElement> advice = new ArrayList<IProgramElement>();
        ArrayList<IProgramElement> declares = new ArrayList<IProgramElement>();
        List methodsDeclaredOn = StructureUtil.getDeclareInterTypeTargets(node, IProgramElement.Kind.INTER_TYPE_METHOD);
        if (methodsDeclaredOn != null && !methodsDeclaredOn.isEmpty()) {
            HtmlDecorator.insertDeclarationsSummary(fileBuffer, methodsDeclaredOn, ITD_METHOD_SUMMARY, index);
        }
        if ((fieldsDeclaredOn = StructureUtil.getDeclareInterTypeTargets(node, IProgramElement.Kind.INTER_TYPE_FIELD)) != null && !fieldsDeclaredOn.isEmpty()) {
            HtmlDecorator.insertDeclarationsSummary(fileBuffer, fieldsDeclaredOn, ITD_FIELD_SUMMARY, index);
        }
        List constDeclaredOn = StructureUtil.getDeclareInterTypeTargets(node, IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR);
        if (fieldsDeclaredOn != null && !constDeclaredOn.isEmpty()) {
            HtmlDecorator.insertDeclarationsSummary(fileBuffer, constDeclaredOn, ITD_CONSTRUCTOR_SUMMARY, index);
        }
        for (IProgramElement member : node.getChildren()) {
            if (member.getKind().equals(IProgramElement.Kind.POINTCUT)) {
                pointcuts.add(member);
                continue;
            }
            if (member.getKind().equals(IProgramElement.Kind.ADVICE)) {
                advice.add(member);
                continue;
            }
            if (!member.getKind().isDeclare() && !member.getKind().isInterTypeMember()) continue;
            declares.add(member);
        }
        if (declares.size() > 0) {
            HtmlDecorator.insertDeclarationsDetails(fileBuffer, declares, DECLARE_DETAIL, index);
            HtmlDecorator.insertDeclarationsSummary(fileBuffer, declares, DECLARE_SUMMARY, index);
        }
        if (pointcuts.size() > 0) {
            HtmlDecorator.insertDeclarationsSummary(fileBuffer, pointcuts, POINTCUT_SUMMARY, index);
            HtmlDecorator.insertDeclarationsDetails(fileBuffer, pointcuts, POINTCUT_DETAIL, index);
        }
        if (advice.size() > 0) {
            HtmlDecorator.insertDeclarationsSummary(fileBuffer, advice, ADVICE_SUMMARY, index);
            HtmlDecorator.insertDeclarationsDetails(fileBuffer, advice, ADVICE_DETAIL, index);
        }
        if ((parentsDeclaredOn = StructureUtil.getDeclareInterTypeTargets(node, IProgramElement.Kind.DECLARE_PARENTS)) != null && parentsDeclaredOn.size() > 0) {
            HtmlDecorator.decorateDocWithRel(node, fileBuffer, index, parentsDeclaredOn, HtmlRelationshipKind.ASPECT_DECLARATIONS);
        }
        if ((annotatedBy = StructureUtil.getTargets(node, IRelationship.Kind.DECLARE_INTER_TYPE, "annotated by")) != null && annotatedBy.size() > 0) {
            HtmlDecorator.decorateDocWithRel(node, fileBuffer, index, annotatedBy, HtmlRelationshipKind.ANNOTATED_BY);
        }
        if ((advisedBy = StructureUtil.getTargets(node, IRelationship.Kind.ADVICE)) != null && advisedBy.size() > 0) {
            HtmlDecorator.decorateDocWithRel(node, fileBuffer, index, advisedBy, HtmlRelationshipKind.ADVISED_BY);
        }
    }

    static void insertDeclarationsSummary(StringBuffer fileBuffer, List decls, String kind, int index) {
        if (!HtmlDecorator.declsAboveVisibilityExist(decls)) {
            return;
        }
        int insertIndex = HtmlDecorator.findSummaryIndex(fileBuffer, index);
        String tableHead = "<!-- ======== " + kind.toUpperCase() + " ======= -->\n\n" + "<TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"1\"" + "CELLSPACING=\"0\"><TR><TD COLSPAN=2 BGCOLOR=\"#CCCCFF\">" + "<FONT SIZE=\"+2\"><B>" + kind + "</B></FONT></TD></TR>\n";
        fileBuffer.insert(insertIndex, tableHead);
        insertIndex += tableHead.length();
        for (int i = 0; i < decls.size(); ++i) {
            IProgramElement decl = (IProgramElement)decls.get(i);
            if (!HtmlDecorator.isAboveVisibility(decl)) continue;
            String comment = HtmlDecorator.generateSummaryComment(decl);
            String entry = "";
            if (kind.equals(ADVICE_SUMMARY)) {
                entry = entry + "<TR><TD><A HREF=\"#" + HtmlDecorator.generateHREFName(decl) + "\">" + "<TT>" + HtmlDecorator.generateSignatures(decl) + "</TT></A><BR>&nbsp;";
                if (!comment.equals("")) {
                    entry = entry + comment + "<P>";
                }
                entry = entry + HtmlDecorator.generateAffects(decl) + "</TD>" + "</TR><TD>\n";
            } else if (kind.equals(POINTCUT_SUMMARY)) {
                entry = entry + "<TR><TD WIDTH=\"1%\"><FONT SIZE=-1><TT>" + HtmlDecorator.genAccessibility(decl) + "</TT></FONT>" + "</TD>\n" + "<TD>" + "<TT><A HREF=\"#" + HtmlDecorator.generateHREFName(decl) + "\">" + decl.toLabelString() + "</A></TT><BR>&nbsp;";
                if (!comment.equals("")) {
                    entry = entry + comment + "<P>";
                }
                entry = entry + "</TR></TD>\n";
            } else if (kind.equals(DECLARE_SUMMARY)) {
                entry = entry + "<TR><TD WIDTH=\"1%\"><FONT SIZE=-1><TT>" + HtmlDecorator.generateModifierInformation(decl, false) + "</TT></FONT>" + "</TD>" + "<TD>" + "<A HREF=\"#" + HtmlDecorator.generateHREFName(decl) + "\">" + "<TT>" + decl.toLabelString() + "</TT></A><P>" + HtmlDecorator.generateAffects(decl);
            } else if (kind.equals(ITD_FIELD_SUMMARY) || kind.equals(ITD_METHOD_SUMMARY)) {
                entry = entry + "<TR><TD WIDTH=\"1%\"><FONT SIZE=-1><TT>" + HtmlDecorator.generateModifierInformation(decl, false) + "</TT></FONT>" + "</TD>" + "<TD>" + "<A HREF=\"#" + HtmlDecorator.generateHREFName(decl) + "\">" + "<TT>" + decl.toLabelString() + "</TT></A><P>" + HtmlDecorator.generateDeclaredBy(decl);
            } else if (kind.equals(ITD_CONSTRUCTOR_SUMMARY)) {
                entry = entry + "<TD><A HREF=\"#" + HtmlDecorator.generateHREFName(decl) + "\">" + "<TT>" + decl.toLabelString() + "</TT></A><P>" + HtmlDecorator.generateDeclaredBy(decl);
            }
            fileBuffer.insert(insertIndex, entry);
            insertIndex += entry.length();
        }
        String tableTail = "</TABLE><P>&nbsp;\n";
        fileBuffer.insert(insertIndex, tableTail);
        insertIndex += tableTail.length();
    }

    private static boolean declsAboveVisibilityExist(List decls) {
        boolean exist = false;
        for (IProgramElement element : decls) {
            if (!HtmlDecorator.isAboveVisibility(element)) continue;
            exist = true;
        }
        return exist;
    }

    private static boolean isAboveVisibility(IProgramElement element) {
        IProgramElement.Accessibility acc = element.getAccessibility();
        if (docVisibilityModifier.equals("private")) {
            return true;
        }
        if (docVisibilityModifier.equals("package")) {
            return acc.equals(IProgramElement.Accessibility.PACKAGE) || acc.equals(IProgramElement.Accessibility.PROTECTED) || acc.equals(IProgramElement.Accessibility.PUBLIC);
        }
        if (docVisibilityModifier.equals("protected")) {
            return acc.equals(IProgramElement.Accessibility.PROTECTED) || acc.equals(IProgramElement.Accessibility.PUBLIC);
        }
        if (docVisibilityModifier.equals("public")) {
            return acc.equals(IProgramElement.Accessibility.PUBLIC);
        }
        return false;
    }

    private static String genAccessibility(IProgramElement decl) {
        if (decl.getAccessibility().equals(IProgramElement.Accessibility.PACKAGE)) {
            return "(package private)";
        }
        return decl.getAccessibility().toString();
    }

    static void insertDeclarationsDetails(StringBuffer fileBuffer, List decls, String kind, int index) {
        if (!HtmlDecorator.declsAboveVisibilityExist(decls)) {
            return;
        }
        int insertIndex = HtmlDecorator.findDetailsIndex(fileBuffer, index);
        String detailsHeading = "<P>&nbsp;\n<!-- ======== " + kind.toUpperCase() + " SUMMARY ======= -->\n\n" + "<TABLE BORDER=\"1\" CELLPADDING=\"3\" CELLSPACING=\"0\" WIDTH=\"100%\">\n" + "<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n" + "<TD COLSPAN=1><FONT SIZE=\"+2\">\n" + "<B>" + kind + "</B></FONT></TD>\n" + "</TR>\n" + "</TABLE>";
        fileBuffer.insert(insertIndex, detailsHeading);
        insertIndex += detailsHeading.length();
        for (int i = 0; i < decls.size(); ++i) {
            IProgramElement decl = (IProgramElement)decls.get(i);
            if (!HtmlDecorator.isAboveVisibility(decl)) continue;
            String entry = "";
            entry = entry + "<A NAME=\"" + HtmlDecorator.generateHREFName(decl) + "\"><!-- --></A>\n";
            if (kind.equals(ADVICE_DETAIL)) {
                entry = entry + "<H3>" + decl.getName() + "</H3><P>";
                entry = entry + "<TT>" + HtmlDecorator.generateSignatures(decl) + "</TT>\n" + "<P>" + HtmlDecorator.generateDetailsComment(decl) + "<P>" + HtmlDecorator.generateAffects(decl);
            } else if (kind.equals(POINTCUT_DETAIL)) {
                entry = entry + "<H3>" + decl.toLabelString() + "</H3><P>" + HtmlDecorator.generateDetailsComment(decl);
            } else if (kind.equals(DECLARE_DETAIL)) {
                entry = entry + "<H3>" + decl.toLabelString() + "</H3><P>" + HtmlDecorator.generateModifierInformation(decl, true);
                if (!decl.getKind().equals(IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR)) {
                    entry = entry + "&nbsp;&nbsp;";
                }
                if (!decl.getKind().isDeclare()) {
                    String sigs = HtmlDecorator.generateSignatures(decl);
                    entry = entry + sigs + "<P>";
                }
                entry = entry + HtmlDecorator.generateAffects(decl) + HtmlDecorator.generateDetailsComment(decl);
            }
            entry = i != decls.size() - 1 ? entry + "<P><HR>\n" : entry + "<P>";
            fileBuffer.insert(insertIndex, entry);
            insertIndex += entry.length();
        }
    }

    static int findSummaryIndex(StringBuffer fileBuffer, int index) {
        int index2;
        String fbs = fileBuffer.toString();
        String MARKER_1 = "<!-- =========== FIELD SUMMARY =========== -->";
        String MARKER_2 = "<!-- ======== CONSTRUCTOR SUMMARY ======== -->";
        int index1 = fbs.indexOf(MARKER_1, index);
        if (index1 < (index2 = fbs.indexOf(MARKER_2, index)) && index1 != -1) {
            return index1;
        }
        if (index2 != -1) {
            return index2;
        }
        return index;
    }

    static int findDetailsIndex(StringBuffer fileBuffer, int index) {
        String fbs = fileBuffer.toString();
        String MARKER_1 = "<!-- ========= CONSTRUCTOR DETAIL ======== -->";
        String MARKER_2 = "<!-- ============ FIELD DETAIL =========== -->";
        String MARKER_3 = "<!-- ============ METHOD DETAIL ========== -->";
        int index1 = fbs.indexOf(MARKER_1, index);
        int index2 = fbs.indexOf(MARKER_2, index);
        int index3 = fbs.indexOf(MARKER_3, index);
        if (index1 != -1 && index1 < index2 && index1 < index3) {
            return index1;
        }
        if (index2 != -1 && index2 < index1 && index2 < index3) {
            return index2;
        }
        if (index3 != -1) {
            return index3;
        }
        return index;
    }

    static void decorateDocWithRel(IProgramElement node, StringBuffer fileContentsBuffer, int index, List targets, HtmlRelationshipKind relKind) {
        if (targets != null && !targets.isEmpty()) {
            String adviceDoc = "<TABLE WIDTH=\"100%\" BGCOLOR=#FFFFFF><TR><TD width=\"15%\" bgcolor=\"#FFD8B0\"><B><FONT COLOR=000000>" + relKind.toString() + "</font></b></td><td>";
            String relativePackagePath = HtmlDecorator.getRelativePathFromHere(node.getPackageName().replace('.', '/') + "/");
            ArrayList<String> addedNames = new ArrayList<String>();
            Iterator it = targets.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                IProgramElement currDecl = null;
                if (o instanceof String) {
                    String currHandle = (String)o;
                    currDecl = node.getModel().getHierarchy().findElementForHandle(currHandle);
                } else if (o instanceof IProgramElement) {
                    currDecl = (IProgramElement)o;
                } else {
                    return;
                }
                String packagePath = "";
                if (currDecl.getPackageName() != null && !currDecl.getPackageName().equals("")) {
                    packagePath = currDecl.getPackageName().replace('.', '/') + "/";
                }
                String hrefName = "";
                String hrefLink = "";
                hrefLink = relativePackagePath + packagePath;
                if (currDecl.getPackageName() != null) {
                    hrefName = currDecl.getPackageName().replace('.', '/');
                }
                ArrayList<String> names = new ArrayList<String>();
                for (IProgramElement parent = currDecl; parent != null && parent.getParent() != null && !parent.getParent().getKind().equals(IProgramElement.Kind.FILE_JAVA) && !parent.getParent().getKind().equals(IProgramElement.Kind.FILE_ASPECTJ); parent = parent.getParent()) {
                    names.add(parent.toLinkLabelString());
                }
                StringBuffer sbuff = new StringBuffer();
                for (int i = names.size() - 1; i >= 0; --i) {
                    String element = (String)names.get(i);
                    if (i == 0) {
                        sbuff.append(element);
                        continue;
                    }
                    sbuff.append(element + ".");
                }
                hrefName = hrefName + "/" + sbuff.toString() + "." + currDecl.toLabelString();
                StringBuffer sb = new StringBuffer(currDecl.toLabelString());
                int nextQuote = sb.toString().indexOf("\"");
                while (nextQuote != -1) {
                    sb.deleteCharAt(nextQuote);
                    sb.insert(nextQuote, "quot;");
                    nextQuote = sb.toString().indexOf("\"");
                }
                hrefLink = hrefLink + sbuff.toString() + ".html" + "#" + sb.toString();
                if (addedNames.contains(hrefName)) continue;
                adviceDoc = adviceDoc + "<A HREF=\"" + hrefLink + "\"><tt>" + hrefName.replace('/', '.') + "</tt></A>";
                if (it.hasNext()) {
                    adviceDoc = adviceDoc + ", ";
                }
                addedNames.add(hrefName);
            }
            adviceDoc = adviceDoc + "</TR></TD></TABLE>\n";
            fileContentsBuffer.insert(index, adviceDoc);
        }
    }

    static void decorateMemberDocumentation(IProgramElement node, StringBuffer fileContentsBuffer, int index) {
        List targets = StructureUtil.getTargets(node, IRelationship.Kind.ADVICE);
        HtmlDecorator.decorateDocWithRel(node, fileContentsBuffer, index, targets, HtmlRelationshipKind.ADVISED_BY);
        List warnings = StructureUtil.getTargets(node, IRelationship.Kind.DECLARE, "matches declare");
        HtmlDecorator.decorateDocWithRel(node, fileContentsBuffer, index, warnings, HtmlRelationshipKind.MATCHES_DECLARE);
        List softenedBy = StructureUtil.getTargets(node, IRelationship.Kind.DECLARE, "softened by");
        HtmlDecorator.decorateDocWithRel(node, fileContentsBuffer, index, softenedBy, HtmlRelationshipKind.SOFTENED_BY);
        List annotatedBy = StructureUtil.getTargets(node, IRelationship.Kind.DECLARE_INTER_TYPE, "annotated by");
        HtmlDecorator.decorateDocWithRel(node, fileContentsBuffer, index, annotatedBy, HtmlRelationshipKind.ANNOTATED_BY);
    }

    static String generateDeclaredBy(IProgramElement decl) {
        String entry = "<TABLE WIDTH=\"100%\" BGCOLOR=#FFFFFF><TR><TD width=\"10%\" bgcolor=\"#FFD8B0\"><B><FONT COLOR=000000>&nbsp;Declared&nbsp;by:</b></font></td><td>";
        String relativePackagePath = HtmlDecorator.getRelativePathFromHere(decl.getPackageName().replace('.', '/') + "/");
        if (decl != null && !StructureUtil.isAnonymous(decl.getParent())) {
            String packagePath = "";
            if (decl.getPackageName() != null && !decl.getPackageName().equals("")) {
                packagePath = decl.getPackageName().replace('.', '/') + "/";
            }
            String typeSignature = HtmlDecorator.constructNestedTypeName(decl);
            String hrefName = packagePath + typeSignature;
            String hrefLink = relativePackagePath + packagePath + typeSignature + ".html";
            entry = entry + "<A HREF=\"" + hrefLink + "\"><tt>" + hrefName.replace('/', '.') + "</tt></A>";
        }
        entry = entry + "</B></FONT></TD></TR></TABLE>\n</TR></TD>\n";
        return entry;
    }

    static String generateAffects(IProgramElement decl) {
        List targets = null;
        targets = decl.getKind().isDeclare() || decl.getKind().isInterTypeMember() ? StructureUtil.getDeclareTargets(decl) : StructureUtil.getTargets(decl, IRelationship.Kind.ADVICE);
        if (targets == null) {
            return "";
        }
        String entry = "<TABLE WIDTH=\"100%\" BGCOLOR=#FFFFFF><TR>";
        IProgramElement.Kind kind = decl.getKind();
        entry = kind.equals(IProgramElement.Kind.ADVICE) ? entry + "<TD width=\"10%\" bgcolor=\"#FFD8B0\"><B><FONT COLOR=000000>" + HtmlRelationshipKind.ADVISES.toString() + "</b></font></td><td>" : (kind.equals(IProgramElement.Kind.DECLARE_WARNING) || kind.equals(IProgramElement.Kind.DECLARE_ERROR) ? entry + "<TD width=\"10%\" bgcolor=\"#FFD8B0\"><B><FONT COLOR=000000>" + HtmlRelationshipKind.MATCHED_BY.toString() + "</b></font></td><td>" : (kind.isDeclareAnnotation() ? entry + "<TD width=\"10%\" bgcolor=\"#FFD8B0\"><B><FONT COLOR=000000>" + HtmlRelationshipKind.ANNOTATES.toString() + "</b></font></td><td>" : (kind.equals(IProgramElement.Kind.DECLARE_SOFT) ? entry + "<TD width=\"10%\" bgcolor=\"#FFD8B0\"><B><FONT COLOR=000000>" + HtmlRelationshipKind.SOFTENS.toString() + "</b></font></td><td>" : entry + "<TD width=\"10%\" bgcolor=\"#FFD8B0\"><B><FONT COLOR=000000>" + HtmlRelationshipKind.DECLARED_ON.toString() + "</b></font></td><td>")));
        String relativePackagePath = HtmlDecorator.getRelativePathFromHere(decl.getPackageName().replace('.', '/') + "/");
        ArrayList<String> addedNames = new ArrayList<String>();
        Iterator it = targets.iterator();
        while (it.hasNext()) {
            String currHandle = (String)it.next();
            IProgramElement currDecl = decl.getModel().getHierarchy().findElementForHandle(currHandle);
            if (currDecl.getKind().equals(IProgramElement.Kind.CODE)) {
                currDecl = currDecl.getParent();
            }
            if (currDecl == null || StructureUtil.isAnonymous(currDecl.getParent())) continue;
            String packagePath = "";
            if (currDecl.getPackageName() != null && !currDecl.getPackageName().equals("")) {
                packagePath = currDecl.getPackageName().replace('.', '/') + "/";
            }
            String typeSignature = HtmlDecorator.constructNestedTypeName(currDecl);
            String hrefName = packagePath + typeSignature;
            String hrefLink = relativePackagePath + packagePath + typeSignature + ".html";
            if (!currDecl.getKind().isType()) {
                hrefName = hrefName + '.' + currDecl.getName();
                hrefLink = hrefLink + "#" + currDecl.toLabelString();
            }
            if (addedNames.contains(hrefName)) continue;
            entry = entry + "<A HREF=\"" + hrefLink + "\"><tt>" + hrefName.replace('/', '.') + "</tt></A>";
            if (it.hasNext()) {
                entry = entry + ", ";
            }
            addedNames.add(hrefName);
        }
        entry = entry + "</B></FONT></TD></TR></TABLE>\n</TR></TD>\n";
        return entry;
    }

    private static String getRelativePathFromHere(String packagePath) {
        StringBuffer result = new StringBuffer("");
        if (packagePath != null && packagePath.indexOf("/") != -1) {
            StringTokenizer sTok = new StringTokenizer(packagePath, "/", false);
            while (sTok.hasMoreTokens()) {
                sTok.nextToken();
                result.append("../");
            }
        }
        return result.toString();
    }

    private static String generateModifierInformation(IProgramElement decl, boolean isDetails) {
        String intro = "";
        if (decl.getKind().isDeclare()) {
            return intro + "</TT>";
        }
        if (isDetails || !decl.getAccessibility().equals(IProgramElement.Accessibility.PUBLIC)) {
            intro = intro + "<TT>" + decl.getAccessibility().toString() + "&nbsp;";
        }
        if (decl.getKind().equals(IProgramElement.Kind.INTER_TYPE_FIELD)) {
            return intro + decl.getCorrespondingType() + "</TT>";
        }
        if (decl.getKind().equals(IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR) && isDetails) {
            return intro + "</TT>";
        }
        return intro + decl.getCorrespondingType(true) + "</TT>";
    }

    static String generateIntroductionSignatures(IProgramElement decl, boolean isDetails) {
        return "<not implemented>";
    }

    static String generateSignatures(IProgramElement decl) {
        return "<B>" + decl.toLabelString() + "</B>";
    }

    static String generateSummaryComment(IProgramElement decl) {
        String COMMENT_INDENT = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        String formattedComment = HtmlDecorator.getFormattedComment(decl);
        int periodIndex = formattedComment.indexOf(46);
        if (formattedComment.equals("")) {
            return "";
        }
        if (periodIndex != -1) {
            return COMMENT_INDENT + formattedComment.substring(0, periodIndex + 1);
        }
        return COMMENT_INDENT + formattedComment;
    }

    static String generateDetailsComment(IProgramElement decl) {
        return HtmlDecorator.getFormattedComment(decl);
    }

    static String generateHREFName(IProgramElement decl) {
        StringBuffer hrefLinkBuffer = new StringBuffer();
        char[] declChars = decl.toLabelString().toCharArray();
        for (int i = 0; i < declChars.length; ++i) {
            if (declChars[i] == '\"') {
                hrefLinkBuffer.append("quot;");
                continue;
            }
            hrefLinkBuffer.append(declChars[i]);
        }
        return hrefLinkBuffer.toString();
    }

    static String generateAffectsHREFLink(String declaringType) {
        String link = rootDir.getAbsolutePath() + "/" + declaringType + ".html";
        return link;
    }

    static String getFormattedComment(IProgramElement decl) {
        String comment = decl.getFormalComment();
        if (comment == null) {
            return "";
        }
        String formattedComment = "";
        int startIndex = comment.indexOf("/**");
        int endIndex = comment.indexOf("*/");
        startIndex = startIndex == -1 ? 0 : (startIndex += 3);
        if (endIndex == -1) {
            endIndex = comment.length();
        }
        comment = comment.substring(startIndex, endIndex);
        BufferedReader reader = new BufferedReader(new StringReader(comment));
        try {
            String line = reader.readLine();
            while (line != null) {
                line = line.trim();
                for (int i = 0; i < line.length() && line.charAt(0) == '*'; ++i) {
                    line = line.substring(1, line.length());
                }
                formattedComment = formattedComment + line;
                line = reader.readLine();
            }
        }
        catch (IOException ioe) {
            throw new Error("Couldn't format comment for declaration: " + decl.getName());
        }
        return formattedComment;
    }

    public static IProgramElement[] getProgramElements(AsmManager model, String filename) {
        IProgramElement file = model.getHierarchy().findElementForSourceFile(filename);
        final ArrayList nodes = new ArrayList();
        HierarchyWalker walker = new HierarchyWalker(){

            public void preProcess(IProgramElement node) {
                IProgramElement p = node;
                if (HtmlDecorator.accept(node)) {
                    nodes.add(p);
                }
            }
        };
        file.walk(walker);
        return nodes.toArray(new IProgramElement[nodes.size()]);
    }

    private static boolean accept(IProgramElement node) {
        if (node.getKind().isType()) {
            boolean isAnonymous = StructureUtil.isAnonymous(node);
            return !node.getParent().getKind().equals(IProgramElement.Kind.METHOD) && !isAnonymous;
        }
        return !node.getKind().equals(IProgramElement.Kind.IMPORT_REFERENCE);
    }

    public static class HtmlRelationshipKind
    extends TypeSafeEnum {
        public static final HtmlRelationshipKind ADVISES = new HtmlRelationshipKind("&nbsp;Advises:", 1);
        public static final HtmlRelationshipKind ADVISED_BY = new HtmlRelationshipKind("&nbsp;Advised&nbsp;by:", 2);
        public static final HtmlRelationshipKind MATCHED_BY = new HtmlRelationshipKind("&nbsp;Matched&nbsp;by:", 3);
        public static final HtmlRelationshipKind MATCHES_DECLARE = new HtmlRelationshipKind("&nbsp;Matches&nbsp;declare:", 4);
        public static final HtmlRelationshipKind DECLARED_ON = new HtmlRelationshipKind("&nbsp;Declared&nbsp;on:", 5);
        public static final HtmlRelationshipKind ASPECT_DECLARATIONS = new HtmlRelationshipKind("&nbsp;Aspect&nbsp;declarations:", 6);
        public static final HtmlRelationshipKind SOFTENS = new HtmlRelationshipKind("&nbsp;Softens:", 7);
        public static final HtmlRelationshipKind SOFTENED_BY = new HtmlRelationshipKind("&nbsp;Softened&nbsp;by:", 8);
        public static final HtmlRelationshipKind ANNOTATES = new HtmlRelationshipKind("&nbsp;Annotates:", 9);
        public static final HtmlRelationshipKind ANNOTATED_BY = new HtmlRelationshipKind("&nbsp;Annotated&nbsp;by:", 10);
        public static final HtmlRelationshipKind USES_POINTCUT = new HtmlRelationshipKind("&nbsp;Uses&nbsp;pointcut:", 11);
        public static final HtmlRelationshipKind POINTCUT_USED_BY = new HtmlRelationshipKind("&nbsp;Pointcut&nbsp;used&nbsp;by:", 12);

        public HtmlRelationshipKind(String name, int key) {
            super(name, key);
        }

        public static HtmlRelationshipKind read(DataInputStream s) throws IOException {
            byte key = s.readByte();
            switch (key) {
                case 1: {
                    return ADVISES;
                }
                case 2: {
                    return ADVISED_BY;
                }
                case 3: {
                    return MATCHED_BY;
                }
                case 4: {
                    return MATCHES_DECLARE;
                }
                case 5: {
                    return DECLARED_ON;
                }
                case 6: {
                    return ASPECT_DECLARATIONS;
                }
                case 7: {
                    return SOFTENS;
                }
                case 8: {
                    return SOFTENED_BY;
                }
                case 9: {
                    return ANNOTATES;
                }
                case 10: {
                    return ANNOTATED_BY;
                }
                case 11: {
                    return USES_POINTCUT;
                }
                case 12: {
                    return POINTCUT_USED_BY;
                }
            }
            throw new Error("weird relationship kind " + key);
        }
    }
}

