/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import org.aspectj.ajdt.internal.compiler.ast.InterSuperReference;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeDeclaration;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseSourceLocation;
import org.aspectj.bridge.IMessage;
import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class InterSuperFixerVisitor
extends ASTVisitor {
    InterTypeDeclaration dec;
    ReferenceBinding onType;
    TypeBinding superType;
    private int depthCounter = 0;
    EclipseFactory world;

    public InterSuperFixerVisitor(InterTypeDeclaration dec, EclipseFactory world, Scope scope) {
        this.dec = dec;
        this.onType = dec.onTypeBinding;
        this.world = world;
        this.superType = this.onType.isInterface() && this.onType.superInterfaces().length == 1 ? this.onType.superInterfaces()[0] : (this.onType.superclass() != null ? this.onType.superclass() : (this.onType.superInterfaces() == null || this.onType.superInterfaces().length == 0 ? scope.getJavaLangObject() : (this.onType.superInterfaces().length == 1 ? this.onType.superInterfaces()[0] : null)));
    }

    public void endVisit(FieldReference ref, BlockScope scope) {
        ref.receiver = this.fixReceiver(ref.receiver, scope);
    }

    public void endVisit(MessageSend send, BlockScope scope) {
        send.receiver = this.fixReceiver(send.receiver, scope);
    }

    public boolean visit(TypeDeclaration localTypeDeclaration, BlockScope scope) {
        ++this.depthCounter;
        return super.visit(localTypeDeclaration, scope);
    }

    public void endVisit(TypeDeclaration localTypeDeclaration, BlockScope scope) {
        --this.depthCounter;
    }

    private Expression fixReceiver(Expression expression, BlockScope scope) {
        if (this.depthCounter != 0) {
            return expression;
        }
        if (expression instanceof SuperReference) {
            SuperReference superRef = (SuperReference)expression;
            if (this.superType == null) {
                EclipseSourceLocation location = new EclipseSourceLocation(scope.problemReporter().referenceContext.compilationResult(), expression.sourceStart, expression.sourceEnd);
                this.world.showMessage(IMessage.ERROR, "multiple supertypes for this interface", location, null);
                this.dec.ignoreFurtherInvestigation = true;
            }
            expression = new InterSuperReference(superRef, this.superType);
        }
        return expression;
    }
}

