/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor.quickfix;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Comparator;
import org.aspectj.ajde.core.AjCompiler;
import org.aspectj.ajde.core.IOutputLocationManager;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.IFieldInfo;
import org.eclipse.jdt.core.util.IInnerClassesAttribute;
import org.eclipse.jdt.core.util.IInnerClassesAttributeEntry;
import org.eclipse.jdt.core.util.IMethodInfo;
import org.eclipse.jdt.internal.corext.fix.AbstractSerialVersionOperation;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public final class AJSerialVersionHashOperation
extends AbstractSerialVersionOperation {
    private static final String STATIC_CLASS_INITIALIZER = "<clinit>";
    private final ICompilationUnit fCompilationUnit;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    public static Long calculateSerialVersionId(ITypeBinding typeBinding, IProgressMonitor monitor) throws CoreException, IOException {
        try {
            IFile classfileResource = AJSerialVersionHashOperation.getClassfile(typeBinding);
            if (classfileResource == null) {
                return null;
            }
            try (InputStream contents = classfileResource.getContents();){
                IClassFileReader cfReader = ToolFactory.createDefaultClassFileReader((InputStream)contents, (int)65535);
                if (cfReader != null) {
                    Long l = AJSerialVersionHashOperation.calculateSerialVersionId(cfReader);
                    return l;
                }
            }
            {
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static String getClassName(char[] name) {
        return new String(name).replace('/', '.');
    }

    private static Long calculateSerialVersionId(IClassFileReader cfReader) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream doos = new DataOutputStream(os);
        doos.writeUTF(AJSerialVersionHashOperation.getClassName(cfReader.getClassName()));
        int mod = AJSerialVersionHashOperation.getClassModifiers(cfReader);
        int classModifiers = mod & 0x611;
        doos.writeInt(classModifiers);
        char[][] interfaces = AJSerialVersionHashOperation.getSortedInterfacesNames(cfReader);
        int i = 0;
        while (i < interfaces.length) {
            doos.writeUTF(AJSerialVersionHashOperation.getClassName(interfaces[i]));
            ++i;
        }
        IFieldInfo[] sortedFields = AJSerialVersionHashOperation.getSortedFields(cfReader);
        int i2 = 0;
        while (i2 < sortedFields.length) {
            IFieldInfo curr = sortedFields[i2];
            int flags = curr.getAccessFlags();
            if (!Flags.isPrivate((int)flags) || !Flags.isStatic((int)flags) && !Flags.isTransient((int)flags)) {
                doos.writeUTF(new String(curr.getName()));
                doos.writeInt(flags & 0xDF);
                doos.writeUTF(new String(curr.getDescriptor()));
            }
            ++i2;
        }
        if (AJSerialVersionHashOperation.hasStaticClassInitializer(cfReader)) {
            doos.writeUTF(STATIC_CLASS_INITIALIZER);
            doos.writeInt(8);
            doos.writeUTF("()V");
        }
        IMethodInfo[] sortedMethods = AJSerialVersionHashOperation.getSortedMethods(cfReader);
        int i3 = 0;
        while (i3 < sortedMethods.length) {
            IMethodInfo curr = sortedMethods[i3];
            int flags = curr.getAccessFlags();
            if (!Flags.isPrivate((int)flags) && !curr.isClinit()) {
                doos.writeUTF(new String(curr.getName()));
                doos.writeInt(flags & 0xD3F);
                doos.writeUTF(AJSerialVersionHashOperation.getClassName(curr.getDescriptor()));
            }
            ++i3;
        }
        doos.flush();
        return AJSerialVersionHashOperation.computeHash(os.toByteArray());
    }

    private static int getClassModifiers(IClassFileReader cfReader) {
        IInnerClassesAttribute innerClassesAttribute = cfReader.getInnerClassesAttribute();
        if (innerClassesAttribute != null) {
            IInnerClassesAttributeEntry[] entries = innerClassesAttribute.getInnerClassAttributesEntries();
            int i = 0;
            while (i < entries.length) {
                IInnerClassesAttributeEntry entry = entries[i];
                char[] innerClassName = entry.getInnerClassName();
                if (innerClassName != null && CharOperation.equals((char[])cfReader.getClassName(), (char[])innerClassName)) {
                    return entry.getAccessFlags();
                }
                ++i;
            }
        }
        return cfReader.getAccessFlags();
    }

    private static Long computeHash(byte[] bytes) {
        try {
            byte[] sha = MessageDigest.getInstance("SHA-1").digest(bytes);
            if (sha.length >= 8) {
                long hash = 0L;
                int i = 7;
                while (i >= 0) {
                    hash = hash << 8 | (long)(sha[i] & 0xFF);
                    --i;
                }
                return new Long(hash);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(noSuchAlgorithmException, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            NoSuchAlgorithmException e = noSuchAlgorithmException;
            JavaPlugin.log((Throwable)e);
        }
        return null;
    }

    private static char[][] getSortedInterfacesNames(IClassFileReader cfReader) {
        char[][] interfaceNames = cfReader.getInterfaceNames();
        Arrays.sort(interfaceNames, new Comparator(){

            public int compare(Object o1, Object o2) {
                return CharOperation.compareTo((char[])((char[])o1), (char[])((char[])o2));
            }
        });
        return interfaceNames;
    }

    private static IFieldInfo[] getSortedFields(IClassFileReader cfReader) {
        IFieldInfo[] allFields = cfReader.getFieldInfos();
        Arrays.sort(allFields, new Comparator(){

            public int compare(Object o1, Object o2) {
                return CharOperation.compareTo((char[])((IFieldInfo)o1).getName(), (char[])((IFieldInfo)o2).getName());
            }
        });
        return allFields;
    }

    private static boolean hasStaticClassInitializer(IClassFileReader cfReader) {
        IMethodInfo[] methodInfos = cfReader.getMethodInfos();
        int i = 0;
        while (i < methodInfos.length) {
            if (methodInfos[i].isClinit()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static IMethodInfo[] getSortedMethods(IClassFileReader cfReader) {
        IMethodInfo[] allMethods = cfReader.getMethodInfos();
        Arrays.sort(allMethods, new Comparator(){

            public int compare(Object o1, Object o2) {
                IMethodInfo mi1 = (IMethodInfo)o1;
                IMethodInfo mi2 = (IMethodInfo)o2;
                if (mi1.isConstructor() != mi2.isConstructor()) {
                    return mi1.isConstructor() ? -1 : 1;
                }
                if (mi1.isConstructor()) {
                    return 0;
                }
                int res = CharOperation.compareTo((char[])mi1.getName(), (char[])mi2.getName());
                if (res != 0) {
                    return res;
                }
                return CharOperation.compareTo((char[])mi1.getDescriptor(), (char[])mi2.getDescriptor());
            }
        });
        return allMethods;
    }

    private static IFile getClassfile(ITypeBinding typeBinding) throws CoreException {
        IFolder outFolder;
        IType type = (IType)typeBinding.getJavaElement();
        IProject project = typeBinding.getJavaElement().getJavaProject().getProject();
        AjCompiler compiler = AspectJPlugin.getDefault().getCompilerFactory().getCompilerForProject(project);
        IOutputLocationManager manager = compiler.getCompilerConfiguration().getOutputLocationManager();
        if (!(manager instanceof CoreOutputLocationManager)) {
            return null;
        }
        CoreOutputLocationManager coreManager = (CoreOutputLocationManager)manager;
        ICompilationUnit cu = type.getCompilationUnit();
        File file = new File(cu.getResource().getLocation().toOSString());
        File outLocation = coreManager.getOutputLocationForResource(file);
        Path outPath = new Path(outLocation.getPath());
        IPath projPath = project.getLocation();
        if (projPath.isPrefixOf((IPath)outPath)) {
            outPath = outPath.removeFirstSegments(projPath.segmentCount());
        }
        if (!(outFolder = project.getFolder((IPath)outPath)).exists()) {
            return null;
        }
        IPackageFragment frag = type.getPackageFragment();
        String packageName = frag.getElementName();
        Path packagePath = new Path(packageName.replace('.', '/'));
        IFolder packageFolder = outFolder.getFolder((IPath)packagePath);
        if (!packageFolder.exists()) {
            return null;
        }
        StringBuffer binaryName = new StringBuffer();
        IJavaElement enclosing = type.getParent();
        while (enclosing != null && !(enclosing instanceof ICompilationUnit)) {
            binaryName.append(String.valueOf(enclosing.getElementName()) + "$");
            enclosing = enclosing.getParent();
        }
        binaryName.append(String.valueOf(type.getElementName()) + ".class");
        IFile classFile = packageFolder.getFile((IPath)new Path(binaryName.toString()));
        if (classFile.exists()) {
            return classFile;
        }
        return null;
    }

    private static void displayErrorMessage(final String message) {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public final void run() {
                    Shell shell;
                    if (!display.isDisposed() && (shell = display.getActiveShell()) != null && !shell.isDisposed()) {
                        MessageDialog.openError((Shell)shell, (String)CorrectionMessages.SerialVersionHashOperation_dialog_error_caption, (String)Messages.format((String)CorrectionMessages.SerialVersionHashOperation_dialog_error_message, (Object)message));
                    }
                }
            });
        }
    }

    private static void displayErrorMessage(Throwable throwable) {
        AJSerialVersionHashOperation.displayErrorMessage(throwable.getLocalizedMessage());
    }

    private static boolean displayYesNoMessage(final String title, final String message) {
        final boolean[] result = new boolean[]{true};
        final Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.syncExec(new Runnable(){

                @Override
                public final void run() {
                    Shell shell;
                    if (!display.isDisposed() && (shell = display.getActiveShell()) != null && !shell.isDisposed()) {
                        result[0] = MessageDialog.openQuestion((Shell)shell, (String)title, (String)message);
                    }
                }
            });
        }
        return result[0];
    }

    public AJSerialVersionHashOperation(ICompilationUnit unit, ASTNode[] nodes) {
        super(unit, nodes);
        this.fCompilationUnit = unit;
    }

    protected boolean addInitializer(final VariableDeclarationFragment fragment, final ASTNode declarationNode) {
        Assert.isNotNull((Object)fragment);
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public final void run(IProgressMonitor monitor) throws InterruptedException {
                    Assert.isNotNull((Object)monitor);
                    String id = AJSerialVersionHashOperation.this.computeId(declarationNode, monitor);
                    fragment.setInitializer((Expression)fragment.getAST().newNumberLiteral(id));
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(invocationTargetException, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
            InvocationTargetException exception = invocationTargetException;
            JavaPlugin.log((Throwable)exception);
        }
        catch (InterruptedException interruptedException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(interruptedException, (Object)this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_3);
        }
        return true;
    }

    protected void addLinkedPositions(ASTRewrite rewrite, VariableDeclarationFragment fragment, LinkedProposalModel positionGroups) {
    }

    private String computeId(ASTNode declarationNode, IProgressMonitor monitor) throws InterruptedException {
        long serialVersionID;
        block17: {
            Assert.isNotNull((Object)monitor);
            serialVersionID = 1L;
            try {
                Long id;
                monitor.beginTask(CorrectionMessages.SerialVersionHashOperation_computing_id, 200);
                IJavaProject project = this.fCompilationUnit.getJavaProject();
                IPath path = this.fCompilationUnit.getResource().getFullPath();
                ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
                try {
                    bufferManager.connect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    ITextFileBuffer buffer = bufferManager.getTextFileBuffer(path, LocationKind.IFILE);
                    if (buffer.isDirty() && buffer.isStateValidated() && buffer.isCommitable() && AJSerialVersionHashOperation.displayYesNoMessage(CorrectionMessages.SerialVersionHashOperation_save_caption, CorrectionMessages.SerialVersionHashOperation_save_message)) {
                        buffer.commit((IProgressMonitor)new SubProgressMonitor(monitor, 20), true);
                    } else {
                        monitor.worked(20);
                    }
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
                finally {
                    bufferManager.disconnect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                }
                project.getProject().build(10, (IProgressMonitor)new SubProgressMonitor(monitor, 60));
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ITypeBinding typeBinding = AJSerialVersionHashOperation.getTypeBinding(declarationNode);
                if (typeBinding != null && (id = AJSerialVersionHashOperation.calculateSerialVersionId(typeBinding, (IProgressMonitor)new SubProgressMonitor(monitor, 100))) != null) {
                    serialVersionID = id;
                }
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_5, (JoinPoint.StaticPart)ajc$tjp_6);
                CoreException exception = coreException;
                AJSerialVersionHashOperation.displayErrorMessage(exception);
                monitor.done();
                break block17;
            }
            catch (IOException iOException) {
                try {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(iOException, (Object)this, ajc$tjp_7, (JoinPoint.StaticPart)ajc$tjp_6);
                    IOException exception = iOException;
                    AJSerialVersionHashOperation.displayErrorMessage(exception);
                    break block17;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    monitor.done();
                }
            }
            monitor.done();
        }
        return String.valueOf(serialVersionID) + "L";
    }

    private static ITypeBinding getTypeBinding(ASTNode parent) {
        if (parent instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)parent;
            return declaration.resolveBinding();
        }
        if (parent instanceof AnonymousClassDeclaration) {
            AnonymousClassDeclaration declaration = (AnonymousClassDeclaration)parent;
            return declaration.resolveBinding();
        }
        if (parent instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)parent;
            return type.resolveBinding();
        }
        return null;
    }

    static {
        AJSerialVersionHashOperation.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AJSerialVersionHashOperation.java", AJSerialVersionHashOperation.class);
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.quickfix.AJSerialVersionHashOperation", "java.security.NoSuchAlgorithmException", "e"), 185);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("a", "computeHash", "org.eclipse.ajdt.internal.ui.editor.quickfix.AJSerialVersionHashOperation", "[B", "bytes", "", "java.lang.Long"), 175);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.quickfix.AJSerialVersionHashOperation", "java.lang.reflect.InvocationTargetException", "exception"), 389);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("4", "addInitializer", "org.eclipse.ajdt.internal.ui.editor.quickfix.AJSerialVersionHashOperation", "org.eclipse.jdt.core.dom.VariableDeclarationFragment:org.eclipse.jdt.core.dom.ASTNode", "fragment:declarationNode", "", "boolean"), 378);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.quickfix.AJSerialVersionHashOperation", "java.lang.InterruptedException", "<missing>"), 391);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.quickfix.AJSerialVersionHashOperation", "org.eclipse.core.runtime.CoreException", "exception"), 438);
        ajc$tjp_6 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "computeId", "org.eclipse.ajdt.internal.ui.editor.quickfix.AJSerialVersionHashOperation", "org.eclipse.jdt.core.dom.ASTNode:org.eclipse.core.runtime.IProgressMonitor", "declarationNode:monitor", "java.lang.InterruptedException", "java.lang.String"), 404);
        ajc$tjp_7 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.quickfix.AJSerialVersionHashOperation", "java.io.IOException", "exception"), 440);
    }
}

