/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor.quickfix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.internal.ui.editor.AspectJEditor;
import org.eclipse.ajdt.internal.ui.editor.quickfix.AspectsProcessor;
import org.eclipse.ajdt.internal.ui.editor.quickfix.QuickFixProcessor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickAssistProcessor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class AJQuickFixProcessor
extends QuickFixProcessor
implements IQuickAssistProcessor {
    public boolean hasCorrections(ICompilationUnit cu, int problemId) {
        switch (problemId) {
            case 0x1000002: 
            case 33554502: 
            case 0x4000064: 
            case 268435846: 
            case 0x600000CC: {
                return true;
            }
        }
        return false;
    }

    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        if (locations == null || locations.length == 0) {
            return null;
        }
        IProject project = context.getCompilationUnit().getJavaProject().getProject();
        if (AspectJPlugin.isAJProject((IProject)project)) {
            IEditorPart ed = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (ed instanceof AspectJEditor) {
                return null;
            }
        } else {
            boolean relevantError = false;
            int i = 0;
            while (i < locations.length && !relevantError) {
                int problemId = locations[i].getProblemId();
                switch (problemId) {
                    case 0x600000CC: {
                        String[] args = locations[i].getProblemArguments();
                        if (args[0].equals("aspect")) {
                            relevantError = true;
                            break;
                        }
                        relevantError = false;
                    }
                    default: {
                        relevantError = false;
                    }
                }
                ++i;
            }
            if (!relevantError) {
                return null;
            }
        }
        HashSet<Integer> handledProblems = new HashSet<Integer>(locations.length);
        ArrayList resultingCollections = new ArrayList();
        int i = 0;
        while (i < locations.length) {
            IProblemLocation curr = locations[i];
            Integer id = new Integer(curr.getProblemId());
            if (handledProblems.add(id)) {
                this.process(context, curr, resultingCollections);
            }
            ++i;
        }
        return resultingCollections.toArray(new IJavaCompletionProposal[resultingCollections.size()]);
    }

    private void process(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        int id = problem.getProblemId();
        if (id == 0) {
            return;
        }
        switch (id) {
            case 0x1000002: 
            case 33554502: 
            case 0x4000064: 
            case 268435846: {
                AspectsProcessor.switchToAJEditorProposal(context, problem, proposals);
                break;
            }
            case 0x600000CC: {
                IProject project = context.getCompilationUnit().getJavaProject().getProject();
                if (AspectJPlugin.isAJProject((IProject)project)) {
                    AspectsProcessor.switchToAJEditorProposal(context, problem, proposals);
                    break;
                }
                AspectsProcessor.convertToAJProjectProposal(context, problem, proposals);
            }
        }
    }

    public IJavaCompletionProposal[] getAssists(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        return this.getCorrections(context, locations);
    }

    public boolean hasAssists(IInvocationContext context) throws CoreException {
        IProblem[] problems = context.getASTRoot().getProblems();
        int i = 0;
        while (i < problems.length) {
            if (this.hasCorrections(context.getCompilationUnit(), problems[i].getID())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

