/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.markers;

import java.io.File;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.CoreUtils;
import org.eclipse.ajdt.internal.ui.markers.DeleteAndUpdateAJMarkersJob;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class DeleteAJMarkers {
    private IProject project;
    private final IFile[] sourceFiles;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    public DeleteAJMarkers(IProject project) {
        this.project = project;
        this.sourceFiles = null;
    }

    public DeleteAJMarkers(IProject project, File[] sourceFiles) {
        this.project = project;
        this.sourceFiles = DeleteAndUpdateAJMarkersJob.javaFileToIFile(sourceFiles);
    }

    public DeleteAJMarkers(IProject project, IFile[] sourceFiles) {
        this.project = project;
        this.sourceFiles = sourceFiles;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            AJLog.logStart((String)("Delete markers: " + this.project.getName()));
            if (this.sourceFiles != null) {
                this.deleteMarkersForFiles(monitor);
            } else {
                this.deleteAllMarkers(monitor);
            }
            AJLog.logEnd((int)2, (String)("Delete markers: " + this.project.getName()), (String)("Finished deleting markers for " + this.project.getName()));
            return Status.OK_STATUS;
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            CoreException e = coreException;
            return new Status(4, "org.eclipse.ajdt.ui", "Error while deleting markers from project " + this.project.getName(), (Throwable)e);
        }
    }

    public void deleteAllMarkers(IProgressMonitor monitor) throws CoreException {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 4);
        try {
            subMonitor.subTask("Delete advises markers");
            this.project.deleteMarkers("org.eclipse.ajdt.ui.advicemarker", true, 2);
        }
        catch (ResourceException resourceException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(resourceException, this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
        }
        subMonitor.worked(1);
        if (subMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            subMonitor.subTask("Delete advice markers");
            this.project.deleteMarkers("org.eclipse.ajdt.ui.sourceadvicemarker", true, 2);
        }
        catch (ResourceException resourceException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(resourceException, this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_3);
        }
        subMonitor.worked(1);
        if (subMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            subMonitor.subTask("Delete declare markers");
            this.project.deleteMarkers("org.eclipse.ajdt.ui.declarationmarker", true, 2);
        }
        catch (ResourceException resourceException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(resourceException, this, ajc$tjp_5, (JoinPoint.StaticPart)ajc$tjp_3);
        }
        subMonitor.worked(1);
        if (subMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            subMonitor.subTask("Delete custom markers");
            this.project.deleteMarkers("org.eclipse.ajdt.ui.customadvicemarker", true, 2);
        }
        catch (ResourceException resourceException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(resourceException, this, ajc$tjp_6, (JoinPoint.StaticPart)ajc$tjp_3);
        }
        subMonitor.worked(1);
        if (subMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        subMonitor.done();
    }

    private void deleteMarkersForFiles(IProgressMonitor monitor) throws CoreException {
        ResourcesPlugin.getWorkspace();
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, this.sourceFiles.length * 4);
        int i = 0;
        while (i < this.sourceFiles.length) {
            IFile file = this.sourceFiles[i];
            if (file.exists() && CoreUtils.ASPECTJ_SOURCE_FILTER.accept(file.getName())) {
                subMonitor.subTask("Delete markers for " + file.getName());
                file.deleteMarkers("org.eclipse.ajdt.ui.advicemarker", true, 2);
                subMonitor.worked(1);
                if (subMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                file.deleteMarkers("org.eclipse.ajdt.ui.sourceadvicemarker", true, 2);
                subMonitor.worked(1);
                if (subMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                file.deleteMarkers("org.eclipse.ajdt.ui.declarationmarker", true, 2);
                subMonitor.worked(1);
                if (subMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                file.deleteMarkers("org.eclipse.ajdt.ui.customadvicemarker", true, 2);
                subMonitor.worked(1);
                if (subMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }
            ++i;
        }
        subMonitor.done();
    }

    boolean deletionForProject(IProject otherProject) {
        return this.project.equals((Object)otherProject);
    }

    static {
        DeleteAJMarkers.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DeleteAJMarkers.java", DeleteAJMarkers.class);
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.markers.DeleteAJMarkers", "org.eclipse.core.runtime.CoreException", "e"), 55);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("4", "run", "org.eclipse.ajdt.internal.ui.markers.DeleteAJMarkers", "org.eclipse.core.runtime.IProgressMonitor", "monitor", "", "org.eclipse.core.runtime.IStatus"), 45);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.markers.DeleteAJMarkers", "org.eclipse.core.internal.resources.ResourceException", "<missing>"), 73);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteAllMarkers", "org.eclipse.ajdt.internal.ui.markers.DeleteAJMarkers", "org.eclipse.core.runtime.IProgressMonitor", "monitor", "org.eclipse.core.runtime.CoreException", "void"), 65);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.markers.DeleteAJMarkers", "org.eclipse.core.internal.resources.ResourceException", "<missing>"), 88);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.markers.DeleteAJMarkers", "org.eclipse.core.internal.resources.ResourceException", "<missing>"), 102);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.markers.DeleteAJMarkers", "org.eclipse.core.internal.resources.ResourceException", "<missing>"), 115);
    }
}

