/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.launching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.aspectj.asm.IProgramElement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.launching.LTWAspectpathModel;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.ajdt.internal.ui.resources.AspectJImages;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaClasspathTab;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.AddAdvancedAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddExternalFolderAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddExternalJarAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddFolderAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddJarAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddLibraryAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddProjectAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddVariableAction;
import org.eclipse.jdt.internal.debug.ui.actions.AttachSourceAction;
import org.eclipse.jdt.internal.debug.ui.actions.MoveDownAction;
import org.eclipse.jdt.internal.debug.ui.actions.MoveUpAction;
import org.eclipse.jdt.internal.debug.ui.actions.RemoveAction;
import org.eclipse.jdt.internal.debug.ui.actions.RuntimeClasspathAction;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathContentProvider;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathLabelProvider;
import org.eclipse.jdt.internal.debug.ui.classpath.IClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.classpath.RuntimeClasspathViewer;
import org.eclipse.jdt.internal.debug.ui.launcher.IClasspathViewer;
import org.eclipse.jdt.internal.debug.ui.launcher.IEntriesChangedListener;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class LTWAspectPathTab
extends JavaClasspathTab {
    private static final String ERROR_MESSAGE;
    public static final String ATTR_ASPECTPATH;
    protected RuntimeClasspathViewer fClasspathViewer;
    private LTWAspectpathModel fModel;
    protected ILaunchConfiguration fLaunchConfiguration;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_5;

    static {
        LTWAspectPathTab.ajc$preClinit();
        ERROR_MESSAGE = UIMessages.LTWAspectPathTab_errormessage;
        ATTR_ASPECTPATH = String.valueOf(LaunchingPlugin.getUniqueIdentifier()) + ".ASPECTPATH";
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IJavaDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_CLASSPATH_TAB);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        comp.setLayout((Layout)topLayout);
        Label label = new Label(comp, 0);
        label.setText(UIMessages.LTWAspectPathTab_label);
        GridData gd = new GridData(32);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fClasspathViewer = new RuntimeClasspathViewer(comp);
        this.fClasspathViewer.addEntriesChangedListener((IEntriesChangedListener)this);
        this.fClasspathViewer.getControl().setFont(font);
        this.fClasspathViewer.setLabelProvider((IBaseLabelProvider)new ClasspathLabelProvider());
        this.fClasspathViewer.setContentProvider((IContentProvider)new ClasspathContentProvider((JavaClasspathTab)this));
        Composite pathButtonComp = new Composite(comp, 0);
        GridLayout pathButtonLayout = new GridLayout();
        pathButtonLayout.marginHeight = 0;
        pathButtonLayout.marginWidth = 0;
        pathButtonComp.setLayout((Layout)pathButtonLayout);
        gd = new GridData(258);
        pathButtonComp.setLayoutData((Object)gd);
        pathButtonComp.setFont(font);
        this.createPathButtons(pathButtonComp);
    }

    protected void createPathButtons(Composite pathButtonComp) {
        ArrayList<AddFolderAction> advancedActions = new ArrayList<AddFolderAction>(5);
        this.createButton(pathButtonComp, (RuntimeClasspathAction)new MoveUpAction((IClasspathViewer)this.fClasspathViewer));
        this.createButton(pathButtonComp, (RuntimeClasspathAction)new MoveDownAction((IClasspathViewer)this.fClasspathViewer));
        this.createButton(pathButtonComp, (RuntimeClasspathAction)new RemoveAction((IClasspathViewer)this.fClasspathViewer));
        this.createButton(pathButtonComp, (RuntimeClasspathAction)new AddProjectAction((IClasspathViewer)this.fClasspathViewer));
        this.createButton(pathButtonComp, (RuntimeClasspathAction)new AddJarAction((IClasspathViewer)this.fClasspathViewer));
        this.createButton(pathButtonComp, (RuntimeClasspathAction)new AddExternalJarAction((IClasspathViewer)this.fClasspathViewer, "JavaClasspathTab"));
        AddFolderAction action = new AddFolderAction(null);
        advancedActions.add(action);
        action = new AddExternalFolderAction(null, "JavaClasspathTab");
        advancedActions.add(action);
        action = new AddVariableAction(null);
        advancedActions.add(action);
        action = new AddLibraryAction(null);
        advancedActions.add(action);
        action = new AttachSourceAction(null, 16);
        advancedActions.add(action);
        IAction[] adv = advancedActions.toArray(new IAction[advancedActions.size()]);
        this.createButton(pathButtonComp, (RuntimeClasspathAction)new AddAdvancedAction((IClasspathViewer)this.fClasspathViewer, adv));
    }

    protected Button createButton(Composite pathButtonComp, RuntimeClasspathAction action) {
        Button button = this.createPushButton(pathButtonComp, action.getText(), null);
        action.setButton(button);
        return button;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    private IRuntimeClasspathEntry[] getCurrentClasspath() {
        IClasspathEntry[] user = this.fModel.getEntries(1);
        ArrayList<IRuntimeClasspathEntry> entries = new ArrayList<IRuntimeClasspathEntry>(user.length);
        int i = 0;
        while (i < user.length) {
            IClasspathEntry userEntry = user[i];
            IRuntimeClasspathEntry entry = null;
            if (userEntry instanceof ClasspathEntry) {
                entry = ((ClasspathEntry)userEntry).getDelegate();
            } else if (userEntry instanceof IRuntimeClasspathEntry) {
                entry = (IRuntimeClasspathEntry)user[i];
            }
            if (entry != null) {
                entry.setClasspathProperty(3);
                entries.add(entry);
            }
            ++i;
        }
        return entries.toArray(new IRuntimeClasspathEntry[entries.size()]);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.refresh(configuration);
        this.fClasspathViewer.expandToLevel(2);
    }

    private void refresh(ILaunchConfiguration configuration) {
        if (configuration == this.getLaunchConfiguration()) {
            this.setDirty(false);
            return;
        }
        this.setErrorMessage(null);
        this.setLaunchConfiguration(configuration);
        try {
            this.createClasspathModel(configuration);
            if (this.fModel.getEntries(1).length == 0) {
                this.setErrorMessage(ERROR_MESSAGE);
            }
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            CoreException e = coreException;
            this.setErrorMessage(e.getMessage());
        }
        this.fClasspathViewer.setLaunchConfiguration(configuration);
        this.fClasspathViewer.setInput((Object)this.fModel);
        this.setDirty(false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.isDirty()) {
            IRuntimeClasspathEntry[] classpath = this.getCurrentClasspath();
            try {
                ArrayList<String> mementos = new ArrayList<String>(classpath.length);
                int i = 0;
                while (i < classpath.length) {
                    IRuntimeClasspathEntry entry = classpath[i];
                    mementos.add(entry.getMemento());
                    ++i;
                }
                configuration.setAttribute(ATTR_ASPECTPATH, mementos);
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
                CoreException e = coreException;
                JDIDebugUIPlugin.errorDialog((String)LauncherMessages.JavaClasspathTab_Unable_to_save_classpath_1, (Throwable)e);
            }
        }
    }

    private void createClasspathModel(ILaunchConfiguration configuration) throws CoreException {
        this.fModel = new LTWAspectpathModel();
        List entries = configuration.getAttribute(ATTR_ASPECTPATH, Collections.EMPTY_LIST);
        IRuntimeClasspathEntry[] rtes = new IRuntimeClasspathEntry[entries.size()];
        Iterator iter = entries.iterator();
        int i = 0;
        while (iter.hasNext()) {
            rtes[i] = JavaRuntime.newRuntimeClasspathEntry((String)((String)iter.next()));
            ++i;
        }
        int j = 0;
        while (j < rtes.length) {
            this.fModel.addEntry(1, rtes[j]);
            ++j;
        }
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        List entries = Collections.EMPTY_LIST;
        this.setErrorMessage(null);
        try {
            entries = configuration.getAttribute(ATTR_ASPECTPATH, Collections.EMPTY_LIST);
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_5);
        }
        if (entries.size() == 0) {
            this.setErrorMessage(ERROR_MESSAGE);
        }
        return entries.size() > 0;
    }

    public String getName() {
        return UIMessages.LTWAspectPathTab_title;
    }

    private void setLaunchConfiguration(ILaunchConfiguration config) {
        this.fLaunchConfiguration = config;
    }

    public ILaunchConfiguration getLaunchConfiguration() {
        return this.fLaunchConfiguration;
    }

    public Image getImage() {
        return AspectJImages.instance().getRegistry().get(AspectJImages.instance().getStructureIcon(IProgramElement.Kind.ASPECT, IProgramElement.Accessibility.PUBLIC).getImageDescriptor());
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("LTWAspectPathTab.java", LTWAspectPathTab.class);
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.launching.LTWAspectPathTab", "org.eclipse.core.runtime.CoreException", "e"), 227);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "refresh", "org.eclipse.ajdt.internal.launching.LTWAspectPathTab", "org.eclipse.debug.core.ILaunchConfiguration", "configuration", "", "void"), 214);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.launching.LTWAspectPathTab", "org.eclipse.core.runtime.CoreException", "e"), 246);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "performApply", "org.eclipse.ajdt.internal.launching.LTWAspectPathTab", "org.eclipse.debug.core.ILaunchConfigurationWorkingCopy", "configuration", "", "void"), 236);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.launching.LTWAspectPathTab", "org.eclipse.core.runtime.CoreException", "<missing>"), 277);
        ajc$tjp_5 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "isValid", "org.eclipse.ajdt.internal.launching.LTWAspectPathTab", "org.eclipse.debug.core.ILaunchConfiguration", "configuration", "", "boolean"), 272);
    }
}

