/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core;

import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.ReflectionUtils;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.core.util.MementoTokenizer;

public class AJMementoTokenizer
extends MementoTokenizer {
    private static final String COUNT = Character.toString('!');
    private static final String JAVAPROJECT = Character.toString('=');
    private static final String PACKAGEFRAGMENTROOT = Character.toString('/');
    private static final String PACKAGEFRAGMENT = Character.toString('<');
    private static final String FIELD = Character.toString('^');
    private static final String METHOD = Character.toString('~');
    private static final String INITIALIZER = Character.toString('|');
    private static final String COMPILATIONUNIT = Character.toString('{');
    private static final String CLASSFILE = Character.toString('(');
    private static final String TYPE = Character.toString('[');
    private static final String PACKAGEDECLARATION = Character.toString('%');
    private static final String IMPORTDECLARATION = Character.toString('#');
    private static final String LOCALVARIABLE = Character.toString('@');
    private static final String TYPE_PARAMETER = Character.toString(']');
    private static final String ANNOTATION = Character.toString('}');
    private static final String ASPECT_CU = Character.toString('*');
    private static final String ADVICE = Character.toString('&');
    private static final String ASPECT_TYPE = Character.toString('\'');
    private static final String CODEELEMENT = Character.toString('?');
    private static final String ITD_METHOD = Character.toString(')');
    private static final String ITD_FIELD = Character.toString(',');
    private static final String DECLARE = Character.toString('`');
    private static final String POINTCUT = Character.toString('\"');
    private final char[] memento;
    private final int length;
    private int index = 0;

    public AJMementoTokenizer(String memento) {
        super(memento);
        this.memento = memento.toCharArray();
        this.length = this.memento.length;
    }

    public AJMementoTokenizer(MementoTokenizer tokenizer) {
        super(String.valueOf((char[])ReflectionUtils.getPrivateField(MementoTokenizer.class, "memento", tokenizer)));
        this.memento = (char[])ReflectionUtils.getPrivateField(MementoTokenizer.class, "memento", tokenizer);
        this.length = this.memento.length;
        this.index = (Integer)ReflectionUtils.getPrivateField(MementoTokenizer.class, "index", tokenizer);
        ReflectionUtils.setPrivateField(MementoTokenizer.class, "index", this, this.index);
    }

    public AJMementoTokenizer(MementoTokenizer tokenizer, String resetToName) {
        super(String.valueOf((char[])ReflectionUtils.getPrivateField(MementoTokenizer.class, "memento", tokenizer)));
        this.memento = (char[])ReflectionUtils.getPrivateField(MementoTokenizer.class, "memento", tokenizer);
        this.length = this.memento.length;
        int nameIndex = CharOperation.indexOf((char[])resetToName.toCharArray(), (char[])this.memento, (boolean)true);
        this.index = this.index >= 0 ? nameIndex + resetToName.length() : (Integer)ReflectionUtils.getPrivateField(MementoTokenizer.class, "index", tokenizer);
        ReflectionUtils.setPrivateField(MementoTokenizer.class, "index", this, this.index);
    }

    public boolean hasMoreTokens() {
        return this.index < this.length;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String nextToken() {
        int start = this.index;
        StringBuffer buffer = null;
        switch (this.memento[this.index++]) {
            case '\\': {
                buffer = new StringBuffer();
                buffer.append(this.memento[this.index]);
                start = ++this.index;
                break;
            }
            case '!': {
                return COUNT;
            }
            case '=': {
                return JAVAPROJECT;
            }
            case '/': {
                return PACKAGEFRAGMENTROOT;
            }
            case '<': {
                return PACKAGEFRAGMENT;
            }
            case '^': {
                return FIELD;
            }
            case '~': {
                return METHOD;
            }
            case '|': {
                return INITIALIZER;
            }
            case '{': {
                return COMPILATIONUNIT;
            }
            case '(': {
                return CLASSFILE;
            }
            case '[': {
                return TYPE;
            }
            case '%': {
                return PACKAGEDECLARATION;
            }
            case '#': {
                return IMPORTDECLARATION;
            }
            case '@': {
                return LOCALVARIABLE;
            }
            case ']': {
                return TYPE_PARAMETER;
            }
            case '}': {
                return ANNOTATION;
            }
            case '&': {
                return ADVICE;
            }
            case '\'': {
                return ASPECT_TYPE;
            }
            case '?': {
                return CODEELEMENT;
            }
            case ')': {
                return ITD_METHOD;
            }
            case ',': {
                return ITD_FIELD;
            }
            case '`': {
                return DECLARE;
            }
            case '\"': {
                return POINTCUT;
            }
            case '*': {
                if (AspectJPlugin.USING_CU_PROVIDER) break;
                return ASPECT_CU;
            }
        }
        block31: while (this.index < this.length) {
            switch (this.memento[this.index]) {
                case '\\': {
                    if (buffer == null) {
                        buffer = new StringBuffer();
                    }
                    buffer.append(this.memento, start, this.index - start);
                    start = ++this.index;
                    break;
                }
                case '!': 
                case '\"': 
                case '#': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case ',': 
                case '/': 
                case '<': 
                case '=': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '`': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    break block31;
                }
                case '*': {
                    if (!AspectJPlugin.USING_CU_PROVIDER) break block31;
                }
            }
            ++this.index;
        }
        if (buffer != null) {
            buffer.append(this.memento, start, this.index - start);
            return buffer.toString();
        }
        return new String(this.memento, start, this.index - start);
    }

    void setIndexTo(int newIndex) {
        this.index = newIndex;
    }
}

