/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards.exports;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.ajdt.internal.ui.wizards.exports.AJJarPackagerUtil;
import org.eclipse.ajdt.internal.ui.wizards.exports.JarPackagerMessages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.ISourceAttribute;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jdt.ui.jarpackager.IJarDescriptionWriter;
import org.eclipse.jdt.ui.jarpackager.IJarExportRunnable;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jdt.ui.jarpackager.JarWriter3;
import org.eclipse.jdt.ui.refactoring.RefactoringSaveHelper;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class AJJarFileExportOperation
extends WorkspaceModifyOperation
implements IJarExportRunnable {
    private JarWriter3 fJarWriter;
    private JarPackageData fJarPackage;
    private JarPackageData[] fJarPackages;
    private Shell fParentShell;
    private Map fJavaNameToClassFilesMap;
    private IContainer fClassFilesMapContainer;
    private Set fExportedClassContainers;
    private MessageMultiStatus fStatus;
    private StandardJavaElementContentProvider fJavaElementContentProvider;
    private boolean fFilesSaved;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_26;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_28;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_33;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_38;

    public AJJarFileExportOperation(JarPackageData jarPackage, Shell parent) {
        this(new JarPackageData[]{jarPackage}, parent);
    }

    public AJJarFileExportOperation(JarPackageData[] jarPackages, Shell parent) {
        this(parent);
        this.fJarPackages = jarPackages;
    }

    private AJJarFileExportOperation(Shell parent) {
        this.fParentShell = parent;
        this.fStatus = new MessageMultiStatus(JavaPlugin.getPluginId(), 0, "", null);
        this.fJavaElementContentProvider = new StandardJavaElementContentProvider();
    }

    protected void addToStatus(CoreException ex) {
        IStatus status = ex.getStatus();
        String message = ex.getLocalizedMessage();
        if (message == null || message.length() < 1) {
            message = JarPackagerMessages.JarFileExportOperation_coreErrorDuringExport;
            status = new Status(status.getSeverity(), status.getPlugin(), status.getCode(), message, (Throwable)ex);
        }
        this.fStatus.add(status);
    }

    protected void addInfo(String message, Throwable error) {
        this.fStatus.add((IStatus)new Status(1, JavaPlugin.getPluginId(), 10001, message, error));
    }

    protected void addWarning(String message, Throwable error) {
        this.fStatus.add((IStatus)new Status(2, JavaPlugin.getPluginId(), 10001, message, error));
    }

    protected void addError(String message, Throwable error) {
        this.fStatus.add((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, message, error));
    }

    protected int countSelectedElements() {
        HashSet<IJavaProject> enclosingJavaProjects = new HashSet<IJavaProject>(10);
        int count = 0;
        int n = this.fJarPackage.getElements().length;
        int i = 0;
        while (i < n) {
            block10: {
                IResource resource;
                block12: {
                    Object element;
                    block11: {
                        element = this.fJarPackage.getElements()[i];
                        IJavaProject javaProject = this.getEnclosingJavaProject(element);
                        if (javaProject != null) {
                            enclosingJavaProjects.add(javaProject);
                        }
                        resource = null;
                        if (!(element instanceof IJavaElement)) break block11;
                        IJavaElement je = (IJavaElement)element;
                        try {
                            resource = je.getUnderlyingResource();
                        }
                        catch (JavaModelException javaModelException) {
                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                            break block10;
                        }
                        if (resource != null) break block12;
                        break block10;
                    }
                    resource = (IResource)element;
                }
                count = resource.getType() == 1 ? ++count : (count += this.getTotalChildCount((IContainer)resource));
            }
            ++i;
        }
        if (this.fJarPackage.areOutputFoldersExported()) {
            if (!this.fJarPackage.areJavaFilesExported()) {
                count = 0;
            }
            for (IJavaProject javaProject : enclosingJavaProjects) {
                IContainer[] outputContainers;
                try {
                    outputContainers = this.getOutputContainers(javaProject);
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
                    CoreException ex = coreException;
                    this.addToStatus(ex);
                    continue;
                }
                int i2 = 0;
                while (i2 < outputContainers.length) {
                    count += this.getTotalChildCount(outputContainers[i2]);
                    ++i2;
                }
            }
        }
        return count;
    }

    private int getTotalChildCount(IContainer container) {
        IResource[] members;
        try {
            members = container.members();
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_3, (JoinPoint.StaticPart)ajc$tjp_4);
            return 0;
        }
        int count = 0;
        int i = 0;
        while (i < members.length) {
            count = members[i].getType() == 1 ? ++count : (count += this.getTotalChildCount((IContainer)members[i]));
            ++i;
        }
        return count;
    }

    protected void exportElement(Object element, IProgressMonitor progressMonitor) throws InterruptedException {
        if (!AspectJPlugin.USING_CU_PROVIDER && element instanceof AJCompilationUnit) {
            return;
        }
        int leadSegmentsToRemove = 1;
        IPackageFragmentRoot pkgRoot = null;
        boolean isInJavaProject = false;
        IResource resource = null;
        IJavaProject jProject = null;
        if (element instanceof IJavaElement) {
            isInJavaProject = true;
            IJavaElement je = (IJavaElement)element;
            int type = je.getElementType();
            if (type != 6 && type != 5) {
                this.exportJavaElement(progressMonitor, je);
                return;
            }
            try {
                resource = je.getUnderlyingResource();
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_5, (JoinPoint.StaticPart)ajc$tjp_6);
                JavaModelException ex = javaModelException;
                this.addWarning(Messages.format((String)JarPackagerMessages.JarFileExportOperation_resourceNotFound, (Object)je.getElementName()), ex);
                return;
            }
            jProject = je.getJavaProject();
            pkgRoot = JavaModelUtil.getPackageFragmentRoot((IJavaElement)je);
        } else {
            resource = (IResource)element;
        }
        if (!resource.isAccessible()) {
            this.addWarning(Messages.format((String)JarPackagerMessages.JarFileExportOperation_resourceNotFound, (Object)resource.getFullPath()), null);
            return;
        }
        if (resource.getType() == 1) {
            if (!isInJavaProject) {
                Throwable ex;
                try {
                    isInJavaProject = resource.getProject().hasNature("org.eclipse.jdt.core.javanature");
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_7, (JoinPoint.StaticPart)ajc$tjp_6);
                    ex = coreException;
                    this.addWarning(Messages.format((String)JarPackagerMessages.JarFileExportOperation_projectNatureNotDeterminable, (Object)resource.getFullPath()), ex);
                    return;
                }
                if (isInJavaProject) {
                    jProject = JavaCore.create((IProject)resource.getProject());
                    try {
                        IPackageFragment pkgFragment = jProject.findPackageFragment(resource.getFullPath().removeLastSegments(1));
                        pkgRoot = pkgFragment != null ? JavaModelUtil.getPackageFragmentRoot((IJavaElement)pkgFragment) : this.findPackageFragmentRoot(jProject, resource.getFullPath().removeLastSegments(1));
                    }
                    catch (JavaModelException javaModelException) {
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_8, (JoinPoint.StaticPart)ajc$tjp_6);
                        ex = javaModelException;
                        this.addWarning(Messages.format((String)JarPackagerMessages.JarFileExportOperation_javaPackageNotDeterminable, (Object)resource.getFullPath()), ex);
                        return;
                    }
                }
            }
            if (pkgRoot != null && jProject != null) {
                leadSegmentsToRemove = pkgRoot.getPath().segmentCount();
                boolean isOnBuildPath = jProject.isOnClasspath(resource);
                if (!isOnBuildPath || this.mustUseSourceFolderHierarchy() && !pkgRoot.getElementName().equals("")) {
                    --leadSegmentsToRemove;
                }
            }
            IPath destinationPath = resource.getFullPath().removeFirstSegments(leadSegmentsToRemove);
            boolean isInOutputFolder = false;
            if (isInJavaProject && jProject != null) {
                try {
                    isInOutputFolder = jProject.getOutputLocation().isPrefixOf(resource.getFullPath());
                }
                catch (JavaModelException javaModelException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_9, (JoinPoint.StaticPart)ajc$tjp_6);
                    isInOutputFolder = false;
                }
            }
            this.exportClassFiles(progressMonitor, pkgRoot, resource, jProject, destinationPath);
            this.exportResource(progressMonitor, pkgRoot, isInJavaProject, resource, destinationPath, isInOutputFolder);
            progressMonitor.worked(1);
            ModalContext.checkCanceled((IProgressMonitor)progressMonitor);
        } else {
            this.exportContainer(progressMonitor, (IContainer)resource);
        }
    }

    private void exportJavaElement(IProgressMonitor progressMonitor, IJavaElement je) throws InterruptedException {
        if (je.getElementType() == 3 && ((IPackageFragmentRoot)je).isArchive()) {
            return;
        }
        Object[] children = this.fJavaElementContentProvider.getChildren((Object)je);
        int i = 0;
        while (i < children.length) {
            this.exportElement(children[i], progressMonitor);
            ++i;
        }
    }

    private void exportResource(IProgressMonitor progressMonitor, IResource resource, int leadingSegmentsToRemove) throws InterruptedException {
        block11: {
            block10: {
                IResource[] children;
                if (!(resource instanceof IContainer)) break block10;
                IContainer container = (IContainer)resource;
                try {
                    children = container.members();
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_10, (JoinPoint.StaticPart)ajc$tjp_11);
                    CoreException e = coreException;
                    this.addWarning(Messages.format((String)JarPackagerMessages.JarFileExportOperation_errorDuringExport, (Object)container.getFullPath()), e);
                    return;
                }
                int i = 0;
                while (i < children.length) {
                    this.exportResource(progressMonitor, children[i], leadingSegmentsToRemove);
                    ++i;
                }
                break block11;
            }
            if (!(resource instanceof IFile)) break block11;
            try {
                try {
                    IPath destinationPath = resource.getFullPath().removeFirstSegments(leadingSegmentsToRemove);
                    progressMonitor.subTask(Messages.format((String)JarPackagerMessages.JarFileExportOperation_exporting, (Object)destinationPath.toString()));
                    this.fJarWriter.write((IFile)resource, destinationPath);
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_12, (JoinPoint.StaticPart)ajc$tjp_11);
                    CoreException ex = coreException;
                    Throwable realEx = ex.getStatus().getException();
                    if (realEx instanceof ZipException && realEx.getMessage() != null && realEx.getMessage().startsWith("duplicate entry:")) {
                        this.addWarning(ex.getMessage(), realEx);
                    } else {
                        this.addToStatus(ex);
                    }
                    progressMonitor.worked(1);
                    ModalContext.checkCanceled((IProgressMonitor)progressMonitor);
                }
            }
            finally {
                progressMonitor.worked(1);
                ModalContext.checkCanceled((IProgressMonitor)progressMonitor);
            }
        }
    }

    private void exportContainer(IProgressMonitor progressMonitor, IContainer container) throws InterruptedException {
        if (container.getType() == 2 && this.isOutputFolder((IFolder)container)) {
            return;
        }
        IResource[] children = null;
        try {
            children = container.members();
            int i = 0;
            while (i < children.length) {
                this.exportElement(children[i], progressMonitor);
                ++i;
            }
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_13, (JoinPoint.StaticPart)ajc$tjp_14);
            CoreException e = coreException;
            this.addWarning(Messages.format((String)JarPackagerMessages.JarFileExportOperation_errorDuringExport, (Object)container.getFullPath()), e);
        }
    }

    private IPackageFragmentRoot findPackageFragmentRoot(IJavaProject jProject, IPath path) throws JavaModelException {
        if (jProject == null || path == null || path.segmentCount() <= 0) {
            return null;
        }
        IPackageFragmentRoot pkgRoot = jProject.findPackageFragmentRoot(path);
        if (pkgRoot != null) {
            return pkgRoot;
        }
        return this.findPackageFragmentRoot(jProject, path.removeLastSegments(1));
    }

    private void exportResource(IProgressMonitor progressMonitor, IPackageFragmentRoot pkgRoot, boolean isInJavaProject, IResource resource, IPath destinationPath, boolean isInOutputFolder) {
        Throwable ex;
        if (this.fJarPackage.areClassFilesExported() && destinationPath.toString().equals("META-INF/MANIFEST.MF")) {
            if (this.fJarPackage.isManifestGenerated()) {
                this.addWarning(Messages.format((String)JarPackagerMessages.JarFileExportOperation_didNotAddManifestToJar, (Object)resource.getFullPath()), null);
            }
            return;
        }
        boolean isNonJavaResource = !isInJavaProject || pkgRoot == null;
        boolean isInClassFolder = false;
        try {
            isInClassFolder = pkgRoot != null && !pkgRoot.isArchive() && pkgRoot.getKind() == 2;
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_15, (JoinPoint.StaticPart)ajc$tjp_16);
            ex = javaModelException;
            this.addWarning(Messages.format((String)JarPackagerMessages.JarFileExportOperation_cantGetRootKind, (Object)resource.getFullPath()), ex);
        }
        if (this.fJarPackage.areClassFilesExported() && (isNonJavaResource || pkgRoot != null && !this.isJavaFile(resource) && !this.isClassFile(resource) || isInClassFolder && this.isClassFile(resource)) || this.fJarPackage.areJavaFilesExported() && (isNonJavaResource || pkgRoot != null && !this.isClassFile(resource) || isInClassFolder && this.isClassFile(resource) && !this.fJarPackage.areClassFilesExported())) {
            try {
                progressMonitor.subTask(Messages.format((String)JarPackagerMessages.JarFileExportOperation_exporting, (Object)destinationPath.toString()));
                this.fJarWriter.write((IFile)resource, destinationPath);
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_17, (JoinPoint.StaticPart)ajc$tjp_16);
                ex = coreException;
                Throwable realEx = ex.getStatus().getException();
                if (realEx instanceof ZipException && realEx.getMessage() != null && realEx.getMessage().startsWith("duplicate entry:")) {
                    this.addWarning(ex.getMessage(), realEx);
                }
                this.addToStatus((CoreException)ex);
            }
        }
    }

    private boolean isOutputFolder(IFolder folder) {
        try {
            IJavaProject javaProject = JavaCore.create((IProject)folder.getProject());
            IPath outputFolderPath = javaProject.getOutputLocation();
            return folder.getFullPath().equals((Object)outputFolderPath);
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_18, (JoinPoint.StaticPart)ajc$tjp_19);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exportClassFiles(IProgressMonitor progressMonitor, IPackageFragmentRoot pkgRoot, IResource resource, IJavaProject jProject, IPath destinationPath) {
        CoreException coreException2;
        block6: {
            if (!this.fJarPackage.areClassFilesExported()) return;
            if (!this.isJavaFile(resource)) return;
            if (pkgRoot == null) return;
            try {
                if (!jProject.isOnClasspath(resource)) {
                    return;
                }
            }
            catch (CoreException coreException2) {
                // empty catch block
                break block6;
            }
            try {
                Iterator iter = this.filesOnClasspath((IFile)resource, destinationPath, jProject, pkgRoot, progressMonitor);
                IPath baseDestinationPath = destinationPath.removeLastSegments(1);
                while (iter.hasNext()) {
                    IFile file = (IFile)iter.next();
                    IPath classFilePath = baseDestinationPath.append(file.getName());
                    progressMonitor.subTask(Messages.format((String)JarPackagerMessages.JarFileExportOperation_exporting, (Object)classFilePath.toString()));
                    this.fJarWriter.write(file, classFilePath);
                }
                return;
            }
            catch (CoreException coreException3) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException3, (Object)this, ajc$tjp_20, (JoinPoint.StaticPart)ajc$tjp_21);
                CoreException coreException4 = coreException3;
            }
        }
        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_22, (JoinPoint.StaticPart)ajc$tjp_21);
        CoreException ex = coreException2;
        this.addToStatus(ex);
    }

    protected void exportSelectedElements(IProgressMonitor progressMonitor) throws InterruptedException {
        this.fExportedClassContainers = new HashSet(10);
        HashSet<IJavaProject> enclosingJavaProjects = new HashSet<IJavaProject>(10);
        int n = this.fJarPackage.getElements().length;
        int i = 0;
        while (i < n) {
            IJavaProject javaProject;
            Object element = this.fJarPackage.getElements()[i];
            this.exportElement(element, progressMonitor);
            if (this.fJarPackage.areOutputFoldersExported() && (javaProject = this.getEnclosingJavaProject(element)) != null) {
                enclosingJavaProjects.add(javaProject);
            }
            ++i;
        }
        if (this.fJarPackage.areOutputFoldersExported()) {
            this.exportOutputFolders(progressMonitor, enclosingJavaProjects);
        }
    }

    private IJavaProject getEnclosingJavaProject(Object element) {
        if (element instanceof IJavaElement) {
            return ((IJavaElement)element).getJavaProject();
        }
        if (element instanceof IResource) {
            IProject project = ((IResource)element).getProject();
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    return JavaCore.create((IProject)project);
                }
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_23, (JoinPoint.StaticPart)ajc$tjp_24);
                CoreException ex = coreException;
                this.addWarning(Messages.format((String)JarPackagerMessages.JarFileExportOperation_projectNatureNotDeterminable, (Object)project.getFullPath()), ex);
            }
        }
        return null;
    }

    private void exportOutputFolders(IProgressMonitor progressMonitor, Set javaProjects) throws InterruptedException {
        if (javaProjects == null) {
            return;
        }
        for (IJavaProject javaProject : javaProjects) {
            IContainer[] outputContainers;
            try {
                outputContainers = this.getOutputContainers(javaProject);
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_25, (JoinPoint.StaticPart)ajc$tjp_26);
                CoreException ex = coreException;
                this.addToStatus(ex);
                continue;
            }
            int i = 0;
            while (i < outputContainers.length) {
                this.exportResource(progressMonitor, (IResource)outputContainers[i], outputContainers[i].getFullPath().segmentCount());
                ++i;
            }
        }
    }

    private IContainer[] getOutputContainers(IJavaProject javaProject) throws CoreException {
        HashSet<IPath> outputPaths = new HashSet<IPath>();
        boolean includeDefaultOutputPath = false;
        IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IClasspathEntry cpEntry;
            if (roots[i] != null && (cpEntry = roots[i].getRawClasspathEntry()).getEntryKind() == 3) {
                IPath location = cpEntry.getOutputLocation();
                if (location != null) {
                    outputPaths.add(location);
                } else {
                    includeDefaultOutputPath = true;
                }
            }
            ++i;
        }
        if (includeDefaultOutputPath) {
            outputPaths.add(javaProject.getOutputLocation());
        }
        HashSet<Object> outputContainers = new HashSet<Object>(outputPaths.size());
        for (IPath path : outputPaths) {
            if (javaProject.getProject().getFullPath().equals((Object)path)) {
                outputContainers.add(javaProject.getProject());
                continue;
            }
            IFolder outputFolder = this.createFolderHandle(path);
            if (outputFolder == null || !outputFolder.isAccessible()) {
                String msg = JarPackagerMessages.JarFileExportOperation_outputContainerNotAccessible;
                this.addToStatus(new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, msg, null)));
                continue;
            }
            outputContainers.add(outputFolder);
        }
        return outputContainers.toArray(new IContainer[outputContainers.size()]);
    }

    protected Iterator filesOnClasspath(IFile file, IPath pathInJar, IJavaProject javaProject, IProgressMonitor progressMonitor) throws CoreException {
        return this.filesOnClasspath(file, pathInJar, javaProject, null, progressMonitor);
    }

    protected Iterator filesOnClasspath(IFile file, IPath pathInJar, IJavaProject javaProject, IPackageFragmentRoot pkgRoot, IProgressMonitor progressMonitor) throws CoreException {
        ArrayList classFileList;
        IProject outputContainer;
        IClasspathEntry cpEntry;
        IFile[] classFiles = this.fJarPackage.findClassfilesFor(file);
        if (classFiles != null) {
            return Arrays.asList(classFiles).iterator();
        }
        if (!this.isJavaFile((IResource)file)) {
            return Collections.EMPTY_LIST.iterator();
        }
        IPath outputPath = null;
        if (pkgRoot != null && (cpEntry = pkgRoot.getRawClasspathEntry()).getEntryKind() == 3) {
            outputPath = cpEntry.getOutputLocation();
        }
        if (outputPath == null) {
            outputPath = javaProject.getOutputLocation();
        }
        if (javaProject.getProject().getFullPath().equals((Object)outputPath)) {
            outputContainer = javaProject.getProject();
        } else {
            outputContainer = this.createFolderHandle(outputPath);
            if (outputContainer == null || !outputContainer.isAccessible()) {
                String msg = JarPackagerMessages.JarFileExportOperation_outputContainerNotAccessible;
                throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, msg, null));
            }
        }
        boolean hasErrors = this.hasCompileErrors((IResource)file);
        boolean hasWarnings = this.hasCompileWarnings((IResource)file);
        boolean canBeExported = this.canBeExported(hasErrors, hasWarnings);
        if (!canBeExported) {
            return Collections.EMPTY_LIST.iterator();
        }
        this.reportPossibleCompileProblems(file, hasErrors, hasWarnings, canBeExported);
        IProject classContainer = outputContainer;
        if (pathInJar.segmentCount() > 1) {
            classContainer = outputContainer.getFolder(pathInJar.removeLastSegments(1));
        }
        if (this.fExportedClassContainers.contains(classContainer)) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (this.fClassFilesMapContainer == null || !this.fClassFilesMapContainer.equals((Object)classContainer)) {
            this.fJavaNameToClassFilesMap = this.buildJavaToClassMap((IContainer)classContainer);
            if (this.fJavaNameToClassFilesMap == null) {
                IPath location = classContainer.getLocation();
                String containerName = "";
                if (location != null) {
                    containerName = location.toFile().toString();
                }
                String msg = Messages.format((String)JarPackagerMessages.JarFileExportOperation_missingSourceFileAttributeExportedAll, (Object)containerName);
                this.addInfo(msg, null);
                this.fExportedClassContainers.add(classContainer);
                return this.getClassesIn((IContainer)classContainer);
            }
            this.fClassFilesMapContainer = classContainer;
        }
        if ((classFileList = (ArrayList)this.fJavaNameToClassFilesMap.get(file.getName())) == null || classFileList.isEmpty()) {
            String msg = Messages.format((String)JarPackagerMessages.JarFileExportOperation_classFileOnClasspathNotAccessible, (Object)file.getFullPath());
            throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, msg, null));
        }
        return classFileList.iterator();
    }

    private Iterator getClassesIn(IContainer classContainer) throws CoreException {
        IResource[] resources = classContainer.members();
        ArrayList<IResource> files = new ArrayList<IResource>(resources.length);
        int i = 0;
        while (i < resources.length) {
            if (resources[i].getType() == 1 && this.isClassFile(resources[i])) {
                files.add(resources[i]);
            }
            ++i;
        }
        return files.iterator();
    }

    boolean isJavaFile(IResource file) {
        return file != null && file.getType() == 1 && file.getFileExtension() != null && (file.getFileExtension().equalsIgnoreCase("java") || file.getFileExtension().equalsIgnoreCase("aj"));
    }

    boolean isClassFile(IResource file) {
        return file != null && file.getType() == 1 && file.getFileExtension() != null && file.getFileExtension().equalsIgnoreCase("class");
    }

    private Map buildJavaToClassMap(IContainer container) throws CoreException {
        if (container == null || !container.isAccessible()) {
            return new HashMap(0);
        }
        IClassFileReader cfReader = null;
        IResource[] members = container.members();
        HashMap map = new HashMap(members.length);
        int i = 0;
        while (i < members.length) {
            IFile classFile;
            IPath location;
            if (this.isClassFile(members[i]) && (location = (classFile = (IFile)members[i]).getLocation()) != null) {
                File file = location.toFile();
                cfReader = ToolFactory.createDefaultClassFileReader((String)location.toOSString(), (int)17);
                if (cfReader != null) {
                    ISourceAttribute sourceAttribute = cfReader.getSourceFileAttribute();
                    if (sourceAttribute == null) {
                        this.addWarning(Messages.format((String)JarPackagerMessages.JarFileExportOperation_classFileWithoutSourceFileAttribute, (Object)file), null);
                        return null;
                    }
                    String javaName = new String(sourceAttribute.getSourceFileName());
                    Object classFiles = map.get(javaName);
                    if (classFiles == null) {
                        classFiles = new ArrayList(3);
                        map.put(javaName, classFiles);
                    }
                    ((ArrayList)classFiles).add(classFile);
                }
            }
            ++i;
        }
        return map;
    }

    protected IFile createFileHandle(IPath filePath) {
        if (filePath.isValidPath(filePath.toString()) && filePath.segmentCount() >= 2) {
            return JavaPlugin.getWorkspace().getRoot().getFile(filePath);
        }
        return null;
    }

    protected IFolder createFolderHandle(IPath folderPath) {
        if (folderPath.isValidPath(folderPath.toString()) && folderPath.segmentCount() >= 2) {
            return JavaPlugin.getWorkspace().getRoot().getFolder(folderPath);
        }
        return null;
    }

    public IStatus getStatus() {
        String message = null;
        switch (this.fStatus.getSeverity()) {
            case 0: {
                message = "";
                break;
            }
            case 1: {
                message = JarPackagerMessages.JarFileExportOperation_exportFinishedWithInfo;
                break;
            }
            case 2: {
                message = JarPackagerMessages.JarFileExportOperation_exportFinishedWithWarnings;
                break;
            }
            case 4: {
                if (this.fJarPackages.length > 1) {
                    message = JarPackagerMessages.JarFileExportOperation_creationOfSomeJARsFailed;
                    break;
                }
                message = JarPackagerMessages.JarFileExportOperation_jarCreationFailed;
                break;
            }
            default: {
                message = "";
            }
        }
        this.fStatus.setMessage(message);
        return this.fStatus;
    }

    protected boolean isDescendant(List resources, IResource child) {
        if (child.getType() == 4) {
            return false;
        }
        IContainer parent = child.getParent();
        if (resources.contains(parent)) {
            return true;
        }
        return this.isDescendant(resources, (IResource)parent);
    }

    protected boolean canBeExported(boolean hasErrors, boolean hasWarnings) throws CoreException {
        return !hasErrors && !hasWarnings || hasErrors && this.fJarPackage.areErrorsExported() || hasWarnings && this.fJarPackage.exportWarnings();
    }

    protected void reportPossibleCompileProblems(IFile file, boolean hasErrors, boolean hasWarnings, boolean canBeExported) {
        if (hasErrors) {
            if (canBeExported) {
                this.addWarning(Messages.format((String)JarPackagerMessages.JarFileExportOperation_exportedWithCompileErrors, (Object)file.getFullPath()), null);
            } else {
                this.addWarning(Messages.format((String)JarPackagerMessages.JarFileExportOperation_notExportedDueToCompileErrors, (Object)file.getFullPath()), null);
            }
        }
        if (hasWarnings) {
            if (canBeExported) {
                this.addWarning(Messages.format((String)JarPackagerMessages.JarFileExportOperation_exportedWithCompileWarnings, (Object)file.getFullPath()), null);
            } else {
                this.addWarning(Messages.format((String)JarPackagerMessages.JarFileExportOperation_notExportedDueToCompileWarnings, (Object)file.getFullPath()), null);
            }
        }
    }

    protected void execute(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        int count = this.fJarPackages.length;
        progressMonitor.beginTask("", count);
        try {
            int i = 0;
            while (i < count) {
                SubProgressMonitor subProgressMonitor = new SubProgressMonitor(progressMonitor, 1, 4);
                this.fJarPackage = this.fJarPackages[i];
                if (this.fJarPackage != null) {
                    this.singleRun((IProgressMonitor)subProgressMonitor);
                }
                ++i;
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    public void singleRun(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        block18: {
            try {
                try {
                    if (!this.preconditionsOK()) {
                        throw new InvocationTargetException(null, JarPackagerMessages.JarFileExportOperation_jarCreationFailedSeeDetails);
                    }
                    int totalWork = this.countSelectedElements();
                    if (this.fJarPackage.areGeneratedFilesExported() && (!this.isAutoBuilding() && this.fJarPackage.isBuildingIfNeeded() || this.isAutoBuilding() && this.fFilesSaved)) {
                        int subMonitorTicks = totalWork / 10;
                        progressMonitor.beginTask("", totalWork += subMonitorTicks);
                        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(progressMonitor, subMonitorTicks, 4);
                        this.buildProjects((IProgressMonitor)subProgressMonitor);
                    } else {
                        progressMonitor.beginTask("", totalWork);
                    }
                    this.fJarWriter = this.fJarPackage.createJarWriter3(this.fParentShell);
                    this.exportSelectedElements(progressMonitor);
                    if (this.getStatus().getSeverity() != 4) {
                        progressMonitor.subTask(JarPackagerMessages.JarFileExportOperation_savingFiles);
                        this.saveFiles();
                    }
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_27, (JoinPoint.StaticPart)ajc$tjp_28);
                    CoreException ex = coreException;
                    this.addToStatus(ex);
                    try {
                        if (this.fJarWriter != null) {
                            this.fJarWriter.close();
                        }
                    }
                    catch (CoreException coreException2) {
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_29, (JoinPoint.StaticPart)ajc$tjp_28);
                        CoreException ex2 = coreException2;
                        this.addToStatus(ex2);
                    }
                    progressMonitor.done();
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (this.fJarWriter != null) {
                        this.fJarWriter.close();
                    }
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_30, (JoinPoint.StaticPart)ajc$tjp_28);
                    CoreException ex = coreException;
                    this.addToStatus(ex);
                }
                progressMonitor.done();
                throw throwable;
            }
            try {
                if (this.fJarWriter != null) {
                    this.fJarWriter.close();
                }
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_31, (JoinPoint.StaticPart)ajc$tjp_28);
                CoreException ex = coreException;
                this.addToStatus(ex);
            }
            progressMonitor.done();
        }
    }

    protected boolean preconditionsOK() {
        if (!this.fJarPackage.areGeneratedFilesExported() && !this.fJarPackage.areJavaFilesExported()) {
            this.addError(JarPackagerMessages.JarFileExportOperation_noExportTypeChosen, null);
            return false;
        }
        if (this.fJarPackage.getElements() == null || this.fJarPackage.getElements().length == 0) {
            this.addError(JarPackagerMessages.JarFileExportOperation_noResourcesSelected, null);
            return false;
        }
        if (this.fJarPackage.getAbsoluteJarLocation() == null) {
            this.addError(JarPackagerMessages.JarFileExportOperation_invalidJarLocation, null);
            return false;
        }
        File targetFile = this.fJarPackage.getAbsoluteJarLocation().toFile();
        if (targetFile.exists() && !targetFile.canWrite()) {
            this.addError(JarPackagerMessages.JarFileExportOperation_jarFileExistsAndNotWritable, null);
            return false;
        }
        if (!this.fJarPackage.isManifestAccessible()) {
            this.addError(JarPackagerMessages.JarFileExportOperation_manifestDoesNotExist, null);
            return false;
        }
        if (!this.fJarPackage.isMainClassValid((IRunnableContext)new BusyIndicatorRunnableContext())) {
            this.addError(JarPackagerMessages.JarFileExportOperation_invalidMainClass, null);
            return false;
        }
        if (this.fParentShell != null) {
            final boolean[] res = new boolean[1];
            this.fParentShell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    RefactoringSaveHelper refactoringSaveHelper = new RefactoringSaveHelper(1);
                    res[0] = refactoringSaveHelper.saveEditors(AJJarFileExportOperation.this.fParentShell);
                    AJJarFileExportOperation.this.fFilesSaved = refactoringSaveHelper.didSaveFiles();
                }
            });
            if (!res[0]) {
                this.addError(JarPackagerMessages.JarFileExportOperation_fileUnsaved, null);
                return false;
            }
        }
        return true;
    }

    protected void saveFiles() {
        Throwable ex;
        if (this.fJarPackage.areGeneratedFilesExported() && this.fJarPackage.isManifestGenerated() && this.fJarPackage.isManifestSaved()) {
            try {
                this.saveManifest();
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_32, (JoinPoint.StaticPart)ajc$tjp_33);
                ex = coreException;
                this.addError(JarPackagerMessages.JarFileExportOperation_errorSavingManifest, ex);
            }
            catch (IOException iOException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(iOException, (Object)this, ajc$tjp_34, (JoinPoint.StaticPart)ajc$tjp_33);
                ex = iOException;
                this.addError(JarPackagerMessages.JarFileExportOperation_errorSavingManifest, ex);
            }
        }
        if (this.fJarPackage.isDescriptionSaved()) {
            try {
                this.saveDescription();
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_35, (JoinPoint.StaticPart)ajc$tjp_33);
                ex = coreException;
                this.addError(JarPackagerMessages.JarFileExportOperation_errorSavingDescription, ex);
            }
            catch (IOException iOException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(iOException, (Object)this, ajc$tjp_36, (JoinPoint.StaticPart)ajc$tjp_33);
                ex = iOException;
                this.addError(JarPackagerMessages.JarFileExportOperation_errorSavingDescription, ex);
            }
        }
    }

    protected void saveDescription() throws CoreException, IOException {
        if (this.fJarPackage.isManifestReused()) {
            this.fJarPackage.setGenerateManifest(false);
        }
        ByteArrayOutputStream objectStreamOutput = new ByteArrayOutputStream();
        IJarDescriptionWriter writer = this.fJarPackage.createJarDescriptionWriter((OutputStream)objectStreamOutput, "UTF-8");
        ByteArrayInputStream fileInput = null;
        try {
            writer.write(this.fJarPackage);
            fileInput = new ByteArrayInputStream(objectStreamOutput.toByteArray());
            IFile descriptionFile = this.fJarPackage.getDescriptionFile();
            if (descriptionFile.isAccessible()) {
                if (this.fJarPackage.allowOverwrite() || AJJarPackagerUtil.askForOverwritePermission(this.fParentShell, descriptionFile.getFullPath().toString())) {
                    descriptionFile.setContents((InputStream)fileInput, true, true, null);
                }
            } else {
                descriptionFile.create((InputStream)fileInput, true, null);
            }
        }
        finally {
            if (fileInput != null) {
                fileInput.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    protected void saveManifest() throws CoreException, IOException {
        ByteArrayOutputStream manifestOutput = new ByteArrayOutputStream();
        ByteArrayInputStream fileInput = null;
        try {
            Manifest manifest = this.fJarPackage.getManifestProvider().create(this.fJarPackage);
            manifest.write(manifestOutput);
            fileInput = new ByteArrayInputStream(manifestOutput.toByteArray());
            IFile manifestFile = this.fJarPackage.getManifestFile();
            if (manifestFile.isAccessible()) {
                if (this.fJarPackage.allowOverwrite() || AJJarPackagerUtil.askForOverwritePermission(this.fParentShell, manifestFile.getFullPath().toString())) {
                    manifestFile.setContents((InputStream)fileInput, true, true, null);
                }
            } else {
                manifestFile.create((InputStream)fileInput, true, null);
            }
        }
        finally {
            if (manifestOutput != null) {
                manifestOutput.close();
            }
            if (fileInput != null) {
                fileInput.close();
            }
        }
    }

    private boolean isAutoBuilding() {
        return ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
    }

    private void buildProjects(IProgressMonitor progressMonitor) {
        HashSet<IProject> builtProjects = new HashSet<IProject>(10);
        Object[] elements = this.fJarPackage.getElements();
        int i = 0;
        while (i < elements.length) {
            block10: {
                IProject project = null;
                Object element = elements[i];
                if (element instanceof IResource) {
                    project = ((IResource)element).getProject();
                } else if (element instanceof IJavaElement) {
                    project = ((IJavaElement)element).getJavaProject().getProject();
                }
                if (project != null && !builtProjects.contains(project)) {
                    try {
                        try {
                            project.build(10, progressMonitor);
                        }
                        catch (CoreException coreException) {
                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_37, (JoinPoint.StaticPart)ajc$tjp_38);
                            CoreException ex = coreException;
                            String message = Messages.format((String)JarPackagerMessages.JarFileExportOperation_errorDuringProjectBuild, (Object)project.getFullPath());
                            this.addError(message, ex);
                            builtProjects.add(project);
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        builtProjects.add(project);
                        throw throwable;
                    }
                    builtProjects.add(project);
                }
            }
            ++i;
        }
    }

    private boolean hasCompileErrors(IResource resource) throws CoreException {
        IMarker[] problemMarkers = resource.findMarkers("org.eclipse.jdt.core.problem", true, 2);
        int i = 0;
        while (i < problemMarkers.length) {
            if (problemMarkers[i].getAttribute("severity", -1) == 2) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasCompileWarnings(IResource resource) throws CoreException {
        IMarker[] problemMarkers = resource.findMarkers("org.eclipse.jdt.core.problem", true, 2);
        int i = 0;
        while (i < problemMarkers.length) {
            if (problemMarkers[i].getAttribute("severity", -1) == 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean mustUseSourceFolderHierarchy() {
        return this.fJarPackage.useSourceFolderHierarchy() && this.fJarPackage.areJavaFilesExported() && !this.fJarPackage.areGeneratedFilesExported();
    }

    static {
        Factory factory = new Factory("AJJarFileExportOperation.java", Class.forName("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 194);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("4", "countSelectedElements", "org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "", "", "", "int"), 177);
        ajc$tjp_10 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.core.runtime.CoreException:", "e:"), 362);
        ajc$tjp_11 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "exportResource", "org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.core.runtime.IProgressMonitor:org.eclipse.core.resources.IResource:int:", "progressMonitor:resource:leadingSegmentsToRemove:", "java.lang.InterruptedException:", "void"), 356);
        ajc$tjp_12 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.core.runtime.CoreException:", "ex:"), 374);
        ajc$tjp_13 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.core.runtime.CoreException:", "e:"), 396);
        ajc$tjp_14 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "exportContainer", "org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.core.runtime.IProgressMonitor:org.eclipse.core.resources.IContainer:", "progressMonitor:container:", "java.lang.InterruptedException:", "void"), 387);
        ajc$tjp_15 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.jdt.core.JavaModelException:", "ex:"), 425);
        ajc$tjp_16 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "exportResource", "org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.core.runtime.IProgressMonitor:org.eclipse.jdt.core.IPackageFragmentRoot:boolean:org.eclipse.core.resources.IResource:org.eclipse.core.runtime.IPath:boolean:", "progressMonitor:pkgRoot:isInJavaProject:resource:destinationPath:isInOutputFolder:", "", "void"), 412);
        ajc$tjp_17 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.core.runtime.CoreException:", "ex:"), 435);
        ajc$tjp_18 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 450);
        ajc$tjp_19 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "isOutputFolder", "org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.core.resources.IFolder:", "folder:", "", "boolean"), 445);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.core.runtime.CoreException:", "ex:"), 220);
        ajc$tjp_20 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.core.runtime.CoreException:", "ex:"), 470);
        ajc$tjp_21 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "exportClassFiles", "org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.core.runtime.IProgressMonitor:org.eclipse.jdt.core.IPackageFragmentRoot:org.eclipse.core.resources.IResource:org.eclipse.jdt.core.IJavaProject:org.eclipse.core.runtime.IPath:", "progressMonitor:pkgRoot:resource:jProject:destinationPath:", "", "void"), 455);
        ajc$tjp_22 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.core.runtime.CoreException:", "ex:"), 470);
        ajc$tjp_23 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.core.runtime.CoreException:", "ex:"), 504);
        ajc$tjp_24 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "getEnclosingJavaProject", "org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "java.lang.Object:", "element:", "", "org.eclipse.jdt.core.IJavaProject"), 496);
        ajc$tjp_25 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.core.runtime.CoreException:", "ex:"), 521);
        ajc$tjp_26 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "exportOutputFolders", "org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.core.runtime.IProgressMonitor:java.util.Set:", "progressMonitor:javaProjects:", "java.lang.InterruptedException:", "void"), 511);
        ajc$tjp_27 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.core.runtime.CoreException:", "ex:"), 891);
        ajc$tjp_28 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "singleRun", "org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.core.runtime.IProgressMonitor:", "progressMonitor:", "java.lang.reflect.InvocationTargetException:java.lang.InterruptedException:", "void"), 869);
        ajc$tjp_29 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.core.runtime.CoreException:", "ex:"), 897);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 237);
        ajc$tjp_30 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.core.runtime.CoreException:", "ex:"), 897);
        ajc$tjp_31 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.core.runtime.CoreException:", "ex:"), 897);
        ajc$tjp_32 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.core.runtime.CoreException:", "ex:"), 954);
        ajc$tjp_33 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("4", "saveFiles", "org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "", "", "", "void"), 949);
        ajc$tjp_34 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "java.io.IOException:", "ex:"), 956);
        ajc$tjp_35 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.core.runtime.CoreException:", "ex:"), 965);
        ajc$tjp_36 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "java.io.IOException:", "ex:"), 967);
        ajc$tjp_37 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.core.runtime.CoreException:", "ex:"), 1041);
        ajc$tjp_38 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "buildProjects", "org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.core.runtime.IProgressMonitor:", "progressMonitor:", "", "void"), 1028);
        ajc$tjp_4 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "getTotalChildCount", "org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.core.resources.IContainer:", "container:", "", "int"), 233);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.jdt.core.JavaModelException:", "ex:"), 279);
        ajc$tjp_6 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("4", "exportElement", "org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "java.lang.Object:org.eclipse.core.runtime.IProgressMonitor:", "element:progressMonitor:", "java.lang.InterruptedException:", "void"), 255);
        ajc$tjp_7 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.core.runtime.CoreException:", "ex:"), 299);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.jdt.core.JavaModelException:", "ex:"), 311);
        ajc$tjp_9 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.AJJarFileExportOperation", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 332);
    }

    private static class MessageMultiStatus
    extends MultiStatus {
        MessageMultiStatus(String pluginId, int code, String message, Throwable exception) {
            super(pluginId, code, message, exception);
        }

        protected void setMessage(String message) {
            super.setMessage(message);
        }
    }
}

