/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import java.io.File;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.builder.AJBuildJob;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.core.model.AJProjectModelFacade;
import org.eclipse.ajdt.core.model.AJProjectModelFactory;
import org.eclipse.ajdt.core.model.AJRelationshipManager;
import org.eclipse.ajdt.core.model.AJRelationshipType;
import org.eclipse.ajdt.internal.ui.ajde.AJDTErrorHandler;
import org.eclipse.ajdt.internal.ui.markers.AJMarkersDialog;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.internal.utils.AJDTUtils;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.ImageImageDescriptor;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.AbstractRulerActionDelegate;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class AdviceActionDelegate
extends AbstractRulerActionDelegate {
    IEditorPart editor = null;
    IVerticalRulerInfo rulerInfo = null;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public void setActiveEditor(IAction callerAction, IEditorPart targetEditor) {
        String id;
        if (!(targetEditor == null || (id = targetEditor.getSite().getId()).equals("org.eclipse.jdt.ui.CompilationUnitEditor") || id.equals("org.eclipse.jdt.ui.ClassFileEditor") || id.equals("org.eclipse.ajdt.internal.ui.editor.CompilationUnitEditor"))) {
            targetEditor = null;
        }
        this.editor = targetEditor;
        super.setActiveEditor(callerAction, targetEditor);
    }

    protected IAction createAction(ITextEditor editor, IVerticalRulerInfo rulerInfo) {
        this.rulerInfo = rulerInfo;
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void menuAboutToShow(IMenuManager manager) {
        CoreException coreException3222222;
        block16: {
            CoreException coreException22222222;
            block18: {
                Object cu;
                Integer clickedLine;
                IFile ifile;
                block17: {
                    block15: {
                        IEditorInput input;
                        block14: {
                            input = this.editor.getEditorInput();
                            if (input instanceof IFileEditorInput) break block14;
                            return;
                        }
                        IFileEditorInput ifep = (IFileEditorInput)input;
                        ifile = ifep.getFile();
                        int linenumber = this.rulerInfo.getLineOfLastMouseButtonActivity();
                        clickedLine = new Integer(linenumber + 1);
                        cu = ifile.getFileExtension().equals("aj") ? AJCompilationUnitManager.INSTANCE.getAJCompilationUnit(ifile) : (ICompilationUnit)JavaCore.create((IFile)ifile);
                        if (cu != null) break block15;
                        return;
                    }
                    try {}
                    catch (CoreException coreException3222222) {
                        // empty catch block
                        break block16;
                    }
                    break block17;
                    catch (CoreException coreException22222222) {
                        // empty catch block
                    }
                    break block18;
                    catch (CoreException coreException4) {
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException4, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                        CoreException coreException5 = coreException4;
                    }
                    break block18;
                }
                AJProjectModelFacade model = AJProjectModelFactory.getInstance().getModelForJavaElement((IJavaElement)cu);
                boolean addedMenu = false;
                if (model.hasModel()) {
                    List javaElementsForLine = model.getJavaElementsForLine((ICompilationUnit)cu, clickedLine.intValue());
                    addedMenu = this.createMenuForRelationshipType(javaElementsForLine, manager, addedMenu, AJRelationshipManager.ADVISES, model);
                    addedMenu = this.createMenuForRelationshipType(javaElementsForLine, manager, addedMenu, AJRelationshipManager.ADVISED_BY, model);
                    addedMenu = this.createMenuForRelationshipType(javaElementsForLine, manager, addedMenu, AJRelationshipManager.ANNOTATES, model);
                    addedMenu = this.createMenuForRelationshipType(javaElementsForLine, manager, addedMenu, AJRelationshipManager.ANNOTATED_BY, model);
                    addedMenu = this.createMenuForRelationshipType(javaElementsForLine, manager, addedMenu, AJRelationshipManager.DECLARED_ON, model);
                    addedMenu = this.createMenuForRelationshipType(javaElementsForLine, manager, addedMenu, AJRelationshipManager.ASPECT_DECLARATIONS, model);
                    addedMenu = this.createMenuForRelationshipType(javaElementsForLine, manager, addedMenu, AJRelationshipManager.SOFTENS, model);
                    addedMenu = this.createMenuForRelationshipType(javaElementsForLine, manager, addedMenu, AJRelationshipManager.SOFTENED_BY, model);
                    addedMenu = this.createMenuForRelationshipType(javaElementsForLine, manager, addedMenu, AJRelationshipManager.MATCHED_BY, model);
                } else {
                    IProject project = cu.getJavaProject().getProject();
                    this.createBuildMenu(manager, project);
                }
                if (addedMenu) {
                    this.createAJToolsMenu(manager);
                }
                IMarker[] probMarkers = ifile.findMarkers("org.eclipse.core.resources.marker", true, 2);
                MenuManager problemSubmenu = null;
                boolean problemSubmenuInitialized = false;
                if (probMarkers == null) return;
                if (probMarkers.length == 0) return;
                int j = 0;
                while (j < probMarkers.length) {
                    IMarker m = probMarkers[j];
                    Object markerLine = m.getAttribute("lineNumber");
                    if (markerLine != null && markerLine.equals(clickedLine)) {
                        String loc;
                        int relCount = 0;
                        if ((loc = (String)m.getAttribute("relatedLocations-" + relCount++)) != null) {
                            IProject project = ifile.getProject();
                            while (loc != null) {
                                String[] s = loc.split(":::");
                                String resName = s[0].substring(s[0].lastIndexOf(File.separator) + 1);
                                String textLabel = NLS.bind((String)UIMessages.EditorRulerContextMenu_relatedLocation_message, (Object[])new String[]{resName, s[1]});
                                RelatedLocationMenuAction ama = new RelatedLocationMenuAction(textLabel, loc, project);
                                if (!problemSubmenuInitialized) {
                                    problemSubmenu = new MenuManager(UIMessages.EditorRulerContextMenu_relatedLocations);
                                    manager.add((IContributionItem)problemSubmenu);
                                    problemSubmenuInitialized = true;
                                }
                                problemSubmenu.add((IAction)ama);
                                loc = (String)m.getAttribute("relatedLocations-" + relCount++);
                            }
                        }
                    }
                    ++j;
                }
                return;
            }
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException22222222, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
            CoreException coreException6 = coreException22222222;
        }
        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException3222222, (Object)this, ajc$tjp_3, (JoinPoint.StaticPart)ajc$tjp_1);
        CoreException ce = coreException3222222;
        AJDTErrorHandler.handleAJDTError(UIMessages.AdviceActionDelegate_exception_adding_advice_to_context_menu, ce);
    }

    private void createBuildMenu(IMenuManager manager, final IProject project) {
        MenuManager emptyAJrefs = new MenuManager("AspectJ References");
        emptyAJrefs.add((IAction)new Action(){

            public String getText() {
                return "Build project to generate references...";
            }

            public void run() {
                AJBuildJob job = new AJBuildJob(project, 6);
                job.schedule();
            }
        });
        manager.add((IContributionItem)emptyAJrefs);
    }

    private void createAJToolsMenu(IMenuManager manager) {
        MenuManager menu = new MenuManager(UIMessages.AdviceActionDelegate_ajtools);
        manager.add((IContributionItem)menu);
        menu.add((IAction)new Action(){

            public String getText() {
                return UIMessages.AdviceActionDelegate_configure_markers;
            }

            public void run() {
                IFile resource = ((IFileEditorInput)AdviceActionDelegate.this.editor.getEditorInput()).getFile();
                if (resource != null) {
                    Shell shell = AspectJUIPlugin.getDefault().getActiveWorkbenchWindow().getShell();
                    IProject project = resource.getProject();
                    AJMarkersDialog dialog = new AJMarkersDialog(shell, project);
                    dialog.open();
                }
            }
        });
    }

    private boolean createMenuForRelationshipType(List javaElements, IMenuManager manager, boolean addedMenu, AJRelationshipType relationshipType, AJProjectModelFacade model) {
        boolean menuInitialized = false;
        MenuManager menu = null;
        for (IJavaElement element : javaElements) {
            List relationships = model.getRelationshipsForElement(element, relationshipType);
            if (relationships == null) continue;
            addedMenu = true;
            for (IJavaElement el : relationships) {
                if (!menuInitialized) {
                    menu = new MenuManager(relationshipType.getMenuName());
                    manager.add((IContributionItem)menu);
                    menuInitialized = true;
                }
                String linkName = model.getJavaElementLinkName(el);
                menu.add((IAction)new MenuAction(el, linkName));
            }
        }
        return addedMenu;
    }

    protected void report(final String message) {
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                IEditorStatusLine fStatusLine = (IEditorStatusLine)AdviceActionDelegate.this.editor.getAdapter(IEditorStatusLine.class);
                if (fStatusLine != null) {
                    fStatusLine.setMessage(true, message, null);
                }
                if (message != null && JDIDebugUIPlugin.getActiveWorkbenchShell() != null) {
                    Display.getCurrent().beep();
                }
            }
        });
    }

    static {
        Factory factory = new Factory("AdviceActionDelegate.java", Class.forName("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate", "org.eclipse.core.runtime.CoreException:", "ce:"), 222);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "menuAboutToShow", "org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate", "org.eclipse.jface.action.IMenuManager:", "manager:", "", "void"), 125);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate", "org.eclipse.core.runtime.CoreException:", "ce:"), 222);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate", "org.eclipse.core.runtime.CoreException:", "ce:"), 222);
    }

    abstract class BaseAJDTMenuAction
    extends Action {
        private IProject project;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
        private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_4;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
        private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_7;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

        BaseAJDTMenuAction(String s, IProject project) {
            super(s);
            this.project = project;
        }

        abstract String getJumpLocation();

        public void run() {
            String[] s = this.getJumpLocation().split(":::");
            String filepath = s[0];
            String linenumber = s[1];
            IResource r = AJDTUtils.findResource(filepath);
            if (r == null) {
                r = AJDTUtils.findResource(filepath, this.project);
            }
            if (!r.exists()) {
                this.revealBinaryAspect(filepath, linenumber);
            } else {
                this.revealSourceAspect(linenumber, r);
            }
        }

        private void revealSourceAspect(String linenumber, IResource resource) {
            IMarker jumpMarker = null;
            if (resource != null && resource.exists()) {
                try {
                    jumpMarker = resource.createMarker("org.eclipse.core.resources.textmarker");
                    jumpMarker.setAttribute("lineNumber", new Integer(linenumber).intValue());
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                    CoreException ce = coreException;
                    AJDTErrorHandler.handleAJDTError(UIMessages.AdviceActionDelegate_unable_to_create_marker, ce);
                }
                try {
                    IDE.openEditor((IWorkbenchPage)AspectJUIPlugin.getDefault().getActiveWorkbenchWindow().getActivePage(), (IMarker)jumpMarker, (boolean)true);
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
                    CoreException e = coreException;
                    AJDTErrorHandler.handleAJDTError(UIMessages.AdviceActionDelegate_exception_jumping, e);
                }
            } else {
                AdviceActionDelegate.this.report(UIMessages.AdviceActionDelegate_resource_not_found);
            }
        }

        private void revealBinaryAspect(String filepath, String linenumber) {
            String qualifiedName = AJDTUtils.extractQualifiedName(filepath);
            IJavaProject javaProject = JavaCore.create((IProject)this.project);
            if (javaProject != null) {
                try {
                    IType type = javaProject.findType(qualifiedName);
                    IEditorPart part = EditorUtility.openInEditor((Object)type, (boolean)true);
                    if (part instanceof ITextEditor) {
                        ITextEditor editor = (ITextEditor)part;
                        IRegion region = this.getOffsetOfLine(linenumber, editor);
                        editor.selectAndReveal(region.getOffset(), region.getLength());
                        return;
                    }
                }
                catch (JavaModelException javaModelException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_3, (JoinPoint.StaticPart)ajc$tjp_4);
                }
                catch (PartInitException partInitException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(partInitException, (Object)this, ajc$tjp_5, (JoinPoint.StaticPart)ajc$tjp_4);
                }
            }
            AdviceActionDelegate.this.report(UIMessages.AdviceActionDelegate_resource_not_found);
        }

        private IRegion getOffsetOfLine(String linenumber, ITextEditor editor) {
            IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            try {
                return doc.getLineInformation(Integer.parseInt(linenumber) - 1);
            }
            catch (NumberFormatException numberFormatException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(numberFormatException, (Object)this, ajc$tjp_6, (JoinPoint.StaticPart)ajc$tjp_7);
            }
            catch (BadLocationException badLocationException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(badLocationException, (Object)this, ajc$tjp_8, (JoinPoint.StaticPart)ajc$tjp_7);
            }
            return null;
        }

        static {
            Factory factory = new Factory("AdviceActionDelegate.java", Class.forName("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$BaseAJDTMenuAction"));
            ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$BaseAJDTMenuAction", "org.eclipse.core.runtime.CoreException:", "ce:"), 409);
            ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "revealSourceAspect", "org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$BaseAJDTMenuAction", "java.lang.String:org.eclipse.core.resources.IResource:", "linenumber:resource:", "", "void"), 394);
            ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$BaseAJDTMenuAction", "org.eclipse.core.runtime.CoreException:", "e:"), 419);
            ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$BaseAJDTMenuAction", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 446);
            ajc$tjp_4 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "revealBinaryAspect", "org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$BaseAJDTMenuAction", "java.lang.String:java.lang.String:", "filepath:linenumber:", "", "void"), 430);
            ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$BaseAJDTMenuAction", "org.eclipse.ui.PartInitException:", "<missing>:"), 447);
            ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$BaseAJDTMenuAction", "java.lang.NumberFormatException:", "<missing>:"), 457);
            ajc$tjp_7 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "getOffsetOfLine", "org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$BaseAJDTMenuAction", "java.lang.String:org.eclipse.ui.texteditor.ITextEditor:", "linenumber:editor:", "", "org.eclipse.jface.text.IRegion"), 453);
            ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$BaseAJDTMenuAction", "org.eclipse.jface.text.BadLocationException:", "<missing>:"), 458);
        }
    }

    private static class MenuAction
    extends Action {
        private static ILabelProvider labelProvider;
        private IJavaElement jumpLocation;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        static {
            Factory factory = new Factory("AdviceActionDelegate.java", Class.forName("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$MenuAction"));
            ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$MenuAction", "org.eclipse.ui.PartInitException:", "<missing>:"), 330);
            ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$MenuAction", "", "", "", "void"), 327);
            ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$MenuAction", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 331);
            labelProvider = new DecoratingJavaLabelProvider((JavaUILabelProvider)new AppearanceAwareLabelProvider());
        }

        public MenuAction(IJavaElement el, String linkName) {
            super(linkName);
            Image image = labelProvider.getImage((Object)el);
            if (image != null) {
                this.setImageDescriptor((ImageDescriptor)new ImageImageDescriptor(image));
            }
            this.jumpLocation = el;
        }

        public void run() {
            try {
                JavaUI.openInEditor((IJavaElement)this.jumpLocation);
            }
            catch (PartInitException partInitException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(partInitException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
            }
        }
    }

    class RelatedLocationMenuAction
    extends BaseAJDTMenuAction {
        private String jumpLocation;

        RelatedLocationMenuAction(String s, String jumpLocation, IProject project) {
            super(s, project);
            this.jumpLocation = jumpLocation;
            this.setImageDescriptor(JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.jcu_obj.gif"));
        }

        String getJumpLocation() {
            return this.jumpLocation;
        }
    }
}

