/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.jdt.preferences;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.contribution.jdt.IsWovenTester;
import org.eclipse.contribution.jdt.JDTWeavingPlugin;
import org.eclipse.contribution.jdt.preferences.EnableWeavingServiceJob;
import org.eclipse.contribution.jdt.preferences.JDTWeavingPreferences;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;

public class WeavableProjectListener
implements ILifecycleListener {
    public static String WEAVABLE_NATURE_EXTENSION_POINT = "org.eclipse.contribution.weaving.jdt.weavablenature";
    private Set<String> weavableNatures = null;
    static WeavableProjectListener INSTANCE = new WeavableProjectListener();

    protected WeavableProjectListener() {
    }

    public static WeavableProjectListener getInstance() {
        return INSTANCE;
    }

    public static void setInstance(WeavableProjectListener mock) {
        INSTANCE = mock;
    }

    private void initWeavableNatures() {
        this.weavableNatures = new HashSet<String>();
        IExtensionPoint exP = null;
        try {
            exP = Platform.getExtensionRegistry().getExtensionPoint(WEAVABLE_NATURE_EXTENSION_POINT);
        }
        catch (InvalidRegistryObjectException e) {
            JDTWeavingPlugin.logException(e);
        }
        if (exP != null) {
            IExtension[] exs = exP.getExtensions();
            int i = 0;
            while (i < exs.length) {
                IConfigurationElement[] configs = exs[i].getConfigurationElements();
                int j = 0;
                while (j < configs.length) {
                    try {
                        String natureid;
                        IConfigurationElement config = configs[j];
                        if (config.isValid() && (natureid = config.getAttribute("natureid")) != null) {
                            this.weavableNatures.add(natureid);
                        }
                    }
                    catch (Exception e) {
                        JDTWeavingPlugin.logException(e);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isWeavableProject(IProject project) {
        try {
            String natureId;
            if (this.weavableNatures == null) {
                this.initWeavableNatures();
            }
            if (project == null) return false;
            if (!project.isAccessible()) return false;
            Iterator<String> iterator = this.weavableNatures.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!project.hasNature(natureId = iterator.next()));
            return true;
        }
        catch (Exception e) {
            JDTWeavingPlugin.logException(e);
        }
        return false;
    }

    public boolean isInWeavableProject(IJavaElement element) {
        IJavaProject jProject;
        if (element != null && (jProject = element.getJavaProject()) != null) {
            IProject project = jProject.getProject();
            return this.isWeavableProject(project);
        }
        return false;
    }

    public void handleEvent(LifecycleEvent event) throws CoreException {
        if ((event.kind == 32 || event.kind == 8) && event.resource instanceof IProject && this.isWeavableProject((IProject)event.resource)) {
            this.askToEnableWeaving();
        }
    }

    public static void weavableNatureAdded(IProject project) {
        if (INSTANCE.isWeavableProject(project)) {
            INSTANCE.askToEnableWeaving();
        }
    }

    protected void askToEnableWeaving() {
        try {
            if (!IsWovenTester.isWeavingActive() && JDTWeavingPreferences.shouldAskToEnableWeaving()) {
                EnableWeavingServiceJob job = new EnableWeavingServiceJob();
                if (Job.getJobManager().find((Object)INSTANCE).length == 0) {
                    job.schedule();
                }
            }
        }
        catch (Exception e) {
            JDTWeavingPlugin.logException(e);
        }
    }
}

