/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.aspectj;

import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.equinox.service.weaving.IWeavingServiceFactory;
import org.eclipse.equinox.weaving.aspectj.AspectJWeavingServiceFactory;
import org.eclipse.equinox.weaving.aspectj.loadtime.AspectAdminImpl;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;

public class AspectJWeavingStarter
implements BundleActivator {
    public static boolean DEBUG;
    public static boolean verbose;
    private static AspectJWeavingStarter plugin;
    private AspectAdminImpl aspectDefinitionRegistry;
    private BundleContext context;

    static {
        verbose = Boolean.getBoolean("org.aspectj.osgi.verbose");
    }

    public AspectJWeavingStarter() {
        plugin = this;
    }

    public static AspectJWeavingStarter getDefault() {
        return plugin;
    }

    public BundleContext getContext() {
        return this.context;
    }

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.aspectDefinitionRegistry = new AspectAdminImpl();
        context.addBundleListener((BundleListener)this.aspectDefinitionRegistry);
        this.aspectDefinitionRegistry.initialize(context.getBundles());
        this.loadOptions(context);
        if (verbose) {
            System.err.println("[org.eclipse.equinox.weaving.aspectj] info Starting AspectJ weaving service ...");
        }
        String serviceName = IWeavingServiceFactory.class.getName();
        AspectJWeavingServiceFactory weavingServiceFactory = new AspectJWeavingServiceFactory(this.aspectDefinitionRegistry);
        Properties props = new Properties();
        context.registerService(serviceName, (Object)weavingServiceFactory, (Dictionary)props);
    }

    public void stop(BundleContext context) throws Exception {
        this.context = null;
        plugin = null;
    }

    private void loadOptions(BundleContext context) {
        DebugOptions service = null;
        ServiceReference reference = context.getServiceReference(DebugOptions.class.getName());
        if (reference != null) {
            service = (DebugOptions)context.getService(reference);
        }
        if (service == null) {
            return;
        }
        try {
            DEBUG = service.getBooleanOption("org.aspectj.osgi.service.weaving/debug", false);
        }
        finally {
            context.ungetService(reference);
        }
    }
}

