/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.adaptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.equinox.service.weaving.ICachingService;
import org.eclipse.equinox.service.weaving.ICachingServiceFactory;
import org.eclipse.equinox.service.weaving.ISupplementerRegistry;
import org.eclipse.equinox.service.weaving.IWeavingService;
import org.eclipse.equinox.service.weaving.IWeavingServiceFactory;
import org.eclipse.equinox.weaving.adaptors.Debug;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;

public class WeavingAdaptorFactory {
    private static final Collection IGNORE_WEAVING_SERVICE_BUNDLES = Arrays.asList("org.eclipse.equinox.weaving.aspectj", "org.eclipse.equinox.weaving.caching", "org.eclipse.equinox.weaving.caching.j9", "org.eclipse.update.configurator", "org.eclipse.equinox.simpleconfigurator", "org.eclipse.equinox.common");
    private static final String WEAVING_SERVICE_DYNAMICS_PROPERTY = "equinox.weaving.service.dynamics";
    private BundleContext bundleContext;
    private ServiceTracker cachingServiceFactoryTracker;
    private PackageAdmin packageAdminService;
    private StartLevel startLevelService;
    private ISupplementerRegistry supplementerRegistry;
    private ServiceTracker weavingServiceFactoryTracker;
    private ServiceListener weavingServiceListener;
    private final Map weavingServices = Collections.synchronizedMap(new HashMap());

    public void dispose(BundleContext bundleContext) {
        bundleContext.removeServiceListener(this.weavingServiceListener);
        if (Debug.DEBUG_WEAVE) {
            Debug.println("> Removed service listener for weaving service.");
        }
        this.weavingServiceFactoryTracker.close();
        if (Debug.DEBUG_WEAVE) {
            Debug.println("> Closed service tracker for weaving service.");
        }
        this.cachingServiceFactoryTracker.close();
        if (Debug.DEBUG_CACHE) {
            Debug.println("> Closed service tracker for caching service.");
        }
    }

    public Bundle getHost(Bundle bundle) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AspectJAdaptorFactory.getHost() fragment=" + bundle);
        }
        Bundle bundle2 = null;
        if (this.packageAdminService != null) {
            bundle2 = this.packageAdminService.getHosts(bundle)[0];
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AspectJAdaptorFactory.getHost() " + bundle2);
        }
        return bundle2;
    }

    public void initialize(BundleContext bundleContext, final ISupplementerRegistry iSupplementerRegistry) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AspectJAdaptorFactory.initialize() context=" + bundleContext);
        }
        this.bundleContext = bundleContext;
        this.supplementerRegistry = iSupplementerRegistry;
        this.initializePackageAdminService(bundleContext);
        this.initializeStartLevelService(bundleContext);
        this.weavingServiceFactoryTracker = new ServiceTracker(bundleContext, IWeavingServiceFactory.class.getName(), null);
        this.weavingServiceFactoryTracker.open();
        if (Debug.DEBUG_WEAVE) {
            Debug.println("> Opened service tracker for weaving service.");
        }
        this.weavingServiceListener = new ServiceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serviceChanged(ServiceEvent serviceEvent) {
                Bundle bundle;
                Map.Entry entry;
                Map map;
                Iterator iterator;
                ArrayList<Bundle> arrayList;
                if (serviceEvent.getType() == 1) {
                    arrayList = new ArrayList<Bundle>();
                    iterator = WeavingAdaptorFactory.this.weavingServices.entrySet().iterator();
                    map = WeavingAdaptorFactory.this.weavingServices;
                    synchronized (map) {
                        while (iterator.hasNext()) {
                            entry = iterator.next();
                            bundle = (Bundle)entry.getKey();
                            if (entry.getValue() != null) continue;
                            iterator.remove();
                            System.err.println("bundle update because of weaving service start: " + bundle.getSymbolicName());
                            arrayList.add(bundle);
                            if (!Debug.DEBUG_WEAVE) continue;
                            Debug.println("> Updated bundle " + bundle.getSymbolicName());
                        }
                    }
                    if (arrayList.size() > 0) {
                        iSupplementerRegistry.refreshBundles(arrayList.toArray(new Bundle[arrayList.size()]));
                    }
                }
                if (serviceEvent.getType() == 4 && WeavingAdaptorFactory.this.startLevelService != null && WeavingAdaptorFactory.this.startLevelService.getStartLevel() > 0) {
                    arrayList = new ArrayList();
                    iterator = WeavingAdaptorFactory.this.weavingServices.entrySet().iterator();
                    map = WeavingAdaptorFactory.this.weavingServices;
                    synchronized (map) {
                        while (iterator.hasNext()) {
                            entry = iterator.next();
                            bundle = (Bundle)entry.getKey();
                            if (entry.getValue() == null) continue;
                            iterator.remove();
                            System.err.println("bundle update because of weaving service stop: " + bundle.getSymbolicName());
                            arrayList.add(bundle);
                            if (!Debug.DEBUG_WEAVE) continue;
                            Debug.println("> Updated bundle " + bundle.getSymbolicName());
                        }
                    }
                    if (arrayList.size() > 0) {
                        iSupplementerRegistry.refreshBundles(arrayList.toArray(new Bundle[arrayList.size()]));
                    }
                }
            }
        };
        if (System.getProperty(WEAVING_SERVICE_DYNAMICS_PROPERTY, "false").equals("true")) {
            try {
                bundleContext.addServiceListener(this.weavingServiceListener, "(objectClass=" + IWeavingService.class.getName() + ")");
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
        }
        this.cachingServiceFactoryTracker = new ServiceTracker(bundleContext, ICachingServiceFactory.class.getName(), null);
        this.cachingServiceFactoryTracker.open();
        if (Debug.DEBUG_CACHE) {
            Debug.println("> Opened service tracker for caching service.");
        }
    }

    protected ICachingService getCachingService(BaseClassLoader baseClassLoader, Bundle bundle, IWeavingService iWeavingService) {
        ICachingServiceFactory iCachingServiceFactory;
        if (Debug.DEBUG_CACHE) {
            Debug.println("> AspectJAdaptorFactory.getCachingService() bundle=" + bundle + ", weavingService=" + iWeavingService);
        }
        ICachingService iCachingService = null;
        String string = "";
        if (iWeavingService != null) {
            string = iWeavingService.getKey();
        }
        if ((iCachingServiceFactory = (ICachingServiceFactory)this.cachingServiceFactoryTracker.getService()) != null) {
            iCachingService = iCachingServiceFactory.createCachingService((ClassLoader)baseClassLoader, bundle, string);
        }
        if (Debug.DEBUG_CACHE) {
            Debug.println("< AspectJAdaptorFactory.getCachingService() service=" + iCachingService + ", key='" + string + "'");
        }
        return iCachingService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IWeavingService getWeavingService(BaseClassLoader baseClassLoader) {
        if (Debug.DEBUG_WEAVE) {
            Debug.println("> AspectJAdaptorFactory.getWeavingService() baseClassLoader=" + baseClassLoader);
        }
        BaseData baseData = baseClassLoader.getClasspathManager().getBaseData();
        State state = baseData.getAdaptor().getState();
        Bundle bundle = baseData.getBundle();
        BundleDescription bundleDescription = state.getBundle(bundle.getBundleId());
        IWeavingService iWeavingService = null;
        if (!IGNORE_WEAVING_SERVICE_BUNDLES.contains(bundle.getSymbolicName())) {
            IWeavingServiceFactory iWeavingServiceFactory = (IWeavingServiceFactory)this.weavingServiceFactoryTracker.getService();
            if (iWeavingServiceFactory != null) {
                iWeavingService = iWeavingServiceFactory.createWeavingService((ClassLoader)baseClassLoader, bundle, state, bundleDescription, this.supplementerRegistry);
            }
            Map map = this.weavingServices;
            synchronized (map) {
                this.weavingServices.put(bundle, iWeavingService);
            }
        }
        if (Debug.DEBUG_WEAVE) {
            Debug.println("< AspectJAdaptorFactory.getWeavingService() service=" + iWeavingService);
        }
        return iWeavingService;
    }

    private void initializePackageAdminService(BundleContext bundleContext) {
        ServiceReference serviceReference;
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AspectJAdaptorFactory.initializePackageAdminService() context=" + bundleContext);
        }
        if ((serviceReference = bundleContext.getServiceReference(PackageAdmin.class.getName())) != null) {
            this.packageAdminService = (PackageAdmin)bundleContext.getService(serviceReference);
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AspectJAdaptorFactory.initializePackageAdminService() " + this.packageAdminService);
        }
    }

    private void initializeStartLevelService(BundleContext bundleContext) {
        ServiceReference serviceReference;
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AspectJAdaptorFactory.initializeStartLevelService() context=" + bundleContext);
        }
        if ((serviceReference = bundleContext.getServiceReference(StartLevel.class.getName())) != null) {
            this.startLevelService = (StartLevel)bundleContext.getService(serviceReference);
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AspectJAdaptorFactory.initializeStartLevelService() " + this.startLevelService);
        }
    }
}

