/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.RendererDefinition;
import org.eclipse.contribution.visualiser.interfaces.IVisualiserRenderer;
import org.eclipse.contribution.visualiser.internal.preference.VisualiserPreferences;
import org.eclipse.contribution.visualiser.renderers.DefaultVisualiserRenderer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class RendererManager {
    public static final String RENDERER_EXTENSION = "org.eclipse.contribution.visualiser.renderers";
    private static final String DEFAULT_RENDERER_CLASS = "org.eclipse.contribution.visualiser.renderers.DefaultVisualiserRenderer";
    private static List renderers;
    private static RendererDefinition current;

    public static List getAllRendererDefinitions() {
        if (renderers == null) {
            RendererManager.initialiseRendererDefinitions();
        }
        return renderers;
    }

    public static RendererDefinition getCurrentRenderer() {
        if (current == null) {
            String name = VisualiserPreferences.getRendererName();
            if (name != null && name.length() > 0) {
                for (RendererDefinition r : RendererManager.getAllRendererDefinitions()) {
                    if (!r.getName().equals(name)) continue;
                    current = r;
                }
            }
            if (current == null) {
                current = RendererManager.getDefaultRenderer();
            }
        }
        return current;
    }

    public static RendererDefinition getRendererByName(String name) {
        for (RendererDefinition r : RendererManager.getAllRendererDefinitions()) {
            if (!r.getName().equals(name)) continue;
            return r;
        }
        return null;
    }

    public static void setCurrentRendererByName(String name) {
        RendererDefinition r = RendererManager.getRendererByName(name);
        if (r != null) {
            current = r;
        }
    }

    public static RendererDefinition getDefaultRenderer() {
        if (renderers == null) {
            RendererManager.initialiseRendererDefinitions();
        }
        for (RendererDefinition r : renderers) {
            if (!(r.getRenderer() instanceof DefaultVisualiserRenderer) || !r.getRenderer().getClass().getName().equals(DEFAULT_RENDERER_CLASS)) continue;
            return r;
        }
        return null;
    }

    private static void initialiseRendererDefinitions() {
        renderers = new ArrayList();
        IExtensionPoint exP = Platform.getExtensionRegistry().getExtensionPoint(RENDERER_EXTENSION);
        IExtension[] exs = exP.getExtensions();
        int i = 0;
        while (i < exs.length) {
            IConfigurationElement[] ces = exs[i].getConfigurationElements();
            int j = 0;
            while (j < ces.length) {
                try {
                    Object ext = ces[j].createExecutableExtension("class");
                    if (ext instanceof IVisualiserRenderer) {
                        String name = ces[j].getAttribute("name");
                        RendererDefinition rd = new RendererDefinition(name, (IVisualiserRenderer)ext);
                        renderers.add(rd);
                    }
                }
                catch (CoreException e) {
                    VisualiserPlugin.logException(e);
                }
                ++j;
            }
            ++i;
        }
    }
}

